/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocumentBase;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.FinalBilledIndicatorEntry;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.framework.postprocessor.DocumentRouteStatusChange;

public class FinalBilledIndicatorDocument
extends TransactionalDocumentBase {
    private static final Logger LOG = LogManager.getLogger(FinalBilledIndicatorDocument.class);
    private ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    private DocumentService documentService;
    private List<FinalBilledIndicatorEntry> invoiceEntries = new ArrayList<FinalBilledIndicatorEntry>();

    protected void updateContractsGrantsInvoiceDocument() throws WorkflowException {
        for (FinalBilledIndicatorEntry entry : this.getInvoiceEntries()) {
            ContractsGrantsInvoiceDocument invoiceDocument = (ContractsGrantsInvoiceDocument)this.getDocumentService().getByDocumentHeaderId(entry.getInvoiceDocumentNumber());
            if (!ObjectUtils.isNotNull((Object)invoiceDocument)) continue;
            invoiceDocument.getInvoiceGeneralDetail().setFinalBillIndicator(false);
            this.getContractGrantsInvoiceDocumentService().updateUnfinalizationToAwardAccount(invoiceDocument.getAccountDetails(), invoiceDocument.getInvoiceGeneralDetail().getProposalNumber());
            invoiceDocument.refresh();
            this.getDocumentService().updateDocument((Document)invoiceDocument);
        }
    }

    public void doRouteStatusChange(DocumentRouteStatusChange statusChangeEvent) {
        super.doRouteStatusChange(statusChangeEvent);
        String newRouteStatus = statusChangeEvent.getNewRouteStatus();
        if (newRouteStatus.equalsIgnoreCase("P") || newRouteStatus.equalsIgnoreCase("F")) {
            try {
                this.updateContractsGrantsInvoiceDocument();
            }
            catch (WorkflowException ex) {
                LOG.error("problem during FinalBilledIndicatorAction.doProcessingAfterPost()", (Throwable)ex);
                throw new RuntimeException("Could not update Contracts & Grants Invoice Document for Final Billed Indicator Document", ex);
            }
        }
    }

    public void addInvoiceEntry(FinalBilledIndicatorEntry invoiceEntry) {
        invoiceEntry.setDocumentId(this.getDocumentNumber());
        this.invoiceEntries.add(invoiceEntry);
    }

    public void removeInvoiceEntry(int deleteIndex) {
        this.invoiceEntries.remove(deleteIndex);
    }

    private ContractsGrantsInvoiceDocumentService getContractGrantsInvoiceDocumentService() {
        if (this.contractsGrantsInvoiceDocumentService == null) {
            this.contractsGrantsInvoiceDocumentService = (ContractsGrantsInvoiceDocumentService)SpringContext.getBean(ContractsGrantsInvoiceDocumentService.class);
        }
        return this.contractsGrantsInvoiceDocumentService;
    }

    protected void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    private DocumentService getDocumentService() {
        if (this.documentService == null) {
            this.documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        }
        return this.documentService;
    }

    protected void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public List<FinalBilledIndicatorEntry> getInvoiceEntries() {
        return this.invoiceEntries;
    }

    public void setInvoiceEntries(List<FinalBilledIndicatorEntry> invoiceEntries) {
        this.invoiceEntries = invoiceEntries;
    }
}

