/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.kfs.module.ar.document.service.PredeterminedBillingScheduleMaintenanceService;
import org.kuali.kfs.module.ar.document.validation.impl.PredeterminedBillingScheduleRuleUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;

public class PredeterminedBillingScheduleMaintainableImpl
extends FinancialSystemMaintainable {
    private static volatile PredeterminedBillingScheduleMaintenanceService predeterminedBillingScheduleMaintenanceService;

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        if (StringUtils.equals((CharSequence)"awardAccountLookupable", (CharSequence)((String)fieldValues.get("refreshCaller")))) {
            PredeterminedBillingSchedule predeterminedBillingSchedule = this.getPredeterminedBillingSchedule();
            predeterminedBillingSchedule.setProposalNumber(predeterminedBillingSchedule.getProposalNumberForAwardAccountLookup());
            predeterminedBillingSchedule.setChartOfAccountsCode(predeterminedBillingSchedule.getChartOfAccountsCodeForAwardAccountLookup());
            predeterminedBillingSchedule.setAccountNumber(predeterminedBillingSchedule.getAccountNumberForAwardAccountLookup());
            if (PredeterminedBillingScheduleRuleUtil.checkIfBillsExist(predeterminedBillingSchedule)) {
                String pathToMaintainable = "document.newMaintainableObject";
                GlobalVariables.getMessageMap().addToErrorPath(pathToMaintainable);
                GlobalVariables.getMessageMap().putError("proposalNumberForAwardAccountLookup", "error.cg.award.predetermined.billing.schedule.exists", new String[]{predeterminedBillingSchedule.getProposalNumber(), predeterminedBillingSchedule.getChartOfAccountsCode(), predeterminedBillingSchedule.getAccountNumber()});
                GlobalVariables.getMessageMap().removeFromErrorPath(pathToMaintainable);
            }
        } else {
            super.refresh(refreshCaller, fieldValues, document);
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        List<Bill> bills = this.getPredeterminedBillingSchedule().getBills();
        if (ObjectUtils.isNotNull(bills)) {
            for (Bill bill : bills) {
                bill.setBilled(false);
                bill.setBillIdentifier(null);
            }
        }
    }

    public void processAfterRetrieve() {
        PredeterminedBillingSchedule predeterminedBillingSchedule = this.getPredeterminedBillingSchedule();
        predeterminedBillingSchedule.refreshNonUpdateableReferences();
        super.processAfterRetrieve();
    }

    private PredeterminedBillingSchedule getPredeterminedBillingSchedule() {
        return (PredeterminedBillingSchedule)this.getBusinessObject();
    }

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        String proposalNumber = this.getPredeterminedBillingSchedule().getProposalNumber();
        for (Section section : sections) {
            String sectionId = section.getSectionId();
            if (!sectionId.equalsIgnoreCase("bills")) continue;
            this.prepareBillsTab(section, proposalNumber);
        }
        return sections;
    }

    private void prepareBillsTab(Section section, String proposalNumber) {
        for (Row row : section.getRows()) {
            for (Field field : row.getFields()) {
                if (!field.getCONTAINER().equalsIgnoreCase(field.getFieldType())) continue;
                for (Row containerRow : field.getContainerRows()) {
                    for (Field containerRowfield : containerRow.getFields()) {
                        String billId;
                        if (!ObjectUtils.getNestedAttributePrimitive((String)containerRowfield.getPropertyName()).matches("billIdentifier") || !StringUtils.isNotEmpty((CharSequence)(billId = containerRowfield.getPropertyValue())) || !this.getPredeterminedBillingScheduleMaintenanceService().hasBillBeenCopiedToInvoice(proposalNumber, billId)) continue;
                        for (Field rowfield : row.getFields()) {
                            if (!rowfield.getCONTAINER().equalsIgnoreCase(rowfield.getFieldType())) continue;
                            for (Row fieldContainerRow : rowfield.getContainerRows()) {
                                for (Field fieldContainerRowField : fieldContainerRow.getFields()) {
                                    fieldContainerRowField.setReadOnly(true);
                                }
                            }
                        }
                    }
                }
            }
        }
    }

    private PredeterminedBillingScheduleMaintenanceService getPredeterminedBillingScheduleMaintenanceService() {
        if (predeterminedBillingScheduleMaintenanceService == null) {
            predeterminedBillingScheduleMaintenanceService = (PredeterminedBillingScheduleMaintenanceService)SpringContext.getBean(PredeterminedBillingScheduleMaintenanceService.class);
        }
        return predeterminedBillingScheduleMaintenanceService;
    }
}

