/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.authorization;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.authorizer.CfDocumentTypeAuthorizer;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kew.doctype.bo.DocumentType;
import org.kuali.rice.kew.routeheader.DocumentRouteHeaderValue;

public class ContractsGrantsInvoiceWorkflowDocumentAuthorizer
extends CfDocumentTypeAuthorizer {
    protected Map<String, String> buildDocumentRoleQualifiers(DocumentRouteHeaderValue document, String routeNodeName) {
        Map qualifiers = super.buildDocumentRoleQualifiers(document, routeNodeName);
        String documentNumber = document.getDocumentId();
        if (StringUtils.isNotBlank((CharSequence)documentNumber)) {
            ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument = null;
            try {
                contractsGrantsInvoiceDocument = (ContractsGrantsInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(documentNumber);
            }
            catch (WorkflowException workflowException) {
                // empty catch block
            }
            if (ObjectUtils.isNotNull(contractsGrantsInvoiceDocument)) {
                ContractsAndGrantsBillingAward award = contractsGrantsInvoiceDocument.getInvoiceGeneralDetail().getAward();
                qualifiers.put("proposalNumber", award.getProposalNumber());
            }
        }
        return qualifiers;
    }

    public boolean canInitiate(String principalId, DocumentType documentType) {
        this.validatePrincipalId(principalId);
        this.validateDocumentType(documentType);
        Map permissionDetails = this.buildDocumentTypePermissionDetails(documentType, null, null, null);
        HashMap<String, String> qualificationDetails = new HashMap<String, String>();
        qualificationDetails.put("principalId", principalId);
        if (this.useKimPermission("KR-SYS", "Initiate Document", permissionDetails, true)) {
            return this.getPermissionService().isAuthorizedByTemplate(principalId, "KR-SYS", "Initiate Document", permissionDetails, qualificationDetails);
        }
        return true;
    }
}

