/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.SequenceAccessorService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.sys.util.TransactionalServiceUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerAddressServiceImpl
implements CustomerAddressService {
    private BusinessObjectService businessObjectService;
    private SequenceAccessorService sequenceAccessorService;
    private DateTimeService dateTimeService;
    protected static final String CUST_ADDR_ID_SEQ = "CUST_ADDR_ID_SEQ";

    @Override
    public CustomerAddress getByPrimaryKey(String customerNumber, Integer customerAddressIdentifier) {
        CustomerAddress customerAddress = null;
        if (StringUtils.isNotBlank((CharSequence)customerNumber) && ObjectUtils.isNotNull((Object)customerAddressIdentifier)) {
            HashMap<String, Object> criteria = new HashMap<String, Object>();
            criteria.put("customerNumber", customerNumber);
            criteria.put("customerAddressIdentifier", customerAddressIdentifier);
            customerAddress = (CustomerAddress)this.businessObjectService.findByPrimaryKey(CustomerAddress.class, criteria);
        }
        return customerAddress;
    }

    @Override
    public CustomerAddress getPrimaryAddress(String customerNumber) {
        CustomerAddress primaryAddress = null;
        if (StringUtils.isNotBlank((CharSequence)customerNumber)) {
            HashMap<String, String> criteria = new HashMap<String, String>();
            criteria.put("customerNumber", customerNumber);
            criteria.put("customerAddressTypeCode", "P");
            Collection primaryAddresses = this.businessObjectService.findMatching(CustomerAddress.class, criteria);
            if (!CollectionUtils.isEmpty((Collection)primaryAddresses)) {
                primaryAddress = (CustomerAddress)TransactionalServiceUtils.retrieveFirstAndExhaustIterator(primaryAddresses.iterator());
            }
        }
        return primaryAddress;
    }

    @Override
    public boolean customerAddressActive(String customerNumber, Integer customerAddressIdentifier) {
        CustomerAddress customerAddress = this.getByPrimaryKey(customerNumber, customerAddressIdentifier);
        if (ObjectUtils.isNotNull((Object)customerAddress) && ObjectUtils.isNotNull((Object)customerAddress.getCustomerAddressEndDate())) {
            Timestamp currentDateTimestamp = new Timestamp(this.dateTimeService.getCurrentDate().getTime());
            Timestamp addressEndDateTimestamp = new Timestamp(customerAddress.getCustomerAddressEndDate().getTime());
            return !addressEndDateTimestamp.before(currentDateTimestamp);
        }
        return true;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    @Override
    public boolean customerAddressExists(String customerNumber, Integer customerAddressIdentifier) {
        return ObjectUtils.isNotNull((Object)this.getByPrimaryKey(customerNumber, customerAddressIdentifier));
    }

    @Override
    public Integer getNextCustomerAddressIdentifier() {
        Long nextId = this.sequenceAccessorService.getNextAvailableSequenceNumber(CUST_ADDR_ID_SEQ, CustomerAddress.class);
        return nextId.intValue();
    }

    public SequenceAccessorService getSequenceAccessorService() {
        return this.sequenceAccessorService;
    }

    public void setSequenceAccessorService(SequenceAccessorService sequenceAccessorService) {
        this.sequenceAccessorService = sequenceAccessorService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

