/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.service.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.dao.DocumentDao;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.InfrastructureException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerBillingStatement;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceRecurrenceDetails;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonInvoicedDistribution;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.CustomerInvoiceDocumentDao;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.InvoicePaidAppliedService;
import org.kuali.kfs.module.ar.document.service.NonInvoicedDistributionService;
import org.kuali.kfs.module.ar.report.util.CustomerStatementResultHolder;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.action.ActionTaken;
import org.kuali.rice.kew.api.action.ActionType;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.IdentityService;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerInvoiceDocumentServiceImpl
implements CustomerInvoiceDocumentService {
    private static final Logger LOG = LogManager.getLogger(CustomerInvoiceDocumentServiceImpl.class);
    protected AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService;
    protected BusinessObjectService businessObjectService;
    protected CustomerAddressService customerAddressService;
    protected CustomerInvoiceDetailService customerInvoiceDetailService;
    protected CustomerInvoiceDocumentDao customerInvoiceDocumentDao;
    protected ConfigurationService configurationService;
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected DocumentDao documentDao;
    protected FinancialSystemUserService financialSystemUserService;
    protected InvoicePaidAppliedService<CustomerInvoiceDetail> invoicePaidAppliedService;
    protected NonInvoicedDistributionService nonInvoicedDistributionService;
    protected PersonService personService;
    protected UniversityDateService universityDateService;
    protected NoteService noteService;
    protected IdentityService identityService;

    @Override
    public void convertDiscountsToPaidApplieds(CustomerInvoiceDocument invoice) {
        KualiDecimal openAmount = invoice.getOpenAmount();
        String invoiceNumber = invoice.getDocumentNumber();
        List<CustomerInvoiceDetail> discounts = invoice.getDiscounts();
        Integer paidAppliedItemNumber = 0;
        for (CustomerInvoiceDetail discount : discounts) {
            if (KualiDecimal.ZERO.equals((Object)discount.getAmount())) continue;
            if (paidAppliedItemNumber == 0) {
                paidAppliedItemNumber = this.invoicePaidAppliedService.getNumberOfInvoicePaidAppliedsForInvoiceDetail(invoiceNumber, discount.getInvoiceItemNumber());
            }
            InvoicePaidApplied invoicePaidApplied = new InvoicePaidApplied();
            invoicePaidApplied.setDocumentNumber(invoiceNumber);
            Integer n = paidAppliedItemNumber;
            Integer n2 = paidAppliedItemNumber = Integer.valueOf(paidAppliedItemNumber + 1);
            invoicePaidApplied.setPaidAppliedItemNumber(n);
            invoicePaidApplied.setFinancialDocumentReferenceInvoiceNumber(invoiceNumber);
            invoicePaidApplied.setInvoiceItemNumber(discount.getInvoiceItemNumber());
            invoicePaidApplied.setUniversityFiscalYear(this.universityDateService.getCurrentFiscalYear());
            invoicePaidApplied.setUniversityFiscalPeriodCode(this.universityDateService.getCurrentUniversityDate().getUniversityFiscalAccountingPeriod());
            invoicePaidApplied.setInvoiceItemAppliedAmount((KualiDecimal)discount.getAmount().abs());
            openAmount = (KualiDecimal)openAmount.subtract(discount.getAmount().abs());
            this.businessObjectService.save((PersistableBusinessObject)invoicePaidApplied);
        }
        if (KualiDecimal.ZERO.equals((Object)openAmount)) {
            invoice.setOpenInvoiceIndicator(false);
            invoice.setClosedDate(this.dateTimeService.getCurrentSqlDate());
            this.documentService.updateDocument((Document)invoice);
        }
    }

    @Override
    public Collection<CustomerInvoiceDocument> getAllOpenCustomerInvoiceDocuments() {
        return this.getAllOpenCustomerInvoiceDocuments(true);
    }

    @Override
    public Collection<CustomerInvoiceDocument> getAllOpenCustomerInvoiceDocumentsWithoutWorkflow() {
        return this.getAllOpenCustomerInvoiceDocuments(false);
    }

    public Collection<CustomerInvoiceDocument> getAllOpenCustomerInvoiceDocuments(boolean includeWorkflowHeaders) {
        ArrayList<CustomerInvoiceDocument> invoices = new ArrayList();
        invoices = this.customerInvoiceDocumentDao.getAllOpen();
        if (!includeWorkflowHeaders) {
            return invoices;
        }
        ArrayList<String> documentHeaderIds = new ArrayList<String>();
        for (CustomerInvoiceDocument customerInvoiceDocument : invoices) {
            documentHeaderIds.add(customerInvoiceDocument.getDocumentNumber());
        }
        ArrayList<CustomerInvoiceDocument> docs = new ArrayList<CustomerInvoiceDocument>();
        try {
            for (Document doc : this.documentService.getDocumentsByListOfDocumentHeaderIds(CustomerInvoiceDocument.class, documentHeaderIds)) {
                docs.add((CustomerInvoiceDocument)doc);
            }
        }
        catch (WorkflowException workflowException) {
            throw new RuntimeException("Unable to retrieve Customer Invoice Documents", workflowException);
        }
        return docs;
    }

    @Override
    public Collection<CustomerInvoiceDocument> attachWorkflowHeadersToTheInvoices(Collection<CustomerInvoiceDocument> invoices) {
        ArrayList<CustomerInvoiceDocument> docs = new ArrayList<CustomerInvoiceDocument>();
        if (invoices == null || invoices.isEmpty()) {
            return docs;
        }
        ArrayList<String> documentHeaderIds = new ArrayList<String>();
        for (CustomerInvoiceDocument invoice : invoices) {
            documentHeaderIds.add(invoice.getDocumentNumber());
        }
        try {
            for (Document doc : this.documentService.getDocumentsByListOfDocumentHeaderIds(CustomerInvoiceDocument.class, documentHeaderIds)) {
                docs.add((CustomerInvoiceDocument)doc);
            }
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Unable to retrieve Customer Invoice Documents", e);
        }
        return docs;
    }

    @Override
    public Collection<CustomerInvoiceDocument> getOpenInvoiceDocumentsByCustomerNumber(String customerNumber) {
        ArrayList<CustomerInvoiceDocument> invoices = new ArrayList<CustomerInvoiceDocument>();
        if (StringUtils.isNotEmpty((CharSequence)customerNumber)) {
            customerNumber = customerNumber.trim().toUpperCase();
        }
        invoices.addAll(this.customerInvoiceDocumentDao.getOpenByCustomerNumber(customerNumber));
        return invoices;
    }

    @Override
    public Collection<CustomerInvoiceDocument> getOpenInvoiceDocumentsByCustomerNameByCustomerType(String customerName, String customerTypeCode) {
        ArrayList<CustomerInvoiceDocument> invoices = new ArrayList<CustomerInvoiceDocument>();
        customerName = StringUtils.replace((String)customerName, (String)"*", (String)"%");
        if (!(customerName = customerName.trim()).contains("%")) {
            customerName = customerName + "%";
        }
        customerTypeCode = customerTypeCode.trim().toUpperCase();
        invoices.addAll(this.customerInvoiceDocumentDao.getOpenByCustomerNameByCustomerType(customerName, customerTypeCode));
        return invoices;
    }

    @Override
    public Collection<CustomerInvoiceDocument> getOpenInvoiceDocumentsByCustomerName(String customerName) {
        ArrayList<CustomerInvoiceDocument> invoices = new ArrayList<CustomerInvoiceDocument>();
        customerName = StringUtils.replace((String)customerName, (String)"*", (String)"%");
        if (!(customerName = customerName.trim()).contains("%")) {
            customerName = customerName + "%";
        }
        invoices.addAll(this.customerInvoiceDocumentDao.getOpenByCustomerName(customerName));
        return invoices;
    }

    @Override
    public Collection<CustomerInvoiceDocument> getOpenInvoiceDocumentsByCustomerType(String customerTypeCode) {
        ArrayList<CustomerInvoiceDocument> invoices = new ArrayList<CustomerInvoiceDocument>();
        customerTypeCode = customerTypeCode.trim().toUpperCase();
        invoices.addAll(this.customerInvoiceDocumentDao.getOpenByCustomerType(customerTypeCode));
        return invoices;
    }

    @Override
    public Collection<CustomerInvoiceDetail> getCustomerInvoiceDetailsForCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        return this.getCustomerInvoiceDetailsForCustomerInvoiceDocument(customerInvoiceDocument.getDocumentNumber());
    }

    @Override
    public Collection<CustomerInvoiceDetail> getCustomerInvoiceDetailsForCustomerInvoiceDocumentWithCaching(CustomerInvoiceDocument customerInvoiceDocument) {
        return this.customerInvoiceDetailService.getCustomerInvoiceDetailsForInvoiceWithCaching(customerInvoiceDocument.getDocumentNumber());
    }

    @Override
    public Collection<CustomerInvoiceDetail> getCustomerInvoiceDetailsForCustomerInvoiceDocument(String customerInvoiceDocumentNumber) {
        return this.customerInvoiceDetailService.getCustomerInvoiceDetailsForInvoice(customerInvoiceDocumentNumber);
    }

    @Override
    public KualiDecimal getOpenAmountForCustomerInvoiceDocument(String customerInvoiceDocumentNumber) {
        if (null == customerInvoiceDocumentNumber) {
            return null;
        }
        return this.getOpenAmountForCustomerInvoiceDocument(this.getInvoiceByInvoiceDocumentNumber(customerInvoiceDocumentNumber));
    }

    @Override
    public KualiDecimal getOpenAmountForCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        KualiDecimal total = new KualiDecimal(0);
        if (customerInvoiceDocument.isOpenInvoiceIndicator()) {
            List<CustomerInvoiceDetail> customerInvoiceDetails = customerInvoiceDocument.getCustomerInvoiceDetailsWithoutDiscounts();
            for (CustomerInvoiceDetail detail : customerInvoiceDetails) {
                detail.setCustomerInvoiceDocument(customerInvoiceDocument);
                total = (KualiDecimal)total.add((AbstractKualiDecimal)detail.getAmountOpen());
            }
        }
        return total;
    }

    @Override
    public KualiDecimal getOriginalTotalAmountForCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        LOG.info("\n\n\n\t\t invoice: " + customerInvoiceDocument.getDocumentNumber() + "\n\t\t 111111111 HEADER TOTAL AMOUNT (should be null): " + customerInvoiceDocument.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount() + "\n\n");
        customerInvoiceDocument.getDocumentNumber();
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("documentNumber", customerInvoiceDocument.getDocumentHeader().getDocumentTemplateNumber());
        FinancialSystemDocumentHeader financialSystemDocumentHeader = (FinancialSystemDocumentHeader)this.businessObjectService.findByPrimaryKey(FinancialSystemDocumentHeader.class, criteria);
        KualiDecimal originalTotalAmount = KualiDecimal.ZERO;
        originalTotalAmount = financialSystemDocumentHeader.getFinancialDocumentTotalAmount();
        LOG.info("\n\n\n\t\t invoice: " + customerInvoiceDocument.getDocumentNumber() + "\n\t\t 333333333333 HEADER TOTAL AMOUNT (should be set now): " + customerInvoiceDocument.getFinancialSystemDocumentHeader().getFinancialDocumentTotalAmount() + "\n\n");
        return originalTotalAmount;
    }

    @Override
    public Collection<CustomerInvoiceDocument> getCustomerInvoiceDocumentsByCustomerNumber(String customerNumber) {
        ArrayList<CustomerInvoiceDocument> invoices = new ArrayList<CustomerInvoiceDocument>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("customerNumber", customerNumber);
        Collection documentHeaders = this.businessObjectService.findMatching(AccountsReceivableDocumentHeader.class, fieldValues);
        ArrayList<String> documentHeaderIds = new ArrayList<String>();
        for (AccountsReceivableDocumentHeader header : documentHeaders) {
            documentHeaderIds.add(header.getDocumentHeader().getDocumentNumber());
        }
        if (0 < documentHeaderIds.size()) {
            try {
                for (Document doc : this.documentService.getDocumentsByListOfDocumentHeaderIds(CustomerInvoiceDocument.class, documentHeaderIds)) {
                    invoices.add((CustomerInvoiceDocument)doc);
                }
            }
            catch (WorkflowException e) {
                LOG.error("getCustomerInvoiceDocumentsByCustomerNumber " + customerNumber + " failed", (Throwable)e);
            }
        }
        return invoices;
    }

    @Override
    public Customer getCustomerByOrganizationInvoiceNumber(String organizationInvoiceNumber) {
        CustomerInvoiceDocument invoice = this.getInvoiceByOrganizationInvoiceNumber(organizationInvoiceNumber);
        return invoice.getAccountsReceivableDocumentHeader().getCustomer();
    }

    @Override
    public CustomerInvoiceDocument getInvoiceByOrganizationInvoiceNumber(String organizationInvoiceNumber) {
        return this.customerInvoiceDocumentDao.getInvoiceByOrganizationInvoiceNumber(organizationInvoiceNumber);
    }

    @Override
    public Customer getCustomerByInvoiceDocumentNumber(String invoiceDocumentNumber) {
        CustomerInvoiceDocument invoice = this.getInvoiceByInvoiceDocumentNumber(invoiceDocumentNumber);
        return invoice.getAccountsReceivableDocumentHeader().getCustomer();
    }

    @Override
    public CustomerInvoiceDocument getInvoiceByInvoiceDocumentNumber(String invoiceDocumentNumber) {
        return this.customerInvoiceDocumentDao.getInvoiceByInvoiceDocumentNumber(invoiceDocumentNumber);
    }

    @Override
    public List<CustomerInvoiceDocument> getPrintableCustomerInvoiceDocumentsByInitiatorPrincipalName(String initiatorPrincipalName) {
        if (StringUtils.isBlank((CharSequence)initiatorPrincipalName)) {
            throw new IllegalArgumentException("The parameter [initiatorPrincipalName] passed in was null or blank.");
        }
        Principal initiator = this.getIdentityService().getPrincipalByPrincipalName(initiatorPrincipalName);
        if (initiator == null) {
            throw new IllegalArgumentException("The parameter value for initiatorPrincipalName [" + initiatorPrincipalName + "] passed in doesnt map to a person.");
        }
        List<String> printableUserQueueDocNumbers = this.customerInvoiceDocumentDao.getPrintableCustomerInvoiceDocumentNumbersFromUserQueue();
        ArrayList<CustomerInvoiceDocument> customerInvoiceDocumentsSuperSet = new ArrayList<CustomerInvoiceDocument>();
        if (printableUserQueueDocNumbers.size() > 0) {
            try {
                for (Document doc : this.documentService.getDocumentsByListOfDocumentHeaderIds(CustomerInvoiceDocument.class, printableUserQueueDocNumbers)) {
                    customerInvoiceDocumentsSuperSet.add((CustomerInvoiceDocument)doc);
                }
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Unable to retrieve Customer Invoice Documents", e);
            }
        } else {
            customerInvoiceDocumentsSuperSet = new ArrayList();
        }
        ArrayList<CustomerInvoiceDocument> customerInvoiceDocuments = new ArrayList<CustomerInvoiceDocument>();
        for (CustomerInvoiceDocument superSetDocument : customerInvoiceDocumentsSuperSet) {
            if (!StringUtils.equalsIgnoreCase((CharSequence)superSetDocument.getDocumentHeader().getWorkflowDocument().getInitiatorPrincipalId(), (CharSequence)initiator.getPrincipalId())) continue;
            customerInvoiceDocuments.add(superSetDocument);
        }
        return customerInvoiceDocuments;
    }

    @Override
    public List<CustomerInvoiceDocument> getPrintableCustomerInvoiceDocumentsByBillingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        List<String> documentHeaderIds = this.customerInvoiceDocumentDao.getPrintableCustomerInvoiceDocumentNumbersByBillingChartAndOrg(chartOfAccountsCode, organizationCode);
        return this.getCustomerInvoiceDocumentsByDocumentNumbers(documentHeaderIds);
    }

    protected List<CustomerInvoiceDocument> getCustomerInvoiceDocumentsByDocumentNumbers(List<String> documentHeaderIds) {
        ArrayList<CustomerInvoiceDocument> customerInvoiceDocuments = new ArrayList<CustomerInvoiceDocument>(documentHeaderIds.size());
        if (documentHeaderIds != null && !documentHeaderIds.isEmpty()) {
            try {
                for (Document doc : this.documentService.getDocumentsByListOfDocumentHeaderIds(CustomerInvoiceDocument.class, documentHeaderIds)) {
                    customerInvoiceDocuments.add((CustomerInvoiceDocument)doc);
                }
            }
            catch (WorkflowException e) {
                throw new RuntimeException("Unable to retrieve Customer Invoice Documents", e);
            }
        }
        return customerInvoiceDocuments;
    }

    @Override
    public List<CustomerInvoiceDocument> getPrintableCustomerInvoiceDocumentsForBillingStatementByBillingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        List<String> documentHeaderIds = this.customerInvoiceDocumentDao.getPrintableCustomerInvoiceDocumentNumbersForBillingStatementByBillingChartAndOrg(chartOfAccountsCode, organizationCode);
        ArrayList<CustomerInvoiceDocument> customerInvoiceDocuments = new ArrayList<CustomerInvoiceDocument>();
        if (documentHeaderIds != null && !documentHeaderIds.isEmpty()) {
            try {
                for (Document doc : this.documentService.getDocumentsByListOfDocumentHeaderIds(CustomerInvoiceDocument.class, documentHeaderIds)) {
                    customerInvoiceDocuments.add((CustomerInvoiceDocument)doc);
                }
            }
            catch (WorkflowException e) {
                throw new InfrastructureException("Unable to retrieve Customer Invoice Documents", (Exception)((Object)e));
            }
        }
        return customerInvoiceDocuments;
    }

    @Override
    public List<CustomerInvoiceDocument> getPrintableCustomerInvoiceDocumentsByProcessingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        List<String> documentHeaderIds = this.customerInvoiceDocumentDao.getPrintableCustomerInvoiceDocumentNumbersByProcessingChartAndOrg(chartOfAccountsCode, organizationCode);
        return this.getCustomerInvoiceDocumentsByDocumentNumbers(documentHeaderIds);
    }

    @Override
    public Collection<CustomerInvoiceDocument> getCustomerInvoiceDocumentsByAccountNumber(String accountNumber) {
        List<String> documentHeaderIds = this.customerInvoiceDetailService.getCustomerInvoiceDocumentNumbersByAccountNumber(accountNumber);
        return this.getCustomerInvoiceDocumentsByDocumentNumbers(documentHeaderIds);
    }

    @Override
    public List<CustomerInvoiceDocument> getCustomerInvoiceDocumentsByBillingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        List<String> documentHeaderIds = this.customerInvoiceDocumentDao.getCustomerInvoiceDocumentNumbersByBillingChartAndOrg(chartOfAccountsCode, organizationCode);
        return this.getCustomerInvoiceDocumentsByDocumentNumbers(documentHeaderIds);
    }

    @Override
    public List<CustomerInvoiceDocument> getCustomerInvoiceDocumentsByProcessingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        List<String> documentHeaderIds = this.customerInvoiceDocumentDao.getCustomerInvoiceDocumentNumbersByProcessingChartAndOrg(chartOfAccountsCode, organizationCode);
        return this.getCustomerInvoiceDocumentsByDocumentNumbers(documentHeaderIds);
    }

    @Override
    public void setupDefaultValuesForNewCustomerInvoiceDocument(CustomerInvoiceDocument document) {
        this.setupBasicDefaultValuesForCustomerInvoiceDocument(document);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = this.accountsReceivableDocumentHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
        accountsReceivableDocumentHeader.setDocumentNumber(document.getDocumentNumber());
        document.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        CustomerInvoiceRecurrenceDetails recurrenceDetails = new CustomerInvoiceRecurrenceDetails();
        recurrenceDetails.setInvoiceNumber(document.getDocumentNumber());
        document.setCustomerInvoiceRecurrenceDetails(recurrenceDetails);
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", document.getBillByChartOfAccountCode());
        criteria.put("organizationCode", document.getBilledByOrganizationCode());
        OrganizationOptions organizationOptions = (OrganizationOptions)this.businessObjectService.findByPrimaryKey(OrganizationOptions.class, criteria);
        if (ObjectUtils.isNotNull((Object)((Object)organizationOptions))) {
            document.setPrintInvoiceIndicator(organizationOptions.getPrintInvoiceIndicator());
            document.setInvoiceTermsText(organizationOptions.getOrganizationPaymentTermsText());
        }
    }

    @Override
    public void loadCustomerAddressesForCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        if (ObjectUtils.isNotNull((Object)((Object)customerInvoiceDocument.getAccountsReceivableDocumentHeader()))) {
            CustomerAddress customerShipToAddress = this.customerAddressService.getByPrimaryKey(customerInvoiceDocument.getAccountsReceivableDocumentHeader().getCustomerNumber(), customerInvoiceDocument.getCustomerShipToAddressIdentifier());
            CustomerAddress customerBillToAddress = this.customerAddressService.getByPrimaryKey(customerInvoiceDocument.getAccountsReceivableDocumentHeader().getCustomerNumber(), customerInvoiceDocument.getCustomerBillToAddressIdentifier());
            if (ObjectUtils.isNotNull((Object)customerShipToAddress)) {
                customerInvoiceDocument.setCustomerShipToAddress(customerShipToAddress);
                customerInvoiceDocument.setCustomerShipToAddressOnInvoice(customerShipToAddress);
            }
            if (ObjectUtils.isNotNull((Object)customerBillToAddress)) {
                customerInvoiceDocument.setCustomerBillToAddress(customerBillToAddress);
                customerInvoiceDocument.setCustomerBillToAddressOnInvoice(customerBillToAddress);
            }
        }
    }

    @Override
    public void setupDefaultValuesForCopiedCustomerInvoiceDocument(CustomerInvoiceDocument document) {
        this.setupBasicDefaultValuesForCustomerInvoiceDocument(document);
        String customerNumber = document.getAccountsReceivableDocumentHeader().getCustomerNumber();
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = this.accountsReceivableDocumentHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
        accountsReceivableDocumentHeader.setDocumentNumber(document.getDocumentNumber());
        accountsReceivableDocumentHeader.setCustomerNumber(customerNumber);
        document.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
        CustomerInvoiceRecurrenceDetails recurrenceDetails = new CustomerInvoiceRecurrenceDetails();
        recurrenceDetails.setInvoiceNumber(document.getDocumentNumber());
        document.setCustomerInvoiceRecurrenceDetails(recurrenceDetails);
        document.setOpenInvoiceIndicator(true);
        document.setPrintDate(null);
        document.setBillingDate(this.dateTimeService.getCurrentSqlDateMidnight());
    }

    @Override
    public Collection<NonInvoicedDistribution> getNonInvoicedDistributionsForInvoice(String documentNumber) {
        return this.nonInvoicedDistributionService.getNonInvoicedDistributionsForInvoice(documentNumber);
    }

    @Override
    public KualiDecimal getNonInvoicedTotalForInvoice(CustomerInvoiceDocument invoice) {
        Collection<NonInvoicedDistribution> payments = this.nonInvoicedDistributionService.getNonInvoicedDistributionsForInvoice(invoice);
        KualiDecimal total = new KualiDecimal(0);
        for (NonInvoicedDistribution payment : payments) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)payment.getFinancialDocumentLineAmount());
        }
        return total;
    }

    @Override
    public KualiDecimal getNonInvoicedTotalForInvoice(String documentNumber) {
        return this.getNonInvoicedTotalForInvoice(this.getInvoiceByInvoiceDocumentNumber(documentNumber));
    }

    @Override
    public KualiDecimal getPaidAppliedTotalForInvoice(CustomerInvoiceDocument invoice) {
        Collection<InvoicePaidApplied> payments = this.invoicePaidAppliedService.getInvoicePaidAppliedsForInvoice(invoice);
        KualiDecimal total = new KualiDecimal(0);
        for (InvoicePaidApplied payment : payments) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)payment.getInvoiceItemAppliedAmount());
        }
        return total;
    }

    @Override
    public KualiDecimal getPaidAppliedTotalForInvoice(String documentNumber) {
        return this.getPaidAppliedTotalForInvoice(this.getInvoiceByInvoiceDocumentNumber(documentNumber));
    }

    protected void setupBasicDefaultValuesForCustomerInvoiceDocument(CustomerInvoiceDocument document) {
        ChartOrgHolder currentUser = this.financialSystemUserService.getPrimaryOrganization(GlobalVariables.getUserSession().getPerson(), "KFS-AR");
        if (currentUser != null) {
            document.setBillByChartOfAccountCode(currentUser.getChartOfAccountsCode());
            document.setBilledByOrganizationCode(currentUser.getOrganizationCode());
        }
        document.setInvoiceDueDate(this.getDefaultInvoiceDueDate());
        document.setOpenInvoiceIndicator(true);
    }

    protected Date getDefaultInvoiceDueDate() {
        Calendar cal = this.dateTimeService.getCurrentCalendar();
        cal.add(5, 30);
        Date sqlDueDate = null;
        try {
            sqlDueDate = this.dateTimeService.convertToSqlDate(new Timestamp(cal.getTime().getTime()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return sqlDueDate;
    }

    @Override
    public void closeCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        customerInvoiceDocument.setOpenInvoiceIndicator(false);
        customerInvoiceDocument.setClosedDate(this.dateTimeService.getCurrentSqlDate());
        this.businessObjectService.save((PersistableBusinessObject)customerInvoiceDocument);
    }

    @Override
    public void updateReportedDate(String docNumber) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("documentNumber", docNumber);
        CustomerInvoiceDocument customerInvoiceDocument = (CustomerInvoiceDocument)this.businessObjectService.findByPrimaryKey(CustomerInvoiceDocument.class, criteria);
        Date reportedDate = this.dateTimeService.getCurrentSqlDate();
        if (ObjectUtils.isNotNull((Object)customerInvoiceDocument)) {
            customerInvoiceDocument.setReportedDate(reportedDate);
            this.businessObjectService.save((PersistableBusinessObject)customerInvoiceDocument);
        }
    }

    @Override
    public void updateReportedInvoiceInfo(CustomerStatementResultHolder data) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("customerNumber", data.getCustomerNumber());
        CustomerBillingStatement customerBillingStatement = (CustomerBillingStatement)this.businessObjectService.findByPrimaryKey(CustomerBillingStatement.class, criteria);
        if (ObjectUtils.isNotNull((Object)((Object)customerBillingStatement))) {
            customerBillingStatement.setPreviouslyBilledAmount(data.getCurrentBilledAmount());
            customerBillingStatement.setReportedDate(this.dateTimeService.getCurrentSqlDate());
        } else {
            customerBillingStatement = new CustomerBillingStatement();
            customerBillingStatement.setCustomerNumber(data.getCustomerNumber());
            customerBillingStatement.setPreviouslyBilledAmount(data.getCurrentBilledAmount());
            customerBillingStatement.setReportedDate(this.dateTimeService.getCurrentSqlDate());
        }
        this.businessObjectService.save((PersistableBusinessObject)customerBillingStatement);
    }

    @Override
    public boolean checkIfInvoiceNumberIsFinal(String invDocumentNumber) {
        boolean isSuccess = true;
        if (StringUtils.isBlank((CharSequence)invDocumentNumber)) {
            isSuccess = false;
        } else {
            CustomerInvoiceDocument customerInvoiceDocument = this.getInvoiceByInvoiceDocumentNumber(invDocumentNumber);
            if (ObjectUtils.isNull((Object)customerInvoiceDocument)) {
                isSuccess = false;
            } else {
                Document doc = null;
                try {
                    doc = this.documentService.getByDocumentHeaderId(invDocumentNumber);
                }
                catch (WorkflowException e) {
                    isSuccess = false;
                }
                if (ObjectUtils.isNull((Object)doc) || ObjectUtils.isNull((Object)doc.getDocumentHeader()) || doc.getDocumentHeader().getWorkflowDocument() == null || !doc.getDocumentHeader().getWorkflowDocument().isApproved() && !doc.getDocumentHeader().getWorkflowDocument().isProcessed()) {
                    isSuccess = false;
                }
            }
        }
        return isSuccess;
    }

    protected Date getPastDate(Integer amount) {
        Integer pastDateAmount = -1 * amount;
        java.util.Date today = this.getDateTimeService().getCurrentDate();
        java.util.Date pastDate = DateUtils.addDays((java.util.Date)today, (int)pastDateAmount);
        return KfsDateUtils.convertToSqlDate((java.util.Date)pastDate);
    }

    @Override
    public Collection<CustomerInvoiceDocument> getAllAgingInvoiceDocumentsByCustomerTypes(List<String> customerTypes, Integer invoiceAge, Date invoiceDueDateFrom) {
        Date pastDate = this.getPastDate(invoiceAge - 1);
        Date invoiceDueDateTo = KfsDateUtils.convertToSqlDate((java.util.Date)DateUtils.addDays((java.util.Date)pastDate, (int)1));
        LOG.info("invoiceDueDateTo" + invoiceDueDateTo);
        return this.customerInvoiceDocumentDao.getAllAgingInvoiceDocumentsByCustomerTypes(customerTypes, invoiceDueDateFrom, invoiceDueDateTo);
    }

    @Override
    public void addCloseNote(CustomerInvoiceDocument documentToClose, WorkflowDocument closingDocument) {
        if (!documentToClose.isOpenInvoiceIndicator()) {
            return;
        }
        String principalName = "Unknown";
        List actionsTaken = closingDocument.getActionsTaken();
        if (ObjectUtils.isNotNull((Object)actionsTaken)) {
            for (ActionTaken action : actionsTaken) {
                if (!this.isActionClose(action.getActionTaken())) continue;
                principalName = this.getPersonService().getPerson(action.getPrincipalId()).getName();
                break;
            }
        }
        String noteTextPattern = this.getConfigurationService().getPropertyValueAsString("note.document.customerInvoiceDocument.closeInvoiceNote");
        Object[] arguments = new Object[]{principalName, closingDocument.getDocumentTypeName(), closingDocument.getDocumentId()};
        String noteText = MessageFormat.format(noteTextPattern, arguments);
        Note note = this.getDocumentService().createNoteFromDocument((Document)documentToClose, noteText);
        note.setAuthorUniversalIdentifier(this.getIdentityService().getPrincipalByPrincipalName("kfs").getPrincipalId());
        documentToClose.addNote(this.noteService.save(note));
    }

    @Override
    public KualiDecimal calculateAppliedPaymentAmount(CustomerInvoiceDocument invoice) {
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        KualiDecimal totalPayments = KualiDecimal.ZERO;
        criteria.put("financialDocumentReferenceInvoiceNumber", invoice.getDocumentNumber());
        ArrayList<String> allowedOwningDocumentTypes = new ArrayList<String>();
        allowedOwningDocumentTypes.add("APP");
        allowedOwningDocumentTypes.add("CRM");
        criteria.put("documentHeader.workflowDocumentTypeName", allowedOwningDocumentTypes);
        Collection invoicePaidApplieds = this.businessObjectService.findMatching(InvoicePaidApplied.class, criteria);
        for (InvoicePaidApplied invoicePapidApplied : invoicePaidApplieds) {
            totalPayments = (KualiDecimal)totalPayments.add((AbstractKualiDecimal)invoicePapidApplied.getInvoiceItemAppliedAmount());
        }
        return totalPayments;
    }

    private boolean isActionClose(ActionType actionTypeToCheck) {
        return actionTypeToCheck.compareTo((Enum)ActionType.COMPLETE) == 0 || actionTypeToCheck.compareTo((Enum)ActionType.SU_BLANKET_APPROVE) == 0 || actionTypeToCheck.compareTo((Enum)ActionType.BLANKET_APPROVE) == 0 || actionTypeToCheck.compareTo((Enum)ActionType.SU_COMPLETE) == 0;
    }

    public CustomerInvoiceDocumentDao getCustomerInvoiceDocumentDao() {
        return this.customerInvoiceDocumentDao;
    }

    public void setCustomerInvoiceDocumentDao(CustomerInvoiceDocumentDao customerInvoiceDocumentDao) {
        this.customerInvoiceDocumentDao = customerInvoiceDocumentDao;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public AccountsReceivableDocumentHeaderService getAccountsReceivableDocumentHeaderService() {
        return this.accountsReceivableDocumentHeaderService;
    }

    public void setAccountsReceivableDocumentHeaderService(AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService) {
        this.accountsReceivableDocumentHeaderService = accountsReceivableDocumentHeaderService;
    }

    public CustomerAddressService getCustomerAddressService() {
        return this.customerAddressService;
    }

    public void setCustomerAddressService(CustomerAddressService customerAddressService) {
        this.customerAddressService = customerAddressService;
    }

    public void setDocumentDao(DocumentDao documentDao) {
        this.documentDao = documentDao;
    }

    public void setInvoicePaidAppliedService(InvoicePaidAppliedService invoicePaidAppliedService) {
        this.invoicePaidAppliedService = invoicePaidAppliedService;
    }

    public void setNonInvoicedDistributionService(NonInvoicedDistributionService nonInvoicedDistributionService) {
        this.nonInvoicedDistributionService = nonInvoicedDistributionService;
    }

    public void setCustomerInvoiceDetailService(CustomerInvoiceDetailService customerInvoiceDetailService) {
        this.customerInvoiceDetailService = customerInvoiceDetailService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public IdentityService getIdentityService() {
        return this.identityService;
    }

    public void setIdentityService(IdentityService identityService) {
        this.identityService = identityService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public FinancialSystemUserService getFinancialSystemUserService() {
        return this.financialSystemUserService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }
}

