/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;

public class CashControlRefDocNumberValidation
extends GenericValidation {
    private CashControlDocument cashControlDocument;
    private DocumentService documentService;

    public boolean validate(AttributedDocumentEvent event) {
        boolean isValid = true;
        GlobalVariables.getMessageMap().addToErrorPath("document");
        String paymentMedium = this.cashControlDocument.getCustomerPaymentMediumCode();
        if ("CA".equalsIgnoreCase(paymentMedium)) {
            String refDocNumber = this.cashControlDocument.getReferenceFinancialDocumentNumber();
            try {
                Long.parseLong(refDocNumber);
                if (StringUtils.isBlank((CharSequence)refDocNumber)) {
                    GlobalVariables.getMessageMap().putError("referenceFinancialDocumentNumber", "error.ar.ReferenceDocNumberCannotBeNullforPaymentMediumCash", new String[0]);
                    isValid = false;
                } else {
                    boolean docExists = ((DocumentService)SpringContext.getBean(DocumentService.class)).documentExists(refDocNumber);
                    if (!docExists) {
                        GlobalVariables.getMessageMap().putError("referenceFinancialDocumentNumber", "error.ar.ReferenceDocNumberMustBeValidforPaymentMediumCash", new String[0]);
                        isValid = false;
                    }
                }
            }
            catch (NumberFormatException nfe) {
                GlobalVariables.getMessageMap().putError("referenceFinancialDocumentNumber", "error.ar.ReferenceDocNumberMustBeValidforPaymentMediumCash", new String[0]);
                isValid = false;
            }
        }
        GlobalVariables.getMessageMap().removeFromErrorPath("document");
        return isValid;
    }

    public CashControlDocument getCashControlDocument() {
        return this.cashControlDocument;
    }

    public void setCashControlDocument(CashControlDocument cashControlDocument) {
        this.cashControlDocument = cashControlDocument;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }
}

