/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerCreditMemoDetailAmountValidation
extends GenericValidation {
    private CustomerCreditMemoDetail customerCreditMemoDetail;

    public boolean validate(AttributedDocumentEvent event) {
        BigDecimal quantity = this.customerCreditMemoDetail.getCreditMemoItemQuantity();
        KualiDecimal invoiceOpenItemAmount = this.customerCreditMemoDetail.getInvoiceOpenItemAmount();
        KualiDecimal creditMemoItemAmount = this.customerCreditMemoDetail.getCreditMemoItemTotalAmount();
        if (ObjectUtils.isNotNull((Object)creditMemoItemAmount) && ObjectUtils.isNull((Object)quantity)) {
            boolean isValid = creditMemoItemAmount.isPositive();
            if (!isValid) {
                GlobalVariables.getMessageMap().putError("document.creditMemoItemTotalAmount", "error.document.customerCreditMemoDocument.invalidCustomerCreditMemoItemAmount", new String[0]);
                return false;
            }
            isValid = creditMemoItemAmount.isLessEqual((AbstractKualiDecimal)invoiceOpenItemAmount);
            if (!isValid) {
                GlobalVariables.getMessageMap().putError("document.creditMemoItemTotalAmount", "error.document.customerCreditMemoDocument.itemAmountGreaterThanParentItemAmount", new String[0]);
                return false;
            }
        }
        return true;
    }

    public CustomerCreditMemoDetail getCustomerCreditMemoDetail() {
        return this.customerCreditMemoDetail;
    }

    public void setCustomerCreditMemoDetail(CustomerCreditMemoDetail customerCreditMemoDetail) {
        this.customerCreditMemoDetail = customerCreditMemoDetail;
    }
}

