/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.math.BigDecimal;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class CustomerCreditMemoDetailQuantityAndAmountValidation
extends GenericValidation {
    private CustomerCreditMemoDetail customerCreditMemoDetail;

    protected BigDecimal getAllowedQtyDeviation() {
        return new BigDecimal("0.10");
    }

    public boolean validate(AttributedDocumentEvent event) {
        KualiDecimal creditAmount = this.customerCreditMemoDetail.getCreditMemoItemTotalAmount();
        BigDecimal quantity = this.customerCreditMemoDetail.getCreditMemoItemQuantity();
        BigDecimal unitPrice = this.customerCreditMemoDetail.getCustomerInvoiceDetail().getInvoiceItemUnitPrice();
        if (ObjectUtils.isNotNull((Object)quantity) && ObjectUtils.isNotNull((Object)creditAmount)) {
            boolean validValue;
            BigDecimal creditQuantity = this.customerCreditMemoDetail.getCreditMemoItemQuantity();
            BigDecimal expectedCreditQuantity = creditAmount.bigDecimalValue().divide(unitPrice, ArConstants.ITEM_QUANTITY_SCALE, 4);
            if (expectedCreditQuantity.compareTo(BigDecimal.ZERO) == 0 && creditQuantity.compareTo(BigDecimal.ZERO) != 0) {
                return false;
            }
            BigDecimal deviationPercentage = creditQuantity.subtract(expectedCreditQuantity).divide(expectedCreditQuantity, ArConstants.ITEM_QUANTITY_SCALE, 4).abs();
            boolean bl = validValue = deviationPercentage.compareTo(this.getAllowedQtyDeviation()) < 1;
            if (!validValue) {
                GlobalVariables.getMessageMap().putError("creditMemoItemQuantity", "error.document.customerCreditMemoDocument.invalidDataInput", new String[0]);
                GlobalVariables.getMessageMap().putError("creditMemoItemTotalAmount", "error.document.customerCreditMemoDocument.invalidDataInput", new String[0]);
            }
        }
        return true;
    }

    public CustomerCreditMemoDetail getCustomerCreditMemoDetail() {
        return this.customerCreditMemoDetail;
    }

    public void setCustomerCreditMemoDetail(CustomerCreditMemoDetail customerCreditMemoDetail) {
        this.customerCreditMemoDetail = customerCreditMemoDetail;
    }
}

