/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.Calendar;
import java.util.Date;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.util.KfsDateUtils;

public class CustomerInvoiceBothEndDateAndTotalRecurrenceNumberValidation
extends GenericValidation {
    private CustomerInvoiceDocument customerInvoiceDocument;

    public boolean validate(AttributedDocumentEvent event) {
        if (ObjectUtils.isNull((Object)((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails()))) {
            return true;
        }
        if (ObjectUtils.isNull((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate()) || ObjectUtils.isNull((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceIntervalCode()) || ObjectUtils.isNull((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate()) || ObjectUtils.isNull((Object)this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentTotalRecurrenceNumber())) {
            return true;
        }
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate());
        java.sql.Date beginDate = this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceBeginDate();
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate());
        java.sql.Date endDate = this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceEndDate();
        Calendar nextCalendar = Calendar.getInstance();
        java.sql.Date nextDate = beginDate;
        int totalRecurrences = 0;
        int addCounter = 0;
        String intervalCode = this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentRecurrenceIntervalCode();
        if ("M".equals(intervalCode)) {
            addCounter = 1;
        }
        if ("Q".equals(intervalCode)) {
            addCounter = 3;
        }
        while (!beginDate.after(endDate)) {
            beginCalendar.setTime(beginDate);
            beginCalendar.add(2, addCounter);
            beginDate = KfsDateUtils.convertToSqlDate((Date)beginCalendar.getTime());
            ++totalRecurrences;
            nextDate = beginDate;
            nextCalendar.setTime(nextDate);
            nextCalendar.add(2, addCounter);
            nextDate = KfsDateUtils.convertToSqlDate((Date)nextCalendar.getTime());
            if (!endDate.after(beginDate) || !endDate.before(nextDate)) continue;
            ++totalRecurrences;
            break;
        }
        if (totalRecurrences != this.customerInvoiceDocument.getCustomerInvoiceRecurrenceDetails().getDocumentTotalRecurrenceNumber()) {
            GlobalVariables.getMessageMap().putError("document.customerInvoiceRecurrenceDetails.documentRecurrenceEndDate", "error.document.invoiceRecurrenceMaintenance.endDateAndTotalNumberOfRecurrencesNotValid", new String[0]);
            return false;
        }
        return true;
    }

    public CustomerInvoiceDocument getCustomerInvoiceDocument() {
        return this.customerInvoiceDocument;
    }

    public void setCustomerInvoiceDocument(CustomerInvoiceDocument customerInvoiceDocument) {
        this.customerInvoiceDocument = customerInvoiceDocument;
    }
}

