/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.module.ar.businessobject.DunningCampaign;
import org.kuali.kfs.module.ar.businessobject.DunningLetterDistribution;

public class DunningCampaignRule
extends MaintenanceDocumentRuleBase {
    public boolean processSaveDocument(Document document) {
        super.processSaveDocument(document);
        this.processRouteDocument(document);
        return true;
    }

    public boolean processRouteDocument(Document document) {
        boolean isValid = super.processRouteDocument(document);
        return isValid &= this.validateDuplicatePastDue((MaintenanceDocument)document);
    }

    public boolean processAddCollectionLineBusinessRules(MaintenanceDocument document, String collectionName, PersistableBusinessObject bo) {
        boolean isValid = super.processAddCollectionLineBusinessRules(document, collectionName, bo);
        if (collectionName.equalsIgnoreCase("dunningLetterDistributions")) {
            DunningLetterDistribution newLine = (DunningLetterDistribution)document.getNewMaintainableObject().getNewCollectionLine("dunningLetterDistributions");
            DunningCampaign dunningCampaign = (DunningCampaign)((Object)document.getNewMaintainableObject().getDataObject());
            HashSet<String> daysPastDueSet = new HashSet<String>();
            daysPastDueSet.add(newLine.getDaysPastDue());
            isValid &= this.isDuplicatePastDue(daysPastDueSet, dunningCampaign.getDunningLetterDistributions(), true);
        }
        return isValid;
    }

    private boolean validateDuplicatePastDue(MaintenanceDocument document) {
        DunningCampaign dunningCampaign = (DunningCampaign)((Object)document.getNewMaintainableObject().getDataObject());
        HashSet<String> daysPastDueSet = new HashSet<String>();
        return this.isDuplicatePastDue(daysPastDueSet, dunningCampaign.getDunningLetterDistributions(), false);
    }

    private boolean isDuplicatePastDue(Set<String> daysPastDueSet, List<DunningLetterDistribution> dunningLetterDistributions, boolean isAddLine) {
        int lineNumber = 0;
        for (DunningLetterDistribution dld : dunningLetterDistributions) {
            if (!daysPastDueSet.add(dld.getDaysPastDue())) {
                if (isAddLine) {
                    this.putFieldError("add.dunningLetterDistributions.daysPastDue", "error.document.daysPastDue.duplicateValue");
                } else {
                    this.putFieldError("dunningLetterDistributions[" + lineNumber + "]." + "daysPastDue", "error.document.daysPastDue.duplicateValue");
                }
                return false;
            }
            ++lineNumber;
        }
        return true;
    }
}

