/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.coa.service.ObjectTypeService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.sys.context.SpringContext;

public class OrganizationAccountingDefaultRule
extends MaintenanceDocumentRuleBase {
    protected static Logger LOG = LogManager.getLogger(OrganizationAccountingDefaultRule.class);
    protected ObjectTypeService objectTypeService;
    protected OrganizationAccountingDefault newOrganizationAccountingDefault;
    protected OrganizationAccountingDefault oldOrganizationAccountingDefault;

    public void setupConvenienceObjects() {
        this.newOrganizationAccountingDefault = (OrganizationAccountingDefault)((Object)super.getNewBo());
        this.oldOrganizationAccountingDefault = (OrganizationAccountingDefault)((Object)super.getOldBo());
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = true;
        success &= this.isWriteOffObjectValidExpense(this.newOrganizationAccountingDefault);
        success &= this.isLateChargeObjectValidIncome(this.newOrganizationAccountingDefault);
        success &= this.isDefaultInvoiceFinancialObjectValidIncome(this.newOrganizationAccountingDefault);
        String writeoffOption = ((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsString(CustomerInvoiceWriteoffDocument.class, "GLPE_WRITEOFF_GENERATION_METHOD");
        if ("2".equals(writeoffOption)) {
            success &= this.doesWriteoffAccountNumberExist(this.newOrganizationAccountingDefault);
            success &= this.doesWriteoffChartOfAccountsCodeExist(this.newOrganizationAccountingDefault);
            success &= this.doesWriteoffFinancialObjectCodeExist(this.newOrganizationAccountingDefault);
        }
        return success;
    }

    protected boolean doesWriteoffAccountNumberExist(OrganizationAccountingDefault organizationAccountingDefault) {
        if (StringUtils.isEmpty((CharSequence)organizationAccountingDefault.getWriteoffAccountNumber())) {
            this.putFieldError("writeoffAccountNumber", "error.document.customerInvoiceDocument.writeoffAccountNumberRequired");
            return false;
        }
        return true;
    }

    protected boolean doesWriteoffChartOfAccountsCodeExist(OrganizationAccountingDefault organizationAccountingDefault) {
        if (StringUtils.isEmpty((CharSequence)organizationAccountingDefault.getWriteoffChartOfAccountsCode())) {
            this.putFieldError("writeoffChartOfAccountsCode", "error.document.customerInvoiceDocument.writeoffChartOfAccountsCodeRequired");
            return false;
        }
        return true;
    }

    protected boolean doesWriteoffFinancialObjectCodeExist(OrganizationAccountingDefault organizationAccountingDefault) {
        if (StringUtils.isEmpty((CharSequence)organizationAccountingDefault.getWriteoffFinancialObjectCode())) {
            this.putFieldError("writeoffFinancialObjectCode", "error.document.customerInvoiceDocument.writeoffFinancialObjectCodeRequired");
            return false;
        }
        return true;
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        this.processCustomRouteDocumentBusinessRules(document);
        return true;
    }

    protected boolean checkOrgOptionsExists() {
        return true;
    }

    protected boolean isWriteOffObjectValidExpense(OrganizationAccountingDefault organizationAccountingDefault) {
        boolean success = true;
        Integer universityFiscalYear = organizationAccountingDefault.getUniversityFiscalYear();
        ObjectCode writeObject = organizationAccountingDefault.getWriteoffFinancialObject();
        if (ObjectUtils.isNotNull((Object)universityFiscalYear) && ObjectUtils.isNotNull((Object)writeObject) && !(success = this.getObjectTypeService().getBasicExpenseObjectTypes(universityFiscalYear).contains(writeObject.getFinancialObjectTypeCode()))) {
            this.putFieldError("writeoffFinancialObjectCode", "error.document.organizationAccountingDefaultMaintenance.writeOffObjectCodeInvalid", writeObject.getCode());
        }
        return success;
    }

    protected boolean isLateChargeObjectValidIncome(OrganizationAccountingDefault organizationAccountingDefault) {
        boolean success = true;
        Integer universityFiscalYear = organizationAccountingDefault.getUniversityFiscalYear();
        ObjectCode lateChargeObject = organizationAccountingDefault.getOrganizationLateChargeObject();
        if (ObjectUtils.isNotNull((Object)universityFiscalYear) && ObjectUtils.isNotNull((Object)lateChargeObject) && !(success = this.getObjectTypeService().getBasicIncomeObjectTypes(universityFiscalYear).contains(lateChargeObject.getFinancialObjectTypeCode()))) {
            this.putFieldError("organizationLateChargeObjectCode", "error.document.organizationAccountingDefaultMaintenance.lateChargeObjectCodeInvalid", lateChargeObject.getCode());
        }
        return success;
    }

    protected boolean isDefaultInvoiceFinancialObjectValidIncome(OrganizationAccountingDefault organizationAccountingDefault) {
        boolean success = true;
        if (StringUtils.isNotEmpty((CharSequence)organizationAccountingDefault.getDefaultInvoiceFinancialObjectCode()) && StringUtils.isEmpty((CharSequence)organizationAccountingDefault.getDefaultInvoiceChartOfAccountsCode())) {
            this.putFieldError("defaultInvoiceChartOfAccountsCode", "error.document.organizationAccountingDefaultMaintenance.defaultInvoiceChartOfAccountsCodeMustExist");
            success = false;
        } else {
            Integer universityFiscalYear = organizationAccountingDefault.getUniversityFiscalYear();
            ObjectCode defaultInvoiceFinancialObject = organizationAccountingDefault.getDefaultInvoiceFinancialObject();
            if (ObjectUtils.isNotNull((Object)universityFiscalYear) && ObjectUtils.isNotNull((Object)defaultInvoiceFinancialObject) && !(success = this.getObjectTypeService().getBasicIncomeObjectTypes(universityFiscalYear).contains(defaultInvoiceFinancialObject.getFinancialObjectTypeCode()))) {
                this.putFieldError("defaultInvoiceChartOfAccountsCode", "error.document.organizationAccountingDefaultMaintenance.defaultInvoiceFinancialObjectCodeInvalid", defaultInvoiceFinancialObject.getCode());
            }
        }
        return success;
    }

    public ObjectTypeService getObjectTypeService() {
        if (this.objectTypeService == null) {
            this.objectTypeService = (ObjectTypeService)SpringContext.getBean(ObjectTypeService.class);
        }
        return this.objectTypeService;
    }

    public void setObjectTypeService(ObjectTypeService objectTypeService) {
        this.objectTypeService = objectTypeService;
    }
}

