/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.service.SessionDocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentFormBase;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class CashControlForm
extends FinancialSystemTransactionalDocumentFormBase {
    private static final Logger LOG = LogManager.getLogger(CashControlForm.class);
    protected CashControlDetail newCashControlDetail;
    protected String processingChartOfAccCodeAndOrgCode;
    protected boolean cashPaymentMediumSelected;

    protected String getDefaultDocumentTypeName() {
        return "CTRL";
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        if (this.hasDocumentId()) {
            CashControlDocument ccDoc = this.getCashControlDocument();
            for (CashControlDetail cashControlDetail : ccDoc.getCashControlDetails()) {
                if (cashControlDetail.getReferenceFinancialDocument().getDocumentHeader().hasWorkflowDocument()) continue;
                try {
                    WorkflowDocument workflowDocument = ((SessionDocumentService)SpringContext.getBean(SessionDocumentService.class)).getDocumentFromSession(GlobalVariables.getUserSession(), cashControlDetail.getReferenceFinancialDocumentNumber());
                    if (workflowDocument == null) {
                        workflowDocument = ((WorkflowDocumentService)SpringContext.getBean(WorkflowDocumentService.class)).loadWorkflowDocument(cashControlDetail.getReferenceFinancialDocumentNumber(), GlobalVariables.getUserSession().getPerson());
                        ((SessionDocumentService)SpringContext.getBean(SessionDocumentService.class)).addDocumentToUserSession(GlobalVariables.getUserSession(), workflowDocument);
                        if (workflowDocument == null) {
                            throw new WorkflowException("Unable to get retrieve document # " + cashControlDetail.getReferenceFinancialDocumentNumber() + " from document service getByDocumentHeaderId");
                        }
                    }
                    cashControlDetail.getReferenceFinancialDocument().getDocumentHeader().setWorkflowDocument(workflowDocument);
                }
                catch (WorkflowException e) {
                    LOG.warn("Error while instantiating workflowDoc: " + cashControlDetail.getReferenceFinancialDocumentNumber(), (Throwable)e);
                    throw new RuntimeException("error populating documentHeader.workflowDocument", e);
                }
            }
        }
    }

    public CashControlDocument getCashControlDocument() {
        return (CashControlDocument)this.getDocument();
    }

    public CashControlDetail getNewCashControlDetail() {
        if (this.newCashControlDetail == null) {
            this.newCashControlDetail = new CashControlDetail();
        }
        return this.newCashControlDetail;
    }

    public void setNewCashControlDetail(CashControlDetail newCashControlDetail) {
        this.newCashControlDetail = newCashControlDetail;
    }

    public String getProcessingChartOfAccCodeAndOrgCode() {
        return this.getCashControlDocument().getAccountsReceivableDocumentHeader().getProcessingChartOfAccCodeAndOrgCode();
    }

    public void setProcessingChartOfAccCodeAndOrgCode(String processingChartOfAccCodeAndOrgCode) {
        this.processingChartOfAccCodeAndOrgCode = processingChartOfAccCodeAndOrgCode;
    }

    public boolean isCashPaymentMediumSelected() {
        return this.cashPaymentMediumSelected;
    }

    public void setCashPaymentMediumSelected(boolean cashPaymentMediumSelected) {
        this.cashPaymentMediumSelected = cashPaymentMediumSelected;
    }
}

