/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsCollectionActivityInvoiceDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsCollectionActivityDocument;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsCollectionActivityDocumentService;
import org.kuali.kfs.module.ar.document.web.struts.ContractsGrantsCollectionActivityForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;
import org.kuali.kfs.sys.service.SegmentedLookupResultsService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class ContractsGrantsCollectionActivityAction
extends FinancialSystemTransactionalDocumentActionBase {
    protected static transient ContractsGrantsCollectionActivityDocumentService contractsGrantsCollectionActivityDocumentService;
    protected static transient BusinessObjectService businessObjectService;
    protected static transient SegmentedLookupResultsService segmentedLookupResultsService;
    protected static transient DateTimeService dateTimeService;

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        ContractsGrantsCollectionActivityForm cgCollectionActivityForm = (ContractsGrantsCollectionActivityForm)kualiDocumentFormBase;
        ContractsGrantsCollectionActivityDocument document = cgCollectionActivityForm.getCollectionActivityDocument();
        document.setActivityDate(ContractsGrantsCollectionActivityAction.getDateTimeService().getCurrentSqlDate());
        if (!StringUtils.isBlank((CharSequence)cgCollectionActivityForm.getSelectedProposalNumber())) {
            document.setProposalNumber(cgCollectionActivityForm.getSelectedProposalNumber());
            this.refreshAward(document);
        }
    }

    public ActionForward deleteInvoice(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsCollectionActivityForm colActDocForm = (ContractsGrantsCollectionActivityForm)form;
        ContractsGrantsCollectionActivityDocument colActDoc = colActDocForm.getCollectionActivityDocument();
        int indexOfLineToDelete = this.getLineToDelete(request);
        colActDoc.deleteInvoiceDetail(indexOfLineToDelete);
        return mapping.findForward("basic");
    }

    public ActionForward refresh(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        super.refresh(mapping, form, request, response);
        ContractsGrantsCollectionActivityForm collectionActivityDocumentForm = (ContractsGrantsCollectionActivityForm)form;
        ContractsGrantsCollectionActivityDocument colActDoc = collectionActivityDocumentForm.getCollectionActivityDocument();
        if (StringUtils.equals((CharSequence)"multipleValues", (CharSequence)collectionActivityDocumentForm.getRefreshCaller())) {
            String lookupResultsSequenceNumber = collectionActivityDocumentForm.getLookupResultsSequenceNumber();
            this.refreshInvoices(colActDoc, lookupResultsSequenceNumber);
        }
        if (StringUtils.equals((CharSequence)"awardLookupable", (CharSequence)collectionActivityDocumentForm.getRefreshCaller())) {
            this.refreshAward(colActDoc);
        }
        return mapping.findForward("basic");
    }

    protected void refreshInvoices(ContractsGrantsCollectionActivityDocument colActDoc, String lookupResultsSequenceNumber) throws Exception {
        Set selectedIds = ContractsGrantsCollectionActivityAction.getSegmentedLookupResultsService().retrieveSetOfSelectedObjectIds(lookupResultsSequenceNumber, GlobalVariables.getUserSession().getPerson().getPrincipalId());
        if (ObjectUtils.isNotNull((Object)selectedIds) && CollectionUtils.isNotEmpty((Collection)selectedIds)) {
            for (String invoiceDocumentNumber : selectedIds) {
                HashMap<String, String> criteria = new HashMap<String, String>();
                criteria.put("documentNumber", invoiceDocumentNumber);
                ContractsGrantsInvoiceDocument cgInvoiceDocument = (ContractsGrantsInvoiceDocument)this.getBusinessObjectService().findByPrimaryKey(ContractsGrantsInvoiceDocument.class, criteria);
                if (!ObjectUtils.isNotNull((Object)cgInvoiceDocument)) continue;
                ContractsGrantsCollectionActivityInvoiceDetail invoiceDetail = new ContractsGrantsCollectionActivityInvoiceDetail();
                invoiceDetail.setBillingPeriod(cgInvoiceDocument.getInvoiceGeneralDetail().getBillingPeriod());
                invoiceDetail.setBillingDate(cgInvoiceDocument.getBillingDate());
                invoiceDetail.setInvoiceNumber(cgInvoiceDocument.getDocumentNumber());
                invoiceDetail.setDocumentNumber(colActDoc.getDocumentNumber());
                if (colActDoc.getInvoiceDetails().contains((Object)invoiceDetail)) continue;
                colActDoc.getInvoiceDetails().add(invoiceDetail);
            }
        }
    }

    protected void refreshAward(ContractsGrantsCollectionActivityDocument colActDoc) {
        if (ObjectUtils.isNotNull((Object)colActDoc.getProposalNumber())) {
            ContractsAndGrantsBillingAward award = ContractsGrantsCollectionActivityAction.getContractsGrantsCollectionActivityDocumentService().retrieveAwardByProposalNumber(colActDoc.getProposalNumber());
            if (ObjectUtils.isNotNull((Object)award)) {
                colActDoc.setAgencyNumber(award.getAgencyNumber());
                colActDoc.setAgencyName(award.getAgency().getFullName());
                if (ObjectUtils.isNotNull((Object)award.getAgency().getCustomer())) {
                    colActDoc.setCustomerNumber(award.getAgency().getCustomer().getCustomerNumber());
                    colActDoc.setCustomerName(award.getAgency().getCustomer().getCustomerName());
                }
            } else {
                colActDoc.setAgencyNumber("Award not found");
                colActDoc.setAgencyName("");
                colActDoc.setCustomerNumber("");
                colActDoc.setCustomerName("");
            }
        }
    }

    public static ContractsGrantsCollectionActivityDocumentService getContractsGrantsCollectionActivityDocumentService() {
        if (contractsGrantsCollectionActivityDocumentService == null) {
            contractsGrantsCollectionActivityDocumentService = (ContractsGrantsCollectionActivityDocumentService)SpringContext.getBean(ContractsGrantsCollectionActivityDocumentService.class);
        }
        return contractsGrantsCollectionActivityDocumentService;
    }

    public static SegmentedLookupResultsService getSegmentedLookupResultsService() {
        if (segmentedLookupResultsService == null) {
            segmentedLookupResultsService = (SegmentedLookupResultsService)SpringContext.getBean(SegmentedLookupResultsService.class);
        }
        return segmentedLookupResultsService;
    }

    public static DateTimeService getDateTimeService() {
        if (dateTimeService == null) {
            dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return dateTimeService;
    }
}

