/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.ChartOrgHolderImpl;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.role.RoleMembership;

public class AccountsReceivableOrganizationDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected static final String PROCESSOR_ROLE_NAME = "Processor";
    protected static final String UNMATCHABLE_QUALIFICATION = "!~!~!~!~!~";
    protected BusinessObjectService businessObjectService;
    protected FinancialSystemUserService financialSystemUserService;
    protected UniversityDateService universityDateService;

    protected ChartOrgHolder getProcessingChartOrg(Map<String, String> qualification) {
        ChartOrgHolderImpl chartOrg = null;
        if (qualification != null && !qualification.isEmpty()) {
            chartOrg = new ChartOrgHolderImpl();
            chartOrg.setChartOfAccountsCode(qualification.get("processingChartOfAccountCode"));
            chartOrg.setOrganizationCode(qualification.get("processingOrganizationCode"));
            if (StringUtils.isBlank((CharSequence)chartOrg.getChartOfAccountsCode()) || StringUtils.isBlank((CharSequence)chartOrg.getOrganizationCode())) {
                chartOrg.setChartOfAccountsCode(qualification.get("chartOfAccountsCode"));
                chartOrg.setOrganizationCode(qualification.get("organizationCode"));
                if (StringUtils.isBlank((CharSequence)chartOrg.getChartOfAccountsCode()) || StringUtils.isBlank((CharSequence)chartOrg.getOrganizationCode())) {
                    return null;
                }
                HashMap<String, String> arOrgOptPk = new HashMap<String, String>(2);
                arOrgOptPk.put("chartOfAccountsCode", chartOrg.getChartOfAccountsCode());
                arOrgOptPk.put("organizationCode", chartOrg.getOrganizationCode());
                OrganizationOptions oo = (OrganizationOptions)this.getBusinessObjectService().findByPrimaryKey(OrganizationOptions.class, arOrgOptPk);
                if (oo != null) {
                    chartOrg.setChartOfAccountsCode(oo.getProcessingChartOfAccountCode());
                    chartOrg.setOrganizationCode(oo.getProcessingOrganizationCode());
                } else {
                    chartOrg.setChartOfAccountsCode(UNMATCHABLE_QUALIFICATION);
                    chartOrg.setOrganizationCode(UNMATCHABLE_QUALIFICATION);
                }
            }
        }
        return chartOrg;
    }

    public boolean hasProcessorRole(ChartOrgHolder userOrg, Map<String, String> qualification) {
        ChartOrgHolder processingOrg = this.getProcessingChartOrg(qualification);
        if (processingOrg == null) {
            HashMap<String, Object> arProcessOrgCriteria = new HashMap<String, Object>(2);
            arProcessOrgCriteria.put("processingChartOfAccountCode", userOrg.getChartOfAccountsCode());
            arProcessOrgCriteria.put("processingOrganizationCode", userOrg.getOrganizationCode());
            arProcessOrgCriteria.put("active", "Y");
            arProcessOrgCriteria.put("universityFiscalYear", this.universityDateService.getCurrentFiscalYear());
            return this.getBusinessObjectService().countMatching(SystemInformation.class, arProcessOrgCriteria) > 0;
        }
        return processingOrg.equals(userOrg);
    }

    public boolean hasBillerRole(ChartOrgHolder userOrg, Map<String, String> qualification) {
        ChartOrgHolderImpl billingOrg = new ChartOrgHolderImpl();
        if (qualification != null && !qualification.isEmpty()) {
            billingOrg.setChartOfAccountsCode(qualification.get("chartOfAccountsCode"));
            billingOrg.setOrganizationCode(qualification.get("organizationCode"));
        }
        if (StringUtils.isBlank((CharSequence)billingOrg.getChartOfAccountsCode()) || StringUtils.isBlank((CharSequence)billingOrg.getOrganizationCode())) {
            HashMap<String, String> arOrgOptPk = new HashMap<String, String>(2);
            arOrgOptPk.put("chartOfAccountsCode", userOrg.getChartOfAccountsCode());
            arOrgOptPk.put("organizationCode", userOrg.getOrganizationCode());
            return this.getBusinessObjectService().countMatching(OrganizationOptions.class, arOrgOptPk) > 0;
        }
        return billingOrg.equals((Object)userOrg);
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        this.validateRequiredAttributesAgainstReceived(qualification);
        if (this.getFinancialSystemUserService().isActiveFinancialSystemUser(principalId)) {
            ChartOrgHolder userOrg = this.getFinancialSystemUserService().getPrimaryOrganization(principalId, "KFS-AR");
            if (PROCESSOR_ROLE_NAME.equals(roleName)) {
                return this.hasProcessorRole(userOrg, qualification);
            }
            return this.hasBillerRole(userOrg, qualification) || this.hasProcessorRole(userOrg, qualification);
        }
        return false;
    }

    public List<RoleMembership> getRoleMembersFromApplicationRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        ArrayList<RoleMembership> results;
        block12: {
            HashSet principalIds;
            block10: {
                ChartOrgHolder processingOrg;
                block11: {
                    this.validateRequiredAttributesAgainstReceived(qualification);
                    results = new ArrayList<RoleMembership>();
                    principalIds = new HashSet();
                    if (!PROCESSOR_ROLE_NAME.equals(roleName)) break block10;
                    processingOrg = this.getProcessingChartOrg(qualification);
                    if (processingOrg != null) break block11;
                    List ooList = (List)this.getBusinessObjectService().findAll(OrganizationOptions.class);
                    for (OrganizationOptions oo : ooList) {
                        principalIds.clear();
                        principalIds.addAll(this.getFinancialSystemUserService().getPrincipalIdsForFinancialSystemOrganizationUsers(namespaceCode, (ChartOrgHolder)new ChartOrgHolderImpl(oo.getProcessingChartOfAccountCode(), oo.getProcessingOrganizationCode())));
                        if (principalIds.isEmpty()) continue;
                        HashMap<String, String> roleQualifier = new HashMap<String, String>(2);
                        roleQualifier.put("chartOfAccountsCode", oo.getProcessingChartOfAccountCode());
                        roleQualifier.put("organizationCode", oo.getProcessingOrganizationCode());
                        for (String principalId : principalIds) {
                            RoleMembership.Builder builder = RoleMembership.Builder.create(null, null, (String)principalId, (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, roleQualifier);
                            results.add(builder.build());
                        }
                    }
                    break block12;
                }
                principalIds.addAll(this.getFinancialSystemUserService().getPrincipalIdsForFinancialSystemOrganizationUsers("KFS-AR", processingOrg));
                if (principalIds.isEmpty()) break block12;
                HashMap<String, String> roleQualifier = new HashMap<String, String>(2);
                roleQualifier.put("chartOfAccountsCode", processingOrg.getChartOfAccountsCode());
                roleQualifier.put("organizationCode", processingOrg.getOrganizationCode());
                for (String principalId : principalIds) {
                    RoleMembership.Builder builder = RoleMembership.Builder.create(null, null, (String)principalId, (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, roleQualifier);
                    results.add(builder.build());
                }
                break block12;
            }
            ChartOrgHolderImpl billingOrg = new ChartOrgHolderImpl();
            if (qualification != null && !qualification.isEmpty()) {
                billingOrg.setChartOfAccountsCode(qualification.get("chartOfAccountsCode"));
                billingOrg.setOrganizationCode(qualification.get("organizationCode"));
            }
            if (StringUtils.isBlank((CharSequence)billingOrg.getChartOfAccountsCode()) || StringUtils.isBlank((CharSequence)billingOrg.getOrganizationCode())) {
                List ooList = (List)this.getBusinessObjectService().findAll(OrganizationOptions.class);
                for (OrganizationOptions oo : ooList) {
                    principalIds.clear();
                    principalIds.addAll(this.getFinancialSystemUserService().getPrincipalIdsForFinancialSystemOrganizationUsers(namespaceCode, (ChartOrgHolder)new ChartOrgHolderImpl(oo.getChartOfAccountsCode(), oo.getOrganizationCode())));
                    if (principalIds.isEmpty()) continue;
                    HashMap<String, String> roleQualifier = new HashMap<String, String>(2);
                    roleQualifier.put("chartOfAccountsCode", oo.getChartOfAccountsCode());
                    roleQualifier.put("organizationCode", oo.getOrganizationCode());
                    for (String principalId : principalIds) {
                        RoleMembership.Builder builder = RoleMembership.Builder.create(null, null, (String)principalId, (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, roleQualifier);
                        results.add(builder.build());
                    }
                }
            } else {
                principalIds.addAll(this.getFinancialSystemUserService().getPrincipalIdsForFinancialSystemOrganizationUsers("KFS-AR", (ChartOrgHolder)billingOrg));
                if (!principalIds.isEmpty()) {
                    HashMap<String, String> roleQualifier = new HashMap<String, String>(2);
                    roleQualifier.put("chartOfAccountsCode", billingOrg.getChartOfAccountsCode());
                    roleQualifier.put("organizationCode", billingOrg.getOrganizationCode());
                    for (String principalId : principalIds) {
                        RoleMembership.Builder builder = RoleMembership.Builder.create(null, null, (String)principalId, (MemberType)KimConstants.KimGroupMemberTypes.PRINCIPAL_MEMBER_TYPE, roleQualifier);
                        results.add(builder.build());
                    }
                }
            }
        }
        return results;
    }

    protected BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public final FinancialSystemUserService getFinancialSystemUserService() {
        return this.financialSystemUserService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }
}

