/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class PdfFormattingMap
implements Map<String, String> {
    protected Map wrappedMap;
    private static volatile DateTimeService dateTimeService;
    private static volatile ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService;

    public PdfFormattingMap(Map mapToWrap) {
        if (ObjectUtils.isNull((Object)mapToWrap)) {
            throw new IllegalArgumentException("Cannot wrap a null map");
        }
        this.wrappedMap = mapToWrap;
    }

    @Override
    public int size() {
        return this.wrappedMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.wrappedMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.wrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.wrappedMap.containsValue(value);
    }

    @Override
    public String get(Object key) {
        return this.stringifyValue(this.wrappedMap.get(key));
    }

    @Override
    public String put(String key, String value) {
        String returnedValue = this.wrappedMap.put(key, value);
        return ObjectUtils.isNull((Object)returnedValue) ? "" : returnedValue.toString();
    }

    @Override
    public String remove(Object key) {
        Object returnedValue = this.wrappedMap.remove(key);
        return ObjectUtils.isNull(returnedValue) ? "" : returnedValue.toString();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {
        this.wrappedMap.putAll(m);
    }

    @Override
    public void clear() {
        this.wrappedMap.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        for (Object key : this.wrappedMap.keySet()) {
            if (ObjectUtils.isNull(key)) continue;
            keySet.add(key.toString());
        }
        return keySet;
    }

    @Override
    public Collection<String> values() {
        ArrayList<String> values = new ArrayList<String>();
        for (Object value : this.wrappedMap.values()) {
            if (ObjectUtils.isNull(value)) continue;
            values.add(this.stringifyValue(value));
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        HashSet<Map.Entry<String, String>> entrySet = new HashSet<Map.Entry<String, String>>();
        for (Map.Entry entry : this.wrappedMap.entrySet()) {
            if (!(entry instanceof Map.Entry)) continue;
            String key = ObjectUtils.isNull(entry.getKey()) ? "" : entry.getKey().toString();
            String value = this.stringifyValue(entry.getValue());
            AbstractMap.SimpleImmutableEntry<String, String> stringyEntry = new AbstractMap.SimpleImmutableEntry<String, String>(key, value);
            entrySet.add(stringyEntry);
        }
        return entrySet;
    }

    protected String stringifyValue(Object value) {
        if (ObjectUtils.isNull((Object)value)) {
            return "";
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Date) {
            return this.getDateTimeService().toDateString((Date)value);
        }
        if (value instanceof Boolean || Boolean.TYPE.equals(value.getClass())) {
            return this.stringifyBooleanForContractsGrantsInvoiceTemplate((Boolean)value);
        }
        if (value instanceof KualiDecimal) {
            return this.getContractsGrantsBillingUtilityService().formatForCurrency((KualiDecimal)value);
        }
        return Objects.toString(value);
    }

    protected String stringifyBooleanForContractsGrantsInvoiceTemplate(boolean bool) {
        return bool ? "Yes" : "No";
    }

    protected DateTimeService getDateTimeService() {
        if (dateTimeService == null) {
            dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return dateTimeService;
    }

    protected ContractsGrantsBillingUtilityService getContractsGrantsBillingUtilityService() {
        if (contractsGrantsBillingUtilityService == null) {
            contractsGrantsBillingUtilityService = (ContractsGrantsBillingUtilityService)SpringContext.getBean(ContractsGrantsBillingUtilityService.class);
        }
        return contractsGrantsBillingUtilityService;
    }
}

