/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceReport;
import org.kuali.kfs.module.ar.report.ContractsGrantsInvoiceReportDetailDataHolder;
import org.kuali.kfs.module.ar.report.ContractsGrantsReportDataHolder;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportDataBuilderService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.krad.bo.BusinessObject;

public class ContractsGrantsInvoiceReportBuilderServiceImpl
implements ContractsGrantsReportDataBuilderService {
    protected ReportInfo reportInfo;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;

    @Override
    public ContractsGrantsReportDataHolder buildReportDataHolder(List<? extends BusinessObject> displayList, String sortPropertyName) {
        boolean isFieldSubtotalRequired = ArConstants.ReportsConstants.cgInvoiceReportSubtotalFieldsList.contains(sortPropertyName);
        Map<Object, Object> subTotalMap = new HashMap();
        if (isFieldSubtotalRequired) {
            subTotalMap = this.buildSubTotalMap(displayList, sortPropertyName);
        }
        ContractsGrantsReportDataHolder cgInvoiceReportDataHolder = new ContractsGrantsReportDataHolder();
        List details = cgInvoiceReportDataHolder.getDetails();
        for (ContractsGrantsInvoiceReport contractsGrantsInvoiceReport : displayList) {
            ContractsGrantsInvoiceReportDetailDataHolder reportDetail = new ContractsGrantsInvoiceReportDetailDataHolder();
            this.setReportDate(contractsGrantsInvoiceReport, reportDetail);
            if (isFieldSubtotalRequired) {
                reportDetail.setSortedFieldValue(this.getContractsGrantsReportHelperService().getPropertyValue((Object)contractsGrantsInvoiceReport, sortPropertyName));
                reportDetail.setDisplaySubtotal(true);
                reportDetail.setInvoiceSubTotal(((KualiDecimal)((List)subTotalMap.get(this.getContractsGrantsReportHelperService().getPropertyValue((Object)contractsGrantsInvoiceReport, sortPropertyName))).get(0)).bigDecimalValue());
                reportDetail.setPaymentSubTotal(((KualiDecimal)((List)subTotalMap.get(this.getContractsGrantsReportHelperService().getPropertyValue((Object)contractsGrantsInvoiceReport, sortPropertyName))).get(1)).bigDecimalValue());
                reportDetail.setRemainingSubTotal(((KualiDecimal)((List)subTotalMap.get(this.getContractsGrantsReportHelperService().getPropertyValue((Object)contractsGrantsInvoiceReport, sortPropertyName))).get(2)).bigDecimalValue());
            } else {
                reportDetail.setDisplaySubtotal(false);
            }
            details.add(reportDetail);
        }
        cgInvoiceReportDataHolder.setDetails(details);
        return cgInvoiceReportDataHolder;
    }

    @Override
    public Class<? extends BusinessObject> getDetailsClass() {
        return ContractsGrantsInvoiceReport.class;
    }

    protected Map<String, List<KualiDecimal>> buildSubTotalMap(List<ContractsGrantsInvoiceReport> displayList, String sortPropertyName) {
        HashMap<String, List<KualiDecimal>> returnSubTotalMap = new HashMap<String, List<KualiDecimal>>();
        List<String> valuesOfsortProperty = this.getContractsGrantsReportHelperService().getListOfValuesSortedProperties(displayList, sortPropertyName);
        for (String value : valuesOfsortProperty) {
            KualiDecimal invoiceSubTotal = KualiDecimal.ZERO;
            KualiDecimal paymentSubTotal = KualiDecimal.ZERO;
            KualiDecimal remainingSubTotal = KualiDecimal.ZERO;
            for (ContractsGrantsInvoiceReport cgInvoiceReportEntry : displayList) {
                if (!value.equals(this.getContractsGrantsReportHelperService().getPropertyValue((Object)cgInvoiceReportEntry, sortPropertyName))) continue;
                invoiceSubTotal = (KualiDecimal)invoiceSubTotal.add((AbstractKualiDecimal)cgInvoiceReportEntry.getInvoiceAmount());
                paymentSubTotal = (KualiDecimal)paymentSubTotal.add((AbstractKualiDecimal)cgInvoiceReportEntry.getPaymentAmount());
                remainingSubTotal = (KualiDecimal)remainingSubTotal.add((AbstractKualiDecimal)cgInvoiceReportEntry.getRemainingAmount());
            }
            ArrayList<KualiDecimal> allSubTotal = new ArrayList<KualiDecimal>();
            allSubTotal.add(0, invoiceSubTotal);
            allSubTotal.add(1, paymentSubTotal);
            allSubTotal.add(2, remainingSubTotal);
            returnSubTotalMap.put(value, allSubTotal);
        }
        return returnSubTotalMap;
    }

    protected void setReportDate(ContractsGrantsInvoiceReport cgInvoiceReportEntry, ContractsGrantsInvoiceReportDetailDataHolder reportDetail) {
        reportDetail.setProposalNumber(cgInvoiceReportEntry.getProposalNumber());
        reportDetail.setDocumentNumber(cgInvoiceReportEntry.getDocumentNumber());
        reportDetail.setInvoiceType(cgInvoiceReportEntry.getInvoiceType());
        reportDetail.setInvoiceDate(cgInvoiceReportEntry.getInvoiceDate());
        reportDetail.setInvoiceDueDate(cgInvoiceReportEntry.getInvoiceDueDate());
        reportDetail.setOpenInvoiceIndicator(cgInvoiceReportEntry.getOpenInvoiceIndicator());
        reportDetail.setCustomerNumber(cgInvoiceReportEntry.getCustomerNumber());
        reportDetail.setCustomerName(cgInvoiceReportEntry.getCustomerName());
        BigDecimal invoiceAmount = ObjectUtils.isNull((Object)cgInvoiceReportEntry.getInvoiceAmount()) ? BigDecimal.ZERO : cgInvoiceReportEntry.getInvoiceAmount().bigDecimalValue();
        reportDetail.setInvoiceAmount(invoiceAmount);
        BigDecimal paymentAmount = ObjectUtils.isNull((Object)cgInvoiceReportEntry.getPaymentAmount()) ? BigDecimal.ZERO : cgInvoiceReportEntry.getPaymentAmount().bigDecimalValue();
        reportDetail.setPaymentAmount(paymentAmount);
        BigDecimal remainingAmount = ObjectUtils.isNull((Object)cgInvoiceReportEntry.getRemainingAmount()) ? BigDecimal.ZERO : cgInvoiceReportEntry.getRemainingAmount().bigDecimalValue();
        reportDetail.setRemainingAmount(remainingAmount);
        reportDetail.setAgeInDays(cgInvoiceReportEntry.getAgeInDays());
    }

    @Override
    public ReportInfo getReportInfo() {
        return this.reportInfo;
    }

    public void setReportInfo(ReportInfo reportInfo) {
        this.reportInfo = reportInfo;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }
}

