/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.lookup.Lookupable;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.lookup.CollectionIncomplete;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsAndGrantsAgingReport;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsAgingReportLookupableHelperServiceImpl;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsAgingReportForm;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsReportLookupAction;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.krad.bo.BusinessObject;

public class ContractsGrantsAgingReportAction
extends ContractsGrantsReportLookupAction {
    private static final Logger LOG = LogManager.getLogger(ContractsGrantsAgingReportAction.class);
    private static volatile ContractsGrantsAgingReportService contractsGrantsAgingReportService;
    private static volatile ConfigurationService configurationService;

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsAgingReportForm lookupForm = (ContractsGrantsAgingReportForm)form;
        Lookupable lookupable = lookupForm.getLookupable();
        if (ObjectUtils.isNull((Object)lookupable)) {
            LOG.error("Lookupable is null.");
            throw new RuntimeException("Lookupable is null.");
        }
        ArrayList resultTable = new ArrayList();
        String[] totalList = new String[8];
        try {
            Collection displayList = lookupable.performLookup((LookupForm)lookupForm, resultTable, true);
            Long totalSize = ((CollectionIncomplete)displayList).getActualSizeIfTruncated();
            request.setAttribute("reqSearchResultsSize", (Object)totalSize);
            request.setAttribute("reqSearchResults", resultTable);
            if (request.getParameter("searchResultKey") != null) {
                GlobalVariables.getUserSession().removeObject(request.getParameter("searchResultKey"));
            }
            request.setAttribute("searchResultKey", (Object)GlobalVariables.getUserSession().addObjectWithGeneratedKey(resultTable));
            totalList[0] = lookupForm.getTotal0to30();
            totalList[1] = lookupForm.getTotal31to60();
            totalList[2] = lookupForm.getTotal61to90();
            totalList[3] = lookupForm.getTotal91toSYSPR();
            totalList[4] = lookupForm.getTotalSYSPRplus1orMore();
            totalList[5] = lookupForm.getTotalOpenInvoices();
            totalList[6] = lookupForm.getTotalCredits();
            totalList[7] = lookupForm.getTotalWriteOffs();
            GlobalVariables.getUserSession().addObject("totalsTable", (Object)totalList);
        }
        catch (NumberFormatException e) {
            LOG.error("Number format Exception", (Throwable)e);
        }
        return mapping.findForward("basic");
    }

    public ActionForward viewResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ContractsGrantsAgingReportForm lookupForm = (ContractsGrantsAgingReportForm)form;
        request.setAttribute("searchResultKey", (Object)request.getParameter("searchResultKey"));
        request.setAttribute("reqSearchResults", GlobalVariables.getUserSession().retrieveObject(request.getParameter("searchResultKey")));
        request.setAttribute("reqSearchResultsSize", (Object)request.getParameter("reqSearchResultsSize"));
        String[] totalsList = (String[])GlobalVariables.getUserSession().retrieveObject("totalsTable");
        if (ObjectUtils.isNotNull((Object)totalsList) && totalsList.length > 0) {
            lookupForm.setTotal0to30(totalsList[0]);
            lookupForm.setTotal31to60(totalsList[1]);
            lookupForm.setTotal61to90(totalsList[2]);
            lookupForm.setTotal91toSYSPR(totalsList[3]);
            lookupForm.setTotalSYSPRplus1orMore(totalsList[4]);
            lookupForm.setTotalOpenInvoices(totalsList[5]);
            lookupForm.setTotalCredits(totalsList[6]);
            lookupForm.setTotalWriteOffs(totalsList[7]);
        }
        if (((ContractsGrantsAgingReportForm)form).getLookupable().getLookupableHelperService() instanceof ContractsGrantsAgingReportLookupableHelperServiceImpl) {
            Object totalsTable = GlobalVariables.getUserSession().retrieveObject("totalsTable");
            request.setAttribute("totalsTable", totalsTable);
        }
        return mapping.findForward("basic");
    }

    @Override
    protected <B extends BusinessObject> String sortReportValues(List<B> displayList) {
        this.sortReport(displayList, "invoiceGeneralDetail.award.agency.reportingName");
        return "invoiceGeneralDetail.award.agency.agencyNumber";
    }

    @Override
    public String generateReportTitle(LookupForm lookupForm) {
        String reportTitlePattern = ContractsGrantsAgingReportAction.getConfigurationService().getPropertyValueAsString("contracts.grants.aging.report.title");
        return MessageFormat.format(reportTitlePattern, (String)lookupForm.getFieldsForLookup().get("reportRunDate"));
    }

    @Override
    public String getReportBuilderServiceBeanName() {
        return "contractsGrantsAgingReportBuilderService";
    }

    @Override
    protected String getSortFieldName() {
        return null;
    }

    @Override
    public Class<? extends BusinessObject> getPrintSearchCriteriaClass() {
        return ContractsAndGrantsAgingReport.class;
    }

    protected List<ContractsGrantsInvoiceDocument> lookupReportValues(LookupForm form, HttpServletRequest request, boolean performValidate) throws Exception {
        Lookupable kualiLookupable;
        String methodToCall = this.findMethodToCall((ActionForm)form, request);
        if (methodToCall.equalsIgnoreCase("search")) {
            GlobalVariables.getUserSession().removeObjectsByPrefix("search");
        }
        if (ObjectUtils.isNull((Object)(kualiLookupable = form.getLookupable()))) {
            throw new RuntimeException("Lookupable is null.");
        }
        if (performValidate) {
            kualiLookupable.validateSearchParameters(form.getFields());
        }
        return ContractsGrantsAgingReportAction.getContractsGrantsAgingReportService().lookupContractsGrantsInvoiceDocumentsForAging(form.getFieldsForLookup());
    }

    public static ContractsGrantsAgingReportService getContractsGrantsAgingReportService() {
        if (contractsGrantsAgingReportService == null) {
            contractsGrantsAgingReportService = (ContractsGrantsAgingReportService)SpringContext.getBean(ContractsGrantsAgingReportService.class);
        }
        return contractsGrantsAgingReportService;
    }

    public static ConfigurationService getConfigurationService() {
        if (configurationService == null) {
            configurationService = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        }
        return configurationService;
    }
}

