/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.web.struts;

import java.io.ByteArrayOutputStream;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.util.WebUtils;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.TransmitContractsAndGrantsInvoicesLookupDataHolder;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.report.service.TransmitContractsAndGrantsInvoicesService;
import org.kuali.kfs.module.ar.web.struts.ContractsGrantsReportLookupAction;
import org.kuali.kfs.module.ar.web.struts.TransmitContractsAndGrantsInvoicesLookupForm;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.krad.bo.BusinessObject;

public class TransmitContractsAndGrantsInvoicesLookupAction
extends ContractsGrantsReportLookupAction {
    protected static volatile TransmitContractsAndGrantsInvoicesService invoiceReportDeliveryService;
    protected static volatile DateTimeService dateTimeService;

    @Override
    public ActionForward print(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        TransmitContractsAndGrantsInvoicesLookupForm lookupForm = (TransmitContractsAndGrantsInvoicesLookupForm)form;
        Map fieldValues = lookupForm.getFieldsForLookup();
        String invoiceTransmissionMethodCode = (String)fieldValues.get("invoiceTransmissionMethodCode");
        this.getTransmitContractsAndGrantsInvoicesService().validateSearchParameters(fieldValues);
        Collection<ContractsGrantsInvoiceDocument> list = this.getTransmitContractsAndGrantsInvoicesService().getInvoicesByParametersFromRequest(fieldValues);
        if (CollectionUtils.isNotEmpty(list)) {
            ActionForward forward = mapping.findForward("basic");
            HashSet<ContractsGrantsInvoiceDocument> emailSet = new HashSet<ContractsGrantsInvoiceDocument>();
            HashSet<ContractsGrantsInvoiceDocument> mailSet = new HashSet<ContractsGrantsInvoiceDocument>();
            if ("EMAIL".equalsIgnoreCase(invoiceTransmissionMethodCode)) {
                for (ContractsGrantsInvoiceDocument invoice : list) {
                    if (!this.getTransmitContractsAndGrantsInvoicesService().isInvoiceValidToEmail(invoice)) continue;
                    emailSet.add(invoice);
                }
                if (CollectionUtils.isNotEmpty(emailSet)) {
                    if (this.getTransmitContractsAndGrantsInvoicesService().sendEmailForListofInvoicesToAgency(emailSet)) {
                        GlobalVariables.getMessageMap().putInfoForSectionId("lookup", "message.invoice.emails.sent", new String[0]);
                    } else {
                        GlobalVariables.getMessageMap().putInfoForSectionId("lookup", "error.sending.invoice.emails", new String[0]);
                    }
                } else {
                    request.setAttribute("reqSearchResultsActualSize", (Object)0);
                }
            } else {
                for (ContractsGrantsInvoiceDocument invoice : list) {
                    if (!this.getTransmitContractsAndGrantsInvoicesService().isInvoiceValidToMail(invoice)) continue;
                    mailSet.add(invoice);
                }
                if (CollectionUtils.isNotEmpty(mailSet)) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    if (this.getTransmitContractsAndGrantsInvoicesService().printInvoicesAndEnvelopesZip(mailSet, baos)) {
                        String fileName = "Invoice-report" + this.getDateTimeService().toDateStringForFilename(this.getDateTimeService().getCurrentDate()) + ".zip";
                        WebUtils.saveMimeOutputStreamAsFile((HttpServletResponse)response, (String)"application/zip", (ByteArrayOutputStream)baos, (String)fileName);
                        GlobalVariables.getMessageMap().putInfoForSectionId("lookup", "message.invoices.print.successfull", new String[0]);
                        request.setAttribute("reqSearchResultsActualSize", (Object)mailSet.size());
                        return null;
                    }
                    GlobalVariables.getMessageMap().putInfoForSectionId("lookup", "error.invoices.print.unsuccessful", new String[0]);
                } else {
                    request.setAttribute("reqSearchResultsActualSize", (Object)0);
                }
            }
            return forward;
        }
        request.setAttribute("reqSearchResultsActualSize", (Object)0);
        return mapping.findForward("basic");
    }

    protected TransmitContractsAndGrantsInvoicesService getTransmitContractsAndGrantsInvoicesService() {
        if (invoiceReportDeliveryService == null) {
            invoiceReportDeliveryService = (TransmitContractsAndGrantsInvoicesService)SpringContext.getBean(TransmitContractsAndGrantsInvoicesService.class);
        }
        return invoiceReportDeliveryService;
    }

    @Override
    protected String getSortFieldName() {
        return null;
    }

    @Override
    public String getReportBuilderServiceBeanName() {
        return null;
    }

    @Override
    public Class<? extends BusinessObject> getPrintSearchCriteriaClass() {
        return TransmitContractsAndGrantsInvoicesLookupDataHolder.class;
    }

    @Override
    public String generateReportTitle(LookupForm lookupForm) {
        return null;
    }

    protected DateTimeService getDateTimeService() {
        if (dateTimeService == null) {
            dateTimeService = (DateTimeService)SpringContext.getBean(DateTimeService.class);
        }
        return dateTimeService;
    }
}

