/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.math.BigDecimal;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.api.parameter.EvaluationOperator;
import org.kuali.kfs.coreservice.api.parameter.Parameter;
import org.kuali.kfs.coreservice.api.parameter.ParameterContract;
import org.kuali.kfs.coreservice.api.parameter.ParameterType;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.service.LockboxService;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.Lockbox;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceWriteoffDocument;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceWriteoffDocumentService;
import org.kuali.kfs.sys.batch.AbstractStep;
import org.kuali.kfs.sys.batch.TestingStep;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class CustomerInvoiceDocumentBatchStep
extends AbstractStep
implements TestingStep {
    private static final Logger LOG = LogManager.getLogger(CustomerInvoiceDocumentBatchStep.class);
    protected static final long MAX_SEQ_NBR_OFFSET = 1000L;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected BusinessObjectService businessObjectService;
    protected DocumentService documentService;
    protected DateTimeService dateTimeService;
    protected LockboxService lockboxService;
    protected CustomerAddressService customerAddressService;
    protected CustomerInvoiceWriteoffDocumentService writeoffService;
    protected Collection<String> createdInvoices = new ArrayList<String>();
    protected static final int NUMBER_OF_INVOICES_TO_CREATE = 5;
    protected static final String RUN_INDICATOR_PARAMETER_NAMESPACE_CODE = "KFS-AR";
    protected static final String RUN_INDICATOR_PARAMETER_APPLICATION_NAMESPACE_CODE = "KFS";
    protected static final String RUN_INDICATOR_PARAMETER_NAMESPACE_STEP = CustomerInvoiceDocumentBatchStep.class.getSimpleName();
    protected static final String RUN_INDICATOR_PARAMETER_VALUE = "N";
    protected static final String RUN_INDICATOR_PARAMETER_ALLOWED = "A";
    protected static final String RUN_INDICATOR_PARAMETER_DESCRIPTION = "Tells the job framework whether to run this job or not; because the CustomerInvoiceDocumentBatchStep needs to only be run once after database initialization.";
    protected static final String RUN_INDICATOR_PARAMETER_TYPE = "CONFG";
    protected static final String INITIATOR_PRINCIPAL_NAME = "khuntley";
    protected final int currentYear = Calendar.getInstance().get(1);

    public boolean execute(String jobName, java.util.Date jobRunDate) throws InterruptedException {
        Parameter runIndicatorParameter = this.getParameterService().getParameter(RUN_INDICATOR_PARAMETER_NAMESPACE_CODE, RUN_INDICATOR_PARAMETER_NAMESPACE_STEP, "RUN_IND");
        if (runIndicatorParameter == null || StringUtils.equals((CharSequence)"Y", (CharSequence)runIndicatorParameter.getValue())) {
            GlobalVariables.clear();
            GlobalVariables.setUserSession((UserSession)new UserSession(INITIATOR_PRINCIPAL_NAME));
            java.util.Date billingDate = this.getDateTimeService().getCurrentDate();
            List<String> customernames = jobName.length() <= 8 && jobName.length() >= 4 ? Arrays.asList(jobName) : Arrays.asList("ABB2", "3MC17500", "ACE21725", "ANT7297", "CAR23612", "CON19567", "DEL14448", "EAT17609", "GAP17272");
            if (customernames.size() > 1) {
                for (int i = 0; i < 5; ++i) {
                    billingDate = DateUtils.addDays((java.util.Date)billingDate, (int)-30);
                    this.createCustomerInvoiceDocumentForFunctionalTesting("HIL22195", billingDate, 1, new KualiDecimal(10), new BigDecimal(1), "2336320", "BL", "BUSCF");
                    this.createCustomerInvoiceDocumentForFunctionalTesting("IBM2655", billingDate, 2, new KualiDecimal(10), new BigDecimal(1), "2336320", "BL", "IBCE");
                    this.createCustomerInvoiceDocumentForFunctionalTesting("JAS19572", billingDate, 3, new KualiDecimal(10), new BigDecimal(1), "2336320", "BL", "WRB");
                    Thread.sleep(500L);
                }
            }
            if (customernames.size() == 1) {
                billingDate = jobRunDate;
                this.createCustomerInvoiceDocumentForFunctionalTesting(customernames.get(0), billingDate, 1, new KualiDecimal(10), new BigDecimal(1), "1111111", "BA", "MATT");
                Thread.sleep(500L);
            }
            Long seqNbr = this.findAvailableLockboxBaseSeqNbr();
            int scenarioNbr = 1;
            for (String createdInvoice : this.createdInvoices) {
                this.createLockboxesForFunctionalTesting(createdInvoice, seqNbr, scenarioNbr);
                Thread.sleep(500L);
                Long l = seqNbr;
                Long l2 = seqNbr = Long.valueOf(seqNbr + 1L);
                if (scenarioNbr <= 6) {
                    ++scenarioNbr;
                    continue;
                }
                scenarioNbr = 1;
            }
            this.setInitiatedParameter();
        }
        return true;
    }

    private long findAvailableLockboxBaseSeqNbr() {
        return this.lockboxService.getMaxLockboxSequenceNumber() + 1000L;
    }

    private boolean dupLockboxRecordExists(Long seqNbr) {
        HashMap<String, Long> pks = new HashMap<String, Long>();
        pks.put("invoiceSequenceNumber", seqNbr);
        Lockbox dupLockBox = (Lockbox)this.businessObjectService.findByPrimaryKey(Lockbox.class, pks);
        return dupLockBox != null;
    }

    private void setInitiatedParameter() {
        Parameter runIndicatorParameter = this.getParameterService().getParameter(RUN_INDICATOR_PARAMETER_NAMESPACE_CODE, RUN_INDICATOR_PARAMETER_NAMESPACE_STEP, "RUN_IND");
        if (runIndicatorParameter == null) {
            Parameter.Builder newParm = Parameter.Builder.create((String)RUN_INDICATOR_PARAMETER_APPLICATION_NAMESPACE_CODE, (String)RUN_INDICATOR_PARAMETER_NAMESPACE_CODE, (String)RUN_INDICATOR_PARAMETER_NAMESPACE_STEP, (String)"RUN_IND", (ParameterType.Builder)ParameterType.Builder.create((String)RUN_INDICATOR_PARAMETER_TYPE));
            newParm.setEvaluationOperator(EvaluationOperator.ALLOW);
            newParm.setDescription(RUN_INDICATOR_PARAMETER_DESCRIPTION);
            newParm.setValue(RUN_INDICATOR_PARAMETER_VALUE);
            this.getParameterService().createParameter(newParm.build());
        } else {
            Parameter.Builder newParm = Parameter.Builder.create((ParameterContract)runIndicatorParameter);
            newParm.setValue(RUN_INDICATOR_PARAMETER_VALUE);
            this.getParameterService().updateParameter(newParm.build());
        }
    }

    private Lockbox populateLockbox(String invoiceNumber, Long seqNbr) {
        CustomerInvoiceDocument customerInvoiceDocument = this.customerInvoiceDocumentService.getInvoiceByInvoiceDocumentNumber(invoiceNumber);
        Lockbox newLockbox = new Lockbox();
        newLockbox.setFinancialDocumentReferenceInvoiceNumber(invoiceNumber);
        newLockbox.setCustomerNumber(customerInvoiceDocument.getCustomer().getCustomerNumber());
        newLockbox.setInvoiceTotalAmount(customerInvoiceDocument.getTotalDollarAmount());
        newLockbox.setInvoicePaidOrAppliedAmount(customerInvoiceDocument.getOpenAmount());
        newLockbox.setBillingDate(customerInvoiceDocument.getBillingDate());
        newLockbox.setCustomerPaymentMediumCode("CK");
        newLockbox.setBankCode("1003");
        newLockbox.setBatchSequenceNumber(8004);
        newLockbox.setInvoiceSequenceNumber(seqNbr);
        newLockbox.setLockboxNumber("66249");
        return newLockbox;
    }

    private void createLockboxesForFunctionalTesting(String invoiceNumber, Long seqNbr, int testtype) throws InterruptedException {
        Lockbox newLockbox = this.populateLockbox(invoiceNumber, seqNbr);
        if (testtype == 2) {
            newLockbox.setInvoicePaidOrAppliedAmount(newLockbox.getInvoiceTotalAmount());
            this.writeoffInvoice(invoiceNumber);
        }
        if (testtype == 3) {
            newLockbox.setInvoicePaidOrAppliedAmount((KualiDecimal)newLockbox.getInvoicePaidOrAppliedAmount().add((AbstractKualiDecimal)new KualiDecimal("100.00")));
        }
        if (testtype == 4) {
            newLockbox.setInvoicePaidOrAppliedAmount((KualiDecimal)newLockbox.getInvoicePaidOrAppliedAmount().subtract((AbstractKualiDecimal)new KualiDecimal("1.00")));
        }
        if (testtype == 5) {
            newLockbox.setFinancialDocumentReferenceInvoiceNumber(null);
        }
        if (testtype == 6) {
            newLockbox.setFinancialDocumentReferenceInvoiceNumber("999999");
        }
        if (testtype == 7) {
            newLockbox.setFinancialDocumentReferenceInvoiceNumber("999999");
            newLockbox.setCustomerNumber("KEY17536");
        }
        LOG.info("Creating customer LOCKBOX [" + seqNbr.toString() + "] for invoice " + invoiceNumber);
        if (this.dupLockboxRecordExists(seqNbr)) {
            throw new RuntimeException("Trying to enter duplicate Lockbox.invoiceSequenceNumber, which will fail, and should never happen.");
        }
        this.businessObjectService.save((PersistableBusinessObject)newLockbox);
    }

    public void writeoffInvoice(String invoiceNumberToWriteOff) {
        CustomerInvoiceWriteoffDocument writeoff;
        String writeoffDocNumber;
        try {
            writeoffDocNumber = this.writeoffService.createCustomerInvoiceWriteoffDocument(invoiceNumberToWriteOff, "Created by CustomerInvoiceDocumentBatch process.");
        }
        catch (WorkflowException e) {
            throw new RuntimeException("A WorkflowException was thrown when trying to create a new Invoice Writeoff document.", e);
        }
        try {
            writeoff = (CustomerInvoiceWriteoffDocument)this.documentService.getByDocumentHeaderId(writeoffDocNumber);
        }
        catch (WorkflowException e) {
            throw new RuntimeException("A WorkflowException was thrown when trying to load Invoice Writeoff doc #" + writeoffDocNumber + ".", e);
        }
        boolean wentToFinal = false;
        try {
            wentToFinal = this.waitForStatusChange(60, writeoff.getDocumentHeader().getWorkflowDocument(), new String[]{"F", "P"});
        }
        catch (Exception e) {
            throw new RuntimeException("An Exception was thrown when trying to monitor writeoff doc #" + writeoffDocNumber + " going to FINAL.", e);
        }
        if (!wentToFinal) {
            try {
                writeoff.getDocumentHeader().getWorkflowDocument().blanketApprove("BlanketApproved by CustomerInvoiceDocumentBatch process.");
            }
            catch (Exception e) {
                throw new RuntimeException("A WorkflowException was thrown when trying to blanketApprove Invoice Writeoff doc #" + writeoffDocNumber + ".", e);
            }
            wentToFinal = false;
            try {
                wentToFinal = this.waitForStatusChange(60, writeoff.getDocumentHeader().getWorkflowDocument(), new String[]{"F", "P"});
            }
            catch (Exception e) {
                throw new RuntimeException("An Exception was thrown when trying to monitor writeoff doc #" + writeoffDocNumber + " going to FINAL.", e);
            }
        }
        if (!wentToFinal) {
            throw new RuntimeException("InvoiceWriteoff document #" + writeoffDocNumber + " failed to route to FINAL.");
        }
    }

    public boolean waitForStatusChange(int numSeconds, WorkflowDocument document, String[] desiredStatus) throws Exception {
        DocWorkflowStatusMonitor monitor = new DocWorkflowStatusMonitor(this.documentService, "" + document.getDocumentId(), desiredStatus);
        return this.waitUntilChange(monitor, numSeconds, 5);
    }

    public boolean waitUntilChange(DocWorkflowStatusMonitor monitor, int maxWaitSeconds, int pauseSeconds) throws Exception {
        long maxWaitMs = maxWaitSeconds * 1000;
        long pauseMs = pauseSeconds * 1000;
        boolean valueChanged = false;
        boolean interrupted = false;
        long startTimeMs = System.currentTimeMillis();
        long endTimeMs = startTimeMs + maxWaitMs;
        Thread.sleep(pauseMs / 10L);
        valueChanged = monitor.valueChanged();
        while (!interrupted && !valueChanged && System.currentTimeMillis() < endTimeMs) {
            try {
                Thread.sleep(pauseMs);
            }
            catch (InterruptedException e) {
                interrupted = true;
            }
            valueChanged = monitor.valueChanged();
        }
        return valueChanged;
    }

    public void createCustomerInvoiceDocumentForFunctionalTesting(String customerNumber, java.util.Date billingDate, int numInvoiceDetails, KualiDecimal nonRandomQuantity, BigDecimal nonRandomuUnitPrice, String accountNumber, String chartCode, String invoiceItemCode) {
        CustomerInvoiceDocument customerInvoiceDocument;
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd/yyyy");
        try {
            customerInvoiceDocument = (CustomerInvoiceDocument)this.documentService.getNewDocument(CustomerInvoiceDocument.class);
            LOG.info("Created customer invoice document " + customerInvoiceDocument.getDocumentNumber());
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Customer Invoice Document creation failed.");
        }
        this.customerInvoiceDocumentService.setupDefaultValuesForNewCustomerInvoiceDocument(customerInvoiceDocument);
        customerInvoiceDocument.getDocumentHeader().setDocumentDescription("TEST CUSTOMER INVOICE DOCUMENT");
        customerInvoiceDocument.getAccountsReceivableDocumentHeader().setCustomerNumber(customerNumber);
        customerInvoiceDocument.setBillingDate(new Date(billingDate.getTime()));
        CustomerAddress customerBillToAddress = this.customerAddressService.getPrimaryAddress(customerNumber);
        customerInvoiceDocument.setCustomerBillToAddress(customerBillToAddress);
        customerInvoiceDocument.setCustomerBillToAddressIdentifier(1);
        customerInvoiceDocument.setBillingAddressTypeCode("P");
        customerInvoiceDocument.setBillingAddressName(customerBillToAddress.getCustomerAddressName());
        customerInvoiceDocument.setBillingLine1StreetAddress(customerBillToAddress.getCustomerLine1StreetAddress());
        customerInvoiceDocument.setBillingLine2StreetAddress(customerBillToAddress.getCustomerLine2StreetAddress());
        customerInvoiceDocument.setBillingCityName(customerBillToAddress.getCustomerCityName());
        customerInvoiceDocument.setBillingStateCode(customerBillToAddress.getCustomerStateCode());
        customerInvoiceDocument.setBillingZipCode(customerBillToAddress.getCustomerZipCode());
        customerInvoiceDocument.setBillingCountryCode(customerBillToAddress.getCustomerCountryCode());
        customerInvoiceDocument.setBillingAddressInternationalProvinceName(customerBillToAddress.getCustomerAddressInternationalProvinceName());
        customerInvoiceDocument.setBillingInternationalMailCode(customerBillToAddress.getCustomerInternationalMailCode());
        customerInvoiceDocument.setBillingEmailAddress(customerBillToAddress.getCustomerEmailAddress());
        if (ObjectUtils.isNotNull((Object)nonRandomQuantity) && ObjectUtils.isNotNull((Object)nonRandomuUnitPrice) && numInvoiceDetails >= 1) {
            for (int i = 0; i < numInvoiceDetails; ++i) {
                customerInvoiceDocument.addSourceAccountingLine(this.createCustomerInvoiceDetailForFunctionalTesting(customerInvoiceDocument, nonRandomQuantity, nonRandomuUnitPrice, accountNumber, chartCode, invoiceItemCode));
            }
        } else {
            int randomNumInvoiceDetails = (int)(Math.random() * 9.0);
            if (randomNumInvoiceDetails == 0) {
                randomNumInvoiceDetails = 1;
            }
            for (int i = 0; i < randomNumInvoiceDetails; ++i) {
                customerInvoiceDocument.addSourceAccountingLine(this.createCustomerInvoiceDetailForFunctionalTesting(customerInvoiceDocument, null, null, accountNumber, chartCode, invoiceItemCode));
            }
        }
        try {
            this.documentService.blanketApproveDocument((Document)customerInvoiceDocument, null, null);
            this.createdInvoices.add(customerInvoiceDocument.getDocumentNumber());
            LOG.info("Submitted customer invoice document " + customerInvoiceDocument.getDocumentNumber() + " for " + customerNumber + " - " + sdf.format(billingDate) + "\n\n");
        }
        catch (WorkflowException e) {
            throw new RuntimeException("Customer Invoice Document routing failed.");
        }
    }

    public CustomerInvoiceDetail createCustomerInvoiceDetailForFunctionalTesting(CustomerInvoiceDocument customerInvoiceDocument, KualiDecimal nonRandomQuantity, BigDecimal nonRandomUnitPrice, String accountNumber, String chartCode, String invoiceItemCode) {
        KualiDecimal quantity = ObjectUtils.isNull((Object)nonRandomQuantity) ? new KualiDecimal(100.0 * Math.random()) : nonRandomQuantity;
        BigDecimal unitprice = ObjectUtils.isNull((Object)nonRandomUnitPrice) ? new BigDecimal(1) : nonRandomUnitPrice;
        KualiDecimal amount = (KualiDecimal)quantity.multiply((AbstractKualiDecimal)new KualiDecimal(unitprice));
        CustomerInvoiceDetail customerInvoiceDetail = new CustomerInvoiceDetail();
        customerInvoiceDetail.setDocumentNumber(customerInvoiceDocument.getDocumentNumber());
        customerInvoiceDetail.setChartOfAccountsCode(chartCode);
        customerInvoiceDetail.setAccountNumber(accountNumber);
        customerInvoiceDetail.setFinancialObjectCode("1800");
        customerInvoiceDetail.setAccountsReceivableObjectCode("8118");
        customerInvoiceDetail.setInvoiceItemCode(invoiceItemCode);
        customerInvoiceDetail.setInvoiceItemServiceDate(this.dateTimeService.getCurrentSqlDate());
        customerInvoiceDetail.setInvoiceItemUnitPrice(unitprice);
        customerInvoiceDetail.setInvoiceItemQuantity(quantity.bigDecimalValue());
        customerInvoiceDetail.setInvoiceItemTaxAmount(new KualiDecimal(100));
        customerInvoiceDetail.setTaxableIndicator(true);
        customerInvoiceDetail.setAmount(amount);
        customerInvoiceDetail.setPostingYear(this.currentYear);
        return customerInvoiceDetail;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public CustomerInvoiceDocumentService getCustomerInvoiceDocumentService() {
        return this.customerInvoiceDocumentService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public LockboxService getLockboxService() {
        return this.lockboxService;
    }

    public void setLockboxService(LockboxService lockboxService) {
        this.lockboxService = lockboxService;
    }

    public CustomerInvoiceWriteoffDocumentService getWriteoffService() {
        return this.writeoffService;
    }

    public void setWriteoffService(CustomerInvoiceWriteoffDocumentService writeoffService) {
        this.writeoffService = writeoffService;
    }

    public CustomerAddressService getCustomerAddressService() {
        return this.customerAddressService;
    }

    public void setCustomerAddressService(CustomerAddressService customerAddressService) {
        this.customerAddressService = customerAddressService;
    }

    private class DocWorkflowStatusMonitor {
        final DocumentService documentService;
        private final String docHeaderId;
        private final String[] desiredWorkflowStates;

        public DocWorkflowStatusMonitor(DocumentService documentService, String docHeaderId, String desiredWorkflowStatus) {
            this.documentService = documentService;
            this.docHeaderId = docHeaderId;
            this.desiredWorkflowStates = new String[]{desiredWorkflowStatus};
        }

        public DocWorkflowStatusMonitor(DocumentService documentService, String docHeaderId, String[] desiredWorkflowStates) {
            this.documentService = documentService;
            this.docHeaderId = docHeaderId;
            this.desiredWorkflowStates = desiredWorkflowStates;
        }

        public boolean valueChanged() throws Exception {
            Document d = this.documentService.getByDocumentHeaderId(this.docHeaderId);
            String currentStatus = d.getDocumentHeader().getWorkflowDocument().getStatus().getCode();
            for (String desiredWorkflowState : this.desiredWorkflowStates) {
                if (!StringUtils.equals((CharSequence)desiredWorkflowState, (CharSequence)currentStatus)) continue;
                return true;
            }
            return false;
        }
    }
}

