/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.ScheduleCsvInputFileType;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.util.AutoPopulatingList;

public class MilestoneScheduleCsvInputFileType
extends ScheduleCsvInputFileType {
    protected Object convertParsedObjectToVO(Object parsedContent) {
        LinkedList<MilestoneSchedule> milestoneSchedules = new LinkedList<MilestoneSchedule>();
        List parseDataList = (List)parsedContent;
        for (Map row : parseDataList) {
            MilestoneSchedule currentSchedule;
            String proposalNumber = (String)row.get("proposalNumber");
            String chartOfAccountsCode = (String)row.get("chartOfAccountsCode");
            String accountNumber = (String)row.get("accountNumber");
            if (StringUtils.isEmpty((CharSequence)chartOfAccountsCode)) {
                chartOfAccountsCode = this.deriveChartOfAccountsCodeFromAccount(accountNumber);
            }
            try {
                currentSchedule = new MilestoneSchedule.MilestoneScheduleBuilder().setProposalNumber(proposalNumber).setChartOfAccountsCode(chartOfAccountsCode).setAccountNumber(accountNumber).addMilestone(this.createMilestone(proposalNumber, chartOfAccountsCode, accountNumber, row)).build();
            }
            catch (IllegalStateException | ParseException e) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.parse", new String[]{e.getMessage()});
                return null;
            }
            if (milestoneSchedules.contains((Object)currentSchedule)) {
                MilestoneSchedule existingSchedule = (MilestoneSchedule)((Object)milestoneSchedules.get(milestoneSchedules.indexOf((Object)currentSchedule)));
                existingSchedule.addMilestone(currentSchedule.getMilestones().get(0));
                continue;
            }
            milestoneSchedules.add(currentSchedule);
        }
        return milestoneSchedules;
    }

    private Milestone createMilestone(String proposalNumber, String chartOfAccountsCode, String accountNumber, Map<String, String> row) throws ParseException {
        String milestoneNumber = row.get("milestoneNumber");
        String milestoneDescription = row.get("milestoneDescription");
        String milestoneAmountString = row.get("milestoneAmount");
        KualiDecimal milestoneAmount = null;
        if (StringUtils.isNotBlank((CharSequence)milestoneAmountString)) {
            milestoneAmount = new KualiDecimal(milestoneAmountString);
        }
        String milestoneExpectedCompletionDateString = row.get("milestoneExpectedCompletionDate");
        Date milestoneExpectedCompletionDate = null;
        if (milestoneExpectedCompletionDateString.length() > 0) {
            milestoneExpectedCompletionDate = this.dateTimeService.convertToSqlDate(milestoneExpectedCompletionDateString);
        }
        String milestoneActualCompletionDateString = row.get("milestoneActualCompletionDate");
        Date milestoneActualCompletionDate = null;
        if (milestoneActualCompletionDateString.length() > 0) {
            milestoneActualCompletionDate = this.dateTimeService.convertToSqlDate(milestoneActualCompletionDateString);
        }
        BooleanConverter converter = new BooleanConverter((Object)Boolean.FALSE);
        boolean active = (Boolean)converter.convert(Boolean.TYPE, (Object)row.get("active"));
        Milestone milestone = new Milestone.MilestoneBuilder().setProposalNumber(proposalNumber).setChartOfAccountsCode(chartOfAccountsCode).setAccountNumber(accountNumber).setMilestoneExpectedCompletionDate(milestoneExpectedCompletionDate).setActive(active).setMilestoneNumber(milestoneNumber).setMilestoneDescription(milestoneDescription).setMilestoneAmount(milestoneAmount).setMilestoneActualCompletionDate(milestoneActualCompletionDate).build();
        milestone.setNewCollectionRecord(true);
        return milestone;
    }

    public String getFileTypeIdentifier() {
        return "MilestoneScheduleCsvInputFileType";
    }

    public void process(String fileName, Object parsedFileContents) {
        List milestoneSchedules = (List)parsedFileContents;
        for (MilestoneSchedule milestoneSchedule : milestoneSchedules) {
            MaintenanceDocument milestoneScheduleDocument;
            try {
                milestoneScheduleDocument = (MaintenanceDocument)this.documentService.getNewDocument(this.maintenanceDocumentDictionaryService.getDocumentTypeName(MilestoneSchedule.class));
            }
            catch (WorkflowException we) {
                this.LOG.error("process(...) - encountered WorkflowException while attempting to get a new milestone schedule document.", (Throwable)we);
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.ar.milestone.schedule.import.nonrecoverable", new String[0]);
                break;
            }
            milestoneScheduleDocument.getDocumentHeader().setDocumentDescription("Milestone Schedule Import");
            MilestoneSchedule existingMilestoneSchedule = this.getMilestoneSchedule(milestoneSchedule);
            if (ObjectUtils.isNull((Object)((Object)existingMilestoneSchedule))) {
                milestoneScheduleDocument.getNewMaintainableObject().setMaintenanceAction("New");
                milestoneScheduleDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)milestoneSchedule);
                milestoneScheduleDocument.getOldMaintainableObject().setBusinessObject((PersistableBusinessObject)new MilestoneSchedule());
            } else {
                MilestoneSchedule copyOfExistingMilestoneSchedule = (MilestoneSchedule)((Object)ObjectUtils.deepCopy((Serializable)((Object)existingMilestoneSchedule)));
                milestoneSchedule.getMilestones().forEach(milestone -> {
                    copyOfExistingMilestoneSchedule.addMilestone((Milestone)((Object)milestone));
                    existingMilestoneSchedule.addMilestone(new Milestone());
                });
                milestoneScheduleDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)copyOfExistingMilestoneSchedule);
                milestoneScheduleDocument.getNewMaintainableObject().setMaintenanceAction("Edit");
                milestoneScheduleDocument.getOldMaintainableObject().setBusinessObject((PersistableBusinessObject)existingMilestoneSchedule);
            }
            try {
                this.documentService.saveDocument((Document)milestoneScheduleDocument);
                this.documentService.routeDocument((Document)milestoneScheduleDocument, "Routed New/Edit Milestone Schedule Maintenance Document from Milestone Schedule Import Process", null);
            }
            catch (ValidationException ve) {
                Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
                errorMessages.keySet().stream().filter(key -> key.equals("GLOBAL_ERRORS")).forEach(key -> KNSGlobalVariables.getMessageList().add("error.ar.milestone.schedule.import.save.failure", new String[]{milestoneSchedule.getProposalNumber(), milestoneSchedule.getChartOfAccountsCode(), milestoneSchedule.getAccountNumber(), this.flattenErrorMessages((AutoPopulatingList<ErrorMessage>)((AutoPopulatingList)errorMessages.get(key)))}));
                GlobalVariables.getMessageMap().clearErrorMessages();
            }
            catch (WorkflowException we) {
                this.LOG.error("process(...) - encountered WorkflowException while attempting to save or route a milestone schedule document.", (Throwable)we);
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.ar.milestone.schedule.import.nonrecoverable", new String[0]);
                break;
            }
        }
        KNSGlobalVariables.getMessageList().add("message.ar.milestone.schedule.import.successful", new String[0]);
        this.removeFiles(fileName);
    }

    private MilestoneSchedule getMilestoneSchedule(MilestoneSchedule milestoneSchedule) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", milestoneSchedule.getProposalNumber());
        primaryKeys.put("chartOfAccountsCode", milestoneSchedule.getChartOfAccountsCode());
        primaryKeys.put("accountNumber", milestoneSchedule.getAccountNumber());
        return (MilestoneSchedule)this.businessObjectService.findByPrimaryKey(MilestoneSchedule.class, primaryKeys);
    }

    public String getTitleKey() {
        return "message.ar.milestone.schedule.import.title";
    }
}

