/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.io.File;
import java.util.Properties;
import org.kuali.kfs.kns.lookup.HtmlData;
import org.kuali.kfs.kns.lookup.KualiLookupableHelperServiceImpl;
import org.kuali.kfs.krad.bo.ModuleConfiguration;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;

public abstract class TemplateLookupableHelperServiceImplBase
extends KualiLookupableHelperServiceImpl {
    protected KualiModuleService kualiModuleService;

    protected HtmlData.AnchorHtmlData getTemplateUploadUrl(String templateCodeKey, String templateCodeValue) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put(templateCodeKey, templateCodeValue);
        parameters.put("docFormKey", "88888888");
        String href = UrlFactory.parameterizeUrl((String)(this.getKualiConfigurationService().getPropertyValueAsString("application.url") + "/" + this.getAction()), (Properties)parameters);
        return new HtmlData.AnchorHtmlData(href, "search", "upload");
    }

    protected boolean templateFileExists(String fileName) {
        ModuleConfiguration systemConfiguration = this.kualiModuleService.getModuleServiceByNamespaceCode("KFS-AR").getModuleConfiguration();
        String templateFolderPath = (String)((FinancialSystemModuleConfiguration)systemConfiguration).getTemplateFileDirectories().get("templates.directory");
        String filePath = templateFolderPath + File.separator + fileName;
        File file = new File(filePath).getAbsoluteFile();
        return file.exists() && file.isFile();
    }

    protected HtmlData.AnchorHtmlData getTemplateDownloadUrl(String fileName) {
        Properties parameters = new Properties();
        if (ObjectUtils.isNotNull((Object)fileName) && this.templateFileExists(fileName)) {
            parameters.put("fileName", fileName);
            parameters.put("methodToCall", "download");
        }
        String href = UrlFactory.parameterizeUrl((String)(this.getKualiConfigurationService().getPropertyValueAsString("application.url") + "/" + this.getAction()), (Properties)parameters);
        return new HtmlData.AnchorHtmlData(href, "search", "download");
    }

    protected abstract String getAction();

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }
}

