/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.sys.document.validation.GenericValidation;
import org.kuali.kfs.sys.document.validation.event.AttributedDocumentEvent;
import org.kuali.kfs.sys.document.validation.event.AttributedSaveDocumentEvent;

public class ContractsGrantsInvoiceDocumentValidation
extends GenericValidation {
    private ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument;

    public boolean validate(AttributedDocumentEvent event) {
        if (this.contractsGrantsInvoiceDocument.isCorrectionDocument()) {
            return true;
        }
        boolean isValid = this.hasEmailAddress(event);
        isValid &= this.hasTransmissionCode(event);
        return isValid &= this.hasTemplate(event);
    }

    private boolean hasEmailAddress(AttributedDocumentEvent event) {
        boolean isValid = true;
        int i = 0;
        for (InvoiceAddressDetail address : this.contractsGrantsInvoiceDocument.getInvoiceAddressDetails()) {
            if (StringUtils.isNotBlank((CharSequence)address.getInvoiceTransmissionMethodCode()) && address.getInvoiceTransmissionMethodCode().equals("EMAIL") && StringUtils.isBlank((CharSequence)address.getCustomerEmailAddress())) {
                if (event instanceof AttributedSaveDocumentEvent) {
                    GlobalVariables.getMessageMap().putWarning("document.invoiceAddressDetails[" + i + "].customerEmailAddress", "error.document.contractsGrantsInvoice.email.address.required", new String[0]);
                } else {
                    GlobalVariables.getMessageMap().putError("document.invoiceAddressDetails[" + i + "].customerEmailAddress", "error.document.contractsGrantsInvoice.email.address.required", new String[0]);
                    GlobalVariables.getMessageMap().getWarningMessages().remove("document.invoiceAddressDetails[" + i + "].customerEmailAddress");
                    isValid = false;
                }
            }
            ++i;
        }
        return isValid;
    }

    private boolean hasTransmissionCode(AttributedDocumentEvent event) {
        boolean isValid = true;
        int i = 0;
        for (InvoiceAddressDetail address : this.contractsGrantsInvoiceDocument.getInvoiceAddressDetails()) {
            if (address.getCustomerAddressTypeCode().equals("P") && StringUtils.isBlank((CharSequence)address.getInvoiceTransmissionMethodCode())) {
                if (event instanceof AttributedSaveDocumentEvent) {
                    GlobalVariables.getMessageMap().putWarning("document.invoiceAddressDetails[" + i + "].invoiceTransmissionMethodCode", "error.document.contractsGrantsInvoice.transmission.code.required", new String[0]);
                } else {
                    GlobalVariables.getMessageMap().putError("document.invoiceAddressDetails[" + i + "].invoiceTransmissionMethodCode", "error.document.contractsGrantsInvoice.transmission.code.required", new String[0]);
                    GlobalVariables.getMessageMap().getWarningMessages().remove("document.invoiceAddressDetails[" + i + "].invoiceTransmissionMethodCode");
                    isValid = false;
                }
            }
            ++i;
        }
        return isValid;
    }

    private boolean hasTemplate(AttributedDocumentEvent event) {
        boolean isValid = true;
        int i = 0;
        for (InvoiceAddressDetail address : this.contractsGrantsInvoiceDocument.getInvoiceAddressDetails()) {
            if (address.getCustomerAddressTypeCode().equals("P") && StringUtils.isBlank((CharSequence)address.getCustomerInvoiceTemplateCode())) {
                if (event instanceof AttributedSaveDocumentEvent) {
                    GlobalVariables.getMessageMap().putWarning("document.invoiceAddressDetails[" + i + "].customerInvoiceTemplateCode", "error.document.contractsGrantsInvoice.template.code.required", new String[0]);
                } else {
                    GlobalVariables.getMessageMap().putError("document.invoiceAddressDetails[" + i + "].customerInvoiceTemplateCode", "error.document.contractsGrantsInvoice.template.code.required", new String[0]);
                    GlobalVariables.getMessageMap().getWarningMessages().remove("document.invoiceAddressDetails[" + i + "].customerInvoiceTemplateCode");
                    isValid = false;
                }
            }
            ++i;
        }
        return isValid;
    }

    public void setContractsGrantsInvoiceDocument(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        this.contractsGrantsInvoiceDocument = contractsGrantsInvoiceDocument;
    }
}

