/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.InvoicePaidApplied;
import org.kuali.kfs.module.ar.businessobject.NonAppliedHolding;
import org.kuali.kfs.module.ar.businessobject.NonInvoiced;
import org.kuali.kfs.module.ar.businessobject.NonInvoicedDistribution;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationInvoiceApply;
import org.kuali.kfs.module.ar.document.web.struts.PaymentApplicationInvoiceDetailApply;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentFormBase;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class PaymentApplicationForm
extends FinancialSystemTransactionalDocumentFormBase {
    protected static Logger LOG = LogManager.getLogger(PaymentApplicationForm.class);
    protected String selectedInvoiceDocumentNumber;
    protected String enteredInvoiceDocumentNumber;
    protected String selectedCustomerNumber;
    protected KualiDecimal unappliedCustomerAmount;
    protected PaymentApplicationInvoiceApply selectedInvoiceApplication = null;
    protected NonInvoiced nonInvoicedAddLine = new NonInvoiced();
    protected Integer nextNonInvoicedLineNumber;
    protected KualiDecimal nonAppliedHoldingAmount;
    protected String nonAppliedHoldingCustomerNumber;
    protected List<PaymentApplicationInvoiceApply> invoiceApplications = new ArrayList<PaymentApplicationInvoiceApply>();
    protected List<CustomerInvoiceDocument> invoices = new ArrayList<CustomerInvoiceDocument>();
    protected List<PaymentApplicationDocument> nonAppliedControlDocs = new ArrayList<PaymentApplicationDocument>();
    protected List<NonAppliedHolding> nonAppliedControlHoldings = new ArrayList<NonAppliedHolding>();
    protected Map<String, KualiDecimal> nonAppliedControlAllocations = new HashMap<String, KualiDecimal>();
    protected Map<String, KualiDecimal> distributionsFromControlDocs = new HashMap<String, KualiDecimal>();

    protected String getDefaultDocumentTypeName() {
        return "APP";
    }

    public void reset(ActionMapping mapping, ServletRequest request) {
        super.reset(mapping, request);
        for (PaymentApplicationInvoiceApply application : this.invoiceApplications) {
            application.setQuickApply(false);
        }
    }

    public void populate(HttpServletRequest request) {
        super.populate(request);
        PaymentApplicationDocument paymentApplicationDocument = this.getPaymentApplicationDocument();
        if (ObjectUtils.isNotNull(paymentApplicationDocument.getNonInvoicedDistributions())) {
            for (NonInvoicedDistribution u : paymentApplicationDocument.getNonInvoicedDistributions()) {
                if (null == this.getNextNonInvoicedLineNumber()) {
                    this.setNextNonInvoicedLineNumber(u.getFinancialDocumentLineNumber());
                    continue;
                }
                if (u.getFinancialDocumentLineNumber() <= this.getNextNonInvoicedLineNumber()) continue;
                this.setNextNonInvoicedLineNumber(u.getFinancialDocumentLineNumber());
            }
        }
        if (null == this.getNextNonInvoicedLineNumber()) {
            this.setNextNonInvoicedLineNumber(1);
        }
        String customerNumber = null;
        String docId = this.getDocument().getDocumentNumber();
        if (ObjectUtils.isNotNull((Object)request.getParameter("docId")) && ObjectUtils.isNull((Object)this.getDocument().getDocumentNumber())) {
            Document d;
            docId = request.getParameter("docId").trim();
            DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
            try {
                d = documentService.getByDocumentHeaderId(docId);
            }
            catch (WorkflowException e) {
                throw new RuntimeException("WorkflowException thrown when trying to load docId [" + docId + "]", e);
            }
            PaymentApplicationDocument pDocument = (PaymentApplicationDocument)d;
            AccountsReceivableDocumentHeader arHeader = pDocument.getAccountsReceivableDocumentHeader();
            if (ObjectUtils.isNotNull((Object)((Object)arHeader))) {
                customerNumber = arHeader.getCustomerNumber();
            }
        }
        if (ObjectUtils.isNull((Object)this.getSelectedInvoiceApplication()) && (ObjectUtils.isNull(this.invoices) || this.invoices.isEmpty()) && ObjectUtils.isNotNull(customerNumber)) {
            CustomerInvoiceDocumentService customerInvoiceDocumentService = (CustomerInvoiceDocumentService)SpringContext.getBean(CustomerInvoiceDocumentService.class);
            Collection<CustomerInvoiceDocument> openInvoicesForCustomer = customerInvoiceDocumentService.getOpenInvoiceDocumentsByCustomerNumber(customerNumber);
            this.setInvoices(new ArrayList<CustomerInvoiceDocument>(openInvoicesForCustomer));
            if (this.invoices != null && !this.invoices.isEmpty()) {
                this.setSelectedInvoiceDocumentNumber(this.invoices.get(0).getDocumentNumber());
            }
            this.setupInvoiceWrappers(docId);
        }
    }

    protected void setupInvoiceWrappers(String payAppDocNumber) {
        if (StringUtils.isBlank((CharSequence)payAppDocNumber)) {
            throw new IllegalArgumentException("The payAppDocNumber parameter passed in was null or blank.");
        }
        this.invoiceApplications.clear();
        if (this.invoices == null || this.invoices.isEmpty()) {
            return;
        }
        for (CustomerInvoiceDocument invoice : this.invoices) {
            PaymentApplicationInvoiceApply invoiceApplication = new PaymentApplicationInvoiceApply(payAppDocNumber, invoice);
            this.addInvoiceApplication(invoiceApplication);
        }
    }

    public Map<String, PaymentApplicationInvoiceApply> getInvoiceApplicationsByDocumentNumber() {
        HashMap<String, PaymentApplicationInvoiceApply> m = new HashMap<String, PaymentApplicationInvoiceApply>();
        for (PaymentApplicationInvoiceApply i : this.invoiceApplications) {
            m.put(i.getDocumentNumber(), i);
        }
        return m;
    }

    public Integer getNextNonInvoicedLineNumber() {
        return this.nextNonInvoicedLineNumber;
    }

    public void setNextNonInvoicedLineNumber(Integer nextNonInvoicedLineNumber) {
        this.nextNonInvoicedLineNumber = nextNonInvoicedLineNumber;
    }

    public KualiDecimal getNonArTotal() {
        return null == this.getPaymentApplicationDocument() ? KualiDecimal.ZERO : this.getPaymentApplicationDocument().getNonArTotal();
    }

    public PaymentApplicationDocument getPaymentApplicationDocument() {
        return (PaymentApplicationDocument)this.getDocument();
    }

    public InvoicePaidApplied getPaidAppliedForInvoiceDetail(String invoiceDocNumber, Integer invoiceItemNumber) {
        if (StringUtils.isBlank((CharSequence)invoiceDocNumber)) {
            throw new IllegalArgumentException("The parameter [invoiceDocNumber] passed in was blank or null.");
        }
        if (invoiceItemNumber == null || invoiceItemNumber < 1) {
            throw new IllegalArgumentException("The parameter [invoiceItemNumber] passed in was blank, zero or negative.");
        }
        PaymentApplicationDocument payAppDoc = this.getPaymentApplicationDocument();
        List<InvoicePaidApplied> paidApplieds = payAppDoc.getInvoicePaidApplieds();
        for (InvoicePaidApplied paidApplied : paidApplieds) {
            if (!invoiceDocNumber.equalsIgnoreCase(paidApplied.getFinancialDocumentReferenceInvoiceNumber()) || !invoiceItemNumber.equals(paidApplied.getInvoiceItemNumber())) continue;
            return paidApplied;
        }
        return null;
    }

    public String getSelectedInvoiceDocumentNumber() {
        return this.selectedInvoiceDocumentNumber;
    }

    public void setSelectedInvoiceDocumentNumber(String selectedInvoiceDocumentNumber) {
        this.selectedInvoiceDocumentNumber = selectedInvoiceDocumentNumber;
    }

    public KualiDecimal getUnappliedCustomerAmount() {
        return this.unappliedCustomerAmount;
    }

    public void setUnappliedCustomerAmount(KualiDecimal unappliedCustomerAmount) {
        this.unappliedCustomerAmount = unappliedCustomerAmount;
    }

    public List<PaymentApplicationInvoiceDetailApply> getSelectedInvoiceDetailApplications() {
        PaymentApplicationInvoiceApply invoiceApplication = this.getSelectedInvoiceApplication();
        List<PaymentApplicationInvoiceDetailApply> detailApplications = null;
        if (ObjectUtils.isNotNull((Object)invoiceApplication) && null == (detailApplications = invoiceApplication.getDetailApplications())) {
            detailApplications = new ArrayList<PaymentApplicationInvoiceDetailApply>();
        }
        return detailApplications;
    }

    public List<PaymentApplicationInvoiceApply> getNonSelectedInvoiceApplications() {
        String selectedInvoiceNumber = this.getSelectedInvoiceApplication().getDocumentNumber();
        ArrayList<PaymentApplicationInvoiceApply> nonSelectedInvoiceApplications = new ArrayList<PaymentApplicationInvoiceApply>();
        for (PaymentApplicationInvoiceApply invoiceApplication : this.invoiceApplications) {
            if (invoiceApplication.getDocumentNumber().equalsIgnoreCase(selectedInvoiceNumber)) continue;
            nonSelectedInvoiceApplications.add(invoiceApplication);
        }
        return nonSelectedInvoiceApplications;
    }

    public List<PaymentApplicationInvoiceApply> getInvoiceApplications() {
        return this.invoiceApplications;
    }

    public void setInvoiceApplications(List<PaymentApplicationInvoiceApply> invoiceApplications) {
        this.invoiceApplications = invoiceApplications;
    }

    public PaymentApplicationInvoiceApply getSelectedInvoiceApplication() {
        String docNumber = this.getSelectedInvoiceDocumentNumber();
        if (ObjectUtils.isNotNull((Object)docNumber)) {
            return this.getInvoiceApplicationsByDocumentNumber().get(docNumber);
        }
        List<PaymentApplicationInvoiceApply> i = this.invoiceApplications;
        if (i.isEmpty()) {
            return null;
        }
        return this.invoiceApplications.get(0);
    }

    public List<CustomerInvoiceDocument> getInvoices() {
        return this.invoices;
    }

    public void setInvoices(ArrayList<CustomerInvoiceDocument> invoices) {
        this.invoices = invoices;
    }

    public String getEnteredInvoiceDocumentNumber() {
        return this.enteredInvoiceDocumentNumber;
    }

    public void setEnteredInvoiceDocumentNumber(String enteredInvoiceDocumentNumber) {
        this.enteredInvoiceDocumentNumber = enteredInvoiceDocumentNumber;
    }

    public KualiDecimal getTotalApplied() {
        KualiDecimal totalApplied = this.getPaymentApplicationDocument().getTotalApplied();
        if (totalApplied.isPositive()) {
            return totalApplied;
        }
        return KualiDecimal.ZERO;
    }

    public KualiDecimal getUnallocatedBalance() {
        return (KualiDecimal)this.getTotalFromControl().subtract((AbstractKualiDecimal)this.getTotalApplied());
    }

    public KualiDecimal getTotalFromControl() {
        PaymentApplicationDocument payAppDoc = (PaymentApplicationDocument)this.getDocument();
        if (payAppDoc.hasCashControlDetail()) {
            return payAppDoc.getTotalFromControl();
        }
        return this.getNonAppliedControlAvailableUnappliedAmount();
    }

    public PaymentApplicationInvoiceDetailApply getInvoiceDetailApplication(int index) {
        List<PaymentApplicationInvoiceDetailApply> details = this.getSelectedInvoiceDetailApplications();
        return details.get(index);
    }

    public PaymentApplicationInvoiceApply getInvoiceApplication(int index) {
        return this.invoiceApplications.get(index);
    }

    public void setInvoiceDetailApplication(int key, PaymentApplicationInvoiceDetailApply value) {
        this.getSelectedInvoiceDetailApplications().set(key, value);
    }

    public KualiDecimal getSelectedInvoiceBalance() {
        PaymentApplicationInvoiceApply invoiceApplication = this.getSelectedInvoiceApplication();
        return invoiceApplication.getOpenAmount();
    }

    public KualiDecimal getSelectedInvoiceTotalAmount() {
        PaymentApplicationInvoiceApply invoiceApplication = this.getSelectedInvoiceApplication();
        return invoiceApplication.getInvoice().getSourceTotal();
    }

    public KualiDecimal getAmountAppliedDirectlyToInvoice() {
        PaymentApplicationInvoiceApply invoiceApplicationToFind = this.getSelectedInvoiceApplication();
        KualiDecimal amount = new KualiDecimal(0);
        for (PaymentApplicationInvoiceApply invoiceApplication : this.invoiceApplications) {
            if (!invoiceApplicationToFind.getDocumentNumber().equalsIgnoreCase(invoiceApplication.getDocumentNumber())) continue;
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)invoiceApplication.getAmountToApply());
        }
        return amount;
    }

    public String getPreviousInvoiceDocumentNumber() {
        CustomerInvoiceDocument selectedInvoiceDocument;
        CustomerInvoiceDocument previousInvoiceDocument = null;
        PaymentApplicationInvoiceApply invoiceApplication = this.getSelectedInvoiceApplication();
        CustomerInvoiceDocument customerInvoiceDocument = selectedInvoiceDocument = invoiceApplication == null ? null : invoiceApplication.getInvoice();
        if (null == selectedInvoiceDocument || 2 > this.invoices.size()) {
            previousInvoiceDocument = null;
        } else {
            Iterator<CustomerInvoiceDocument> iterator = this.invoices.iterator();
            CustomerInvoiceDocument customerInvoiceDocument2 = iterator.next();
            String selectedInvoiceDocumentNumber = selectedInvoiceDocument.getDocumentNumber();
            if (null != selectedInvoiceDocumentNumber && selectedInvoiceDocumentNumber.equals(customerInvoiceDocument2.getDocumentNumber())) {
                previousInvoiceDocument = null;
            } else {
                while (iterator.hasNext()) {
                    CustomerInvoiceDocument currentInvoiceDocument = iterator.next();
                    String currentInvoiceDocumentNumber = currentInvoiceDocument.getDocumentNumber();
                    if (null != currentInvoiceDocumentNumber && currentInvoiceDocumentNumber.equals(selectedInvoiceDocument.getDocumentNumber())) {
                        previousInvoiceDocument = customerInvoiceDocument2;
                        continue;
                    }
                    customerInvoiceDocument2 = currentInvoiceDocument;
                }
            }
        }
        return null == previousInvoiceDocument ? "" : previousInvoiceDocument.getDocumentNumber();
    }

    public String getNextInvoiceDocumentNumber() {
        CustomerInvoiceDocument selectedInvoiceDocument;
        CustomerInvoiceDocument nextInvoiceDocument = null;
        PaymentApplicationInvoiceApply invoiceApplication = this.getSelectedInvoiceApplication();
        CustomerInvoiceDocument customerInvoiceDocument = selectedInvoiceDocument = invoiceApplication == null ? null : invoiceApplication.getInvoice();
        if (null == selectedInvoiceDocument || 2 > this.invoices.size()) {
            nextInvoiceDocument = null;
        } else {
            Iterator<CustomerInvoiceDocument> iterator = this.invoices.iterator();
            while (iterator.hasNext()) {
                CustomerInvoiceDocument currentInvoiceDocument = iterator.next();
                String currentInvoiceDocumentNumber = currentInvoiceDocument.getDocumentNumber();
                if (!currentInvoiceDocumentNumber.equals(selectedInvoiceDocument.getDocumentNumber())) continue;
                if (iterator.hasNext()) {
                    nextInvoiceDocument = iterator.next();
                    continue;
                }
                nextInvoiceDocument = null;
            }
        }
        return null == nextInvoiceDocument ? "" : nextInvoiceDocument.getDocumentNumber();
    }

    public CashControlDocument getCashControlDocument() {
        return this.getPaymentApplicationDocument().getCashControlDocument();
    }

    public NonInvoiced getNonInvoicedAddLine() {
        return this.nonInvoicedAddLine;
    }

    public void setNonInvoicedAddLine(NonInvoiced nonInvoicedAddLine) {
        this.nonInvoicedAddLine = nonInvoicedAddLine;
    }

    public Integer getNonInvoicedAddLineItemNumber() {
        Integer number = 0;
        if (null != this.getPaymentApplicationDocument()) {
            List<NonInvoiced> items = this.getPaymentApplicationDocument().getNonInvoiceds();
            for (NonInvoiced item : items) {
                Integer i = item.getFinancialDocumentLineNumber();
                if (i <= number) continue;
                number = i;
            }
        }
        return number + 1;
    }

    public PaymentApplicationInvoiceApply getInvoiceApplication(String documentNumber) {
        if (StringUtils.isBlank((CharSequence)documentNumber)) {
            throw new RuntimeException("The parameter passed in [documentNumber] was null or blank.");
        }
        for (PaymentApplicationInvoiceApply invoiceApplication : this.invoiceApplications) {
            if (!documentNumber.equalsIgnoreCase(invoiceApplication.getDocumentNumber())) continue;
            return invoiceApplication;
        }
        return null;
    }

    public void addInvoiceApplication(PaymentApplicationInvoiceApply invoiceApplicationToAdd) {
        if (invoiceApplicationToAdd == null) {
            throw new RuntimeException("The parameter passed in [invoiceApplicationToAdd] was null.");
        }
        for (int i = 0; i < this.invoiceApplications.size(); ++i) {
            PaymentApplicationInvoiceApply invoiceApplication = this.invoiceApplications.get(i);
            if (!invoiceApplicationToAdd.getDocumentNumber().equalsIgnoreCase(invoiceApplication.getDocumentNumber())) continue;
            this.invoiceApplications.set(i, invoiceApplicationToAdd);
        }
        this.invoiceApplications.add(invoiceApplicationToAdd);
    }

    public String getSelectedCustomerNumber() {
        return this.selectedCustomerNumber;
    }

    public void setSelectedCustomerNumber(String selectedCustomerNumber) {
        this.selectedCustomerNumber = StringUtils.isBlank((CharSequence)selectedCustomerNumber) ? null : selectedCustomerNumber.toUpperCase();
    }

    public KualiDecimal getNonAppliedHoldingAmount() {
        return this.nonAppliedHoldingAmount;
    }

    public void setNonAppliedHoldingAmount(KualiDecimal nonAppliedHoldingAmount) {
        this.nonAppliedHoldingAmount = nonAppliedHoldingAmount;
    }

    public String getNonAppliedHoldingCustomerNumber() {
        return this.nonAppliedHoldingCustomerNumber;
    }

    public void setNonAppliedHoldingCustomerNumber(String nonAppliedHoldingCustomerNumber) {
        this.nonAppliedHoldingCustomerNumber = nonAppliedHoldingCustomerNumber;
    }

    public List<PaymentApplicationDocument> getNonAppliedControlDocs() {
        return this.nonAppliedControlDocs;
    }

    public void setNonAppliedControlDocs(List<PaymentApplicationDocument> nonAppliedControlDocs) {
        this.nonAppliedControlDocs = nonAppliedControlDocs;
    }

    public KualiDecimal getNonAppliedControlAvailableUnappliedAmount() {
        KualiDecimal amount = KualiDecimal.ZERO;
        for (NonAppliedHolding nonAppliedHolding : this.nonAppliedControlHoldings) {
            amount = (KualiDecimal)amount.add((AbstractKualiDecimal)nonAppliedHolding.getAvailableUnappliedAmount());
        }
        return amount;
    }

    public List<NonAppliedHolding> getNonAppliedControlHoldings() {
        EntryHolderComparator entryHolderComparator = new EntryHolderComparator();
        ArrayList<EntryHolder> entryHoldings = new ArrayList<EntryHolder>();
        for (NonAppliedHolding nonAppliedControlHolding : this.nonAppliedControlHoldings) {
            entryHoldings.add(new EntryHolder(nonAppliedControlHolding.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate(), (Object)nonAppliedControlHolding));
        }
        if (entryHoldings.size() > 0) {
            Collections.sort(entryHoldings, entryHolderComparator);
        }
        ArrayList<NonAppliedHolding> results = new ArrayList<NonAppliedHolding>();
        for (EntryHolder entryHolder : entryHoldings) {
            results.add((NonAppliedHolding)((Object)entryHolder.getHolder()));
        }
        return results;
    }

    public void setNonAppliedControlHoldings(List<NonAppliedHolding> nonAppliedControlHoldings) {
        this.nonAppliedControlHoldings = nonAppliedControlHoldings;
    }

    public Map<String, KualiDecimal> getDistributionsFromControlDocs() {
        if (this.distributionsFromControlDocs == null || this.distributionsFromControlDocs.isEmpty()) {
            this.distributionsFromControlDocs = this.getPaymentApplicationDocument().getDistributionsFromControlDocuments();
        }
        return this.distributionsFromControlDocs;
    }

    public Map<String, KualiDecimal> getNonAppliedControlAllocations() {
        if (this.nonAppliedControlAllocations == null || this.nonAppliedControlAllocations.isEmpty()) {
            this.nonAppliedControlAllocations = this.getPaymentApplicationDocument().allocateFundsFromUnappliedControls(this.nonAppliedControlHoldings, this.getTotalApplied());
        }
        return this.nonAppliedControlAllocations;
    }

    public void setNonAppliedControlAllocations(Map<String, KualiDecimal> nonAppliedControlAllocations) {
        this.nonAppliedControlAllocations = nonAppliedControlAllocations;
    }

    public KualiDecimal getNonAppliedControlAllocation(String documentNumber) {
        if (!this.getNonAppliedControlAllocations().containsKey(documentNumber)) {
            return KualiDecimal.ZERO;
        }
        return this.getNonAppliedControlAllocations().get(documentNumber);
    }

    protected void populateFalseCheckboxes(HttpServletRequest request) {
        String[] checkboxesToReset;
        Map parameterMap = request.getParameterMap();
        if (parameterMap.get("checkboxToReset") != null && (checkboxesToReset = request.getParameterValues("checkboxToReset")) != null && checkboxesToReset.length > 0) {
            for (String propertyName : checkboxesToReset) {
                if (!StringUtils.isBlank((CharSequence)propertyName) && parameterMap.get(propertyName) == null) {
                    this.populateForProperty(propertyName, "No", parameterMap);
                    continue;
                }
                if (StringUtils.isBlank((CharSequence)propertyName) || parameterMap.get(propertyName) == null || ((String[])parameterMap.get(propertyName)).length < 1 || !((String[])parameterMap.get(propertyName))[0].equalsIgnoreCase("on")) continue;
                this.populateForProperty(propertyName, "Yes", parameterMap);
            }
        }
    }

    protected static class EntryHolderComparator
    implements Comparator<EntryHolder> {
        protected EntryHolderComparator() {
        }

        @Override
        public int compare(EntryHolder rosencrantz, EntryHolder guildenstern) {
            return rosencrantz.getDate().compareTo(guildenstern.getDate());
        }
    }

    protected class EntryHolder {
        private Date date;
        private Object holder;

        public EntryHolder(Date date, Object holder) {
            this.date = date;
            this.holder = holder;
        }

        public Date getDate() {
            return this.date;
        }

        public Object getHolder() {
            return this.holder;
        }
    }
}

