/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.io.File;
import java.util.Date;
import java.util.Map;
import java.util.ResourceBundle;
import org.kuali.kfs.module.ar.report.service.CustomerStatementReportService;
import org.kuali.kfs.module.ar.report.util.CustomerStatementReportDataHolder;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public class CustomerStatementReportServiceImpl
implements CustomerStatementReportService {
    private ReportGenerationService reportGenerationService;
    private ReportInfo customerStatementReportInfo;
    private ReportInfo customerDetailStatementReportInfo;

    @Override
    public File generateReport(CustomerStatementReportDataHolder reportDataHolder, Date runDate, String statementFormat) {
        String reportFileName = this.customerStatementReportInfo.getReportFileName();
        String reportDirectory = this.customerStatementReportInfo.getReportsDirectory();
        String reportTemplateClassPath = this.customerStatementReportInfo.getReportTemplateClassPath();
        ResourceBundle resourceBundle = this.customerStatementReportInfo.getResourceBundle();
        String subReportTemplateClassPath = this.customerStatementReportInfo.getSubReportTemplateClassPath();
        String reportTemplateName = "";
        Map subReports = null;
        if (statementFormat.equalsIgnoreCase("Summary")) {
            reportTemplateName = this.customerStatementReportInfo.getReportTemplateName();
            subReports = this.customerStatementReportInfo.getSubReports();
        } else {
            reportTemplateName = this.customerDetailStatementReportInfo.getReportTemplateName();
            subReports = this.customerDetailStatementReportInfo.getSubReports();
        }
        Map<String, Object> reportData = reportDataHolder.getReportData();
        reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        reportData.put("SUBREPORT_DIR", subReportTemplateClassPath);
        reportData.put("SUBREPORT_TEMPLATE_NAMES", subReports);
        String template = reportTemplateClassPath + reportTemplateName;
        String fullReportFileName = this.reportGenerationService.buildFullFileName(runDate, reportDirectory, reportFileName, "");
        File report = new File(fullReportFileName + ".pdf");
        this.reportGenerationService.generateReportToPdfFile(reportData, template, fullReportFileName);
        return report;
    }

    public void setCustomerStatementReportInfo(ReportInfo customerStatementReportInfo) {
        this.customerStatementReportInfo = customerStatementReportInfo;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public void setCustomerDetailStatementReportInfo(ReportInfo customerDetailStatementReportInfo) {
        this.customerDetailStatementReportInfo = customerDetailStatementReportInfo;
    }
}

