/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.io.Serializable;
import java.sql.Date;
import java.text.ParseException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.converters.BooleanConverter;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.util.KNSGlobalVariables;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.ScheduleCsvInputFileType;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.PredeterminedBillingSchedule;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.util.AutoPopulatingList;

public class PredeterminedBillingScheduleCsvInputFileType
extends ScheduleCsvInputFileType {
    protected Object convertParsedObjectToVO(Object parsedContent) {
        LinkedList<PredeterminedBillingSchedule> predeterminedBillingSchedules = new LinkedList<PredeterminedBillingSchedule>();
        List parseDataList = (List)parsedContent;
        for (Map row : parseDataList) {
            PredeterminedBillingSchedule currentSchedule;
            String proposalNumber = (String)row.get("proposalNumber");
            String chartOfAccountsCode = (String)row.get("chartOfAccountsCode");
            String accountNumber = (String)row.get("accountNumber");
            if (StringUtils.isEmpty((CharSequence)chartOfAccountsCode)) {
                chartOfAccountsCode = this.deriveChartOfAccountsCodeFromAccount(accountNumber);
            }
            try {
                currentSchedule = new PredeterminedBillingSchedule.PredeterminedBillingScheduleBuilder().setProposalNumber(proposalNumber).setChartOfAccountsCode(chartOfAccountsCode).setAccountNumber(accountNumber).addBill(this.createBill(proposalNumber, chartOfAccountsCode, accountNumber, row)).build();
            }
            catch (IllegalStateException | ParseException e) {
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.batchUpload.parse", new String[]{e.getMessage()});
                return null;
            }
            if (predeterminedBillingSchedules.contains((Object)currentSchedule)) {
                PredeterminedBillingSchedule existingSchedule = (PredeterminedBillingSchedule)((Object)predeterminedBillingSchedules.get(predeterminedBillingSchedules.indexOf((Object)currentSchedule)));
                existingSchedule.addBill(currentSchedule.getBills().get(0));
                continue;
            }
            predeterminedBillingSchedules.add(currentSchedule);
        }
        return predeterminedBillingSchedules;
    }

    private Bill createBill(String proposalNumber, String chartOfAccountsCode, String accountNumber, Map<String, String> row) throws ParseException {
        String billNumber = row.get("billNumber");
        String billDescription = row.get("billDescription");
        String estimatedAmountString = row.get("estimatedAmount");
        KualiDecimal estimatedAmount = null;
        if (StringUtils.isNotBlank((CharSequence)estimatedAmountString)) {
            estimatedAmount = new KualiDecimal(estimatedAmountString);
        }
        String billDateString = row.get("billDate");
        Date billDate = null;
        if (billDateString.length() > 0) {
            billDate = this.dateTimeService.convertToSqlDate(billDateString);
        }
        BooleanConverter converter = new BooleanConverter((Object)Boolean.FALSE);
        boolean active = (Boolean)converter.convert(Boolean.TYPE, (Object)row.get("active"));
        Bill bill = new Bill.BillBuilder().setProposalNumber(proposalNumber).setChartOfAccountsCode(chartOfAccountsCode).setAccountNumber(accountNumber).setActive(active).setBillNumber(billNumber).setBillDescription(billDescription).setBillDate(billDate).setEstimatedAmount(estimatedAmount).build();
        bill.setNewCollectionRecord(true);
        return bill;
    }

    public String getFileTypeIdentifier() {
        return "PredeterminedBillingScheduleCsvInputFileType";
    }

    public void process(String fileName, Object parsedFileContents) {
        List predeterminedBillingSchedules = (List)parsedFileContents;
        for (PredeterminedBillingSchedule predeterminedBillingSchedule : predeterminedBillingSchedules) {
            MaintenanceDocument predeterminedBillingScheduleDocument;
            try {
                predeterminedBillingScheduleDocument = (MaintenanceDocument)this.documentService.getNewDocument(this.maintenanceDocumentDictionaryService.getDocumentTypeName(PredeterminedBillingSchedule.class));
            }
            catch (WorkflowException we) {
                this.LOG.error("process(...) - encountered WorkflowException while attempting to get a new predetermined billing schedule document.", (Throwable)we);
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.ar.predetermined.billing.schedule.import.nonrecoverable", new String[0]);
                break;
            }
            predeterminedBillingScheduleDocument.getDocumentHeader().setDocumentDescription("Predetermined Billing Schedule Import");
            PredeterminedBillingSchedule existingPredeterminedBillingSchedule = this.getPredeterminedBillingSchedule(predeterminedBillingSchedule);
            if (ObjectUtils.isNull((Object)((Object)existingPredeterminedBillingSchedule))) {
                predeterminedBillingScheduleDocument.getNewMaintainableObject().setMaintenanceAction("New");
                predeterminedBillingScheduleDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)predeterminedBillingSchedule);
                predeterminedBillingScheduleDocument.getOldMaintainableObject().setBusinessObject((PersistableBusinessObject)new PredeterminedBillingSchedule());
            } else {
                PredeterminedBillingSchedule copyOfExistingPredeterminedBillingSchedule = (PredeterminedBillingSchedule)((Object)ObjectUtils.deepCopy((Serializable)((Object)existingPredeterminedBillingSchedule)));
                predeterminedBillingSchedule.getBills().forEach(bill -> {
                    copyOfExistingPredeterminedBillingSchedule.addBill((Bill)((Object)bill));
                    existingPredeterminedBillingSchedule.addBill(new Bill());
                });
                predeterminedBillingScheduleDocument.getNewMaintainableObject().setBusinessObject((PersistableBusinessObject)copyOfExistingPredeterminedBillingSchedule);
                predeterminedBillingScheduleDocument.getNewMaintainableObject().setMaintenanceAction("Edit");
                predeterminedBillingScheduleDocument.getOldMaintainableObject().setBusinessObject((PersistableBusinessObject)existingPredeterminedBillingSchedule);
            }
            try {
                this.documentService.saveDocument((Document)predeterminedBillingScheduleDocument);
                this.documentService.routeDocument((Document)predeterminedBillingScheduleDocument, "Routed New/Edit Predetermined Billing Schedule Maintenance Document from Predetermined Billing Schedule Import Process", null);
            }
            catch (ValidationException ve) {
                Map errorMessages = GlobalVariables.getMessageMap().getErrorMessages();
                errorMessages.keySet().stream().filter(key -> key.equals("GLOBAL_ERRORS")).forEach(key -> KNSGlobalVariables.getMessageList().add("error.ar.predetermined.billing.schedule.import.save.failure", new String[]{predeterminedBillingSchedule.getProposalNumber(), predeterminedBillingSchedule.getChartOfAccountsCode(), predeterminedBillingSchedule.getAccountNumber(), this.flattenErrorMessages((AutoPopulatingList<ErrorMessage>)((AutoPopulatingList)errorMessages.get(key)))}));
                GlobalVariables.getMessageMap().clearErrorMessages();
            }
            catch (WorkflowException we) {
                this.LOG.error("process(...) - encountered WorkflowException while attempting to save or route a predetermined billing schedule document.", (Throwable)we);
                GlobalVariables.getMessageMap().putError("GLOBAL_ERRORS", "error.ar.predetermined.billing.schedule.import.nonrecoverable", new String[0]);
                break;
            }
        }
        KNSGlobalVariables.getMessageList().add("message.ar.predetermined.billing.schedule.import.successful", new String[0]);
        this.removeFiles(fileName);
    }

    private PredeterminedBillingSchedule getPredeterminedBillingSchedule(PredeterminedBillingSchedule predeterminedBillingSchedule) {
        HashMap<String, String> primaryKeys = new HashMap<String, String>();
        primaryKeys.put("proposalNumber", predeterminedBillingSchedule.getProposalNumber());
        primaryKeys.put("chartOfAccountsCode", predeterminedBillingSchedule.getChartOfAccountsCode());
        primaryKeys.put("accountNumber", predeterminedBillingSchedule.getAccountNumber());
        return (PredeterminedBillingSchedule)this.businessObjectService.findByPrimaryKey(PredeterminedBillingSchedule.class, primaryKeys);
    }

    public String getTitleKey() {
        return "message.ar.predetermined.billing.schedule.import.title";
    }
}

