/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject;

import java.sql.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.BillBase;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.mo.common.active.MutableInactivatable;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class Bill
extends BillBase
implements MutableInactivatable {
    private String proposalNumber;
    private String chartOfAccountsCode;
    private String accountNumber;
    private boolean billed = false;
    private boolean active;
    private ContractsAndGrantsBillingAward award;
    private transient ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;

    public Bill() {
    }

    private Bill(String proposalNumber, String chartOfAccountsCode, String accountNumber, boolean billed, boolean active, Long billIdentifier, String billNumber, String billDescription, Date billDate, KualiDecimal estimatedAmount) {
        this.proposalNumber = proposalNumber;
        this.chartOfAccountsCode = chartOfAccountsCode;
        this.accountNumber = accountNumber;
        this.billed = billed;
        this.active = active;
        this.billIdentifier = billIdentifier;
        this.billNumber = billNumber;
        this.billDescription = billDescription;
        this.billDate = billDate;
        this.estimatedAmount = estimatedAmount;
    }

    public String getProposalNumber() {
        return this.proposalNumber;
    }

    public void setProposalNumber(String proposalNumber) {
        this.proposalNumber = proposalNumber;
    }

    public String getChartOfAccountsCode() {
        return this.chartOfAccountsCode;
    }

    public void setChartOfAccountsCode(String chartOfAccountsCode) {
        this.chartOfAccountsCode = chartOfAccountsCode;
    }

    public String getAccountNumber() {
        return this.accountNumber;
    }

    public void setAccountNumber(String accountNumber) {
        this.accountNumber = accountNumber;
    }

    public boolean isBilled() {
        return this.billed;
    }

    public void setBilled(boolean billed) {
        this.billed = billed;
    }

    public ContractsAndGrantsBillingAward getAward() {
        ContractsAndGrantsBillingAward updatedAward = this.getContractsAndGrantsModuleBillingService().updateAwardIfNecessary(this.proposalNumber, this.award);
        if (ObjectUtils.isNull((Object)updatedAward)) {
            return this.award;
        }
        return updatedAward;
    }

    public void setAward(ContractsAndGrantsBillingAward award) {
        this.award = award;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Bill)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Bill bill = (Bill)((Object)o);
        return this.billed == bill.billed && this.active == bill.active && Objects.equals(this.proposalNumber, bill.proposalNumber) && Objects.equals(this.chartOfAccountsCode, bill.chartOfAccountsCode) && Objects.equals(this.accountNumber, bill.accountNumber);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.proposalNumber, this.chartOfAccountsCode, this.accountNumber, this.billed, this.active);
    }

    protected ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        if (this.contractsAndGrantsModuleBillingService == null) {
            this.contractsAndGrantsModuleBillingService = (ContractsAndGrantsModuleBillingService)SpringContext.getBean(ContractsAndGrantsModuleBillingService.class);
        }
        return this.contractsAndGrantsModuleBillingService;
    }

    protected void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public static class BillBuilder {
        private String proposalNumber;
        private String chartOfAccountsCode;
        private String accountNumber;
        private boolean billed;
        private boolean active;
        private Long billIdentifier;
        private String billNumber;
        private String billDescription;
        private Date billDate;
        private KualiDecimal estimatedAmount;

        public BillBuilder setProposalNumber(String proposalNumber) {
            this.proposalNumber = proposalNumber;
            return this;
        }

        public BillBuilder setChartOfAccountsCode(String chartOfAccountsCode) {
            this.chartOfAccountsCode = chartOfAccountsCode;
            return this;
        }

        public BillBuilder setAccountNumber(String accountNumber) {
            this.accountNumber = accountNumber;
            return this;
        }

        public BillBuilder setBilled(boolean billed) {
            this.billed = billed;
            return this;
        }

        public BillBuilder setActive(boolean active) {
            this.active = active;
            return this;
        }

        public BillBuilder setBillIdentifier(Long billIdentifier) {
            this.billIdentifier = billIdentifier;
            return this;
        }

        public BillBuilder setBillNumber(String billNumber) {
            this.billNumber = billNumber;
            return this;
        }

        public BillBuilder setBillDescription(String billDescription) {
            this.billDescription = billDescription;
            return this;
        }

        public BillBuilder setBillDate(Date billDate) {
            this.billDate = billDate;
            return this;
        }

        public BillBuilder setEstimatedAmount(KualiDecimal estimatedAmount) {
            this.estimatedAmount = estimatedAmount;
            return this;
        }

        public Bill build() {
            this.validate();
            return new Bill(this.proposalNumber, this.chartOfAccountsCode, this.accountNumber, this.billed, this.active, this.billIdentifier, this.billNumber, this.billDescription, this.billDate, this.estimatedAmount);
        }

        private void validate() {
            if (StringUtils.isBlank((CharSequence)this.proposalNumber)) {
                throw new IllegalStateException("Proposal Number is required.");
            }
            if (StringUtils.isBlank((CharSequence)this.chartOfAccountsCode)) {
                throw new IllegalStateException("Chart of Accounts Code is required.");
            }
            if (StringUtils.isBlank((CharSequence)this.accountNumber)) {
                throw new IllegalStateException("Account Number is required.");
            }
            if (StringUtils.isBlank((CharSequence)this.billNumber)) {
                throw new IllegalStateException("Bill Number is required.");
            }
            if (this.estimatedAmount == null) {
                throw new IllegalStateException("Estimated Amount is required.");
            }
            if (this.billDate == null) {
                throw new IllegalStateException("Bill Date is required.");
            }
        }
    }
}

