/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.Maintainable;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.MilestoneSchedule;
import org.kuali.kfs.module.ar.document.service.MilestoneScheduleMaintenanceService;
import org.kuali.kfs.module.ar.document.validation.impl.MilestoneScheduleRuleUtil;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.FinancialSystemMaintainable;

public class MilestoneScheduleMaintainableImpl
extends FinancialSystemMaintainable {
    private static volatile MilestoneScheduleMaintenanceService milestoneScheduleMaintenanceService;

    public void refresh(String refreshCaller, Map fieldValues, MaintenanceDocument document) {
        if (StringUtils.equals((CharSequence)"awardAccountLookupable", (CharSequence)((String)fieldValues.get("refreshCaller")))) {
            MilestoneSchedule milestoneSchedule = this.getMilestoneSchedule();
            milestoneSchedule.setProposalNumber(milestoneSchedule.getProposalNumberForAwardAccountLookup());
            milestoneSchedule.setChartOfAccountsCode(milestoneSchedule.getChartOfAccountsCodeForAwardAccountLookup());
            milestoneSchedule.setAccountNumber(milestoneSchedule.getAccountNumberForAwardAccountLookup());
            if (MilestoneScheduleRuleUtil.checkIfMilestonesExists(milestoneSchedule)) {
                String pathToMaintainable = "document.newMaintainableObject";
                GlobalVariables.getMessageMap().addToErrorPath(pathToMaintainable);
                GlobalVariables.getMessageMap().putError("proposalNumberForAwardAccountLookup", "error.cg.award.milestone.schedule.exists", new String[]{milestoneSchedule.getProposalNumber(), milestoneSchedule.getChartOfAccountsCode(), milestoneSchedule.getAccountNumber()});
                GlobalVariables.getMessageMap().removeFromErrorPath(pathToMaintainable);
            }
        } else {
            super.refresh(refreshCaller, fieldValues, document);
        }
    }

    public void processAfterCopy(MaintenanceDocument document, Map<String, String[]> parameters) {
        super.processAfterCopy(document, parameters);
        List<Milestone> milestones = this.getMilestoneSchedule().getMilestones();
        if (ObjectUtils.isNotNull(milestones)) {
            for (Milestone milestone : milestones) {
                milestone.setBilled(false);
                milestone.setMilestoneIdentifier(null);
            }
        }
    }

    public void processAfterRetrieve() {
        MilestoneSchedule milestoneSchedule = this.getMilestoneSchedule();
        milestoneSchedule.refreshNonUpdateableReferences();
        milestoneSchedule.forceAwardUpdate();
        super.processAfterRetrieve();
    }

    public List getSections(MaintenanceDocument document, Maintainable oldMaintainable) {
        List sections = super.getSections(document, oldMaintainable);
        MilestoneSchedule milestoneSchedule = (MilestoneSchedule)document.getNewMaintainableObject().getBusinessObject();
        String proposalNumber = milestoneSchedule.getProposalNumber();
        for (Section section : sections) {
            String sectionId = section.getSectionId();
            if (!sectionId.equalsIgnoreCase("Milestones")) continue;
            this.prepareMilestonesTab(section, proposalNumber);
        }
        return sections;
    }

    protected void prepareMilestonesTab(Section section, String proposalNumber) {
        section.getRows().forEach(row -> row.getFields().stream().filter(field -> field.getCONTAINER().equalsIgnoreCase(field.getFieldType())).flatMap(field -> field.getContainerRows().stream()).flatMap(containerRow -> containerRow.getFields().stream()).filter(containerRowfield -> ObjectUtils.getNestedAttributePrimitive((String)containerRowfield.getPropertyName()).matches("milestoneIdentifier")).map(Field::getPropertyValue).filter(StringUtils::isNotEmpty).filter(milestoneId -> this.getMilestoneScheduleMaintenanceService().hasMilestoneBeenCopiedToInvoice(proposalNumber, (String)milestoneId)).flatMap(milestoneId -> row.getFields().stream()).filter(rowfield -> rowfield.getCONTAINER().equalsIgnoreCase(rowfield.getFieldType())).flatMap(rowfield -> rowfield.getContainerRows().stream()).flatMap(fieldContainerRow -> fieldContainerRow.getFields().stream()).forEach(fieldContainerRowField -> fieldContainerRowField.setReadOnly(true)));
    }

    public MilestoneSchedule getMilestoneSchedule() {
        return (MilestoneSchedule)this.getBusinessObject();
    }

    public MilestoneScheduleMaintenanceService getMilestoneScheduleMaintenanceService() {
        if (milestoneScheduleMaintenanceService == null) {
            milestoneScheduleMaintenanceService = (MilestoneScheduleMaintenanceService)SpringContext.getBean(MilestoneScheduleMaintenanceService.class);
        }
        return milestoneScheduleMaintenanceService;
    }
}

