/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import com.lowagie.text.DocumentException;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.mail.MessagingException;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.krad.exception.InvalidAddressException;
import org.kuali.kfs.krad.exception.ValidationException;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsInvoiceReportService;
import org.kuali.kfs.module.ar.report.service.TransmitContractsAndGrantsInvoicesService;
import org.kuali.kfs.module.ar.service.AREmailService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;

public class TransmitContractsAndGrantsInvoicesServiceImpl
implements TransmitContractsAndGrantsInvoicesService {
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected ContractsGrantsInvoiceReportService contractsGrantsInvoiceReportService;
    protected DateTimeService dateTimeService;
    protected DocumentService documentService;
    protected AREmailService arEmailService;

    @Override
    public Collection<ContractsGrantsInvoiceDocument> getInvoicesByParametersFromRequest(Map fieldValues) throws WorkflowException, ParseException {
        String invoiceTransmissionMethodCode;
        String invoiceAmount;
        String proposalNumber;
        String invoiceInitiatorPrincipalName;
        String unformattedFromDate;
        Date fromDate = null;
        Date toDate = null;
        String unformattedToDate = (String)fieldValues.get("invoicePrintDate");
        if (StringUtils.isNotEmpty((CharSequence)unformattedToDate)) {
            toDate = this.dateTimeService.convertToDate(unformattedToDate);
        }
        if (StringUtils.isNotEmpty((CharSequence)(unformattedFromDate = (String)fieldValues.get("rangeLowerBoundKeyPrefix_invoicePrintDate")))) {
            fromDate = this.dateTimeService.convertToDate(unformattedFromDate);
        }
        if (StringUtils.isNotEmpty((CharSequence)(invoiceInitiatorPrincipalName = (String)fieldValues.get("invoiceInitiatorPrincipalName")))) {
            Principal principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(invoiceInitiatorPrincipalName);
            if (ObjectUtils.isNotNull((Object)principal)) {
                fieldValues.put("documentHeader.initiatorPrincipalId", principal.getPrincipalId());
            } else {
                throw new IllegalArgumentException("The parameter value for initiatorPrincipalName [" + invoiceInitiatorPrincipalName + "] passed in does not map to a person.");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)(proposalNumber = (String)fieldValues.get("proposalNumber")))) {
            fieldValues.put("invoiceGeneralDetail.proposalNumber", proposalNumber);
        }
        if (StringUtils.isNotEmpty((CharSequence)(invoiceAmount = (String)fieldValues.get("invoiceAmount")))) {
            fieldValues.put("documentHeader.financialDocumentTotalAmount", invoiceAmount);
        }
        if (StringUtils.isNotBlank((CharSequence)(invoiceTransmissionMethodCode = (String)fieldValues.get("invoiceTransmissionMethodCode")))) {
            fieldValues.put("invoiceAddressDetails.invoiceTransmissionMethodCode", invoiceTransmissionMethodCode);
        }
        fieldValues.put("invoiceAddressDetails.initialTransmissionDate", SearchOperator.NULL.op());
        fieldValues.put("invoiceAddressDetails.invoiceTransmissionMethodCode", invoiceTransmissionMethodCode);
        fieldValues.put("documentHeader.workflowDocumentStatusCode", DocumentStatus.FINAL.getCode() + SearchOperator.OR.op() + DocumentStatus.PROCESSED.getCode());
        fieldValues.put("invoiceGeneralDetail.billingFrequencyCode", SearchOperator.NOT + ArConstants.BillingFrequencyValues.LETTER_OF_CREDIT.getCode());
        Collection<ContractsGrantsInvoiceDocument> list = this.getContractsGrantsInvoiceDocumentService().retrieveAllCGInvoicesByCriteria(fieldValues);
        ArrayList<ContractsGrantsInvoiceDocument> finalList = new ArrayList<ContractsGrantsInvoiceDocument>();
        for (ContractsGrantsInvoiceDocument item : list) {
            ContractsGrantsInvoiceDocument invoice = (ContractsGrantsInvoiceDocument)this.getDocumentService().getByDocumentHeaderId(item.getDocumentNumber());
            if (invoice.isInvoiceReversal() || invoice.hasInvoiceBeenCorrected() || !this.isInvoiceBetween(invoice, fromDate, toDate) || (!StringUtils.equals((CharSequence)"EMAIL", (CharSequence)invoiceTransmissionMethodCode) || !this.isInvoiceValidToEmail(invoice)) && (!StringUtils.equals((CharSequence)"MAIL", (CharSequence)invoiceTransmissionMethodCode) || !this.isInvoiceValidToMail(invoice))) continue;
            finalList.add(invoice);
        }
        return finalList;
    }

    protected boolean isInvoiceBetween(ContractsGrantsInvoiceDocument invoice, Date fromDate, Date toDate) {
        Date dateCreated = invoice.getDocumentHeader().getWorkflowDocument().getDateCreated().toDate();
        if (ObjectUtils.isNotNull((Object)fromDate) && fromDate.after(dateCreated)) {
            return false;
        }
        if (ObjectUtils.isNotNull((Object)toDate)) {
            return !toDate.before(dateCreated) || KfsDateUtils.isSameDay((Date)toDate, (Date)dateCreated);
        }
        return true;
    }

    @Override
    public boolean isInvoiceValidToEmail(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        for (InvoiceAddressDetail invoiceAddressDetail : contractsGrantsInvoiceDocument.getInvoiceAddressDetails()) {
            if (!ObjectUtils.isNull((Object)invoiceAddressDetail.getInitialTransmissionDate()) || !"EMAIL".equals(invoiceAddressDetail.getInvoiceTransmissionMethodCode())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isInvoiceValidToMail(ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument) {
        for (InvoiceAddressDetail invoiceAddressDetail : contractsGrantsInvoiceDocument.getInvoiceAddressDetails()) {
            if (!ObjectUtils.isNull((Object)invoiceAddressDetail.getInitialTransmissionDate()) || !"MAIL".equals(invoiceAddressDetail.getInvoiceTransmissionMethodCode())) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean printInvoicesAndEnvelopesZip(Collection<ContractsGrantsInvoiceDocument> list, ByteArrayOutputStream baos) throws DocumentException, IOException {
        if (CollectionUtils.isNotEmpty(list)) {
            byte[] envelopes = this.contractsGrantsInvoiceReportService.combineInvoicePdfEnvelopes(list);
            byte[] report = this.contractsGrantsInvoiceReportService.combineInvoicePdfs(list);
            boolean invoiceFileWritten = false;
            boolean envelopeFileWritten = false;
            try (ZipOutputStream zos = new ZipOutputStream(baos);){
                String invoiceFileName = "Invoices-" + this.getDateTimeService().toDateStringForFilename(this.getDateTimeService().getCurrentDate()) + ".pdf";
                invoiceFileWritten = this.writeFile(report, zos, invoiceFileName);
                String envelopeFileName = "InvoiceEnvelopes-" + this.getDateTimeService().toDateStringForFilename(this.getDateTimeService().getCurrentDate()) + ".pdf";
                envelopeFileWritten = this.writeFile(envelopes, zos, envelopeFileName);
            }
            return invoiceFileWritten || envelopeFileWritten;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeFile(byte[] arrayToWrite, ZipOutputStream zos, String fileName) throws IOException {
        byte[] buffer = new byte[1024];
        CRC32 crc = new CRC32();
        if (ObjectUtils.isNotNull((Object)arrayToWrite) && arrayToWrite.length > 0) {
            try (BufferedInputStream bis = new BufferedInputStream(new ByteArrayInputStream(arrayToWrite));){
                int bytesRead;
                while ((bytesRead = bis.read(buffer)) != -1) {
                    crc.update(buffer, 0, bytesRead);
                }
                bis.close();
                bis = new BufferedInputStream(new ByteArrayInputStream(arrayToWrite));
                ZipEntry entry = new ZipEntry(fileName);
                entry.setMethod(0);
                entry.setCompressedSize(arrayToWrite.length);
                entry.setSize(arrayToWrite.length);
                entry.setCrc(crc.getValue());
                zos.putNextEntry(entry);
                while ((bytesRead = bis.read(buffer)) != -1) {
                    zos.write(buffer, 0, bytesRead);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void validateSearchParameters(Map<String, String> fieldValues) {
        Person person;
        String invoiceTransmissionMethodCode = fieldValues.get("invoiceTransmissionMethodCode");
        String invoiceInitiatorPrincipalName = fieldValues.get("invoiceInitiatorPrincipalName");
        String invoicePrintDateFromString = fieldValues.get("rangeLowerBoundKeyPrefix_invoicePrintDate");
        String invoicePrintDateToString = fieldValues.get("invoicePrintDate");
        String invoiceAmount = fieldValues.get("invoiceAmount");
        if (StringUtils.isBlank((CharSequence)invoiceTransmissionMethodCode)) {
            GlobalVariables.getMessageMap().putError("invoiceTransmissionMethodCode", "error.required", new String[]{"Method of Invoice Transmission"});
        }
        if (StringUtils.isNotBlank((CharSequence)invoicePrintDateFromString)) {
            try {
                this.dateTimeService.convertToDate(invoicePrintDateFromString);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError("rangeLowerBoundKeyPrefix_invoicePrintDate", "error.invalidDateTime", new String[]{"Print Invoices From"});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)invoicePrintDateToString)) {
            try {
                this.dateTimeService.convertToDate(invoicePrintDateToString);
            }
            catch (ParseException e) {
                GlobalVariables.getMessageMap().putError("invoicePrintDate", "error.invalidDateTime", new String[]{"Print Invoices To"});
            }
        }
        if (StringUtils.isNotBlank((CharSequence)invoiceAmount) && !KualiDecimal.isNumeric((String)invoiceAmount)) {
            GlobalVariables.getMessageMap().putError("invoiceAmount", "error.numeric", new String[]{"Invoice Amount"});
        }
        if (StringUtils.isNotEmpty((CharSequence)invoiceInitiatorPrincipalName) && ObjectUtils.isNull((Object)(person = ((PersonService)SpringContext.getBean(PersonService.class)).getPersonByPrincipalName(invoiceInitiatorPrincipalName)))) {
            GlobalVariables.getMessageMap().putErrorForSectionId("lookup", "error.no.principal.name.found", new String[0]);
        }
        if (GlobalVariables.getMessageMap().hasErrors()) {
            throw new ValidationException("Error(s) in search criteria");
        }
    }

    @Override
    public boolean sendEmailForListofInvoicesToAgency(Collection<ContractsGrantsInvoiceDocument> list) throws InvalidAddressException, MessagingException {
        return this.arEmailService.sendInvoicesViaEmail(list);
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public ContractsGrantsInvoiceReportService getContractsGrantsInvoiceReportService() {
        return this.contractsGrantsInvoiceReportService;
    }

    public void setContractsGrantsInvoiceReportService(ContractsGrantsInvoiceReportService contractsGrantsInvoiceReportService) {
        this.contractsGrantsInvoiceReportService = contractsGrantsInvoiceReportService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public AREmailService getArEmailService() {
        return this.arEmailService;
    }

    public void setArEmailService(AREmailService arEmailService) {
        this.arEmailService = arEmailService;
    }
}

