/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Date;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import javax.mail.MessagingException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Organization;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.bo.Attachment;
import org.kuali.kfs.krad.bo.Note;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.InvalidAddressException;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.service.NoteService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.UpcomingMilestoneNotificationStep;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.service.AREmailService;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.kfs.sys.mail.BodyMailMessage;
import org.kuali.kfs.sys.mail.MailMessage;
import org.kuali.kfs.sys.service.EmailService;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.kim.api.identity.Person;

public class AREmailServiceImpl
implements AREmailService {
    private static final Logger LOG = LogManager.getLogger(AREmailServiceImpl.class);
    protected ParameterService parameterService;
    protected DataDictionaryService dataDictionaryService;
    protected ConfigurationService kualiConfigurationService;
    protected BusinessObjectService businessObjectService;
    protected DocumentService documentService;
    protected NoteService noteService;
    protected KualiModuleService kualiModuleService;
    protected ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService;
    protected EmailService emailService;

    @Override
    public boolean sendInvoicesViaEmail(Collection<ContractsGrantsInvoiceDocument> invoices) throws InvalidAddressException, MessagingException {
        LOG.debug("sendInvoicesViaEmail() starting.");
        boolean success = true;
        for (ContractsGrantsInvoiceDocument invoice : invoices) {
            List<InvoiceAddressDetail> invoiceAddressDetails = invoice.getInvoiceAddressDetails();
            for (InvoiceAddressDetail invoiceAddressDetail : invoiceAddressDetails) {
                if (!"EMAIL".equals(invoiceAddressDetail.getInvoiceTransmissionMethodCode())) continue;
                Note note = this.noteService.getNoteByNoteId(Long.valueOf(invoiceAddressDetail.getNoteId()));
                if (ObjectUtils.isNotNull((Object)note)) {
                    Attachment attachment;
                    BodyMailMessage message = new BodyMailMessage();
                    String sender = this.parameterService.getParameterValueAsString("KFS-AR", "ContractsGrantsInvoice", "FROM_EMAIL_ADDRESS");
                    message.setFromAddress(sender);
                    CustomerAddress customerAddress = invoiceAddressDetail.getCustomerAddress();
                    String recipients = invoiceAddressDetail.getCustomerEmailAddress();
                    if (StringUtils.isNotEmpty((CharSequence)recipients)) {
                        message.getToAddresses().add(recipients);
                    } else {
                        LOG.warn("sendInvoicesViaEmail() No recipients indicated.");
                    }
                    String subject = this.getSubject(invoice);
                    message.setSubject(subject);
                    if (StringUtils.isEmpty((CharSequence)subject)) {
                        LOG.warn("sendInvoicesViaEmail() Empty subject being sent.");
                    }
                    String bodyText = this.getMessageBody(invoice, customerAddress);
                    message.setMessage(bodyText);
                    if (StringUtils.isEmpty((CharSequence)bodyText)) {
                        LOG.warn("sendInvoicesViaEmail() Empty bodyText being sent.");
                    }
                    if (ObjectUtils.isNotNull((Object)(attachment = note.getAttachment()))) {
                        try {
                            message.setAttachmentContent(IOUtils.toByteArray((InputStream)attachment.getAttachmentContents()));
                        }
                        catch (IOException ex) {
                            LOG.error("Error setting attachment contents", (Throwable)ex);
                            throw new RuntimeException(ex);
                        }
                        message.setAttachmentFileName(attachment.getAttachmentFileName());
                        message.setAttachmentContentType(attachment.getAttachmentMimeTypeCode());
                    }
                    this.emailService.sendMessage((MailMessage)message, false);
                    invoiceAddressDetail.setInitialTransmissionDate(new Date(new java.util.Date().getTime()));
                    this.documentService.updateDocument((Document)invoice);
                    continue;
                }
                success = false;
            }
        }
        return success;
    }

    protected String getSubject(ContractsGrantsInvoiceDocument invoice) {
        String message;
        String grantNumber = invoice.getInvoiceGeneralDetail().getAward().getProposal().getGrantNumber();
        if (StringUtils.isBlank((CharSequence)grantNumber)) {
            String subject = this.kualiConfigurationService.getPropertyValueAsString("cginvoice.email.subject.nograntnumber");
            message = MessageFormat.format(subject, invoice.getDocumentNumber());
        } else {
            String subject = this.kualiConfigurationService.getPropertyValueAsString("cginvoice.email.subject");
            message = MessageFormat.format(subject, invoice.getInvoiceGeneralDetail().getAward().getProposal().getGrantNumber(), invoice.getDocumentNumber());
        }
        return message;
    }

    protected String getMessageBody(ContractsGrantsInvoiceDocument invoice, CustomerAddress customerAddress) {
        String message = this.kualiConfigurationService.getPropertyValueAsString("cginvoice.email.body");
        String department = "";
        String[] orgCode = invoice.getInvoiceGeneralDetail().getAward().getAwardPrimaryFundManager().getFundManager().getPrimaryDepartmentCode().split("-");
        HashMap<String, String> key = new HashMap<String, String>();
        key.put("chartOfAccountsCode", orgCode[0].trim());
        key.put("organizationCode", orgCode[1].trim());
        Organization org = (Organization)this.businessObjectService.findByPrimaryKey(Organization.class, key);
        if (ObjectUtils.isNotNull((Object)org)) {
            department = org.getOrganizationName();
        }
        Person fundManager = invoice.getInvoiceGeneralDetail().getAward().getAwardPrimaryFundManager().getFundManager();
        return MessageFormat.format(message, customerAddress.getCustomer().getCustomerName(), fundManager.getFirstName() + " " + fundManager.getLastName(), department, fundManager.getPhoneNumber(), fundManager.getEmailAddress());
    }

    @Override
    public void sendEmailNotificationsForMilestones(List<Milestone> milestones, ContractsAndGrantsBillingAward award) {
        LOG.debug("sendEmailNotificationsForMilestones() started");
        BodyMailMessage message = new BodyMailMessage();
        message.setFromAddress(this.emailService.getDefaultFromAddress());
        message.setSubject(this.getEmailSubject("REMINDER_EMAIL_SUBJECT"));
        message.getToAddresses().add(award.getAwardPrimaryFundManager().getFundManager().getEmailAddress());
        StringBuffer body = new StringBuffer();
        String messageKey = this.kualiConfigurationService.getPropertyValueAsString("message.cg.upcoming.milestones.email.line1");
        body.append(messageKey + "\n\n");
        for (Milestone milestone : milestones) {
            String proposalNumber = this.dataDictionaryService.getAttributeLabel(Milestone.class, "proposalNumber");
            String chartOfAccountsCode = this.dataDictionaryService.getAttributeLabel(Milestone.class, "chartOfAccountsCode");
            String accountNumber = this.dataDictionaryService.getAttributeLabel(Milestone.class, "accountNumber");
            String milestoneNumber = this.dataDictionaryService.getAttributeLabel(Milestone.class, "milestoneNumber");
            String milestoneDescription = this.dataDictionaryService.getAttributeLabel(Milestone.class, "milestoneDescription");
            String milestoneAmount = this.dataDictionaryService.getAttributeLabel(Milestone.class, "milestoneAmount");
            String milestoneExpectedCompletionDate = this.dataDictionaryService.getAttributeLabel(Milestone.class, "milestoneExpectedCompletionDate");
            body.append(proposalNumber + ": " + milestone.getProposalNumber() + " \n");
            body.append(chartOfAccountsCode + ": " + milestone.getChartOfAccountsCode() + " \n");
            body.append(accountNumber + ": " + milestone.getAccountNumber() + " \n");
            body.append(milestoneNumber + ": " + milestone.getMilestoneNumber() + " \n");
            body.append(milestoneDescription + ": " + milestone.getMilestoneDescription() + " \n");
            body.append(milestoneAmount + ": " + milestone.getMilestoneAmount() + " \n");
            body.append(milestoneExpectedCompletionDate + ": " + milestone.getMilestoneExpectedCompletionDate() + " \n");
            body.append("\n\n");
        }
        body.append("\n\n");
        messageKey = this.kualiConfigurationService.getPropertyValueAsString("message.cg.upcoming.milestones.email.line2");
        body.append(MessageFormat.format(messageKey, new Object[]{null}) + "\n\n");
        message.setMessage(body.toString());
        this.emailService.sendMessage((MailMessage)message, false);
    }

    protected String getEmailSubject(String subjectParameterName) {
        return this.parameterService.getParameterValueAsString(UpcomingMilestoneNotificationStep.class, subjectParameterName);
    }

    protected Properties getConfigProperties() {
        return ConfigContext.getCurrentContextConfig().getProperties();
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setNoteService(NoteService noteService) {
        this.noteService = noteService;
    }

    public void setKualiConfigurationService(ConfigurationService kualiConfigurationService) {
        this.kualiConfigurationService = kualiConfigurationService;
    }

    public void setContractsGrantsBillingUtilityService(ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService) {
        this.contractsGrantsBillingUtilityService = contractsGrantsBillingUtilityService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setEmailService(EmailService emailService) {
        this.emailService = emailService;
    }
}

