/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.actions;

import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.kns.datadictionary.BusinessObjectAdminService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerOpenItemReportDetail;
import org.kuali.kfs.module.ar.businessobject.admin.CustomerAdminService;
import org.kuali.kfs.sys.businessobject.actions.BusinessObjectActionsProvider;
import org.kuali.rice.kim.api.identity.Person;

public class CustomerActionsProvider
extends BusinessObjectActionsProvider {
    public List<Map<String, Object>> getActionLinks(BusinessObjectBase businessObject, Person user) {
        List actions = super.getActionLinks(businessObject, user);
        BusinessObjectAdminService businessObjectAdminService = this.getBusinessObjectDictionaryService().getBusinessObjectAdminService(businessObject.getClass());
        if (businessObjectAdminService instanceof CustomerAdminService && ((CustomerAdminService)businessObjectAdminService).allowsReport(user)) {
            String reportUrl = this.generateReportUrl((Customer)businessObject);
            actions.add(this.buildAction("Report", "GET", reportUrl));
        }
        return actions;
    }

    private String generateReportUrl(Customer customer) {
        Properties params = new Properties();
        params.put("businessObjectClassName", CustomerOpenItemReportDetail.class.getName());
        params.put("returnLocation", "");
        params.put("lookupableImplServiceName", "arCustomerOpenItemReportLookupable");
        params.put("methodToCall", "search");
        params.put("customerNumber", customer.getCustomerNumber());
        params.put("reportName", "Customer History Report");
        params.put("customerName", customer.getCustomerName());
        params.put("docFormKey", "88888888");
        return UrlFactory.parameterizeUrl((String)"arCustomerOpenItemReportLookup.do", (Properties)params);
    }
}

