/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.actions;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.kuali.kfs.kns.datadictionary.ActionType;
import org.kuali.kfs.kns.datadictionary.BusinessObjectAdminService;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.bo.ModuleConfiguration;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.businessobject.TemplateBase;
import org.kuali.kfs.sys.FinancialSystemModuleConfiguration;
import org.kuali.kfs.sys.businessobject.actions.BusinessObjectActionsProvider;
import org.kuali.rice.kim.api.identity.Person;

public class TemplateActionsProvider
extends BusinessObjectActionsProvider {
    private KualiModuleService kualiModuleService;
    private String baseUrl;
    private String templateCodeKey;

    public List<Map<String, Object>> getActionLinks(BusinessObjectBase businessObject, Person user) {
        List actionLinks = super.getActionLinks(businessObject, user);
        BusinessObjectAdminService businessObjectAdminService = this.getBusinessObjectDictionaryService().getBusinessObjectAdminService(businessObject.getClass());
        BusinessObjectEntry businessObjectEntry = this.getBusinessObjectDictionaryService().getBusinessObjectEntry(businessObject.getClass());
        if (businessObjectEntry.supportsAction(ActionType.EDIT) && businessObjectAdminService.allowsEdit(businessObject, user)) {
            String uploadUrl = this.generateUploadUrl(businessObject);
            actionLinks.add(this.buildAction("Upload", "GET", uploadUrl));
            if (this.templateFileExists(((TemplateBase)businessObject).getFilename())) {
                String downloadUrl = this.generateDownloadUrl(businessObject);
                actionLinks.add(this.buildAction("Download", "GET", downloadUrl));
            }
        }
        return actionLinks;
    }

    private String generateUploadUrl(BusinessObjectBase businessObject) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "start");
        parameters.put(this.templateCodeKey, ((TemplateBase)businessObject).getTemplateCode());
        return UrlFactory.parameterizeUrl((String)this.baseUrl, (Properties)parameters);
    }

    private String generateDownloadUrl(BusinessObjectBase businessObject) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "download");
        parameters.put("fileName", ((TemplateBase)businessObject).getFilename());
        return UrlFactory.parameterizeUrl((String)this.baseUrl, (Properties)parameters);
    }

    private boolean templateFileExists(String fileName) {
        ModuleConfiguration systemConfiguration = this.kualiModuleService.getModuleServiceByNamespaceCode("KFS-AR").getModuleConfiguration();
        String templateFolderPath = (String)((FinancialSystemModuleConfiguration)systemConfiguration).getTemplateFileDirectories().get("templates.directory");
        String filePath = templateFolderPath + File.separator + fileName;
        return new File(filePath).isFile();
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public void setTemplateCodeKey(String templateCodeKey) {
        this.templateCodeKey = templateCodeKey;
    }
}

