/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.businessobject.lookup;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.kns.document.authorization.BusinessObjectRestrictions;
import org.kuali.kfs.kns.web.comparator.CellComparatorHelper;
import org.kuali.kfs.kns.web.struts.form.LookupForm;
import org.kuali.kfs.kns.web.ui.Column;
import org.kuali.kfs.kns.web.ui.ResultRow;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsMilestoneReport;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.businessobject.lookup.ContractsGrantsReportLookupableHelperServiceImplBase;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.krad.bo.BusinessObject;

public class ContractsGrantsMilestoneReportLookupableHelperServiceImpl
extends ContractsGrantsReportLookupableHelperServiceImplBase {
    protected DateTimeService dateTimeService;

    public Collection performLookup(LookupForm lookupForm, Collection resultTable, boolean bounded) {
        Map lookupFormFields = lookupForm.getFieldsForLookup();
        this.setBackLocation((String)lookupForm.getFieldsForLookup().get("backLocation"));
        this.setDocFormKey((String)lookupForm.getFieldsForLookup().get("docFormKey"));
        ArrayList<ContractsGrantsMilestoneReport> displayList = new ArrayList<ContractsGrantsMilestoneReport>();
        Map<String, String> lookupCriteria = this.buildCriteriaForLookup(lookupFormFields);
        Collection milestones = this.getLookupService().findCollectionBySearchHelper(Milestone.class, lookupCriteria, true);
        String awardChartOfAccountsCode = (String)lookupFormFields.get("chartOfAccountsCode");
        String awardAccountNumber = (String)lookupFormFields.get("accountNumber");
        for (Milestone milestone : milestones) {
            if (!this.isMilestoneMatchesChart(milestone, awardChartOfAccountsCode) || !this.isMilestoneMatchesAccount(milestone, awardAccountNumber)) continue;
            ContractsGrantsMilestoneReport cgMilestoneReport = new ContractsGrantsMilestoneReport();
            cgMilestoneReport.setProposalNumber(milestone.getProposalNumber());
            ContractsAndGrantsBillingAward award = milestone.getAward();
            List awardAccounts = ObjectUtils.isNull((Object)award) ? new ArrayList() : award.getActiveAwardAccounts();
            String accountNumber = awardAccounts.size() > 0 ? ((ContractsAndGrantsBillingAwardAccount)awardAccounts.get(0)).getAccountNumber() : "";
            cgMilestoneReport.setAccountNumber(accountNumber);
            cgMilestoneReport.setChartOfAccountsCode(milestone.getChartOfAccountsCode());
            cgMilestoneReport.setMilestoneNumber(milestone.getMilestoneNumber());
            cgMilestoneReport.setMilestoneExpectedCompletionDate(milestone.getMilestoneExpectedCompletionDate());
            cgMilestoneReport.setMilestoneAmount(milestone.getMilestoneAmount());
            cgMilestoneReport.setBilled(milestone.isBilled());
            cgMilestoneReport.setActive(milestone.isActive());
            displayList.add(cgMilestoneReport);
        }
        this.buildResultTable(lookupForm, displayList, resultTable);
        return displayList;
    }

    protected Map<String, String> buildCriteriaForLookup(Map lookupFormFields) {
        String active;
        String billed;
        HashMap<String, String> lookupCriteria = new HashMap<String, String>();
        String proposalNumber = (String)lookupFormFields.get("proposalNumber");
        if (!StringUtils.isBlank((CharSequence)proposalNumber)) {
            lookupCriteria.put("proposalNumber", proposalNumber);
        }
        String lowerBoundMilestoneExpectedCompletionDate = (String)lookupFormFields.get("rangeLowerBoundKeyPrefix_milestoneExpectedCompletionDate");
        String upperBoundMilestoneExpectedCompletionDate = (String)lookupFormFields.get("milestoneExpectedCompletionDate");
        String milestoneExpectedCompletionDate = this.getContractsGrantsReportHelperService().fixDateCriteria(lowerBoundMilestoneExpectedCompletionDate, upperBoundMilestoneExpectedCompletionDate, false);
        if (!StringUtils.isBlank((CharSequence)milestoneExpectedCompletionDate)) {
            lookupCriteria.put("milestoneExpectedCompletionDate", milestoneExpectedCompletionDate);
        }
        if (!StringUtils.isBlank((CharSequence)(billed = (String)lookupFormFields.get("billed")))) {
            lookupCriteria.put("billed", billed);
        }
        if (!StringUtils.isBlank((CharSequence)(active = (String)lookupFormFields.get("active")))) {
            lookupCriteria.put("active", active);
        }
        return lookupCriteria;
    }

    protected boolean isMilestoneMatchesChart(Milestone milestone, String chartOfAccountsCode) {
        if (StringUtils.isBlank((CharSequence)chartOfAccountsCode)) {
            return true;
        }
        if (ObjectUtils.isNull((Object)milestone.getAward()) || ObjectUtils.isNull((Object)milestone.getAward().getActiveAwardAccounts()) || milestone.getAward().getActiveAwardAccounts().isEmpty()) {
            return true;
        }
        Pattern chartRegex = this.convertWildcardsToPattern(chartOfAccountsCode);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : milestone.getAward().getActiveAwardAccounts()) {
            Matcher chartMatch = chartRegex.matcher(awardAccount.getChartOfAccountsCode());
            if (!chartMatch.matches()) continue;
            return true;
        }
        return false;
    }

    protected boolean isMilestoneMatchesAccount(Milestone milestone, String accountNumber) {
        if (StringUtils.isBlank((CharSequence)accountNumber)) {
            return true;
        }
        if (ObjectUtils.isNull((Object)milestone.getAward()) || ObjectUtils.isNull((Object)milestone.getAward().getActiveAwardAccounts()) || milestone.getAward().getActiveAwardAccounts().isEmpty()) {
            return true;
        }
        Pattern accountRegex = this.convertWildcardsToPattern(accountNumber);
        for (ContractsAndGrantsBillingAwardAccount awardAccount : milestone.getAward().getActiveAwardAccounts()) {
            Matcher accountMatch = accountRegex.matcher(awardAccount.getAccountNumber());
            if (!accountMatch.matches()) continue;
            return true;
        }
        return false;
    }

    protected Pattern convertWildcardsToPattern(String lookupFieldValue) {
        String lookupFieldValueRegex = lookupFieldValue.replaceAll("\\*", ".+");
        return Pattern.compile(lookupFieldValueRegex);
    }

    @Override
    protected void buildResultTable(LookupForm lookupForm, Collection displayList, Collection resultTable) {
        Person user = GlobalVariables.getUserSession().getPerson();
        boolean hasReturnableRow = false;
        for (Object entry : displayList) {
            BusinessObject element = (BusinessObject)entry;
            BusinessObjectRestrictions businessObjectRestrictions = this.getBusinessObjectAuthorizationService().getLookupResultRestrictions((Object)element, user);
            List columns = this.getColumns();
            for (Column col : columns) {
                String propValue = ObjectUtils.getFormattedPropertyValue((BusinessObject)element, (String)col.getPropertyName(), (Formatter)col.getFormatter());
                Class propClass = this.getPropertyClass(element, col.getPropertyName());
                col.setComparator(CellComparatorHelper.getAppropriateComparatorForPropertyClass((Class)propClass));
                col.setValueComparator(CellComparatorHelper.getAppropriateValueComparatorForPropertyClass((Class)propClass));
                propValue = this.maskValueIfNecessary(element, col.getPropertyName(), propValue, businessObjectRestrictions);
                col.setPropertyValue(propValue);
            }
            ResultRow row = new ResultRow(columns, "", "&nbsp;");
            if (this.getBusinessObjectDictionaryService().isExportable(this.getBusinessObjectClass()).booleanValue()) {
                row.setBusinessObject(element);
            }
            boolean isRowReturnable = this.isResultReturnable(element);
            row.setRowReturnable(isRowReturnable);
            if (isRowReturnable) {
                hasReturnableRow = true;
            }
            resultTable.add(row);
        }
        lookupForm.setHasReturnableRow(hasReturnableRow);
    }

    public void validateSearchParameters(Map<String, String> fieldValues) {
        super.validateSearchParameters(fieldValues);
        String lowerBoundMilestoneExpectedCompletionDate = fieldValues.get("rangeLowerBoundKeyPrefix_milestoneExpectedCompletionDate");
        this.validateDateField(lowerBoundMilestoneExpectedCompletionDate, "rangeLowerBoundKeyPrefix_milestoneExpectedCompletionDate", this.getDateTimeService());
        String upperBoundMilestoneExpectedCompletionDate = fieldValues.get("milestoneExpectedCompletionDate");
        this.validateDateField(upperBoundMilestoneExpectedCompletionDate, "milestoneExpectedCompletionDate", this.getDateTimeService());
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }
}

