/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.dataaccess.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.ojb.broker.query.Criteria;
import org.apache.ojb.broker.query.Query;
import org.apache.ojb.broker.query.QueryByCriteria;
import org.apache.ojb.broker.query.QueryFactory;
import org.apache.ojb.broker.query.ReportQueryByCriteria;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.dataaccess.CustomerInvoiceDocumentDao;
import org.kuali.rice.core.framework.persistence.ojb.dao.PlatformAwareDaoBaseOjb;

public class CustomerInvoiceDocumentDaoOjb
extends PlatformAwareDaoBaseOjb
implements CustomerInvoiceDocumentDao {
    private static final Logger LOG = LogManager.getLogger(CustomerInvoiceDocumentDaoOjb.class);

    @Override
    public List<String> getPrintableCustomerInvoiceDocumentNumbersFromUserQueue() {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("printInvoiceIndicator", (Object)"U");
        criteria.addIsNull("printDate");
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)"A");
        ReportQueryByCriteria rqbc = QueryFactory.newReportQuery(CustomerInvoiceDocument.class, (String[])new String[]{"documentNumber"}, (Criteria)criteria, (boolean)false);
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)rqbc);
        ArrayList<String> invoiceNumbers = new ArrayList<String>();
        while (iter.hasNext()) {
            invoiceNumbers.add((String)((Object[])iter.next())[0]);
        }
        return invoiceNumbers;
    }

    @Override
    public List<String> getPrintableCustomerInvoiceDocumentNumbersByProcessingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        if (StringUtils.isBlank((CharSequence)chartOfAccountsCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank chartOfAccountsCode parameter.");
        }
        if (StringUtils.isBlank((CharSequence)organizationCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank organizationCode parameter.");
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("accountsReceivableDocumentHeader.processingChartOfAccountCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("accountsReceivableDocumentHeader.processingOrganizationCode", (Object)organizationCode);
        criteria.addEqualTo("printInvoiceIndicator", (Object)"Q");
        criteria.addIsNull("printDate");
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)"A");
        ReportQueryByCriteria rqbc = QueryFactory.newReportQuery(CustomerInvoiceDocument.class, (String[])new String[]{"documentNumber"}, (Criteria)criteria, (boolean)false);
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)rqbc);
        ArrayList<String> invoiceNumbers = new ArrayList<String>();
        while (iter.hasNext()) {
            invoiceNumbers.add((String)((Object[])iter.next())[0]);
        }
        return new ArrayList<String>(invoiceNumbers);
    }

    @Override
    public List<String> getPrintableCustomerInvoiceDocumentNumbersByBillingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        if (StringUtils.isBlank((CharSequence)chartOfAccountsCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank chartOfAccountsCode parameter.");
        }
        if (StringUtils.isBlank((CharSequence)organizationCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank organizationCode parameter.");
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("billByChartOfAccountCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("billedByOrganizationCode", (Object)organizationCode);
        criteria.addEqualTo("printInvoiceIndicator", (Object)"B");
        criteria.addIsNull("printDate");
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)"A");
        ReportQueryByCriteria rqbc = QueryFactory.newReportQuery(CustomerInvoiceDocument.class, (String[])new String[]{"documentNumber"}, (Criteria)criteria, (boolean)false);
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)rqbc);
        ArrayList<String> invoiceNumbers = new ArrayList<String>();
        while (iter.hasNext()) {
            invoiceNumbers.add((String)((Object[])iter.next())[0]);
        }
        return new ArrayList<String>(invoiceNumbers);
    }

    @Override
    public List<String> getPrintableCustomerInvoiceDocumentNumbersForBillingStatementByBillingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        if (StringUtils.isBlank((CharSequence)chartOfAccountsCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank chartOfAccountsCode parameter.");
        }
        if (StringUtils.isBlank((CharSequence)organizationCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank organizationCode parameter.");
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("billByChartOfAccountCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("billedByOrganizationCode", (Object)organizationCode);
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)"A");
        ReportQueryByCriteria rqbc = QueryFactory.newReportQuery(CustomerInvoiceDocument.class, (String[])new String[]{"documentNumber"}, (Criteria)criteria, (boolean)false);
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)rqbc);
        ArrayList<String> invoiceNumbers = new ArrayList<String>();
        while (iter.hasNext()) {
            invoiceNumbers.add((String)((Object[])iter.next())[0]);
        }
        return new ArrayList<String>(invoiceNumbers);
    }

    @Override
    public List<String> getCustomerInvoiceDocumentNumbersByProcessingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        if (StringUtils.isBlank((CharSequence)chartOfAccountsCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank chartOfAccountsCode parameter.");
        }
        if (StringUtils.isBlank((CharSequence)organizationCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank organizationCode parameter.");
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("accountsReceivableDocumentHeader.processingChartOfAccountCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("accountsReceivableDocumentHeader.processingOrganizationCode", (Object)organizationCode);
        ReportQueryByCriteria rqbc = QueryFactory.newReportQuery(CustomerInvoiceDocument.class, (String[])new String[]{"documentNumber"}, (Criteria)criteria, (boolean)false);
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)rqbc);
        ArrayList<String> invoiceNumbers = new ArrayList<String>();
        while (iter.hasNext()) {
            invoiceNumbers.add((String)((Object[])iter.next())[0]);
        }
        return new ArrayList<String>(invoiceNumbers);
    }

    @Override
    public List<String> getCustomerInvoiceDocumentNumbersByBillingChartAndOrg(String chartOfAccountsCode, String organizationCode) {
        if (StringUtils.isBlank((CharSequence)chartOfAccountsCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank chartOfAccountsCode parameter.");
        }
        if (StringUtils.isBlank((CharSequence)organizationCode)) {
            throw new IllegalArgumentException("The method was called with a Null or Blank organizationCode parameter.");
        }
        Criteria criteria = new Criteria();
        criteria.addEqualTo("billByChartOfAccountCode", (Object)chartOfAccountsCode);
        criteria.addEqualTo("billedByOrganizationCode", (Object)organizationCode);
        ReportQueryByCriteria rqbc = QueryFactory.newReportQuery(CustomerInvoiceDocument.class, (String[])new String[]{"documentNumber"}, (Criteria)criteria, (boolean)false);
        Iterator iter = this.getPersistenceBrokerTemplate().getReportQueryIteratorByQuery((Query)rqbc);
        ArrayList<String> invoiceNumbers = new ArrayList<String>();
        while (iter.hasNext()) {
            invoiceNumbers.add((String)((Object[])iter.next())[0]);
        }
        return new ArrayList<String>(invoiceNumbers);
    }

    @Override
    public Collection getAllOpen() {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("openInvoiceIndicator", (Object)true);
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)"A");
        QueryByCriteria qbc = QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria);
        Collection customerInvoiceDocuments = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
        return new ArrayList(customerInvoiceDocuments);
    }

    @Override
    public Collection getOpenByCustomerNumber(String customerNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("accountsReceivableDocumentHeader.customerNumber", (Object)(customerNumber == null ? customerNumber : customerNumber.toUpperCase()));
        criteria.addEqualTo("openInvoiceIndicator", (Object)"true");
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)"A");
        QueryByCriteria qbc = QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria);
        Collection customerInvoiceDocuments = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
        return new ArrayList(customerInvoiceDocuments);
    }

    @Override
    public Collection getOpenByCustomerNameByCustomerType(String customerName, String customerTypeCode) {
        Criteria criteria = new Criteria();
        criteria.addLike((Object)"accountsReceivableDocumentHeader.customer.customerName", (Object)customerName);
        criteria.addEqualTo("accountsReceivableDocumentHeader.customer.customerTypeCode", (Object)customerTypeCode);
        criteria.addEqualTo("openInvoiceIndicator", (Object)"true");
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)"A");
        QueryByCriteria qbc = QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria);
        Collection customerInvoiceDocuments = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
        return new ArrayList(customerInvoiceDocuments);
    }

    @Override
    public Collection getOpenByCustomerName(String customerName) {
        Criteria criteria = new Criteria();
        criteria.addLike((Object)"accountsReceivableDocumentHeader.customer.customerName", (Object)customerName);
        criteria.addEqualTo("openInvoiceIndicator", (Object)"true");
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)"A");
        QueryByCriteria qbc = QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria);
        Collection customerInvoiceDocuments = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
        return new ArrayList(customerInvoiceDocuments);
    }

    @Override
    public Collection getOpenByCustomerType(String customerTypeCode) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("accountsReceivableDocumentHeader.customer.customerTypeCode", (Object)customerTypeCode);
        criteria.addEqualTo("openInvoiceIndicator", (Object)"true");
        criteria.addEqualTo("documentHeader.financialDocumentStatusCode", (Object)"A");
        QueryByCriteria qbc = QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria);
        Collection customerInvoiceDocuments = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)qbc);
        return new ArrayList(customerInvoiceDocuments);
    }

    @Override
    public CustomerInvoiceDocument getInvoiceByOrganizationInvoiceNumber(String organizationInvoiceNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("organizationInvoiceNumber", (Object)organizationInvoiceNumber);
        return (CustomerInvoiceDocument)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria));
    }

    @Override
    public CustomerInvoiceDocument getInvoiceByInvoiceDocumentNumber(String documentNumber) {
        Criteria criteria = new Criteria();
        criteria.addEqualTo("documentNumber", (Object)documentNumber);
        return (CustomerInvoiceDocument)this.getPersistenceBrokerTemplate().getObjectByQuery((Query)QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria));
    }

    @Override
    public Collection<CustomerInvoiceDocument> getAllAgingInvoiceDocumentsByBilling(List<String> charts, List<String> organizations, Date invoiceBillingDateFrom, Date invoiceBillingDateTo) {
        Criteria criteria = this.getAllAgingInvoiceDocumentsCriteria("", invoiceBillingDateFrom, invoiceBillingDateTo);
        if (ObjectUtils.isNotNull(charts)) {
            criteria.addIn("billByChartOfAccountCode", charts);
        }
        if (ObjectUtils.isNotNull(organizations)) {
            criteria.addIn("billedByOrganizationCode", organizations);
        }
        criteria.addIsNull("agingReportSentTime");
        QueryByCriteria query = QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public Collection<CustomerInvoiceDocument> getAllAgingInvoiceDocumentsByProcessing(List<String> charts, List<String> organizations, Date invoiceBillingDateFrom, Date invoiceBillingDateTo) {
        Criteria criteria = this.getAllAgingInvoiceDocumentsCriteria("", invoiceBillingDateFrom, invoiceBillingDateTo);
        if (ObjectUtils.isNotNull(charts) && !charts.isEmpty()) {
            criteria.addIn("accountsReceivableDocumentHeader.processingChartOfAccountCode", charts);
        }
        if (ObjectUtils.isNotNull(organizations) && !organizations.isEmpty()) {
            criteria.addIn("accountsReceivableDocumentHeader.processingOrganizationCode", organizations);
        }
        criteria.addIsNull("agingReportSentTime");
        QueryByCriteria query = QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }

    @Override
    public Collection<CustomerInvoiceDocument> getAllAgingInvoiceDocumentsByAccounts(List<String> charts, List<String> accounts, Date invoiceBillingDateFrom, Date invoiceBillingDateTo) {
        ArrayList<CustomerInvoiceDocument> customerInvoiceDocuments = new ArrayList<CustomerInvoiceDocument>();
        Criteria criteria = this.getAllAgingInvoiceDocumentsCriteria("customerInvoiceDocument.", invoiceBillingDateFrom, invoiceBillingDateTo);
        if (ObjectUtils.isNotNull(charts)) {
            criteria.addIn("chartOfAccountsCode", charts);
        }
        if (ObjectUtils.isNotNull(accounts)) {
            criteria.addIn("accountNumber", accounts);
        }
        criteria.addIsNull("agingReportSentTime");
        QueryByCriteria query = QueryFactory.newQuery(CustomerInvoiceDetail.class, (Criteria)criteria);
        Collection customerInvoiceDetails = this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
        HashSet<String> invoiceDocumentNumbers = new HashSet<String>();
        for (CustomerInvoiceDetail detail : customerInvoiceDetails) {
            CustomerInvoiceDocument customerInvoiceDocument = detail.getCustomerInvoiceDocument();
            String documentNumber = customerInvoiceDocument.getDocumentNumber();
            if (invoiceDocumentNumbers.contains(documentNumber)) continue;
            customerInvoiceDocuments.add(customerInvoiceDocument);
            invoiceDocumentNumbers.add(documentNumber);
        }
        return customerInvoiceDocuments;
    }

    protected Criteria getAllAgingInvoiceDocumentsCriteria(String prefix, Date invoiceDueDateFrom, Date invoiceDueDateTo) {
        Criteria criteria = new Criteria();
        if (ObjectUtils.isNotNull((Object)invoiceDueDateFrom)) {
            criteria.addGreaterOrEqualThan((Object)"invoiceDueDate", (Object)invoiceDueDateFrom);
        }
        if (ObjectUtils.isNotNull((Object)invoiceDueDateTo)) {
            criteria.addLessThan((Object)"invoiceDueDate", (Object)invoiceDueDateTo);
        }
        criteria.addEqualTo(prefix + "openInvoiceIndicator", (Object)true);
        criteria.addEqualTo(prefix + "documentHeader.financialDocumentStatusCode", (Object)"A");
        return criteria;
    }

    @Override
    public Collection<CustomerInvoiceDocument> getAllAgingInvoiceDocumentsByCustomerTypes(List<String> customerTypes, Date invoiceDueDateFrom, Date invoiceDueDateTo) {
        LOG.info("invoiceDueDateFrom :::::" + invoiceDueDateFrom);
        LOG.info("invoiceDueDateTo ::::::::" + invoiceDueDateTo);
        Criteria criteria = this.getAllAgingInvoiceDocumentsCriteria("", invoiceDueDateFrom, invoiceDueDateTo);
        if (ObjectUtils.isNotNull(customerTypes)) {
            criteria.addIn("accountsReceivableDocumentHeader.customer.customerTypeCode", customerTypes);
        }
        QueryByCriteria query = QueryFactory.newQuery(CustomerInvoiceDocument.class, (Criteria)criteria);
        return this.getPersistenceBrokerTemplate().getCollectionByQuery((Query)query);
    }
}

