/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.event;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.document.TransactionalDocument;
import org.kuali.kfs.krad.rules.rule.BusinessRule;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEventBase;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.validation.AddCashControlDetailRule;

public final class AddCashControlDetailEvent
extends KualiDocumentEventBase {
    private static final Logger LOG = LogManager.getLogger();
    private final CashControlDetail cashControlDetail;

    public AddCashControlDetailEvent(String errorPathPrefix, Document document, CashControlDetail cashControlDetail) {
        super("Adding cash control detail to document " + AddCashControlDetailEvent.getDocumentId((Document)document), errorPathPrefix, document);
        this.cashControlDetail = (CashControlDetail)((Object)ObjectUtils.deepCopy((Serializable)((Object)cashControlDetail)));
        this.logEvent();
    }

    public Class getRuleInterfaceClass() {
        return AddCashControlDetailRule.class;
    }

    public boolean invokeRuleMethod(BusinessRule rule) {
        return ((AddCashControlDetailRule)rule).processAddCashControlDetailBusinessRules((TransactionalDocument)this.getDocument(), this.getCashControlDetail());
    }

    public CashControlDetail getCashControlDetail() {
        return this.cashControlDetail;
    }

    public void validate() {
        super.validate();
        if (this.getCashControlDetail() == null) {
            throw new IllegalArgumentException("invalid (null) cash control detail");
        }
    }

    private void logEvent() {
        if (LOG.isDebugEnabled()) {
            StringBuffer logMessage = new StringBuffer(StringUtils.substringAfterLast((String)((Object)((Object)this)).getClass().getName(), (String)"."));
            logMessage.append(" with ");
            if (this.cashControlDetail == null) {
                logMessage.append("null cashControlDetail");
            } else {
                logMessage.append(" cashControlDetail# ");
                logMessage.append(this.cashControlDetail.getDocumentNumber());
            }
            LOG.debug((CharSequence)logMessage);
        }
    }
}

