/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.InvoiceRecurrence;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.InvoiceRecurrenceDocumentService;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class InvoiceRecurrenceRule
extends MaintenanceDocumentRuleBase {
    protected static Logger LOG = LogManager.getLogger(InvoiceRecurrenceRule.class);
    protected InvoiceRecurrence oldInvoiceRecurrence;
    protected InvoiceRecurrence newInvoiceRecurrence;
    protected DateTimeService dateTimeService;

    public void setupConvenienceObjects() {
        this.oldInvoiceRecurrence = (InvoiceRecurrence)((Object)super.getOldBo());
        this.newInvoiceRecurrence = (InvoiceRecurrence)((Object)super.getNewBo());
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = this.checkIfInvoiceIsApproved(this.newInvoiceRecurrence.getInvoiceNumber());
        success &= this.validateDocumentRecurrenceEndDate(this.newInvoiceRecurrence.getDocumentRecurrenceBeginDate(), this.newInvoiceRecurrence.getDocumentRecurrenceEndDate());
        success &= this.validateIfBothEndDateAndTotalRecurrenceNumberAreEntered(this.newInvoiceRecurrence.getDocumentRecurrenceBeginDate(), this.newInvoiceRecurrence.getDocumentRecurrenceEndDate(), this.newInvoiceRecurrence.getDocumentTotalRecurrenceNumber(), this.newInvoiceRecurrence.getDocumentRecurrenceIntervalCode());
        success &= this.validateEndDateOrTotalNumberofRecurrences(this.newInvoiceRecurrence.getDocumentRecurrenceEndDate(), this.newInvoiceRecurrence.getDocumentTotalRecurrenceNumber());
        return success &= this.validateMaximumNumberOfRecurrences(this.newInvoiceRecurrence.getDocumentTotalRecurrenceNumber(), this.newInvoiceRecurrence.getDocumentRecurrenceIntervalCode());
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        this.processCustomRouteDocumentBusinessRules(document);
        return true;
    }

    protected boolean checkIfRecurrenceMaintenanceAlreadyExists(InvoiceRecurrence newInvoiceRecurrence) {
        boolean success = true;
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("invoiceNumber", newInvoiceRecurrence.getInvoiceNumber());
        InvoiceRecurrence invoiceRecurrence = (InvoiceRecurrence)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(InvoiceRecurrence.class, criteria);
        if (ObjectUtils.isNotNull((Object)((Object)invoiceRecurrence)) && !((Object)((Object)this.oldInvoiceRecurrence)).equals((Object)invoiceRecurrence)) {
            this.putFieldError("invoiceNumber", "error.document.invoiceRecurrenceMaintenance.maintenanceDocumentsExists");
            success = false;
        }
        return success;
    }

    protected boolean checkIfInvoiceIsApproved(String recurrenceInvoiceNumber) {
        boolean success = true;
        if (ObjectUtils.isNull((Object)recurrenceInvoiceNumber)) {
            return true;
        }
        CustomerInvoiceDocument customerInvoiceDocument = null;
        if (!((DocumentService)SpringContext.getBean(DocumentService.class)).documentExists(recurrenceInvoiceNumber)) {
            this.putFieldError("invoiceNumber", "error.document.invoiceRecurrenceMaintenance.invoiceDoesNotExist");
            success = false;
        } else {
            WorkflowDocument workflowDocument;
            try {
                customerInvoiceDocument = (CustomerInvoiceDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(recurrenceInvoiceNumber);
            }
            catch (WorkflowException workflowException) {
                // empty catch block
            }
            if (ObjectUtils.isNotNull(customerInvoiceDocument) && !(workflowDocument = customerInvoiceDocument.getDocumentHeader().getWorkflowDocument()).isApproved()) {
                this.putFieldError("invoiceNumber", "error.document.invoiceRecurrenceMaintenance.invoiceMustBeApproved");
                success = false;
            }
        }
        return success;
    }

    protected boolean validateDocumentRecurrenceBeginDate(InvoiceRecurrence newInvoiceRecurrence) {
        if (ObjectUtils.isNull((Object)newInvoiceRecurrence.getDocumentRecurrenceBeginDate())) {
            return true;
        }
        Timestamp currentDate = new Timestamp(this.getDateTimeService().getCurrentDate().getTime());
        Timestamp beginDateTimestamp = new Timestamp(newInvoiceRecurrence.getDocumentRecurrenceBeginDate().getTime());
        if (beginDateTimestamp.before(currentDate) || beginDateTimestamp.equals(currentDate)) {
            this.putFieldError("documentRecurrenceBeginDate", "error.document.invoiceRecurrenceMaintenance.beginDateMustBeEarlierThanToday");
            return false;
        }
        return true;
    }

    public boolean validateDocumentRecurrenceEndDate(Date newInvoiceRecurrenceBeginDate, Date newInvoiceRecurrenceEndDate) {
        if (!((InvoiceRecurrenceDocumentService)SpringContext.getBean(InvoiceRecurrenceDocumentService.class)).isValidRecurrenceEndDate(newInvoiceRecurrenceBeginDate, newInvoiceRecurrenceEndDate)) {
            this.putFieldError("documentRecurrenceEndDate", "error.document.invoiceRecurrenceMaintenance.endDateEarlierThanBeginDate");
            return false;
        }
        return true;
    }

    protected boolean validateIfBothEndDateAndTotalRecurrenceNumberAreEntered(Date recurrenceBeginDate, Date recurrenceEndDate, Integer totalRecurrenceNumber, String recurrenceIntervalCode) {
        if (ObjectUtils.isNull((Object)recurrenceBeginDate) || ObjectUtils.isNull((Object)recurrenceIntervalCode) || ObjectUtils.isNull((Object)recurrenceEndDate) || ObjectUtils.isNull((Object)totalRecurrenceNumber)) {
            return true;
        }
        Calendar beginCalendar = Calendar.getInstance();
        beginCalendar.setTime(recurrenceBeginDate);
        Date beginDate = recurrenceBeginDate;
        Calendar endCalendar = Calendar.getInstance();
        endCalendar.setTime(recurrenceEndDate);
        Date endDate = recurrenceEndDate;
        Calendar nextCalendar = Calendar.getInstance();
        Date nextDate = beginDate;
        int totalRecurrences = 0;
        int addCounter = 0;
        if ("M".equals(recurrenceIntervalCode)) {
            addCounter = 1;
        }
        if ("Q".equals(recurrenceIntervalCode)) {
            addCounter = 3;
        }
        while (!beginDate.after(endDate)) {
            beginCalendar.setTime(beginDate);
            beginCalendar.add(2, addCounter);
            beginDate = KfsDateUtils.convertToSqlDate((java.util.Date)beginCalendar.getTime());
            ++totalRecurrences;
            nextDate = beginDate;
            nextCalendar.setTime(nextDate);
            nextCalendar.add(2, addCounter);
            nextDate = KfsDateUtils.convertToSqlDate((java.util.Date)nextCalendar.getTime());
            if (!endDate.after(beginDate) || !endDate.before(nextDate)) continue;
            ++totalRecurrences;
            break;
        }
        if (totalRecurrences != totalRecurrenceNumber) {
            this.putFieldError("documentRecurrenceEndDate", "error.document.invoiceRecurrenceMaintenance.endDateAndTotalNumberOfRecurrencesNotValid");
            return false;
        }
        return true;
    }

    protected boolean validateEndDateOrTotalNumberofRecurrences(Date recurrenceEndDate, Integer totalRecurrenceNumber) {
        if (ObjectUtils.isNull((Object)recurrenceEndDate) && ObjectUtils.isNull((Object)totalRecurrenceNumber)) {
            this.putFieldError("documentRecurrenceEndDate", "error.document.invoiceRecurrenceMaintenance.enterEndDateOrTotalNumberOfRecurrences");
            return false;
        }
        return true;
    }

    protected boolean validateMaximumNumberOfRecurrences(Integer totalRecurrenceNumber, String recurrenceIntervalCode) {
        ArrayList maximumRecurrences;
        if (ObjectUtils.isNull((Object)recurrenceIntervalCode) || ObjectUtils.isNull((Object)totalRecurrenceNumber)) {
            return true;
        }
        if (ObjectUtils.isNotNull((Object)recurrenceIntervalCode) && (maximumRecurrences = new ArrayList(((ParameterService)SpringContext.getBean(ParameterService.class)).getSubParameterValuesAsString(InvoiceRecurrence.class, "MAXIMUM_RECURRENCES_BY_INTERVAL", recurrenceIntervalCode))).size() > 0 && StringUtils.isNotBlank((CharSequence)((CharSequence)maximumRecurrences.get(0)))) {
            Integer maximumRecurrencesByInterval = Integer.valueOf((String)maximumRecurrences.get(0));
            if (totalRecurrenceNumber > maximumRecurrencesByInterval) {
                this.putFieldError("documentTotalRecurrenceNumber", "error.document.invoiceRecurrenceMaintenance.totalRecurrencesMoreThanAllowed", (String)maximumRecurrences.get(0));
                return false;
            }
        }
        return true;
    }
}

