/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.validation.impl;

import java.util.HashMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.kns.document.MaintenanceDocument;
import org.kuali.kfs.kns.maintenance.rules.MaintenanceDocumentRuleBase;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.MessageMap;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.kfs.sys.service.impl.KfsParameterConstants;
import org.springframework.util.AutoPopulatingList;

public class OrganizationOptionsRule
extends MaintenanceDocumentRuleBase {
    protected static Logger LOG = LogManager.getLogger(OrganizationOptionsRule.class);
    protected OrganizationOptions newOrganizationOptions;
    protected OrganizationOptions oldOrganizationOptions;

    public void setupConvenienceObjects() {
        this.newOrganizationOptions = (OrganizationOptions)((Object)super.getNewBo());
        this.oldOrganizationOptions = (OrganizationOptions)((Object)super.getOldBo());
    }

    protected boolean processCustomRouteDocumentBusinessRules(MaintenanceDocument document) {
        boolean success = this.doesSystemInformationExistForProcessingChartAngOrg(this.newOrganizationOptions);
        return success &= this.isOrganizationOptionsPostalZipCodeNotEmpty(this.newOrganizationOptions);
    }

    protected boolean processCustomSaveDocumentBusinessRules(MaintenanceDocument document) {
        this.processCustomRouteDocumentBusinessRules(document);
        return true;
    }

    protected void removeRestrictedFieldChangedErrors(MessageMap map, String propertyKey) {
        AutoPopulatingList errorMessages = map.getErrorMessagesForProperty(propertyKey);
        if (errorMessages != null) {
            for (int i = 0; i < errorMessages.size(); ++i) {
                ErrorMessage eMessage = (ErrorMessage)errorMessages.get(i);
                String errorKey = eMessage.getErrorKey();
                if (!errorKey.equals("error.document.maintenance.authorization.restrictedFieldChanged")) continue;
                errorMessages.remove(i);
            }
        }
    }

    public boolean doesSystemInformationExistForProcessingChartAngOrg(OrganizationOptions organizationOptions) {
        boolean success = true;
        String processingChartOfAccountCode = organizationOptions.getProcessingChartOfAccountCode();
        String processingOrganizationCode = organizationOptions.getProcessingOrganizationCode();
        HashMap<String, Object> criteria = new HashMap<String, Object>();
        criteria.put("universityFiscalYear", ((UniversityDateService)SpringContext.getBean(UniversityDateService.class)).getCurrentFiscalYear());
        criteria.put("processingChartOfAccountCode", processingChartOfAccountCode);
        criteria.put("processingOrganizationCode", processingOrganizationCode);
        SystemInformation systemInformation = (SystemInformation)((BusinessObjectService)SpringContext.getBean(BusinessObjectService.class)).findByPrimaryKey(SystemInformation.class, criteria);
        if (ObjectUtils.isNull((Object)((Object)systemInformation))) {
            this.putFieldError("processingChartOfAccountCode", "error.document.organizationOptions.sysInfoDoesNotExistForProcessingChartAndOrg", new String[]{processingChartOfAccountCode, processingOrganizationCode});
            success = false;
        }
        return success;
    }

    public boolean isOrganizationOptionsPostalZipCodeNotEmpty(OrganizationOptions organizationOptions) {
        boolean success = true;
        if (((ParameterService)SpringContext.getBean(ParameterService.class)).getParameterValueAsBoolean(KfsParameterConstants.ACCOUNTS_RECEIVABLE_DOCUMENT.class, "ENABLE_SALES_TAX_IND").booleanValue() && StringUtils.isBlank((CharSequence)organizationOptions.getOrganizationPostalZipCode())) {
            this.putFieldError("organizationPostalZipCode", "error.document.organizationOptions.orgOptionsZipCodeRequired");
            success = false;
        }
        return success;
    }
}

