/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.kuali.kfs.kns.web.struts.form.KualiDocumentFormBase;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.exception.UnknownDocumentIdException;
import org.kuali.kfs.krad.rules.rule.event.KualiDocumentEvent;
import org.kuali.kfs.krad.rules.rule.event.SaveDocumentEvent;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiRuleService;
import org.kuali.kfs.krad.service.SessionDocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CashControlDocumentService;
import org.kuali.kfs.module.ar.document.validation.event.AddCashControlDetailEvent;
import org.kuali.kfs.module.ar.document.web.struts.CashControlForm;
import org.kuali.kfs.sys.businessobject.Bank;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.document.GeneralLedgerPendingEntrySource;
import org.kuali.kfs.sys.document.web.struts.FinancialSystemTransactionalDocumentActionBase;
import org.kuali.kfs.sys.service.BankService;
import org.kuali.kfs.sys.service.GeneralLedgerPendingEntryService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.kew.api.exception.WorkflowException;

public class CashControlAction
extends FinancialSystemTransactionalDocumentActionBase {
    protected void loadDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.loadDocument(kualiDocumentFormBase);
        CashControlForm ccForm = (CashControlForm)kualiDocumentFormBase;
        CashControlDocument cashControlDocument = ccForm.getCashControlDocument();
        if (cashControlDocument != null && cashControlDocument.getCustomerPaymentMediumCode() != null) {
            ccForm.setCashPaymentMediumSelected("CA".equalsIgnoreCase(cashControlDocument.getCustomerPaymentMediumCode()));
        }
        if (cashControlDocument != null) {
            for (CashControlDetail cashControlDetail : cashControlDocument.getCashControlDetails()) {
                String docId = cashControlDetail.getReferenceFinancialDocumentNumber();
                PaymentApplicationDocument doc = (PaymentApplicationDocument)((DocumentService)SpringContext.getBean(DocumentService.class)).getByDocumentHeaderId(docId);
                if (doc == null) {
                    throw new UnknownDocumentIdException("Document " + docId + " no longer exists.  It may have been cancelled before being saved.");
                }
                cashControlDetail.setReferenceFinancialDocument(doc);
                WorkflowDocument workflowDoc = doc.getDocumentHeader().getWorkflowDocument();
                ((SessionDocumentService)SpringContext.getBean(SessionDocumentService.class)).addDocumentToUserSession(GlobalVariables.getUserSession(), workflowDoc);
            }
            cashControlDocument.recalculateTotals();
        }
    }

    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CashControlForm ccForm = (CashControlForm)form;
        CashControlDocument ccDoc = ccForm.getCashControlDocument();
        if (ccDoc != null) {
            ccForm.setCashPaymentMediumSelected("CA".equalsIgnoreCase(ccDoc.getCustomerPaymentMediumCode()));
        }
        if (ccForm.hasDocumentId()) {
            ccDoc = ccForm.getCashControlDocument();
            ccDoc.refreshReferenceObject("customerPaymentMedium");
            ccDoc.recalculateTotals();
        }
        return super.execute(mapping, form, request, response);
    }

    protected void createDocument(KualiDocumentFormBase kualiDocumentFormBase) throws WorkflowException {
        super.createDocument(kualiDocumentFormBase);
        CashControlForm form = (CashControlForm)kualiDocumentFormBase;
        CashControlDocument document = form.getCashControlDocument();
        document.setBankCode("");
        Bank defaultBank = ((BankService)SpringContext.getBean(BankService.class)).getDefaultBankByDocType(form.getDocTypeName());
        if (defaultBank != null) {
            document.setBankCode(defaultBank.getBankCode());
        }
        AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService = (AccountsReceivableDocumentHeaderService)SpringContext.getBean(AccountsReceivableDocumentHeaderService.class);
        AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = accountsReceivableDocumentHeaderService.getNewAccountsReceivableDocumentHeaderForCurrentUser();
        accountsReceivableDocumentHeader.setDocumentNumber(document.getDocumentNumber());
        document.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
    }

    public ActionForward cancel(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CashControlForm cashControlDocForm = (CashControlForm)form;
        CashControlDocument cashControlDocument = cashControlDocForm.getCashControlDocument();
        if (this.cancelLinkedPaymentApplicationDocuments(cashControlDocument)) {
            cashControlDocument.recalculateTotals();
            this.getBusinessObjectService().save((PersistableBusinessObject)cashControlDocument);
            return super.cancel(mapping, form, request, response);
        }
        return mapping.findForward("basic");
    }

    public ActionForward disapprove(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CashControlForm cashControlDocForm = (CashControlForm)form;
        CashControlDocument cashControlDocument = cashControlDocForm.getCashControlDocument();
        boolean success = this.cancelLinkedPaymentApplicationDocuments(cashControlDocument);
        if (!success) {
            return mapping.findForward("basic");
        }
        return super.disapprove(mapping, form, request, response);
    }

    protected boolean cancelLinkedPaymentApplicationDocuments(CashControlDocument cashControlDocument) throws WorkflowException {
        boolean success = true;
        List<CashControlDetail> details = cashControlDocument.getCashControlDetails();
        for (CashControlDetail cashControlDetail : details) {
            DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
            PaymentApplicationDocument applicationDocument = (PaymentApplicationDocument)documentService.getByDocumentHeaderId(cashControlDetail.getReferenceFinancialDocumentNumber());
            String financialDocumentStatusCode = applicationDocument.getFinancialSystemDocumentHeader().getFinancialDocumentStatusCode();
            if ("X".equals(financialDocumentStatusCode) || "D".equals(financialDocumentStatusCode)) continue;
            if (!"A".equals(financialDocumentStatusCode)) {
                applicationDocument.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(KualiDecimal.ZERO);
                documentService.cancelDocument((Document)applicationDocument, "message.ar.documentDeletedFromCashControl");
                cashControlDetail.setFinancialDocumentLineAmount(KualiDecimal.ZERO);
                this.getBusinessObjectService().save((PersistableBusinessObject)cashControlDetail);
                continue;
            }
            GlobalVariables.getMessageMap().putError("document.cashControlDetails", "error.ar.CantCancelCashControlDocWithAssociatedApprovedPaymentApplicationDoc", new String[0]);
            success = false;
        }
        return success;
    }

    public ActionForward addCashControlDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CashControlForm cashControlDocForm = (CashControlForm)form;
        CashControlDocument cashControlDocument = cashControlDocForm.getCashControlDocument();
        ConfigurationService kualiConfiguration = (ConfigurationService)SpringContext.getBean(ConfigurationService.class);
        CashControlDetail newCashControlDetail = cashControlDocForm.getNewCashControlDetail();
        newCashControlDetail.setDocumentNumber(cashControlDocument.getDocumentNumber());
        String customerNumber = newCashControlDetail.getCustomerNumber();
        if (StringUtils.isNotEmpty((CharSequence)customerNumber)) {
            customerNumber = customerNumber.toUpperCase();
        }
        newCashControlDetail.setCustomerNumber(customerNumber);
        KualiRuleService ruleService = (KualiRuleService)SpringContext.getBean(KualiRuleService.class);
        boolean rulePassed = ruleService.applyRules((KualiDocumentEvent)new SaveDocumentEvent("document.header*", (Document)cashControlDocument));
        if (rulePassed &= ruleService.applyRules((KualiDocumentEvent)new AddCashControlDetailEvent("newCashControlDetail", (Document)cashControlDocument, newCashControlDetail))) {
            CashControlDocumentService cashControlDocumentService = (CashControlDocumentService)SpringContext.getBean(CashControlDocumentService.class);
            cashControlDocumentService.addNewCashControlDetail(kualiConfiguration.getPropertyValueAsString("message.ar.createdByCashControlDocument"), cashControlDocument, newCashControlDetail);
            cashControlDocForm.setNewCashControlDetail(new CashControlDetail());
        }
        cashControlDocument.recalculateTotals();
        return mapping.findForward("basic");
    }

    public ActionForward cancelCashControlDetail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CashControlForm cashControlDocForm = (CashControlForm)form;
        CashControlDocument cashControlDocument = cashControlDocForm.getCashControlDocument();
        int indexOfLineToDelete = this.getLineToDelete(request);
        CashControlDetail cashControlDetail = cashControlDocument.getCashControlDetail(indexOfLineToDelete);
        DocumentService documentService = (DocumentService)SpringContext.getBean(DocumentService.class);
        PaymentApplicationDocument payAppDoc = (PaymentApplicationDocument)documentService.getByDocumentHeaderId(cashControlDetail.getReferenceFinancialDocumentNumber());
        if (!payAppDoc.getDocumentHeader().getWorkflowDocument().isCanceled()) {
            payAppDoc.getFinancialSystemDocumentHeader().setFinancialDocumentTotalAmount(KualiDecimal.ZERO);
            documentService.cancelDocument((Document)payAppDoc, "message.ar.documentDeletedFromCashControl");
            cashControlDetail.setReferenceFinancialDocument(payAppDoc);
            WorkflowDocument workflowDoc = payAppDoc.getDocumentHeader().getWorkflowDocument();
            ((SessionDocumentService)SpringContext.getBean(SessionDocumentService.class)).addDocumentToUserSession(GlobalVariables.getUserSession(), workflowDoc);
        }
        cashControlDocument.cancelCashControlDetail(indexOfLineToDelete);
        cashControlDocument.recalculateTotals();
        return mapping.findForward("basic");
    }

    public ActionForward generateGLPEs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        CashControlForm cashControlDocForm = (CashControlForm)form;
        CashControlDocument cashControlDocument = cashControlDocForm.getCashControlDocument();
        cashControlDocument.refreshReferenceObject("customerPaymentMedium");
        cashControlDocument.refreshReferenceObject("generalLedgerPendingEntries");
        BusinessObjectService businessObjectService = (BusinessObjectService)SpringContext.getBean(BusinessObjectService.class);
        businessObjectService.save((PersistableBusinessObject)cashControlDocument);
        GeneralLedgerPendingEntryService glpeService = (GeneralLedgerPendingEntryService)SpringContext.getBean(GeneralLedgerPendingEntryService.class);
        boolean success = glpeService.generateGeneralLedgerPendingEntries((GeneralLedgerPendingEntrySource)cashControlDocument);
        if (!success) {
            GlobalVariables.getMessageMap().putError("document.generalLedgerPendingEntr*", "error.ar.GLPEsNotCreated", new String[0]);
        }
        CashControlDocumentService cashControlDocumentService = (CashControlDocumentService)SpringContext.getBean(CashControlDocumentService.class);
        cashControlDocumentService.saveGLPEs(cashControlDocument);
        return mapping.findForward("basic");
    }

    protected KualiDecimal calculateCashControlTotal(CashControlDocument cashControlDocument) {
        KualiDecimal total = KualiDecimal.ZERO;
        for (CashControlDetail cashControlDetail : cashControlDocument.getCashControlDetails()) {
            total = (KualiDecimal)total.add((AbstractKualiDecimal)cashControlDetail.getFinancialDocumentLineAmount());
        }
        return total;
    }
}

