/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.identity;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.integration.cg.ContractsAndGrantsFundManager;
import org.kuali.kfs.kns.kim.role.DerivedRoleTypeServiceBase;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.rice.core.api.membership.MemberType;
import org.kuali.rice.kim.api.role.RoleMembership;

public class FundsManagerDerivedRoleTypeServiceImpl
extends DerivedRoleTypeServiceBase {
    protected KualiModuleService kualiModuleService;

    public List<RoleMembership> getRoleMembersFromDerivedRole(String namespaceCode, String roleName, Map<String, String> qualification) {
        ArrayList<RoleMembership> roleMembers = new ArrayList<RoleMembership>();
        if (ObjectUtils.isNotNull(qualification) && !qualification.isEmpty()) {
            String principalId = qualification.get("principalId");
            String proposalNumber = qualification.get("proposalNumber");
            if (StringUtils.isNotBlank((CharSequence)proposalNumber)) {
                if (StringUtils.isNotBlank((CharSequence)principalId)) {
                    return this.getRoleMembersForPrincipalAndAward(principalId, proposalNumber);
                }
                return this.getRoleMembersForAward(proposalNumber);
            }
            if (StringUtils.isNotBlank((CharSequence)principalId)) {
                return this.getRoleMembersForPrincipal(principalId);
            }
        }
        return roleMembers;
    }

    public boolean hasDerivedRole(String principalId, List<String> groupIds, String namespaceCode, String roleName, Map<String, String> qualification) {
        String proposalNumber;
        if (ObjectUtils.isNotNull(qualification) && !qualification.isEmpty() && StringUtils.isNotBlank((CharSequence)(proposalNumber = qualification.get("proposalNumber")))) {
            return CollectionUtils.isNotEmpty(this.getRoleMembersForPrincipalAndAward(principalId, proposalNumber));
        }
        return CollectionUtils.isNotEmpty(this.getRoleMembersForPrincipal(principalId));
    }

    private List<RoleMembership> getRoleMembersForAward(String proposalNumber) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("proposalNumber", proposalNumber);
        return this.getRoleMembers(map);
    }

    private List<RoleMembership> getRoleMembersForPrincipal(String principalId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("principalId", principalId);
        return this.getRoleMembers(map);
    }

    private List<RoleMembership> getRoleMembersForPrincipalAndAward(String principalId, String proposalNumber) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("principalId", principalId);
        map.put("proposalNumber", proposalNumber);
        return this.getRoleMembers(map);
    }

    private List<RoleMembership> getRoleMembers(Map<String, Object> criteria) {
        ArrayList<RoleMembership> roleMembers = new ArrayList<RoleMembership>();
        criteria.put("active", true);
        List awardFundManagers = this.kualiModuleService.getResponsibleModuleService(ContractsAndGrantsFundManager.class).getExternalizableBusinessObjectsList(ContractsAndGrantsFundManager.class, criteria);
        for (ContractsAndGrantsFundManager awardFundManager : awardFundManagers) {
            roleMembers.add(RoleMembership.Builder.create(null, null, (String)awardFundManager.getPrincipalId(), (MemberType)MemberType.PRINCIPAL, null).build());
        }
        return roleMembers;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }
}

