/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.CollectionEvent;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.report.ContractsGrantsAgingReportDetailDataHolder;
import org.kuali.kfs.module.ar.report.ContractsGrantsReportDataHolder;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsAgingReportService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportDataBuilderService;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.util.KfsDateUtils;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.WorkflowDocument;
import org.kuali.rice.krad.bo.BusinessObject;

public class ContractsGrantsAgingReportBuilderServiceImpl
implements ContractsGrantsReportDataBuilderService {
    protected ReportInfo reportInfo;
    protected ContractsGrantsReportHelperService contractsGrantsReportHelperService;
    protected ContractsGrantsAgingReportService contractsGrantsAgingReportService;

    @Override
    public ContractsGrantsReportDataHolder buildReportDataHolder(List<? extends BusinessObject> displayList, String sortPropertyName) {
        Map<String, List<KualiDecimal>> subTotalMap = this.buildSubTotalMap(displayList, sortPropertyName);
        BigDecimal invoiceTotal = BigDecimal.ZERO;
        BigDecimal paymentTotal = BigDecimal.ZERO;
        BigDecimal remainingTotal = BigDecimal.ZERO;
        ContractsGrantsReportDataHolder cgInvoiceReportDataHolder = new ContractsGrantsReportDataHolder();
        List details = cgInvoiceReportDataHolder.getDetails();
        for (ContractsGrantsInvoiceDocument contractsGrantsInvoiceDocument : displayList) {
            ContractsGrantsAgingReportDetailDataHolder reportDetail = new ContractsGrantsAgingReportDetailDataHolder();
            this.setReportData(contractsGrantsInvoiceDocument, reportDetail);
            reportDetail.setSortedFieldValue(this.getContractsGrantsReportHelperService().getPropertyValue(contractsGrantsInvoiceDocument, sortPropertyName));
            reportDetail.setDisplaySubtotal(true);
            reportDetail.setInvoiceSubTotal(subTotalMap.get(this.getContractsGrantsReportHelperService().getPropertyValue(contractsGrantsInvoiceDocument, sortPropertyName)).get(0).bigDecimalValue());
            reportDetail.setPaymentSubTotal(subTotalMap.get(this.getContractsGrantsReportHelperService().getPropertyValue(contractsGrantsInvoiceDocument, sortPropertyName)).get(1).bigDecimalValue());
            reportDetail.setRemainingSubTotal(subTotalMap.get(this.getContractsGrantsReportHelperService().getPropertyValue(contractsGrantsInvoiceDocument, sortPropertyName)).get(2).bigDecimalValue());
            invoiceTotal = invoiceTotal.add(reportDetail.getInvoiceAmount());
            paymentTotal = paymentTotal.add(reportDetail.getPaymentAmount());
            remainingTotal = remainingTotal.add(reportDetail.getRemainingAmount());
            details.add(reportDetail);
        }
        ContractsGrantsAgingReportDetailDataHolder reportDetail = new ContractsGrantsAgingReportDetailDataHolder();
        reportDetail.setDisplayTotal(true);
        reportDetail.setInvoiceTotal(invoiceTotal);
        reportDetail.setPaymentTotal(paymentTotal);
        reportDetail.setRemainingTotal(remainingTotal);
        details.add(reportDetail);
        cgInvoiceReportDataHolder.setDetails(details);
        return cgInvoiceReportDataHolder;
    }

    @Override
    public Class<? extends BusinessObject> getDetailsClass() {
        return ContractsGrantsInvoiceDocument.class;
    }

    protected void setReportData(ContractsGrantsInvoiceDocument cgInvoiceReportEntry, ContractsGrantsAgingReportDetailDataHolder reportDetail) {
        java.util.Date today = new java.util.Date();
        Date sqlToday = new Date(today.getTime());
        reportDetail.setAgencyNumber(cgInvoiceReportEntry.getInvoiceGeneralDetail().getAward().getAgency().getAgencyNumber());
        reportDetail.setAgencyName(cgInvoiceReportEntry.getInvoiceGeneralDetail().getAward().getAgency().getReportingName());
        reportDetail.setCustomerNumber(cgInvoiceReportEntry.getCustomerNumber());
        reportDetail.setProposalNumber(cgInvoiceReportEntry.getInvoiceGeneralDetail().getProposalNumber());
        reportDetail.setAwardEndDate(cgInvoiceReportEntry.getInvoiceGeneralDetail().getAward().getAwardEndingDate());
        reportDetail.setDocumentNumber(cgInvoiceReportEntry.getDocumentNumber());
        WorkflowDocument workflowDocument = cgInvoiceReportEntry.getDocumentHeader().getWorkflowDocument();
        Date docCreateDate = new Date(workflowDocument.getDateCreated().toDate().getTime());
        reportDetail.setInvoiceDate(docCreateDate);
        List<CollectionEvent> events = cgInvoiceReportEntry.getCollectionEvents();
        if (ObjectUtils.isNotNull(events) && CollectionUtils.isNotEmpty(events)) {
            events.sort((o1, o2) -> {
                if (KfsDateUtils.isSameDay((java.util.Date)o1.getActivityDate(), (java.util.Date)o2.getActivityDate())) {
                    return 0;
                }
                return o2.getActivityDate().compareTo(o1.getActivityDate());
            });
            reportDetail.setLastEventDate(events.get(0).getActivityDate());
        }
        long MILLSECS_PER_DAY = 86400000L;
        reportDetail.setAgeInDays((sqlToday.getTime() - docCreateDate.getTime()) / 86400000L);
        BigDecimal invoiceAmount = cgInvoiceReportEntry.getTotalDollarAmount().bigDecimalValue();
        reportDetail.setInvoiceAmount(invoiceAmount);
        BigDecimal paymentAmount = cgInvoiceReportEntry.getCustomerInvoiceDetailsWithoutDiscounts().stream().reduce(BigDecimal.ZERO, (sum, customerInvoiceDetail) -> customerInvoiceDetail.getAmountApplied().bigDecimalValue().add((BigDecimal)sum), BigDecimal::add);
        reportDetail.setPaymentAmount(paymentAmount);
        BigDecimal remainingAmount = invoiceAmount.subtract(paymentAmount);
        reportDetail.setRemainingAmount(remainingAmount);
    }

    protected Map<String, List<KualiDecimal>> buildSubTotalMap(List<ContractsGrantsInvoiceDocument> displayList, String sortPropertyName) {
        HashMap<String, List<KualiDecimal>> returnSubTotalMap = new HashMap<String, List<KualiDecimal>>();
        List<String> valuesOfsortProperty = this.getContractsGrantsReportHelperService().getListOfValuesSortedProperties(displayList, sortPropertyName);
        for (String value : valuesOfsortProperty) {
            KualiDecimal invoiceSubTotal = KualiDecimal.ZERO;
            KualiDecimal paymentSubTotal = KualiDecimal.ZERO;
            for (ContractsGrantsInvoiceDocument cgInvoiceReportEntry : displayList) {
                if (!value.equals(this.getContractsGrantsReportHelperService().getPropertyValue(cgInvoiceReportEntry, sortPropertyName))) continue;
                KualiDecimal sourceTotal = cgInvoiceReportEntry.getSourceTotal();
                KualiDecimal paymentAmount = cgInvoiceReportEntry.getCustomerInvoiceDetailsWithoutDiscounts().stream().reduce(KualiDecimal.ZERO, (sum, customerInvoiceDetail) -> (KualiDecimal)customerInvoiceDetail.getAmountApplied().add((AbstractKualiDecimal)sum), AbstractKualiDecimal::add);
                invoiceSubTotal = (KualiDecimal)invoiceSubTotal.add((AbstractKualiDecimal)sourceTotal);
                paymentSubTotal = (KualiDecimal)paymentSubTotal.add((AbstractKualiDecimal)paymentAmount);
            }
            ArrayList<Object> allSubTotal = new ArrayList<Object>();
            allSubTotal.add(0, invoiceSubTotal);
            allSubTotal.add(1, paymentSubTotal);
            allSubTotal.add(2, invoiceSubTotal.subtract((AbstractKualiDecimal)paymentSubTotal));
            returnSubTotalMap.put(value, allSubTotal);
        }
        return returnSubTotalMap;
    }

    @Override
    public ReportInfo getReportInfo() {
        return this.reportInfo;
    }

    public void setReportInfo(ReportInfo reportInfo) {
        this.reportInfo = reportInfo;
    }

    public ContractsGrantsReportHelperService getContractsGrantsReportHelperService() {
        return this.contractsGrantsReportHelperService;
    }

    public void setContractsGrantsReportHelperService(ContractsGrantsReportHelperService contractsGrantsReportHelperService) {
        this.contractsGrantsReportHelperService = contractsGrantsReportHelperService;
    }

    public ContractsGrantsAgingReportService getContractsGrantsAgingReportService() {
        return this.contractsGrantsAgingReportService;
    }

    public void setContractsGrantsAgingReportService(ContractsGrantsAgingReportService contractsGrantsAgingReportService) {
        this.contractsGrantsAgingReportService = contractsGrantsAgingReportService;
    }
}

