/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.report.service.impl;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import net.sf.jasperreports.engine.data.JRBeanCollectionDataSource;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.kns.datadictionary.BusinessObjectEntry;
import org.kuali.kfs.kns.service.DataDictionaryService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.report.ContractsGrantsReportDataHolder;
import org.kuali.kfs.module.ar.report.service.ContractsGrantsReportHelperService;
import org.kuali.kfs.sys.report.ReportInfo;
import org.kuali.kfs.sys.service.ReportGenerationService;
import org.kuali.rice.core.api.config.property.ConfigContext;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.search.SearchOperator;
import org.kuali.rice.core.web.format.BooleanFormatter;
import org.kuali.rice.core.web.format.CollectionFormatter;
import org.kuali.rice.core.web.format.DateFormatter;
import org.kuali.rice.core.web.format.Formatter;
import org.kuali.rice.kim.api.identity.Person;
import org.kuali.rice.kim.api.identity.PersonService;
import org.kuali.rice.krad.bo.BusinessObject;
import org.springframework.util.StringUtils;

public class ContractsGrantsReportHelperServiceImpl
implements ContractsGrantsReportHelperService {
    private static final Logger LOG = LogManager.getLogger(ContractsGrantsReportHelperServiceImpl.class);
    protected DataDictionaryService dataDictionaryService;
    protected ReportGenerationService reportGenerationService;
    protected ConfigurationService configurationService;
    protected DateTimeService dateTimeService;
    protected PersonService personService;

    @Override
    public String generateReport(ContractsGrantsReportDataHolder reportDataHolder, ReportInfo reportInfo, ByteArrayOutputStream baos) {
        String reportFileName = reportInfo.getReportFileName();
        String reportTemplateClassPath = reportInfo.getReportTemplateClassPath();
        String reportTemplateName = reportInfo.getReportTemplateName();
        ResourceBundle resourceBundle = reportInfo.getResourceBundle();
        String subReportTemplateClassPath = reportInfo.getSubReportTemplateClassPath();
        Map subReports = reportInfo.getSubReports();
        Map<String, Object> reportData = reportDataHolder.getReportData();
        if (ObjectUtils.isNull((Object)reportData.get("reportTitle"))) {
            reportData.put("reportTitle", reportInfo.getReportTitle());
        }
        reportData.put("REPORT_RESOURCE_BUNDLE", resourceBundle);
        reportData.put("SUBREPORT_DIR", subReportTemplateClassPath);
        reportData.put("SUBREPORT_TEMPLATE_NAMES", subReports);
        this.addParametersToReportData(reportData);
        String template = reportTemplateClassPath + reportTemplateName;
        List<String> data = Arrays.asList("");
        JRBeanCollectionDataSource dataSource = new JRBeanCollectionDataSource(data);
        this.reportGenerationService.generateReportToOutputStream(reportData, (Object)dataSource, template, (OutputStream)baos);
        return reportFileName;
    }

    public void addParametersToReportData(Map<String, Object> reportData) {
        BusinessObjectEntry boe = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(ContractsAndGrantsBillingAward.class.getName());
        reportData.put("awardProposalId", boe.getAttributeDefinition("proposalNumber").getLabel());
        reportData.put("agencySponsorCode", boe.getAttributeDefinition("agencyNumber").getLabel());
    }

    @Override
    public String getFieldNameForSorting(int index, String businessObjectName) {
        BusinessObjectEntry boe = (BusinessObjectEntry)this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(businessObjectName);
        List lookupResultFields = boe.getLookupDefinition().getResultFieldNames();
        return (String)lookupResultFields.get(index);
    }

    @Override
    public List<String> getListOfValuesSortedProperties(List list, String propertyName) {
        ArrayList<String> returnList = new ArrayList<String>();
        for (Object object : list) {
            if (returnList.contains(this.getPropertyValue(object, propertyName))) continue;
            returnList.add(this.getPropertyValue(object, propertyName));
        }
        return returnList;
    }

    @Override
    public String getPropertyValue(Object object, String propertyName) {
        Object fieldValue = ObjectUtils.getPropertyValue((Object)object, (String)propertyName);
        return ObjectUtils.isNull((Object)fieldValue) ? "" : StringUtils.trimAllWhitespace((String)fieldValue.toString());
    }

    @Override
    public String createTitleText(Class<? extends BusinessObject> boClass) {
        String objectLabel;
        String titleText = "";
        String titlePrefixProp = this.getConfigurationService().getPropertyValueAsString("title.inquiry.url.value.prependtext");
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)titlePrefixProp)) {
            titleText = titleText + titlePrefixProp + " ";
        }
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)(objectLabel = this.getDataDictionaryService().getDataDictionary().getBusinessObjectEntry(boClass.getName()).getObjectLabel()))) {
            titleText = titleText + objectLabel + " ";
        }
        return titleText;
    }

    @Override
    public String formatByType(Object prop, Formatter preferredFormatter) {
        Formatter formatter = preferredFormatter;
        if (prop instanceof Boolean) {
            formatter = new BooleanFormatter();
        }
        if (prop instanceof Date) {
            formatter = new DateFormatter();
        }
        if (prop instanceof Collection && ObjectUtils.isNull((Object)formatter)) {
            formatter = new CollectionFormatter();
        }
        if (ObjectUtils.isNotNull((Object)formatter)) {
            return (String)formatter.format(prop);
        }
        return prop.toString();
    }

    @Override
    public String correctEndDateForTime(String dateString) {
        try {
            Date dateDate = DateUtils.addDays((Date)this.dateTimeService.convertToDate(dateString), (int)1);
            return this.dateTimeService.toString(dateDate, "MM/dd/yyyy");
        }
        catch (ParseException ex) {
            LOG.warn("invalid date format for errorDate: " + dateString);
            return "";
        }
    }

    @Override
    public String fixDateCriteria(String dateLowerBound, String dateUpperBound, boolean includeTime) {
        String correctedUpperBound;
        String string = correctedUpperBound = includeTime && StringUtils.hasText((String)dateUpperBound) ? this.correctEndDateForTime(dateUpperBound) : dateUpperBound;
        if (StringUtils.hasText((String)dateLowerBound)) {
            if (StringUtils.hasText((String)dateUpperBound)) {
                return dateLowerBound + SearchOperator.BETWEEN.op() + correctedUpperBound;
            }
            return SearchOperator.GREATER_THAN_EQUAL.op() + dateLowerBound;
        }
        if (StringUtils.hasText((String)dateUpperBound)) {
            return SearchOperator.LESS_THAN_EQUAL.op() + correctedUpperBound;
        }
        return null;
    }

    @Override
    public Set<String> lookupPrincipalIds(String principalName) {
        if (!StringUtils.hasText((String)principalName)) {
            return new HashSet<String>();
        }
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("principalName", principalName);
        List peoples = this.getPersonService().findPeople(fieldValues);
        if (peoples == null || peoples.isEmpty()) {
            return new HashSet<String>();
        }
        HashSet<String> principalIdsSet = new HashSet<String>();
        for (Person person : peoples) {
            principalIdsSet.add(person.getPrincipalId());
        }
        return principalIdsSet;
    }

    @Override
    public String getDocSearchUrl(String docId) {
        String baseUrl = ConfigContext.getCurrentContextConfig().getKEWBaseURL() + "/" + "DocHandler.do";
        Properties parameters = new Properties();
        parameters.put("command", "displayDocSearchView");
        parameters.put("docId", docId);
        return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
    }

    @Override
    public String getInitiateCollectionActivityDocumentUrl(String proposalNumber, String invoiceNumber) {
        Properties parameters = new Properties();
        parameters.put("methodToCall", "docHandler");
        if (StringUtils.hasText((String)proposalNumber)) {
            parameters.put("selectedProposalNumber", proposalNumber);
        }
        parameters.put("selectedInvoiceDocumentNumber", invoiceNumber);
        parameters.put("command", "initiate");
        parameters.put("docTypeName", "CCA");
        String baseUrl = StringUtils.hasText((String)proposalNumber) ? this.getBaseContractsGrantsCollectionActivityDocumentUrl() : "";
        return UrlFactory.parameterizeUrl((String)baseUrl, (Properties)parameters);
    }

    protected String getBaseContractsGrantsCollectionActivityDocumentUrl() {
        return "arContractsGrantsCollectionActivity.do";
    }

    public DataDictionaryService getDataDictionaryService() {
        return this.dataDictionaryService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public ReportGenerationService getReportGenerationService() {
        return this.reportGenerationService;
    }

    public void setReportGenerationService(ReportGenerationService reportGenerationService) {
        this.reportGenerationService = reportGenerationService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public PersonService getPersonService() {
        return this.personService;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }
}

