/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerAddress;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerCreditMemo;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoice;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoiceDetail;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerInvoiceRecurrenceDetails;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomerType;
import org.kuali.kfs.integration.ar.AccountsReceivableDocumentHeader;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleService;
import org.kuali.kfs.integration.ar.AccountsReceivableOrganizationOptions;
import org.kuali.kfs.integration.ar.AccountsReceivableSystemInformation;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.kns.lookup.Lookupable;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.CustomerCreditMemoDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.CustomerInvoiceRecurrenceDetails;
import org.kuali.kfs.module.ar.businessobject.CustomerType;
import org.kuali.kfs.module.ar.businessobject.OrganizationOptions;
import org.kuali.kfs.module.ar.document.CustomerCreditMemoDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.AccountsReceivablePendingEntryService;
import org.kuali.kfs.module.ar.document.service.CustomerAddressService;
import org.kuali.kfs.module.ar.document.service.CustomerCreditMemoDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDetailService;
import org.kuali.kfs.module.ar.document.service.CustomerInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.kfs.module.ar.service.CustomerDocumentService;
import org.kuali.kfs.sys.service.ElectronicPaymentClaimingDocumentGenerationStrategy;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.krad.bo.BusinessObject;

public class AccountsReceivableModuleServiceImpl
implements AccountsReceivableModuleService {
    private static final Logger LOG = LogManager.getLogger(AccountsReceivableModuleServiceImpl.class);
    protected AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService;
    protected AccountsReceivablePendingEntryService accountsReceivablePendingEntryService;
    protected BusinessObjectService businessObjectService;
    protected CustomerCreditMemoDetailService customerCreditMemoDetailService;
    protected CustomerDocumentService customerDocumentService;
    protected CustomerInvoiceDetailService customerInvoiceDetailService;
    protected CustomerInvoiceDocumentService customerInvoiceDocumentService;
    protected Lookupable customerLookupable;
    protected CustomerService customerService;
    protected CustomerAddressService customerAddressService;
    protected DocumentService documentService;
    protected ElectronicPaymentClaimingDocumentGenerationStrategy electronicPaymentClaimingDocumentGenerationStrategy;
    protected FinancialSystemUserService financialSystemUserService;
    protected KualiModuleService kualiModuleService;
    protected ParameterService parameterService;
    protected SystemInformationService systemInformationService;

    public CustomerAddressService getCustomerAddressService() {
        return this.customerAddressService;
    }

    public void setCustomerAddressService(CustomerAddressService customerAddressService) {
        this.customerAddressService = customerAddressService;
    }

    public CustomerCreditMemoDetailService getCustomerCreditMemoDetailService() {
        return this.customerCreditMemoDetailService;
    }

    public void setCustomerCreditMemoDetailService(CustomerCreditMemoDetailService customerCreditMemoDetailService) {
        this.customerCreditMemoDetailService = customerCreditMemoDetailService;
    }

    public SystemInformationService getSystemInformationService() {
        return this.systemInformationService;
    }

    public void setSystemInformationService(SystemInformationService systemInformationService) {
        this.systemInformationService = systemInformationService;
    }

    public CustomerInvoiceDetailService getCustomerInvoiceDetailService() {
        return this.customerInvoiceDetailService;
    }

    public void setCustomerInvoiceDetailService(CustomerInvoiceDetailService customerInvoiceDetailService) {
        this.customerInvoiceDetailService = customerInvoiceDetailService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public void setCustomerInvoiceDocumentService(CustomerInvoiceDocumentService customerInvoiceDocumentService) {
        this.customerInvoiceDocumentService = customerInvoiceDocumentService;
    }

    public void setAccountsReceivableDocumentHeaderService(AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService) {
        this.accountsReceivableDocumentHeaderService = accountsReceivableDocumentHeaderService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public CustomerDocumentService getCustomerDocumentService() {
        return this.customerDocumentService;
    }

    public void setCustomerDocumentService(CustomerDocumentService customerDocumentService) {
        this.customerDocumentService = customerDocumentService;
    }

    public void setCustomerLookupable(Lookupable customerLookupable) {
        this.customerLookupable = customerLookupable;
    }

    public KualiModuleService getKualiModuleService() {
        return this.kualiModuleService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public ElectronicPaymentClaimingDocumentGenerationStrategy getAccountsReceivablePaymentClaimingStrategy() {
        return this.electronicPaymentClaimingDocumentGenerationStrategy;
    }

    public Collection<AccountsReceivableCustomer> searchForCustomers(Map<String, String> fieldValues) {
        this.customerLookupable.setBusinessObjectClass(Customer.class);
        List results = this.customerLookupable.getSearchResults(fieldValues);
        ArrayList<AccountsReceivableCustomer> customers = new ArrayList<AccountsReceivableCustomer>();
        for (BusinessObject result : results) {
            customers.add((AccountsReceivableCustomer)result);
        }
        return customers;
    }

    public AccountsReceivableCustomer findCustomer(String customerNumber) {
        HashMap<String, String> primaryKey = new HashMap<String, String>();
        primaryKey.put("customerNumber", customerNumber);
        return (AccountsReceivableCustomer)this.getKualiModuleService().getResponsibleModuleService(Customer.class).getExternalizableBusinessObject(Customer.class, primaryKey);
    }

    public Collection<AccountsReceivableCustomerAddress> searchForCustomerAddresses(Map<String, String> fieldValues) {
        return new ArrayList<AccountsReceivableCustomerAddress>(this.getBusinessObjectService().findMatching(CustomerAddress.class, fieldValues));
    }

    public AccountsReceivableCustomerAddress findCustomerAddress(String customerNumber, String customerAddressIdentifier) {
        HashMap<String, String> addressKey = new HashMap<String, String>();
        addressKey.put("customerNumber", customerNumber);
        addressKey.put("customerAddressIdentifier", customerAddressIdentifier);
        return (AccountsReceivableCustomerAddress)this.getBusinessObjectService().findByPrimaryKey(CustomerAddress.class, addressKey);
    }

    public AccountsReceivableCustomerInvoice getOpenCustomerInvoice(String customerInvoiceDocumentNumber) {
        return (AccountsReceivableCustomerInvoice)this.getBusinessObjectService().findBySinglePrimaryKey(CustomerInvoiceDocument.class, (Object)customerInvoiceDocumentNumber);
    }

    public Map<String, KualiDecimal> getCustomerInvoiceOpenAmount(List<String> customerTypeCodes, Integer customerInvoiceAge, Date invoiceDueDateFrom) {
        HashMap<String, KualiDecimal> customerInvoiceOpenAmountMap = new HashMap<String, KualiDecimal>();
        Collection<? extends AccountsReceivableCustomerInvoice> customerInvoiceDocuments = this.getOpenCustomerInvoices(customerTypeCodes, customerInvoiceAge, invoiceDueDateFrom);
        if (ObjectUtils.isNull(customerInvoiceDocuments)) {
            return customerInvoiceOpenAmountMap;
        }
        for (AccountsReceivableCustomerInvoice accountsReceivableCustomerInvoice : customerInvoiceDocuments) {
            KualiDecimal openAmount = accountsReceivableCustomerInvoice.getOpenAmount();
            if (!ObjectUtils.isNotNull((Object)openAmount) || !openAmount.isPositive()) continue;
            customerInvoiceOpenAmountMap.put(accountsReceivableCustomerInvoice.getDocumentNumber(), openAmount);
        }
        return customerInvoiceOpenAmountMap;
    }

    public Collection<? extends AccountsReceivableCustomerInvoice> getOpenCustomerInvoices(List<String> customerTypeCodes, Integer customerInvoiceAge, Date invoiceDueDateFrom) {
        return this.customerInvoiceDocumentService.getAllAgingInvoiceDocumentsByCustomerTypes(customerTypeCodes, customerInvoiceAge, invoiceDueDateFrom);
    }

    public AccountsReceivableCustomer createCustomer() {
        return new Customer();
    }

    public AccountsReceivableCustomerAddress createCustomerAddress() {
        return new CustomerAddress();
    }

    public String getNextCustomerNumber(AccountsReceivableCustomer customer) {
        return this.customerService.getNextCustomerNumber((Customer)customer);
    }

    public String createAndSaveCustomer(String description, ContractsAndGrantsBillingAgency agency) throws WorkflowException {
        return this.customerDocumentService.createAndSaveCustomer(description, agency);
    }

    public void saveCustomer(AccountsReceivableCustomer customer) {
        this.getBusinessObjectService().save((PersistableBusinessObject)((Customer)customer));
    }

    public List<AccountsReceivableCustomerType> findByCustomerTypeDescription(String customerTypeDescription) {
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        fieldMap.put("customerTypeDescription", customerTypeDescription);
        return new ArrayList<AccountsReceivableCustomerType>(this.getBusinessObjectService().findMatching(CustomerType.class, fieldMap));
    }

    public AccountsReceivableOrganizationOptions getOrgOptionsIfExists(String chartOfAccountsCode, String organizationCode) {
        HashMap<String, String> criteria = new HashMap<String, String>();
        criteria.put("chartOfAccountsCode", chartOfAccountsCode);
        criteria.put("organizationCode", organizationCode);
        return (AccountsReceivableOrganizationOptions)this.getBusinessObjectService().findByPrimaryKey(OrganizationOptions.class, criteria);
    }

    public void saveCustomerInvoiceDocument(AccountsReceivableCustomerInvoice customerInvoiceDocument) throws WorkflowException {
        this.getDocumentService().saveDocument((Document)((CustomerInvoiceDocument)customerInvoiceDocument));
    }

    public Document blanketApproveCustomerInvoiceDocument(AccountsReceivableCustomerInvoice customerInvoiceDocument) throws WorkflowException {
        return this.getDocumentService().blanketApproveDocument((Document)((CustomerInvoiceDocument)customerInvoiceDocument), null, null);
    }

    public AccountsReceivableCustomerInvoiceRecurrenceDetails createCustomerInvoiceRecurrenceDetails() {
        return new CustomerInvoiceRecurrenceDetails();
    }

    public AccountsReceivableDocumentHeader createAccountsReceivableDocumentHeader() {
        return new org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader();
    }

    public AccountsReceivableSystemInformation getSystemInformationByProcessingChartOrgAndFiscalYear(String chartOfAccountsCode, String organizationCode, Integer currentFiscalYear) {
        return this.systemInformationService.getByProcessingChartOrgAndFiscalYear(chartOfAccountsCode, organizationCode, currentFiscalYear);
    }

    public AccountsReceivableCustomerInvoiceDetail getCustomerInvoiceDetailFromCustomerInvoiceItemCode(String invoiceItemCode, String processingChartCode, String processingOrgCode) {
        return this.customerInvoiceDetailService.getCustomerInvoiceDetailFromCustomerInvoiceItemCode(invoiceItemCode, processingChartCode, processingOrgCode);
    }

    public String getAccountsReceivableObjectCodeBasedOnReceivableParameter(AccountsReceivableCustomerInvoiceDetail customerInvoiceDetail) {
        return this.getAccountsReceivablePendingEntryService().getAccountsReceivableObjectCode((CustomerInvoiceDetail)customerInvoiceDetail);
    }

    public void recalculateCustomerInvoiceDetail(AccountsReceivableCustomerInvoice customerInvoiceDocument, AccountsReceivableCustomerInvoiceDetail detail) {
        this.customerInvoiceDetailService.recalculateCustomerInvoiceDetail((CustomerInvoiceDocument)customerInvoiceDocument, (CustomerInvoiceDetail)detail);
    }

    public void prepareCustomerInvoiceDetailForAdd(AccountsReceivableCustomerInvoiceDetail detail, AccountsReceivableCustomerInvoice customerInvoiceDocument) {
        this.customerInvoiceDetailService.prepareCustomerInvoiceDetailForAdd((CustomerInvoiceDetail)detail, (CustomerInvoiceDocument)customerInvoiceDocument);
    }

    public KualiDecimal getOpenAmountForCustomerInvoiceDocument(AccountsReceivableCustomerInvoice invoice) {
        return this.customerInvoiceDocumentService.getOpenAmountForCustomerInvoiceDocument((CustomerInvoiceDocument)invoice);
    }

    public AccountsReceivableDocumentHeader getNewAccountsReceivableDocumentHeader(String processingChart, String processingOrg) {
        return this.accountsReceivableDocumentHeaderService.getNewAccountsReceivableDocumentHeader(processingChart, processingOrg);
    }

    public AccountsReceivableCustomerInvoice createCustomerInvoiceDocument() {
        try {
            return (CustomerInvoiceDocument)this.getDocumentService().getNewDocument(CustomerInvoiceDocument.class);
        }
        catch (WorkflowException ex) {
            LOG.error("problem during AccountsReceivableModuleServiceImpl.createCustomerInvoiceDocument()", (Throwable)ex);
            throw new RuntimeException("Could not create customer invoice document", ex);
        }
    }

    public AccountsReceivableCustomerCreditMemo createCustomerCreditMemoDocument() {
        CustomerCreditMemoDocument crmDocument;
        try {
            crmDocument = (CustomerCreditMemoDocument)this.getDocumentService().getNewDocument(CustomerCreditMemoDocument.class);
        }
        catch (WorkflowException ex) {
            LOG.error("problem during AccountsReceivableModuleServiceImpl.createCustomerCreditMemoDocument()", (Throwable)ex);
            throw new RuntimeException("Could not create new customer credit memo document", ex);
        }
        return crmDocument;
    }

    public AccountsReceivableCustomerCreditMemo populateCustomerCreditMemoDocumentDetails(AccountsReceivableCustomerCreditMemo arCrmDocument, String invoiceNumber, KualiDecimal creditAmount) {
        CustomerCreditMemoDocument crmDocument = (CustomerCreditMemoDocument)arCrmDocument;
        crmDocument.setFinancialDocumentReferenceInvoiceNumber(invoiceNumber);
        crmDocument.getInvoice();
        crmDocument.populateCustomerCreditMemoDetails();
        CustomerCreditMemoDetail detail = crmDocument.getCreditMemoDetails().get(0);
        detail.setCreditMemoItemTotalAmount(creditAmount);
        this.customerCreditMemoDetailService.recalculateCustomerCreditMemoDetail(detail, crmDocument);
        return crmDocument;
    }

    public Document blanketApproveCustomerCreditMemoDocument(AccountsReceivableCustomerCreditMemo creditMemoDocument, String annotation) throws WorkflowException {
        return this.getDocumentService().blanketApproveDocument((Document)((CustomerCreditMemoDocument)creditMemoDocument), annotation, null);
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public FinancialSystemUserService getFinancialSystemUserService() {
        return this.financialSystemUserService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }

    public ElectronicPaymentClaimingDocumentGenerationStrategy getElectronicPaymentClaimingDocumentGenerationStrategy() {
        return this.electronicPaymentClaimingDocumentGenerationStrategy;
    }

    public void setElectronicPaymentClaimingDocumentGenerationStrategy(ElectronicPaymentClaimingDocumentGenerationStrategy electronicPaymentClaimingDocumentGenerationStrategy) {
        this.electronicPaymentClaimingDocumentGenerationStrategy = electronicPaymentClaimingDocumentGenerationStrategy;
    }

    public AccountsReceivablePendingEntryService getAccountsReceivablePendingEntryService() {
        return this.accountsReceivablePendingEntryService;
    }

    public void setAccountsReceivablePendingEntryService(AccountsReceivablePendingEntryService accountsReceivablePendingEntryService) {
        this.accountsReceivablePendingEntryService = accountsReceivablePendingEntryService;
    }
}

