/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.coa.businessobject.Account;
import org.kuali.kfs.coa.businessobject.AccountingPeriod;
import org.kuali.kfs.coa.businessobject.ObjectType;
import org.kuali.kfs.coa.service.AccountService;
import org.kuali.kfs.coa.service.AccountingPeriodService;
import org.kuali.kfs.coreservice.framework.parameter.ParameterService;
import org.kuali.kfs.gl.businessobject.Balance;
import org.kuali.kfs.integration.ar.AccountsReceivableCustomer;
import org.kuali.kfs.integration.ar.Billable;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAgency;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAward;
import org.kuali.kfs.integration.cg.ContractsAndGrantsBillingAwardAccount;
import org.kuali.kfs.integration.cg.ContractsAndGrantsModuleBillingService;
import org.kuali.kfs.integration.cg.ContractsAndGrantsOrganization;
import org.kuali.kfs.krad.bo.DocumentHeader;
import org.kuali.kfs.krad.bo.PersistableBusinessObject;
import org.kuali.kfs.krad.document.Document;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DataDictionaryService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.service.KualiModuleService;
import org.kuali.kfs.krad.util.ErrorMessage;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.krad.workflow.service.WorkflowDocumentService;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.batch.service.VerifyBillingFrequencyService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.AwardAccountObjectCodeTotalBilled;
import org.kuali.kfs.module.ar.businessobject.Bill;
import org.kuali.kfs.module.ar.businessobject.BillingPeriod;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDetail;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorLog;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsInvoiceDocumentErrorMessage;
import org.kuali.kfs.module.ar.businessobject.ContractsGrantsLetterOfCreditReviewDetail;
import org.kuali.kfs.module.ar.businessobject.CostCategory;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerAddress;
import org.kuali.kfs.module.ar.businessobject.InvoiceAccountDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceAddressDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceBill;
import org.kuali.kfs.module.ar.businessobject.InvoiceDetailAccountObjectCode;
import org.kuali.kfs.module.ar.businessobject.InvoiceGeneralDetail;
import org.kuali.kfs.module.ar.businessobject.InvoiceMilestone;
import org.kuali.kfs.module.ar.businessobject.Milestone;
import org.kuali.kfs.module.ar.dataaccess.AwardAccountObjectCodeTotalBilledDao;
import org.kuali.kfs.module.ar.document.ContractsGrantsInvoiceDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsBillingAwardVerificationService;
import org.kuali.kfs.module.ar.document.service.ContractsGrantsInvoiceDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.service.ContractsGrantsBillingUtilityService;
import org.kuali.kfs.module.ar.service.ContractsGrantsInvoiceCreateDocumentService;
import org.kuali.kfs.module.ar.service.CostCategoryService;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.businessobject.FinancialSystemDocumentHeader;
import org.kuali.kfs.sys.businessobject.SystemOptions;
import org.kuali.kfs.sys.document.service.FinancialSystemDocumentService;
import org.kuali.kfs.sys.document.validation.event.DocumentSystemSaveEvent;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.OptionsService;
import org.kuali.kfs.sys.service.UniversityDateService;
import org.kuali.rice.core.api.config.property.ConfigurationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.document.DocumentStatus;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Transactional
public class ContractsGrantsInvoiceCreateDocumentServiceImpl
implements ContractsGrantsInvoiceCreateDocumentService {
    private static final Logger LOG = LogManager.getLogger(ContractsGrantsInvoiceCreateDocumentServiceImpl.class);
    protected AccountService accountService;
    protected AccountingPeriodService accountingPeriodService;
    protected AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService;
    protected AwardAccountObjectCodeTotalBilledDao awardAccountObjectCodeTotalBilledDao;
    protected BusinessObjectService businessObjectService;
    protected ConfigurationService configurationService;
    protected ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationService;
    protected ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService;
    protected ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService;
    protected ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService;
    protected CostCategoryService costCategoryService;
    protected CustomerService customerService;
    protected DateTimeService dateTimeService;
    protected DataDictionaryService dataDictionaryService;
    protected DocumentService documentService;
    protected FinancialSystemDocumentService financialSystemDocumentService;
    protected KualiModuleService kualiModuleService;
    protected ParameterService parameterService;
    protected VerifyBillingFrequencyService verifyBillingFrequencyService;
    protected WorkflowDocumentService workflowDocumentService;
    protected UniversityDateService universityDateService;
    protected OptionsService optionsService;
    protected FinancialSystemUserService financialSystemUserService;
    public static final String REPORT_LINE_DIVIDER = "--------------------------------------------------------------------------------------------------------------";

    @Override
    public List<ErrorMessage> createCGInvoiceDocumentsByAwards(Collection<ContractsAndGrantsBillingAward> awards, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType creationProcessTypeCode) {
        List<ErrorMessage> errorMessages = this.createInvoices(awards, null, null);
        if (!CollectionUtils.isEmpty(errorMessages)) {
            this.storeCreationErrors(errorMessages, creationProcessTypeCode.getCode());
        }
        return errorMessages;
    }

    @Override
    public List<ErrorMessage> createCGInvoiceDocumentsByAwards(Collection<ContractsAndGrantsBillingAward> awards, List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails, String locCreationType) {
        List<ErrorMessage> errorMessages = this.createInvoices(awards, accountDetails, locCreationType);
        if (!CollectionUtils.isEmpty(errorMessages)) {
            this.storeCreationErrors(errorMessages, ArConstants.ContractsAndGrantsInvoiceDocumentCreationProcessType.LOC.getCode());
        }
        return errorMessages;
    }

    protected List<ErrorMessage> createInvoices(Collection<ContractsAndGrantsBillingAward> awards, List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails, String locCreationType) {
        ArrayList<ErrorMessage> errorMessages = new ArrayList<ErrorMessage>();
        if (ObjectUtils.isNotNull(awards) && awards.size() > 0) {
            for (ContractsAndGrantsBillingAward awd : awards) {
                String invOpt = awd.getInvoicingOptionCode();
                ContractsAndGrantsOrganization awardOrganization = awd.getPrimaryAwardOrganization();
                if (ObjectUtils.isNull((Object)awardOrganization)) {
                    ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.no.organization.on.award", new String[]{awd.getProposalNumber()});
                    errorMessages.add(errorMessage);
                    continue;
                }
                switch (invOpt) {
                    case "2": 
                    case "4": {
                        this.createInvoicesByAccounts(awd, errorMessages, accountDetails, locCreationType);
                        break;
                    }
                    case "3": {
                        this.createInvoicesByContractControlAccounts(awd, errorMessages, accountDetails, locCreationType);
                        break;
                    }
                    case "1": {
                        this.createInvoicesByAward(awd, errorMessages, accountDetails, locCreationType);
                        break;
                    }
                }
            }
        } else {
            ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.no.award", new String[0]);
            errorMessages.add(errorMessage);
        }
        return errorMessages;
    }

    protected void createInvoicesByAward(ContractsAndGrantsBillingAward awd, List<ErrorMessage> errorMessages, List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails, String locCreationType) {
        int accountNum = awd.getActiveAwardAccounts().size();
        List<Account> controlAccounts = this.getContractsGrantsInvoiceDocumentService().getContractControlAccounts(awd);
        if (controlAccounts == null || controlAccounts.size() < accountNum) {
            ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.bill.by.contract.control.no.accounts", new String[]{awd.getProposalNumber()});
            errorMessages.add(errorMessage);
        } else {
            boolean isValid = true;
            if (accountNum != 1) {
                HashSet<Account> distinctAwardAccounts = new HashSet<Account>();
                for (ContractsAndGrantsBillingAwardAccount awardAccount : awd.getActiveAwardAccounts()) {
                    if (ObjectUtils.isNull((Object)awardAccount.getAccount().getContractControlAccount())) continue;
                    distinctAwardAccounts.add(awardAccount.getAccount().getContractControlAccount());
                }
                if (distinctAwardAccounts.size() > 1) {
                    ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.different.control.accounts", new String[]{awd.getProposalNumber()});
                    errorMessages.add(errorMessage);
                    isValid = false;
                }
            }
            if (isValid) {
                if (!this.getValidAwardAccounts(awd.getActiveAwardAccounts(), awd).containsAll(awd.getActiveAwardAccounts())) {
                    ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.not.all.billable.accounts", new String[]{awd.getProposalNumber()});
                    errorMessages.add(errorMessage);
                }
                this.generateAndSaveContractsAndGrantsInvoiceDocument(awd, this.getValidAwardAccounts(awd.getActiveAwardAccounts(), awd), errorMessages, accountDetails, locCreationType);
            }
        }
    }

    protected void createInvoicesByContractControlAccounts(ContractsAndGrantsBillingAward awd, List<ErrorMessage> errorMessages, List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails, String locCreationType) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> tmpAcctList = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        List<Account> controlAccounts = this.getContractsGrantsInvoiceDocumentService().getContractControlAccounts(awd);
        List<Account> controlAccountsTemp = this.getContractsGrantsInvoiceDocumentService().getContractControlAccounts(awd);
        if (controlAccounts == null || controlAccounts.size() != awd.getActiveAwardAccounts().size()) {
            ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.no.control.account", new String[]{awd.getProposalNumber()});
            errorMessages.add(errorMessage);
        } else {
            HashSet<Account> controlAccountSet = new HashSet<Account>();
            for (int i = 0; i < controlAccountsTemp.size() && ObjectUtils.isNotNull((Object)controlAccountsTemp.get(i)); ++i) {
                for (int j = i + 1; j < controlAccounts.size(); ++j) {
                    if (!controlAccountsTemp.get(i).equals((Object)controlAccounts.get(j))) continue;
                    controlAccounts.set(j, null);
                }
            }
            for (Account ctrlAcct : controlAccounts) {
                if (!ObjectUtils.isNotNull((Object)ctrlAcct)) continue;
                controlAccountSet.add(ctrlAcct);
            }
            if (controlAccountSet.size() != 0) {
                for (Account controlAccount : controlAccountSet) {
                    tmpAcctList.clear();
                    for (ContractsAndGrantsBillingAwardAccount awardAccount : awd.getActiveAwardAccounts()) {
                        Account tmpCtrlAcct;
                        if (awardAccount.isFinalBilledIndicator() || !(tmpCtrlAcct = awardAccount.getAccount().getContractControlAccount()).getChartOfAccountsCode().equals(controlAccount.getChartOfAccountsCode()) || !tmpCtrlAcct.getAccountNumber().equals(controlAccount.getAccountNumber())) continue;
                        tmpAcctList.add(awardAccount);
                    }
                    if (!this.getValidAwardAccounts(tmpAcctList, awd).containsAll(tmpAcctList)) {
                        ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.control.account.non.billable", new String[]{controlAccount.getAccountNumber(), awd.getProposalNumber()});
                        errorMessages.add(errorMessage);
                    }
                    this.generateAndSaveContractsAndGrantsInvoiceDocument(awd, this.getValidAwardAccounts(tmpAcctList, awd), errorMessages, accountDetails, locCreationType);
                }
            } else {
                ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.bill.by.contract.control.no.control.account", new String[]{awd.getProposalNumber()});
                errorMessages.add(errorMessage);
            }
        }
    }

    protected void createInvoicesByAccounts(ContractsAndGrantsBillingAward award, List<ErrorMessage> errorMessages, List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails, String locCreationType) {
        ArrayList<ContractsAndGrantsBillingAwardAccount> tmpAcctList = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
        for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
            if (awardAccount.isFinalBilledIndicator()) continue;
            tmpAcctList.clear();
            tmpAcctList.add(awardAccount);
            List<ContractsAndGrantsBillingAwardAccount> validAwardAccounts = this.getValidAwardAccounts(tmpAcctList, award);
            if (validAwardAccounts.containsAll(tmpAcctList) && this.contractsGrantsBillingAwardVerificationService.isAwardAccountValidToInvoiceBasedOnSchedule(awardAccount)) {
                this.generateAndSaveContractsAndGrantsInvoiceDocument(award, validAwardAccounts, errorMessages, accountDetails, locCreationType);
                continue;
            }
            ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.non.billable", new String[]{awardAccount.getAccountNumber(), award.getProposalNumber()});
            errorMessages.add(errorMessage);
        }
    }

    protected void generateAndSaveContractsAndGrantsInvoiceDocument(ContractsAndGrantsBillingAward awd, List<ContractsAndGrantsBillingAwardAccount> validAwardAccounts, List<ErrorMessage> errorMessages, List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails, String locCreationType) {
        ChartOrgHolder chartOrgHolder = this.financialSystemUserService.getPrimaryOrganization(awd.getAwardPrimaryFundManager().getFundManager().getPrincipalId(), "KFS-AR");
        ContractsGrantsInvoiceDocument cgInvoiceDocument = this.createCGInvoiceDocumentByAwardInfo(awd, validAwardAccounts, chartOrgHolder.getChartOfAccountsCode(), chartOrgHolder.getOrganizationCode(), errorMessages, accountDetails, locCreationType);
        if (ObjectUtils.isNotNull((Object)cgInvoiceDocument)) {
            if (cgInvoiceDocument.getTotalInvoiceAmount().isPositive() || ArConstants.BillingFrequencyValues.isMilestone((Billable)awd) || ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)awd)) {
                try {
                    this.documentService.saveDocument((Document)cgInvoiceDocument, DocumentSystemSaveEvent.class);
                }
                catch (WorkflowException ex) {
                    LOG.error("Error creating cgin documents: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException("Error creating cgin documents: " + ex.getMessage(), ex);
                }
            } else {
                List<InvoiceAccountDetail> invoiceAccounts = cgInvoiceDocument.getAccountDetails();
                ErrorMessage errorMessage = !invoiceAccounts.isEmpty() ? new ErrorMessage("error.invoice.create.document.non.billable", new String[]{invoiceAccounts.get(0).getAccountNumber(), awd.getProposalNumber()}) : new ErrorMessage("error.invoice.create.document.non.billable", new String[]{null, awd.getProposalNumber()});
                errorMessages.add(errorMessage);
            }
        }
    }

    @Override
    public ContractsGrantsInvoiceDocument createCGInvoiceDocumentByAwardInfo(ContractsAndGrantsBillingAward awd, List<ContractsAndGrantsBillingAwardAccount> accounts, String chartOfAccountsCode, String organizationCode, List<ErrorMessage> errorMessages, List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails, String locCreationType) {
        ContractsGrantsInvoiceDocument cgInvoiceDocument = null;
        if (ObjectUtils.isNotNull(accounts) && !accounts.isEmpty()) {
            if (chartOfAccountsCode != null && organizationCode != null) {
                try {
                    cgInvoiceDocument = (ContractsGrantsInvoiceDocument)this.documentService.getNewDocument(ContractsGrantsInvoiceDocument.class);
                    cgInvoiceDocument.getDocumentHeader().setDocumentDescription(this.buildDocumentDescription(awd, accounts));
                    cgInvoiceDocument.setBillByChartOfAccountCode(chartOfAccountsCode);
                    cgInvoiceDocument.setBilledByOrganizationCode(organizationCode);
                    List<String> procCodes = this.getContractsGrantsInvoiceDocumentService().getProcessingFromBillingCodes(chartOfAccountsCode, organizationCode);
                    AccountsReceivableDocumentHeader accountsReceivableDocumentHeader = new AccountsReceivableDocumentHeader();
                    accountsReceivableDocumentHeader.setDocumentNumber(cgInvoiceDocument.getDocumentNumber());
                    if (procCodes != null) {
                        int procCodesSize = procCodes.size();
                        if (procCodesSize > 0) {
                            accountsReceivableDocumentHeader.setProcessingChartOfAccountCode(procCodes.get(0));
                        }
                        if (procCodesSize > 1) {
                            accountsReceivableDocumentHeader.setProcessingOrganizationCode(procCodes.get(1));
                        }
                    }
                    cgInvoiceDocument.setAccountsReceivableDocumentHeader(accountsReceivableDocumentHeader);
                    this.populateInvoiceFromAward(awd, accounts, cgInvoiceDocument, accountDetails, locCreationType);
                    this.contractsGrantsInvoiceDocumentService.createSourceAccountingLines(cgInvoiceDocument, accounts);
                    if (ObjectUtils.isNotNull((Object)cgInvoiceDocument.getInvoiceGeneralDetail().getAward())) {
                        this.contractsGrantsInvoiceDocumentService.updateSuspensionCategoriesOnDocument(cgInvoiceDocument);
                    }
                    LOG.info("Created Contracts & Grants Invoice Document " + cgInvoiceDocument.getDocumentNumber());
                }
                catch (WorkflowException ex) {
                    LOG.error("Error creating cgin documents: " + ex.getMessage(), (Throwable)ex);
                    throw new RuntimeException("Error creating cgin documents: " + ex.getMessage(), ex);
                }
            } else {
                ErrorMessage errorMessage = new ErrorMessage("error.invoice.create.document.no.chart.or.org", new String[]{awd.getProposalNumber()});
                errorMessages.add(errorMessage);
            }
        }
        return cgInvoiceDocument;
    }

    protected String buildDocumentDescription(ContractsAndGrantsBillingAward award, List<ContractsAndGrantsBillingAwardAccount> accounts) {
        String contractControlAccount = StringUtils.defaultString((String)((ContractsAndGrantsBillingAwardAccount)accounts.stream().findFirst().get()).getAccount().getContractControlAccountNumber());
        String fundManagerPrincipalName = award.getAwardPrimaryFundManager().getFundManager().getPrincipalName();
        String description = MessageFormat.format(this.getConfigurationService().getPropertyValueAsString("contracts.grants.invoice.document.description.format"), award.getProposalNumber(), contractControlAccount, fundManagerPrincipalName);
        int descriptionMaxLength = this.dataDictionaryService.getAttributeMaxLength(DocumentHeader.class, "documentDescription");
        return StringUtils.left((String)description, (int)descriptionMaxLength);
    }

    protected void populateInvoiceFromAward(ContractsAndGrantsBillingAward award, List<ContractsAndGrantsBillingAwardAccount> awardAccounts, ContractsGrantsInvoiceDocument document, List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails, String locCreationType) {
        if (ObjectUtils.isNotNull((Object)award)) {
            ContractsAndGrantsBillingAwardAccount awardAccount;
            InvoiceGeneralDetail invoiceGeneralDetail = new InvoiceGeneralDetail();
            invoiceGeneralDetail.setDocumentNumber(document.getDocumentNumber());
            invoiceGeneralDetail.setProposalNumber(award.getProposalNumber());
            invoiceGeneralDetail.setAward(award);
            Timestamp ts = new Timestamp(new Date().getTime());
            java.sql.Date today = new java.sql.Date(ts.getTime());
            AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
            BillingPeriod billingPeriod = this.verifyBillingFrequencyService.getStartDateAndEndDateOfPreviousBillingPeriod(award, currPeriod);
            invoiceGeneralDetail.setBillingPeriod(this.getDateTimeService().toDateString((Date)billingPeriod.getStartDate()) + " to " + this.getDateTimeService().toDateString((Date)billingPeriod.getEndDate()));
            invoiceGeneralDetail.setLastBilledDate(billingPeriod.getEndDate());
            this.populateInvoiceDetailFromAward(invoiceGeneralDetail, award);
            document.setInvoiceGeneralDetail(invoiceGeneralDetail);
            document.setCustomerBillToAddressIdentifier(1);
            document.setInvoiceDueDate(this.dateTimeService.getCurrentSqlDateMidnight());
            document.getInvoiceAddressDetails().clear();
            ContractsAndGrantsBillingAgency agency = award.getAgency();
            if (ObjectUtils.isNotNull((Object)agency)) {
                List<InvoiceAddressDetail> invoiceAddressDetails = this.buildInvoiceAddressDetailsFromAgency(agency, document);
                document.getInvoiceAddressDetails().addAll(invoiceAddressDetails);
            }
            if (ArConstants.BillingFrequencyValues.isMilestone(document.getInvoiceGeneralDetail())) {
                awardAccount = awardAccounts.get(0);
                List<Milestone> milestones = this.getContractsGrantsBillingUtilityService().getActiveMilestonesForProposalNumber(award.getProposalNumber(), awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber());
                if (!CollectionUtils.isEmpty(milestones)) {
                    document.getInvoiceMilestones().clear();
                    document.getInvoiceMilestones().addAll(this.buildInvoiceMilestones(milestones));
                }
            } else if (ArConstants.BillingFrequencyValues.isPredeterminedBilling(document.getInvoiceGeneralDetail())) {
                awardAccount = awardAccounts.get(0);
                List<Bill> bills = this.getContractsGrantsBillingUtilityService().getActiveBillsForAwardAccount(award.getProposalNumber(), awardAccount.getChartOfAccountsCode(), awardAccount.getAccountNumber());
                if (!CollectionUtils.isEmpty(bills)) {
                    document.getInvoiceBills().clear();
                    document.getInvoiceBills().addAll(this.buildInvoiceBills(bills));
                }
            }
            document.getAccountDetails().clear();
            ArrayList<InvoiceAccountDetail> invoiceAccountDetails = new ArrayList<InvoiceAccountDetail>();
            ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectsCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
            HashMap<String, KualiDecimal> budgetAmountsByCostCategory = new HashMap<String, KualiDecimal>();
            Integer currentYear = this.getUniversityDateService().getCurrentFiscalYear();
            boolean firstFiscalPeriod = this.isFirstFiscalPeriod();
            Integer fiscalYear = firstFiscalPeriod && ArConstants.BillingFrequencyValues.isTimeBased(document.getInvoiceGeneralDetail()) ? currentYear - 1 : currentYear;
            SystemOptions systemOptions = this.optionsService.getOptions(fiscalYear);
            ArrayList<String> balanceTypeCodeList = new ArrayList<String>();
            balanceTypeCodeList.add(systemOptions.getBudgetCheckingBalanceTypeCd());
            balanceTypeCodeList.add(systemOptions.getActualFinancialBalanceTypeCd());
            for (ContractsAndGrantsBillingAwardAccount awardAccount2 : awardAccounts) {
                InvoiceAccountDetail invoiceAccountDetail = this.buildInvoiceAccountDetailForAwardAccount(awardAccount2, document.getDocumentNumber());
                ContractsGrantsLetterOfCreditReviewDetail locReviewDetail = this.retrieveMatchingLetterOfCreditReviewDetail(awardAccount2, accountDetails);
                List<Balance> glBalances = this.retrieveBalances(fiscalYear, awardAccount2.getChartOfAccountsCode(), awardAccount2.getAccountNumber(), balanceTypeCodeList);
                KualiDecimal awardAccountBudgetAmount = KualiDecimal.ZERO;
                KualiDecimal awardAccountCumulativeAmount = KualiDecimal.ZERO;
                for (Balance balance : glBalances) {
                    if (!this.isBalanceCostShare(balance)) {
                        if (balance.getBalanceTypeCode().equalsIgnoreCase(systemOptions.getBudgetCheckingBalanceTypeCd())) {
                            awardAccountBudgetAmount = this.addBalanceToAwardAccountBudgetAmount(balance, awardAccountBudgetAmount, firstFiscalPeriod);
                            this.updateCategoryBudgetAmountsByBalance(balance, budgetAmountsByCostCategory, firstFiscalPeriod);
                        } else if (balance.getBalanceTypeCode().equalsIgnoreCase(systemOptions.getActualFinancialBalanceTypeCd())) {
                            awardAccountCumulativeAmount = this.addBalanceToAwardAccountCumulativeAmount(document, balance, award, awardAccountCumulativeAmount, firstFiscalPeriod);
                            this.updateCategoryActualAmountsByBalance(document, balance, award, invoiceDetailAccountObjectsCodes, firstFiscalPeriod);
                        }
                    }
                    invoiceAccountDetail.setTotalBudget(awardAccountBudgetAmount);
                    invoiceAccountDetail.setCumulativeExpenditures(awardAccountCumulativeAmount);
                }
                invoiceAccountDetails.add(invoiceAccountDetail);
                if (!ObjectUtils.isNull((Object)((Object)locReviewDetail)) && !((KualiDecimal)locReviewDetail.getClaimOnCashBalance().negated()).equals((Object)locReviewDetail.getAmountToDraw()) && ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)award)) {
                    this.distributeAmountAmongAllAccountObjectCodes(document, awardAccount2, invoiceDetailAccountObjectsCodes, locReviewDetail);
                    continue;
                }
                this.updateInvoiceDetailAccountObjectCodesByBilledAmount(awardAccount2, invoiceDetailAccountObjectsCodes);
            }
            document.getAccountDetails().addAll(invoiceAccountDetails);
            if (!ArConstants.BillingFrequencyValues.isMilestone(document.getInvoiceGeneralDetail()) && !ArConstants.BillingFrequencyValues.isPredeterminedBilling(document.getInvoiceGeneralDetail())) {
                document.getInvoiceDetailAccountObjectCodes().addAll(invoiceDetailAccountObjectsCodes);
                List<AwardAccountObjectCodeTotalBilled> awardAccountObjectCodeTotalBilleds = this.getAwardAccountObjectCodeTotalBilledDao().getAwardAccountObjectCodeTotalBuildByProposalNumberAndAccount(awardAccounts);
                List<ContractsGrantsInvoiceDetail> invoiceDetails = this.generateValuesForCategories(document.getDocumentNumber(), document.getInvoiceDetailAccountObjectCodes(), budgetAmountsByCostCategory, awardAccountObjectCodeTotalBilleds);
                document.getInvoiceDetails().addAll(invoiceDetails);
            }
            this.populateContractsGrantsInvoiceDocument(award, document, accountDetails, locCreationType);
        }
    }

    protected ContractsGrantsLetterOfCreditReviewDetail retrieveMatchingLetterOfCreditReviewDetail(ContractsAndGrantsBillingAwardAccount awardAccount, List<ContractsGrantsLetterOfCreditReviewDetail> accountDetails) {
        if (CollectionUtils.isEmpty(accountDetails)) {
            return null;
        }
        for (ContractsGrantsLetterOfCreditReviewDetail reviewDetail : accountDetails) {
            if (!reviewDetail.getProposalNumber().equals(awardAccount.getProposalNumber()) || !StringUtils.equals((CharSequence)reviewDetail.getChartOfAccountsCode(), (CharSequence)awardAccount.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)reviewDetail.getAccountNumber(), (CharSequence)awardAccount.getAccountNumber())) continue;
            return reviewDetail;
        }
        return null;
    }

    protected void updateCategoryActualAmountsByBalance(ContractsGrantsInvoiceDocument document, Balance balance, ContractsAndGrantsBillingAward award, List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes, boolean firstFiscalPeriod) {
        CostCategory category = this.getCostCategoryService().getCostCategoryForObjectCode(balance.getUniversityFiscalYear(), balance.getChartOfAccountsCode(), balance.getObjectCode());
        if (!ObjectUtils.isNull((Object)((Object)category))) {
            InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = this.getInvoiceDetailAccountObjectCodeByBalanceAndCategory(invoiceDetailAccountObjectCodes, balance, document.getDocumentNumber(), document.getInvoiceGeneralDetail().getProposalNumber(), category);
            if (ArConstants.BillingFrequencyValues.isTimeBased(document.getInvoiceGeneralDetail())) {
                if (firstFiscalPeriod) {
                    invoiceDetailAccountObjectCode.setCumulativeExpenditures((KualiDecimal)((KualiDecimal)this.cleanAmount(invoiceDetailAccountObjectCode.getCumulativeExpenditures()).add((AbstractKualiDecimal)this.cleanAmount(balance.getContractsGrantsBeginningBalanceAmount()))).add((AbstractKualiDecimal)this.cleanAmount(balance.getAccountLineAnnualBalanceAmount())));
                    if (!this.includePeriod13InPeriod01Calculations()) {
                        invoiceDetailAccountObjectCode.setCumulativeExpenditures((KualiDecimal)this.cleanAmount(invoiceDetailAccountObjectCode.getCumulativeExpenditures()).subtract((AbstractKualiDecimal)this.cleanAmount(balance.getMonth13Amount())));
                    }
                } else {
                    invoiceDetailAccountObjectCode.setCumulativeExpenditures((KualiDecimal)this.cleanAmount(invoiceDetailAccountObjectCode.getCumulativeExpenditures()).add((AbstractKualiDecimal)this.calculateBalanceAmountWithoutLastBilledPeriod(document.getInvoiceGeneralDetail().getLastBilledDate(), balance)));
                }
            } else {
                this.cleanAmount(balance.getContractsGrantsBeginningBalanceAmount()).add((AbstractKualiDecimal)this.cleanAmount(balance.getAccountLineAnnualBalanceAmount()));
                invoiceDetailAccountObjectCode.setCumulativeExpenditures((KualiDecimal)this.cleanAmount(invoiceDetailAccountObjectCode.getCumulativeExpenditures()).add(this.cleanAmount(balance.getContractsGrantsBeginningBalanceAmount()).add((AbstractKualiDecimal)this.cleanAmount(balance.getAccountLineAnnualBalanceAmount()))));
            }
        }
    }

    protected KualiDecimal addBalanceToAwardAccountCumulativeAmount(ContractsGrantsInvoiceDocument document, Balance balance, ContractsAndGrantsBillingAward award, KualiDecimal awardAccountCumulativeAmount, boolean firstFiscalPeriod) {
        if (ArConstants.BillingFrequencyValues.isTimeBased(document.getInvoiceGeneralDetail())) {
            if (firstFiscalPeriod) {
                KualiDecimal newAwardAccountCumulativeAmount = (KualiDecimal)((KualiDecimal)awardAccountCumulativeAmount.add((AbstractKualiDecimal)this.cleanAmount(balance.getContractsGrantsBeginningBalanceAmount()))).add((AbstractKualiDecimal)this.cleanAmount(balance.getAccountLineAnnualBalanceAmount()));
                if (!this.includePeriod13InPeriod01Calculations()) {
                    newAwardAccountCumulativeAmount = (KualiDecimal)newAwardAccountCumulativeAmount.subtract((AbstractKualiDecimal)balance.getMonth13Amount());
                }
                return newAwardAccountCumulativeAmount;
            }
            return (KualiDecimal)awardAccountCumulativeAmount.add((AbstractKualiDecimal)this.calculateBalanceAmountWithoutLastBilledPeriod(award.getLastBilledDate(), balance));
        }
        KualiDecimal balanceAmount = (KualiDecimal)this.cleanAmount(balance.getContractsGrantsBeginningBalanceAmount()).add((AbstractKualiDecimal)this.cleanAmount(balance.getAccountLineAnnualBalanceAmount()));
        return (KualiDecimal)awardAccountCumulativeAmount.add((AbstractKualiDecimal)balanceAmount);
    }

    protected void updateCategoryBudgetAmountsByBalance(Balance balance, Map<String, KualiDecimal> budgetAmountsByCostCategory, boolean firstFiscalPeriod) {
        CostCategory category = this.getCostCategoryService().getCostCategoryForObjectCode(balance.getUniversityFiscalYear(), balance.getChartOfAccountsCode(), balance.getObjectCode());
        if (!ObjectUtils.isNull((Object)((Object)category))) {
            KualiDecimal balanceAmount = this.getBudgetBalanceAmount(balance, firstFiscalPeriod);
            KualiDecimal categoryBudgetAmount = budgetAmountsByCostCategory.get(category.getCategoryCode());
            if (categoryBudgetAmount == null) {
                categoryBudgetAmount = KualiDecimal.ZERO;
            }
            categoryBudgetAmount = (KualiDecimal)categoryBudgetAmount.add((AbstractKualiDecimal)balanceAmount);
            budgetAmountsByCostCategory.put(category.getCategoryCode(), categoryBudgetAmount);
        } else {
            LOG.warn("Could not find cost category for balance: " + balance.getUniversityFiscalYear() + " " + balance.getChartOfAccountsCode() + " " + balance.getAccountNumber() + " " + balance.getSubAccountNumber() + " " + balance.getObjectCode() + " " + balance.getSubObjectCode() + " " + balance.getBalanceTypeCode());
        }
    }

    protected KualiDecimal addBalanceToAwardAccountBudgetAmount(Balance balance, KualiDecimal awardAccountBudgetAmount, boolean firstFiscalPeriod) {
        KualiDecimal balanceAmount = this.getBudgetBalanceAmount(balance, firstFiscalPeriod);
        return (KualiDecimal)awardAccountBudgetAmount.add((AbstractKualiDecimal)balanceAmount);
    }

    protected KualiDecimal getBudgetBalanceAmount(Balance balance, boolean firstFiscalPeriod) {
        KualiDecimal balanceAmount = (KualiDecimal)balance.getContractsGrantsBeginningBalanceAmount().add((AbstractKualiDecimal)balance.getAccountLineAnnualBalanceAmount());
        if (firstFiscalPeriod && !this.includePeriod13InPeriod01Calculations()) {
            balanceAmount = (KualiDecimal)balanceAmount.subtract((AbstractKualiDecimal)balance.getMonth13Amount());
        }
        return balanceAmount;
    }

    protected InvoiceAccountDetail buildInvoiceAccountDetailForAwardAccount(ContractsAndGrantsBillingAwardAccount awardAccount, String documentNumber) {
        InvoiceAccountDetail invoiceAccountDetail = new InvoiceAccountDetail();
        invoiceAccountDetail.setDocumentNumber(documentNumber);
        invoiceAccountDetail.setAccountNumber(awardAccount.getAccountNumber());
        invoiceAccountDetail.setChartOfAccountsCode(awardAccount.getChartOfAccountsCode());
        invoiceAccountDetail.setProposalNumber(awardAccount.getProposalNumber());
        return invoiceAccountDetail;
    }

    protected List<InvoiceBill> buildInvoiceBills(List<Bill> bills) {
        List<Bill> billsToInvoice = this.contractsGrantsBillingAwardVerificationService.determineBillsToInvoice(bills);
        return billsToInvoice.stream().map(InvoiceBill::new).collect(Collectors.toList());
    }

    protected List<InvoiceMilestone> buildInvoiceMilestones(List<Milestone> milestones) {
        List<Milestone> milestonesToInvoice = this.contractsGrantsBillingAwardVerificationService.determineMilestonesToInvoice(milestones);
        return milestonesToInvoice.stream().map(InvoiceMilestone::new).collect(Collectors.toList());
    }

    protected List<InvoiceAddressDetail> buildInvoiceAddressDetailsFromAgency(ContractsAndGrantsBillingAgency agency, ContractsGrantsInvoiceDocument document) {
        HashMap<String, String> mapKey = new HashMap<String, String>();
        mapKey.put("customerNumber", agency.getCustomerNumber());
        List customerAddresses = (List)this.businessObjectService.findMatching(CustomerAddress.class, mapKey);
        String documentNumber = document.getDocumentNumber();
        ArrayList<InvoiceAddressDetail> invoiceAddressDetails = new ArrayList<InvoiceAddressDetail>();
        for (CustomerAddress customerAddress : customerAddresses) {
            if (StringUtils.equalsIgnoreCase((CharSequence)"P", (CharSequence)customerAddress.getCustomerAddressTypeCode())) {
                document.setCustomerBillToAddressOnInvoice(customerAddress);
            }
            InvoiceAddressDetail invoiceAddressDetail = new InvoiceAddressDetail();
            invoiceAddressDetail.setCustomerNumber(customerAddress.getCustomerNumber());
            invoiceAddressDetail.setDocumentNumber(documentNumber);
            invoiceAddressDetail.setCustomerAddressIdentifier(customerAddress.getCustomerAddressIdentifier());
            invoiceAddressDetail.setCustomerAddressTypeCode(customerAddress.getCustomerAddressTypeCode());
            invoiceAddressDetail.setCustomerAddressName(customerAddress.getCustomerAddressName());
            invoiceAddressDetail.setInvoiceTransmissionMethodCode(customerAddress.getInvoiceTransmissionMethodCode());
            invoiceAddressDetail.setCustomerEmailAddress(customerAddress.getCustomerEmailAddress());
            invoiceAddressDetail.setCustomerLine1StreetAddress(customerAddress.getCustomerLine1StreetAddress());
            invoiceAddressDetail.setCustomerLine2StreetAddress(customerAddress.getCustomerLine2StreetAddress());
            invoiceAddressDetail.setCustomerCityName(customerAddress.getCustomerCityName());
            invoiceAddressDetail.setCustomerStateCode(customerAddress.getCustomerStateCode());
            invoiceAddressDetail.setCustomerZipCode(customerAddress.getCustomerZipCode());
            invoiceAddressDetail.setCustomerCountryCode(customerAddress.getCustomerCountryCode());
            invoiceAddressDetail.setCustomerInternationalMailCode(customerAddress.getCustomerInternationalMailCode());
            invoiceAddressDetail.setCustomerAddressInternationalProvinceName(customerAddress.getCustomerAddressInternationalProvinceName());
            if (StringUtils.isNotBlank((CharSequence)customerAddress.getCustomerInvoiceTemplateCode())) {
                invoiceAddressDetail.setCustomerInvoiceTemplateCode(customerAddress.getCustomerInvoiceTemplateCode());
            } else {
                AccountsReceivableCustomer customer = agency.getCustomer();
                if (ObjectUtils.isNotNull((Object)customer) && StringUtils.isNotBlank((CharSequence)customer.getCustomerInvoiceTemplateCode())) {
                    invoiceAddressDetail.setCustomerInvoiceTemplateCode(customer.getCustomerInvoiceTemplateCode());
                }
            }
            invoiceAddressDetails.add(invoiceAddressDetail);
        }
        return invoiceAddressDetails;
    }

    public List<ContractsGrantsInvoiceDetail> generateValuesForCategories(String documentNumber, List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes, Map<String, KualiDecimal> budgetAmountsByCostCategory, List<AwardAccountObjectCodeTotalBilled> awardAccountObjectCodeTotalBilleds) {
        Collection<CostCategory> costCategories = this.retrieveAllBillingCategories();
        ArrayList<ContractsGrantsInvoiceDetail> invoiceDetails = new ArrayList<ContractsGrantsInvoiceDetail>();
        Map<String, List<InvoiceDetailAccountObjectCode>> invoiceDetailAccountObjectCodesMap = this.mapInvoiceDetailAccountObjectCodesByCategoryCode(invoiceDetailAccountObjectCodes);
        Map<String, List<AwardAccountObjectCodeTotalBilled>> billedsMap = this.mapAwardAccountObjectCodeTotalBilledsByCategoryCode(awardAccountObjectCodeTotalBilleds);
        for (CostCategory category : costCategories) {
            List<AwardAccountObjectCodeTotalBilled> billedForCategory;
            ContractsGrantsInvoiceDetail invDetail = new ContractsGrantsInvoiceDetail();
            invDetail.setDocumentNumber(documentNumber);
            invDetail.setCategoryCode(category.getCategoryCode());
            invDetail.setCostCategory(category);
            invDetail.setIndirectCostIndicator(category.isIndirectCostIndicator());
            invDetail.setCumulativeExpenditures(KualiDecimal.ZERO);
            invDetail.setInvoiceAmount(KualiDecimal.ZERO);
            invDetail.setTotalPreviouslyBilled(KualiDecimal.ZERO);
            List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodesForCategory = invoiceDetailAccountObjectCodesMap.get(category.getCategoryCode());
            if (!CollectionUtils.isEmpty(invoiceDetailAccountObjectCodesForCategory)) {
                for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodesForCategory) {
                    invDetail.setCumulativeExpenditures((KualiDecimal)invDetail.getCumulativeExpenditures().add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCumulativeExpenditures()));
                    invDetail.setInvoiceAmount((KualiDecimal)invDetail.getInvoiceAmount().add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures()));
                }
            }
            if (!CollectionUtils.isEmpty(billedForCategory = billedsMap.get(category.getCategoryCode()))) {
                for (AwardAccountObjectCodeTotalBilled accountObjectCodeTotalBilled : billedForCategory) {
                    invDetail.setTotalPreviouslyBilled((KualiDecimal)invDetail.getTotalPreviouslyBilled().add((AbstractKualiDecimal)accountObjectCodeTotalBilled.getTotalBilled()));
                }
            }
            if (!ObjectUtils.isNull((Object)budgetAmountsByCostCategory.get(category.getCategoryCode()))) {
                invDetail.setTotalBudget(budgetAmountsByCostCategory.get(category.getCategoryCode()));
            } else {
                invDetail.setTotalBudget(KualiDecimal.ZERO);
            }
            invoiceDetails.add(invDetail);
        }
        return invoiceDetails;
    }

    protected Map<String, List<InvoiceDetailAccountObjectCode>> mapInvoiceDetailAccountObjectCodesByCategoryCode(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        HashMap<String, List<InvoiceDetailAccountObjectCode>> invoiceDetailAccountObjectCodesMap = new HashMap<String, List<InvoiceDetailAccountObjectCode>>();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            ArrayList<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodesForCategory = (ArrayList<InvoiceDetailAccountObjectCode>)invoiceDetailAccountObjectCodesMap.get(invoiceDetailAccountObjectCode.getCategoryCode());
            if (invoiceDetailAccountObjectCodesForCategory == null) {
                invoiceDetailAccountObjectCodesForCategory = new ArrayList<InvoiceDetailAccountObjectCode>();
            }
            invoiceDetailAccountObjectCodesForCategory.add(invoiceDetailAccountObjectCode);
            invoiceDetailAccountObjectCodesMap.put(invoiceDetailAccountObjectCode.getCategoryCode(), invoiceDetailAccountObjectCodesForCategory);
        }
        return invoiceDetailAccountObjectCodesMap;
    }

    protected Map<String, List<AwardAccountObjectCodeTotalBilled>> mapAwardAccountObjectCodeTotalBilledsByCategoryCode(List<AwardAccountObjectCodeTotalBilled> awardAccountObjectCodeTotalBilleds) {
        Integer fiscalYear = this.getUniversityDateService().getCurrentFiscalYear();
        HashMap<String, List<AwardAccountObjectCodeTotalBilled>> billedsMap = new HashMap<String, List<AwardAccountObjectCodeTotalBilled>>();
        for (AwardAccountObjectCodeTotalBilled billed : awardAccountObjectCodeTotalBilleds) {
            CostCategory category = this.getCostCategoryService().getCostCategoryForObjectCode(fiscalYear, billed.getChartOfAccountsCode(), billed.getFinancialObjectCode());
            if (!ObjectUtils.isNull((Object)((Object)category))) {
                ArrayList<AwardAccountObjectCodeTotalBilled> billedForCategory = (ArrayList<AwardAccountObjectCodeTotalBilled>)billedsMap.get(category.getCategoryCode());
                if (billedForCategory == null) {
                    billedForCategory = new ArrayList<AwardAccountObjectCodeTotalBilled>();
                }
                billedForCategory.add(billed);
                billedsMap.put(category.getCategoryCode(), billedForCategory);
                continue;
            }
            LOG.warn("Could not find cost category for AwardAccountObjectCodeTotalBilled, fiscal year = " + fiscalYear + " " + billed.getChartOfAccountsCode() + " " + billed.getFinancialObjectCode());
        }
        return billedsMap;
    }

    protected void populateInvoiceDetailFromAward(InvoiceGeneralDetail invoiceGeneralDetail, ContractsAndGrantsBillingAward award) {
        invoiceGeneralDetail.setAwardTotal(award.getAwardTotalAmount());
        invoiceGeneralDetail.setAgencyNumber(award.getAgencyNumber());
        if (ObjectUtils.isNotNull((Object)award.getBillingFrequencyCode())) {
            invoiceGeneralDetail.setBillingFrequencyCode(award.getBillingFrequencyCode());
        }
        if (ObjectUtils.isNotNull((Object)award.getInstrumentTypeCode())) {
            invoiceGeneralDetail.setInstrumentTypeCode(award.getInstrumentTypeCode());
        }
        String awdDtRange = this.getDateTimeService().toDateString((Date)award.getAwardBeginningDate()) + " to " + this.getDateTimeService().toDateString((Date)award.getAwardEndingDate());
        invoiceGeneralDetail.setAwardDateRange(awdDtRange);
        invoiceGeneralDetail.setTotalPreviouslyBilled(this.contractsGrantsInvoiceDocumentService.getAwardBilledToDateAmount(award.getProposalNumber()));
    }

    protected void distributeAmountAmongAllAccountObjectCodes(ContractsGrantsInvoiceDocument document, ContractsAndGrantsBillingAwardAccount awdAcct, List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectsCodes, ContractsGrantsLetterOfCreditReviewDetail locReviewDetail) {
        List<InvoiceDetailAccountObjectCode> locRedistributionInvoiceDetailAccountObjectCodes = this.filterInvoiceAccountObjectCodesByDocumentAndAccount(document, awdAcct, invoiceDetailAccountObjectsCodes);
        Map<String, List<InvoiceDetailAccountObjectCode>> locRedistributionAccountObjectCodesByCategory = this.mapInvoiceDetailAccountObjectCodesByCategoryCode(locRedistributionInvoiceDetailAccountObjectCodes);
        Map<String, BigDecimal> percentagesByCategory = this.calculatePercentagesByCategory(locRedistributionAccountObjectCodesByCategory, (KualiDecimal)locReviewDetail.getClaimOnCashBalance().negated());
        Map<String, KualiDecimal> amountsByCategory = this.calculateAmountsByCategory(percentagesByCategory, locReviewDetail.getAmountToDraw());
        this.redistributeAmountsToInvoiceAccountCategories(locRedistributionAccountObjectCodesByCategory, amountsByCategory);
        this.takeAPennyLeaveAPennyCGBStyle(locRedistributionInvoiceDetailAccountObjectCodes, locReviewDetail.getAmountToDraw());
    }

    protected List<InvoiceDetailAccountObjectCode> filterInvoiceAccountObjectCodesByDocumentAndAccount(ContractsGrantsInvoiceDocument document, ContractsAndGrantsBillingAwardAccount awdAcct, List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectsCodes) {
        ArrayList<InvoiceDetailAccountObjectCode> locRedistributionInvoiceDetailAccountObjectCodes = new ArrayList<InvoiceDetailAccountObjectCode>();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectsCodes) {
            if (!StringUtils.equals((CharSequence)invoiceDetailAccountObjectCode.getDocumentNumber(), (CharSequence)document.getDocumentNumber()) || !invoiceDetailAccountObjectCode.getProposalNumber().equals(document.getInvoiceGeneralDetail().getProposalNumber()) || !StringUtils.equals((CharSequence)invoiceDetailAccountObjectCode.getAccountNumber(), (CharSequence)awdAcct.getAccountNumber()) || !StringUtils.equals((CharSequence)invoiceDetailAccountObjectCode.getChartOfAccountsCode(), (CharSequence)awdAcct.getChartOfAccountsCode())) continue;
            locRedistributionInvoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode);
        }
        return locRedistributionInvoiceDetailAccountObjectCodes;
    }

    protected InvoiceDetailAccountObjectCode sumInvoiceDetailAccountObjectCodes(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        InvoiceDetailAccountObjectCode total = new InvoiceDetailAccountObjectCode();
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            total.setCumulativeExpenditures((KualiDecimal)total.getCumulativeExpenditures().add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCumulativeExpenditures()));
            total.setCurrentExpenditures((KualiDecimal)total.getCurrentExpenditures().add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures()));
            total.setTotalBilled((KualiDecimal)total.getTotalBilled().add((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getTotalBilled()));
        }
        return total;
    }

    protected Map<String, BigDecimal> calculatePercentagesByCategory(Map<String, List<InvoiceDetailAccountObjectCode>> invoiceDetailAccountObjectCodesByCategory, KualiDecimal total) {
        HashMap<String, BigDecimal> percentagesByCategory = new HashMap<String, BigDecimal>();
        for (String categoryCode : invoiceDetailAccountObjectCodesByCategory.keySet()) {
            if (total.equals((Object)KualiDecimal.ZERO)) {
                percentagesByCategory.put(categoryCode, BigDecimal.ZERO);
                continue;
            }
            percentagesByCategory.put(categoryCode, this.calculatePercentageByInvoiceDetailAccountObjectCodes(invoiceDetailAccountObjectCodesByCategory.get(categoryCode), total));
        }
        return percentagesByCategory;
    }

    protected BigDecimal calculatePercentageByInvoiceDetailAccountObjectCodes(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes, KualiDecimal total) {
        KualiDecimal cumulativeExpenditureTotal = this.sumInvoiceDetailAccountObjectCodes(invoiceDetailAccountObjectCodes).getCumulativeExpenditures();
        return cumulativeExpenditureTotal.bigDecimalValue().divide(total.bigDecimalValue(), 10, RoundingMode.HALF_UP);
    }

    protected Map<String, KualiDecimal> calculateAmountsByCategory(Map<String, BigDecimal> percentagesByCategory, KualiDecimal amount) {
        BigDecimal bigDecimalAmount = amount.bigDecimalValue().setScale(2, RoundingMode.HALF_UP);
        HashMap<String, KualiDecimal> amountsByCategory = new HashMap<String, KualiDecimal>();
        for (String categoryCode : percentagesByCategory.keySet()) {
            amountsByCategory.put(categoryCode, new KualiDecimal(bigDecimalAmount.multiply(percentagesByCategory.get(categoryCode))));
        }
        return amountsByCategory;
    }

    protected void redistributeAmountsToInvoiceAccountCategories(Map<String, List<InvoiceDetailAccountObjectCode>> redistributionAccountObjectCodesByCategory, Map<String, KualiDecimal> amountsByCategory) {
        for (String categoryCode : redistributionAccountObjectCodesByCategory.keySet()) {
            List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes = redistributionAccountObjectCodesByCategory.get(categoryCode);
            if (invoiceDetailAccountObjectCodes.size() == 1) {
                invoiceDetailAccountObjectCodes.get(0).setCurrentExpenditures(amountsByCategory.get(categoryCode));
                continue;
            }
            this.splitOutRedistribution(invoiceDetailAccountObjectCodes, amountsByCategory.get(categoryCode));
        }
    }

    protected void takeAPennyLeaveAPennyCGBStyle(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes, KualiDecimal amountToTarget) {
        KualiDecimal currentExpenditureTotal;
        if (!CollectionUtils.isEmpty(invoiceDetailAccountObjectCodes) && !(currentExpenditureTotal = this.sumInvoiceDetailAccountObjectCodes(invoiceDetailAccountObjectCodes).getCurrentExpenditures()).equals((Object)amountToTarget)) {
            KualiDecimal difference = (KualiDecimal)currentExpenditureTotal.subtract((AbstractKualiDecimal)amountToTarget);
            InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = this.findFirstPositiveCurrentExpenditureInvoiceDetailAccountObjectCode(invoiceDetailAccountObjectCodes);
            if (invoiceDetailAccountObjectCode != null) {
                invoiceDetailAccountObjectCode.setCurrentExpenditures((KualiDecimal)invoiceDetailAccountObjectCode.getCurrentExpenditures().subtract((AbstractKualiDecimal)difference));
            }
        }
    }

    protected InvoiceDetailAccountObjectCode findFirstPositiveCurrentExpenditureInvoiceDetailAccountObjectCode(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes) {
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            if (ObjectUtils.isNull((Object)invoiceDetailAccountObjectCode.getCurrentExpenditures()) || !invoiceDetailAccountObjectCode.getCurrentExpenditures().isPositive()) continue;
            return invoiceDetailAccountObjectCode;
        }
        return null;
    }

    protected void splitOutRedistribution(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes, KualiDecimal amount) {
        KualiDecimal amountEach = new KualiDecimal(amount.bigDecimalValue().divide(new BigDecimal(invoiceDetailAccountObjectCodes.size()), 2, RoundingMode.HALF_UP));
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectCodes) {
            invoiceDetailAccountObjectCode.setCurrentExpenditures(amountEach);
        }
    }

    protected void updateInvoiceDetailAccountObjectCodesByBilledAmount(ContractsAndGrantsBillingAwardAccount awdAcct, List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectsCodes) {
        List<AwardAccountObjectCodeTotalBilled> awardAccountObjectCodeTotalBilledList = this.retrieveBillingInformationForAwardAccount(awdAcct);
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectsCodes) {
            if (!StringUtils.equals((CharSequence)invoiceDetailAccountObjectCode.getChartOfAccountsCode(), (CharSequence)awdAcct.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)invoiceDetailAccountObjectCode.getAccountNumber(), (CharSequence)awdAcct.getAccountNumber())) continue;
            if (!CollectionUtils.isEmpty(awardAccountObjectCodeTotalBilledList)) {
                for (AwardAccountObjectCodeTotalBilled awardAccountObjectCodeTotalBilled : awardAccountObjectCodeTotalBilledList) {
                    if (!invoiceDetailAccountObjectCode.getFinancialObjectCode().equalsIgnoreCase(awardAccountObjectCodeTotalBilled.getFinancialObjectCode())) continue;
                    invoiceDetailAccountObjectCode.setTotalBilled(awardAccountObjectCodeTotalBilled.getTotalBilled());
                }
            }
            invoiceDetailAccountObjectCode.setCurrentExpenditures((KualiDecimal)invoiceDetailAccountObjectCode.getCumulativeExpenditures().subtract((AbstractKualiDecimal)invoiceDetailAccountObjectCode.getTotalBilled()));
        }
    }

    protected List<AwardAccountObjectCodeTotalBilled> retrieveBillingInformationForAwardAccount(ContractsAndGrantsBillingAwardAccount awdAcct) {
        HashMap<String, String> totalBilledKeys = new HashMap<String, String>();
        totalBilledKeys.put("proposalNumber", awdAcct.getProposalNumber());
        totalBilledKeys.put("chartOfAccountsCode", awdAcct.getChartOfAccountsCode());
        totalBilledKeys.put("accountNumber", awdAcct.getAccountNumber());
        return (List)this.businessObjectService.findMatching(AwardAccountObjectCodeTotalBilled.class, totalBilledKeys);
    }

    protected boolean isFirstFiscalPeriod() {
        AccountingPeriod currentPeriod = this.accountingPeriodService.getByDate(this.getDateTimeService().getCurrentSqlDate());
        return StringUtils.equals((CharSequence)currentPeriod.getUniversityFiscalPeriodCode(), (CharSequence)"01");
    }

    protected Collection<CostCategory> retrieveAllBillingCategories() {
        HashMap<String, Boolean> criteria = new HashMap<String, Boolean>();
        criteria.put("active", true);
        return this.businessObjectService.findMatching(CostCategory.class, criteria);
    }

    protected InvoiceDetailAccountObjectCode getInvoiceDetailAccountObjectCodeByBalanceAndCategory(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectCodes, Balance bal, String documentNumber, String proposalNumber, CostCategory category) {
        InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode = this.lookupInvoiceDetailAccountObjectCode(invoiceDetailAccountObjectCodes, bal, proposalNumber);
        if (ObjectUtils.isNull((Object)((Object)invoiceDetailAccountObjectCode))) {
            if (!ObjectUtils.isNull((Object)((Object)category))) {
                invoiceDetailAccountObjectCode = new InvoiceDetailAccountObjectCode();
                invoiceDetailAccountObjectCode.setDocumentNumber(documentNumber);
                invoiceDetailAccountObjectCode.setProposalNumber(proposalNumber);
                invoiceDetailAccountObjectCode.setFinancialObjectCode(bal.getObjectCode());
                invoiceDetailAccountObjectCode.setCategoryCode(category.getCategoryCode());
                invoiceDetailAccountObjectCode.setAccountNumber(bal.getAccountNumber());
                invoiceDetailAccountObjectCode.setChartOfAccountsCode(bal.getChartOfAccountsCode());
                invoiceDetailAccountObjectCodes.add(invoiceDetailAccountObjectCode);
            } else {
                LOG.warn("Could not find cost category for balance: " + bal.getUniversityFiscalYear() + " " + bal.getChartOfAccountsCode() + " " + bal.getAccountNumber() + " " + bal.getSubAccountNumber() + " " + bal.getObjectCode() + " " + bal.getSubObjectCode() + " " + bal.getBalanceTypeCode());
            }
        }
        return invoiceDetailAccountObjectCode;
    }

    protected InvoiceDetailAccountObjectCode lookupInvoiceDetailAccountObjectCode(List<InvoiceDetailAccountObjectCode> invoiceDetailAccountObjectsCodes, Balance bal, String proposalNumber) {
        for (InvoiceDetailAccountObjectCode invoiceDetailAccountObjectCode : invoiceDetailAccountObjectsCodes) {
            if (!StringUtils.equals((CharSequence)bal.getChartOfAccountsCode(), (CharSequence)invoiceDetailAccountObjectCode.getChartOfAccountsCode()) || !StringUtils.equals((CharSequence)bal.getAccountNumber(), (CharSequence)invoiceDetailAccountObjectCode.getAccountNumber()) || !StringUtils.equals((CharSequence)bal.getObjectCode(), (CharSequence)invoiceDetailAccountObjectCode.getFinancialObjectCode()) || !Objects.equals(proposalNumber, invoiceDetailAccountObjectCode.getProposalNumber())) continue;
            return invoiceDetailAccountObjectCode;
        }
        return null;
    }

    protected boolean isBalanceCostShare(Balance bal) {
        return ObjectUtils.isNotNull((Object)bal.getSubAccount()) && ObjectUtils.isNotNull((Object)bal.getSubAccount().getA21SubAccount()) && StringUtils.equalsIgnoreCase((CharSequence)bal.getSubAccount().getA21SubAccount().getSubAccountTypeCode(), (CharSequence)"CS");
    }

    protected List<Balance> retrieveBalances(Integer fiscalYear, String chartOfAccountsCode, String accountNumber, List<String> balanceTypeCodeList) {
        HashMap<String, Object> balanceKeys = new HashMap<String, Object>();
        balanceKeys.put("chartOfAccountsCode", chartOfAccountsCode);
        balanceKeys.put("accountNumber", accountNumber);
        balanceKeys.put("universityFiscalYear", fiscalYear);
        balanceKeys.put("objectTypeCode", this.retrieveExpenseObjectTypes());
        balanceKeys.put("balanceTypeCode", balanceTypeCodeList);
        return (List)this.getBusinessObjectService().findMatching(Balance.class, balanceKeys);
    }

    protected boolean includePeriod13InPeriod01Calculations() {
        return this.getParameterService().getParameterValueAsBoolean(ContractsGrantsInvoiceDocument.class, "INCLUDE_PERIOD_13_IN_BUDGET_AND_CURRENT_IND", Boolean.FALSE);
    }

    protected void populateContractsGrantsInvoiceDocument(ContractsAndGrantsBillingAward award, ContractsGrantsInvoiceDocument document, List<ContractsGrantsLetterOfCreditReviewDetail> locReviewDetails, String locCreationType) {
        if (ObjectUtils.isNotNull((Object)award.getAgency())) {
            Customer customer;
            if (ObjectUtils.isNotNull((Object)((Object)document.getAccountsReceivableDocumentHeader()))) {
                document.getAccountsReceivableDocumentHeader().setCustomerNumber(award.getAgency().getCustomerNumber());
            }
            if (ObjectUtils.isNotNull((Object)((Object)(customer = this.getCustomerService().getByPrimaryKey(award.getAgency().getCustomerNumber()))))) {
                document.setCustomerName(customer.getCustomerName());
            }
        }
        document.setOpenInvoiceIndicator(true);
        if (!StringUtils.isBlank((CharSequence)locCreationType)) {
            document.getInvoiceGeneralDetail().setLetterOfCreditCreationType(locCreationType);
        }
        if (StringUtils.isNotEmpty((CharSequence)award.getLetterOfCreditFundCode())) {
            document.getInvoiceGeneralDetail().setLetterOfCreditFundCode(award.getLetterOfCreditFundCode());
        }
        if (ObjectUtils.isNotNull((Object)award.getLetterOfCreditFund()) && StringUtils.isNotEmpty((CharSequence)award.getLetterOfCreditFund().getLetterOfCreditFundGroupCode())) {
            document.getInvoiceGeneralDetail().setLetterOfCreditFundGroupCode(award.getLetterOfCreditFund().getLetterOfCreditFundGroupCode());
        }
        KualiDecimal totalAmountBilledToDate = document.getInvoiceMilestones().size() > 0 ? this.calculateMilestoneAmount(document) : (document.getInvoiceBills().size() > 0 ? this.calculateTotalBillAmount(document) : (KualiDecimal)this.calculateTotalExpenditureAmount(document, locReviewDetails).add((AbstractKualiDecimal)this.getContractsGrantsInvoiceDocumentService().getOtherTotalBilledForAwardPeriod(document)));
        document.getInvoiceGeneralDetail().setTotalAmountBilledToDate(totalAmountBilledToDate);
    }

    protected KualiDecimal calculateMilestoneAmount(ContractsGrantsInvoiceDocument document) {
        KualiDecimal totalMilestoneAmount = KualiDecimal.ZERO;
        if (document.getInvoiceMilestones().size() > 0) {
            for (InvoiceMilestone milestone : document.getInvoiceMilestones()) {
                if (milestone.getMilestoneAmount() == null) continue;
                totalMilestoneAmount = (KualiDecimal)totalMilestoneAmount.add((AbstractKualiDecimal)milestone.getMilestoneAmount());
            }
        }
        totalMilestoneAmount = (KualiDecimal)totalMilestoneAmount.add((AbstractKualiDecimal)document.getInvoiceGeneralDetail().getTotalPreviouslyBilled());
        return totalMilestoneAmount;
    }

    protected KualiDecimal calculateTotalBillAmount(ContractsGrantsInvoiceDocument document) {
        KualiDecimal totalBillAmount = KualiDecimal.ZERO;
        if (document.getInvoiceBills().size() > 0) {
            for (InvoiceBill bill : document.getInvoiceBills()) {
                if (bill.getEstimatedAmount() == null) continue;
                totalBillAmount = (KualiDecimal)totalBillAmount.add((AbstractKualiDecimal)bill.getEstimatedAmount());
            }
        }
        totalBillAmount = (KualiDecimal)totalBillAmount.add((AbstractKualiDecimal)document.getInvoiceGeneralDetail().getTotalPreviouslyBilled());
        return totalBillAmount;
    }

    protected KualiDecimal calculateTotalExpenditureAmount(ContractsGrantsInvoiceDocument document, List<ContractsGrantsLetterOfCreditReviewDetail> locReviewDetails) {
        HashMap<String, KualiDecimal> totalBilledByAccountNumberMap = new HashMap<String, KualiDecimal>();
        for (InvoiceDetailAccountObjectCode objectCode : document.getInvoiceDetailAccountObjectCodes()) {
            String key = objectCode.getChartOfAccountsCode() + "-" + objectCode.getAccountNumber();
            KualiDecimal totalBilled = this.cleanAmount((KualiDecimal)totalBilledByAccountNumberMap.get(key));
            totalBilled = (KualiDecimal)totalBilled.add((AbstractKualiDecimal)objectCode.getTotalBilled());
            totalBilledByAccountNumberMap.put(key, totalBilled);
        }
        KualiDecimal totalExpendituredAmount = KualiDecimal.ZERO;
        for (InvoiceAccountDetail invAcctD : document.getAccountDetails()) {
            ContractsAndGrantsBillingAward award;
            String chartOfAccountsCode = invAcctD.getChartOfAccountsCode();
            String accountNumber = invAcctD.getAccountNumber();
            String key = chartOfAccountsCode + "-" + accountNumber;
            if (!ObjectUtils.isNull(totalBilledByAccountNumberMap.get(key))) {
                invAcctD.setTotalPreviouslyBilled((KualiDecimal)totalBilledByAccountNumberMap.get(key));
            } else {
                invAcctD.setTotalPreviouslyBilled(KualiDecimal.ZERO);
            }
            if (invAcctD.getTotalPreviouslyBilled().isZero()) {
                String proposalNumber = document.getInvoiceGeneralDetail().getProposalNumber();
                KualiDecimal previouslyBilledAmount = KualiDecimal.ZERO;
                previouslyBilledAmount = (KualiDecimal)previouslyBilledAmount.add((AbstractKualiDecimal)this.contractsGrantsInvoiceDocumentService.getPredeterminedBillingBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber));
                previouslyBilledAmount = (KualiDecimal)previouslyBilledAmount.add((AbstractKualiDecimal)this.contractsGrantsInvoiceDocumentService.getMilestonesBilledToDateAmount(proposalNumber, chartOfAccountsCode, accountNumber));
                invAcctD.setTotalPreviouslyBilled(previouslyBilledAmount);
            }
            KualiDecimal currentExpenditureAmount = (KualiDecimal)invAcctD.getCumulativeExpenditures().subtract((AbstractKualiDecimal)invAcctD.getTotalPreviouslyBilled());
            invAcctD.setInvoiceAmount(currentExpenditureAmount);
            if (!ObjectUtils.isNull((Object)((Object)document.getInvoiceGeneralDetail())) && ObjectUtils.isNotNull((Object)(award = document.getInvoiceGeneralDetail().getAward())) && ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)award) && !CollectionUtils.isEmpty(locReviewDetails)) {
                for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                    ContractsGrantsLetterOfCreditReviewDetail locReviewDetail = this.retrieveMatchingLetterOfCreditReviewDetail(awardAccount, locReviewDetails);
                    if (ObjectUtils.isNull((Object)((Object)locReviewDetail)) || !StringUtils.equals((CharSequence)awardAccount.getChartOfAccountsCode(), (CharSequence)chartOfAccountsCode) || !StringUtils.equals((CharSequence)awardAccount.getAccountNumber(), (CharSequence)accountNumber)) continue;
                    currentExpenditureAmount = locReviewDetail.getAmountToDraw();
                    invAcctD.setInvoiceAmount(currentExpenditureAmount);
                }
            }
            totalExpendituredAmount = (KualiDecimal)totalExpendituredAmount.add((AbstractKualiDecimal)currentExpenditureAmount);
        }
        totalExpendituredAmount = (KualiDecimal)totalExpendituredAmount.add((AbstractKualiDecimal)document.getInvoiceGeneralDetail().getTotalPreviouslyBilled());
        return totalExpendituredAmount;
    }

    protected KualiDecimal calculateBalanceAmountWithoutLastBilledPeriod(java.sql.Date lastBilledDate, Balance glBalance) {
        Timestamp ts = new Timestamp(new Date().getTime());
        java.sql.Date today = new java.sql.Date(ts.getTime());
        AccountingPeriod currPeriod = this.accountingPeriodService.getByDate(today);
        String currentPeriodCode = currPeriod.getUniversityFiscalPeriodCode();
        KualiDecimal currentBalanceAmount = KualiDecimal.ZERO;
        switch (currentPeriodCode) {
            case "13": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth12Amount()));
            }
            case "12": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth11Amount()));
            }
            case "11": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth10Amount()));
            }
            case "10": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth9Amount()));
            }
            case "09": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth8Amount()));
            }
            case "08": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth7Amount()));
            }
            case "07": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth6Amount()));
            }
            case "06": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth5Amount()));
            }
            case "05": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth4Amount()));
            }
            case "04": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth3Amount()));
            }
            case "03": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth2Amount()));
            }
            case "02": {
                currentBalanceAmount = (KualiDecimal)currentBalanceAmount.add((AbstractKualiDecimal)this.cleanAmount(glBalance.getMonth1Amount()));
                break;
            }
        }
        return (KualiDecimal)glBalance.getContractsGrantsBeginningBalanceAmount().add((AbstractKualiDecimal)currentBalanceAmount);
    }

    protected KualiDecimal cleanAmount(KualiDecimal amount) {
        return amount == null ? KualiDecimal.ZERO : amount;
    }

    @Override
    public Collection<ContractsAndGrantsBillingAward> retrieveAllAwards() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("active", true);
        return this.kualiModuleService.getResponsibleModuleService(ContractsAndGrantsBillingAward.class).getExternalizableBusinessObjectsList(ContractsAndGrantsBillingAward.class, map);
    }

    @Override
    public Collection<ContractsAndGrantsBillingAward> validateAwards(Collection<ContractsAndGrantsBillingAward> awards, Collection<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs, String errOutputFile, String creationProcessTypeCode) {
        HashMap<ContractsAndGrantsBillingAward, List<String>> invalidGroup = new HashMap<ContractsAndGrantsBillingAward, List<String>>();
        ArrayList<ContractsAndGrantsBillingAward> qualifiedAwards = new ArrayList<ContractsAndGrantsBillingAward>();
        if (ObjectUtils.isNull(contractsGrantsInvoiceDocumentErrorLogs)) {
            contractsGrantsInvoiceDocumentErrorLogs = new ArrayList<ContractsGrantsInvoiceDocumentErrorLog>();
        }
        this.performAwardValidation(awards, invalidGroup, qualifiedAwards);
        if (!CollectionUtils.isEmpty(invalidGroup)) {
            if (StringUtils.isNotBlank((CharSequence)errOutputFile)) {
                this.writeErrorToFile(invalidGroup, errOutputFile);
            }
            this.storeValidationErrors(invalidGroup, contractsGrantsInvoiceDocumentErrorLogs, creationProcessTypeCode);
        }
        return qualifiedAwards;
    }

    protected void performAwardValidation(Collection<ContractsAndGrantsBillingAward> awards, Map<ContractsAndGrantsBillingAward, List<String>> invalidGroup, List<ContractsAndGrantsBillingAward> qualifiedAwards) {
        Set<ContractsAndGrantsBillingAward> awardsWithDuplicateAccounts = this.findAwardsWithDuplicateAccounts(awards);
        for (ContractsAndGrantsBillingAward award : awards) {
            ArrayList<String> errorList = new ArrayList<String>();
            if (award.isExcludedFromInvoicing()) {
                errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.award.excluded.from.invoicing"));
            } else {
                if (awardsWithDuplicateAccounts.contains(award)) {
                    errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.account.on.multiple.awards"));
                }
                if (ArConstants.BillingFrequencyValues.isLetterOfCredit((Billable)award)) {
                    errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.award.locb.billing.frequency"));
                } else if (award.getAwardBeginningDate() != null) {
                    if (award.getBillingFrequencyCode() != null && this.getContractsGrantsBillingAwardVerificationService().isValueOfBillingFrequencyValid(award)) {
                        if (this.verifyBillingFrequencyService.validateBillingFrequency(award)) {
                            this.validateAward(errorList, award);
                        } else {
                            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.eligible.invoice"));
                        }
                    } else {
                        errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.billing.missing.frequency"));
                    }
                } else {
                    errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.award.startDate.missing"));
                }
            }
            if (errorList.size() > 0) {
                invalidGroup.put(award, errorList);
                continue;
            }
            qualifiedAwards.add(award);
        }
    }

    protected Set<ContractsAndGrantsBillingAward> findAwardsWithDuplicateAccounts(Collection<ContractsAndGrantsBillingAward> awards) {
        Map accountMap = awards.stream().flatMap(award -> award.getActiveAwardAccounts().stream().map(awardAccount -> new AbstractMap.SimpleEntry<String, ContractsAndGrantsBillingAward>(awardAccount.getAccountNumber(), (ContractsAndGrantsBillingAward)award))).collect(Collectors.groupingBy(Map.Entry::getKey, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
        return accountMap.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 1).flatMap(entry -> ((List)entry.getValue()).stream()).collect(Collectors.toSet());
    }

    protected void validateAward(List<String> errorList, ContractsAndGrantsBillingAward award) {
        List<String> errorString;
        if (!award.isActive()) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.award.inactive"));
        }
        if (StringUtils.isEmpty((CharSequence)award.getInvoicingOptionCode())) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.award.missing"));
        }
        if (CollectionUtils.isEmpty((Collection)award.getActiveAwardAccounts())) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.no.active.accounts.assigned"));
        }
        if (this.getContractsGrantsBillingAwardVerificationService().isAwardFinalInvoiceAlreadyBuilt(award)) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.already.billed"));
        }
        if (ArConstants.BillingFrequencyValues.isMilestone((Billable)award) && !this.getContractsGrantsBillingAwardVerificationService().hasMilestonesToInvoice(award)) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.valid.milestones"));
        }
        if (ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)award) && !this.getContractsGrantsBillingAwardVerificationService().hasBillsToInvoice(award)) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.valid.bills"));
        }
        if (!this.getContractsGrantsBillingAwardVerificationService().owningAgencyHasCustomerRecord(award)) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.award.not.valid.customer"));
        }
        if (!this.hasBillableAccounts(award)) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cgivoice.award.not.valid.accounts"));
        }
        if (!CollectionUtils.isEmpty(errorString = this.contractsGrantsInvoiceDocumentService.checkAwardContractControlAccounts(award)) && errorString.size() > 1) {
            errorList.add(this.configurationService.getPropertyValueAsString(errorString.get(0)).replace("{0}", errorString.get(1)));
        }
        if (award.getPrimaryAwardOrganization() == null && this.configurationService.getPropertyValueAsBoolean("module.external.kuali.coeus.enabled")) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.account.auto.creation.not.setup"));
            return;
        }
        if (!this.getContractsGrantsBillingAwardVerificationService().isChartAndOrgSetupForInvoicing(award)) {
            errorList.add(this.configurationService.getPropertyValueAsString("error.cginvoice.sys.info.not.setup"));
        }
    }

    protected void writeErrorToFile(Map<ContractsAndGrantsBillingAward, List<String>> invalidGroup, String errOutputFile) {
        File errOutPutfile = new File(errOutputFile);
        try (PrintStream outputFileStream = null;){
            outputFileStream = new PrintStream(errOutPutfile);
            this.writeReportHeader(outputFileStream);
            for (ContractsAndGrantsBillingAward award : invalidGroup.keySet()) {
                this.writeErrorEntryByAward(award, invalidGroup.get(award), outputFileStream);
            }
            outputFileStream.print("\r\n");
        }
    }

    protected void storeValidationErrors(Map<ContractsAndGrantsBillingAward, List<String>> invalidGroup, Collection<ContractsGrantsInvoiceDocumentErrorLog> contractsGrantsInvoiceDocumentErrorLogs, String creationProcessTypeCode) {
        for (ContractsAndGrantsBillingAward award : invalidGroup.keySet()) {
            KualiDecimal cumulativeExpenses = KualiDecimal.ZERO;
            ContractsGrantsInvoiceDocumentErrorLog contractsGrantsInvoiceDocumentErrorLog = new ContractsGrantsInvoiceDocumentErrorLog();
            if (ObjectUtils.isNotNull((Object)award)) {
                java.sql.Date beginningDate = award.getAwardBeginningDate();
                java.sql.Date endingDate = award.getAwardEndingDate();
                SystemOptions systemOptions = this.optionsService.getCurrentYearOptions();
                contractsGrantsInvoiceDocumentErrorLog.setProposalNumber(award.getProposalNumber());
                contractsGrantsInvoiceDocumentErrorLog.setAwardBeginningDate(beginningDate);
                contractsGrantsInvoiceDocumentErrorLog.setAwardEndingDate(endingDate);
                contractsGrantsInvoiceDocumentErrorLog.setAwardTotalAmount(award.getAwardTotalAmount().bigDecimalValue());
                if (ObjectUtils.isNotNull((Object)award.getAwardPrimaryFundManager())) {
                    contractsGrantsInvoiceDocumentErrorLog.setPrimaryFundManagerPrincipalId(award.getAwardPrimaryFundManager().getPrincipalId());
                }
                if (!CollectionUtils.isEmpty((Collection)award.getActiveAwardAccounts())) {
                    boolean firstLineFlag = true;
                    for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                        cumulativeExpenses = (KualiDecimal)cumulativeExpenses.add((AbstractKualiDecimal)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, systemOptions.getActualFinancialBalanceTypeCd()));
                        if (firstLineFlag) {
                            firstLineFlag = false;
                            contractsGrantsInvoiceDocumentErrorLog.setAccounts(awardAccount.getAccountNumber());
                            continue;
                        }
                        contractsGrantsInvoiceDocumentErrorLog.setAccounts(contractsGrantsInvoiceDocumentErrorLog.getAccounts() + ";" + awardAccount.getAccountNumber());
                    }
                }
                contractsGrantsInvoiceDocumentErrorLog.setCumulativeExpensesAmount(cumulativeExpenses.bigDecimalValue());
            }
            for (String vCat : invalidGroup.get(award)) {
                ContractsGrantsInvoiceDocumentErrorMessage contractsGrantsInvoiceDocumentErrorCategory = new ContractsGrantsInvoiceDocumentErrorMessage();
                contractsGrantsInvoiceDocumentErrorCategory.setErrorMessageText(vCat);
                contractsGrantsInvoiceDocumentErrorLog.getErrorMessages().add(contractsGrantsInvoiceDocumentErrorCategory);
            }
            int errorAccountsMax = this.dataDictionaryService.getAttributeMaxLength(ContractsGrantsInvoiceDocumentErrorLog.class, "accounts");
            contractsGrantsInvoiceDocumentErrorLog.setAccounts(StringUtils.left((String)contractsGrantsInvoiceDocumentErrorLog.getAccounts(), (int)errorAccountsMax));
            contractsGrantsInvoiceDocumentErrorLog.setErrorDate(this.dateTimeService.getCurrentTimestamp());
            contractsGrantsInvoiceDocumentErrorLog.setCreationProcessTypeCode(creationProcessTypeCode);
            this.businessObjectService.save((PersistableBusinessObject)contractsGrantsInvoiceDocumentErrorLog);
            contractsGrantsInvoiceDocumentErrorLogs.add(contractsGrantsInvoiceDocumentErrorLog);
        }
    }

    protected void storeCreationErrors(List<ErrorMessage> errorMessages, String creationProcessTypeCode) {
        for (ErrorMessage errorMessage : errorMessages) {
            ContractsGrantsInvoiceDocumentErrorLog contractsGrantsInvoiceDocumentErrorLog = new ContractsGrantsInvoiceDocumentErrorLog();
            ContractsGrantsInvoiceDocumentErrorMessage contractsGrantsInvoiceDocumentErrorCategory = new ContractsGrantsInvoiceDocumentErrorMessage();
            contractsGrantsInvoiceDocumentErrorCategory.setErrorMessageText(MessageFormat.format(this.configurationService.getPropertyValueAsString(errorMessage.getErrorKey()), errorMessage.getMessageParameters()));
            contractsGrantsInvoiceDocumentErrorLog.getErrorMessages().add(contractsGrantsInvoiceDocumentErrorCategory);
            contractsGrantsInvoiceDocumentErrorLog.setErrorDate(this.dateTimeService.getCurrentTimestamp());
            contractsGrantsInvoiceDocumentErrorLog.setCreationProcessTypeCode(creationProcessTypeCode);
            this.businessObjectService.save((PersistableBusinessObject)contractsGrantsInvoiceDocumentErrorLog);
        }
    }

    @Override
    public void routeContractsGrantsInvoiceDocuments() {
        String currentUserPrincipalId = GlobalVariables.getUserSession().getPerson().getPrincipalId();
        List<String> documentIdList = this.retrieveContractsGrantsInvoiceDocumentsToRoute(DocumentStatus.SAVED, currentUserPrincipalId);
        if (LOG.isInfoEnabled()) {
            LOG.info("CGinvoice to Route: " + documentIdList);
        }
        for (String cgInvoiceDocId : documentIdList) {
            try {
                ContractsGrantsInvoiceDocument cgInvoiceDoc = (ContractsGrantsInvoiceDocument)this.documentService.getByDocumentHeaderId(cgInvoiceDocId);
                if (LOG.isInfoEnabled()) {
                    LOG.info("Routing Contracts & Grants Invoice document # " + cgInvoiceDocId + ".");
                }
                this.documentService.prepareWorkflowDocument((Document)cgInvoiceDoc);
                this.workflowDocumentService.route(cgInvoiceDoc.getDocumentHeader().getWorkflowDocument(), "", null);
            }
            catch (WorkflowException e) {
                LOG.error("Error routing document # " + cgInvoiceDocId + " " + e.getMessage());
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }

    protected List<String> retrieveContractsGrantsInvoiceDocumentsToRoute(DocumentStatus statusCode, String initiatorPrincipalId) {
        ArrayList<String> documentIds = new ArrayList<String>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("workflowDocumentTypeName", "CINV");
        fieldValues.put("workflowDocumentStatusCode", statusCode.getCode());
        fieldValues.put("initiatorPrincipalId", initiatorPrincipalId);
        Collection docHeaders = this.businessObjectService.findMatching(FinancialSystemDocumentHeader.class, fieldValues);
        for (FinancialSystemDocumentHeader docHeader : docHeaders) {
            documentIds.add(docHeader.getDocumentNumber());
        }
        return documentIds;
    }

    protected void writeErrorEntryByAward(ContractsAndGrantsBillingAward award, List<String> validationCategory, PrintStream printStream) throws IOException {
        if (ObjectUtils.isNotNull((Object)award)) {
            KualiDecimal cumulativeExpenses = KualiDecimal.ZERO;
            String proposalNumber = award.getProposalNumber();
            java.sql.Date beginningDate = award.getAwardBeginningDate();
            java.sql.Date endingDate = award.getAwardEndingDate();
            KualiDecimal totalAmount = award.getAwardTotalAmount();
            String awardBeginningDate = ObjectUtils.isNotNull((Object)beginningDate) ? beginningDate.toString() : "null award beginning date";
            String awardEndingDate = ObjectUtils.isNotNull((Object)endingDate) ? endingDate.toString() : "null award ending date";
            String awardTotalAmount = ObjectUtils.isNotNull((Object)totalAmount) && ObjectUtils.isNotNull((Object)totalAmount.bigDecimalValue()) ? totalAmount.toString() : "null award total amount";
            if (CollectionUtils.isEmpty((Collection)award.getActiveAwardAccounts())) {
                this.writeToReport(proposalNumber, "", awardBeginningDate, awardEndingDate, awardTotalAmount, cumulativeExpenses.toString(), printStream);
            } else {
                SystemOptions systemOptions = this.optionsService.getCurrentYearOptions();
                for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                    cumulativeExpenses = (KualiDecimal)cumulativeExpenses.add((AbstractKualiDecimal)this.contractsGrantsInvoiceDocumentService.getBudgetAndActualsForAwardAccount(awardAccount, systemOptions.getActualFinancialBalanceTypeCd()));
                }
                boolean firstLineFlag = true;
                for (ContractsAndGrantsBillingAwardAccount awardAccount : award.getActiveAwardAccounts()) {
                    if (firstLineFlag) {
                        this.writeToReport(proposalNumber, awardAccount.getAccountNumber(), awardBeginningDate, awardEndingDate, awardTotalAmount, cumulativeExpenses.toString(), printStream);
                        firstLineFlag = false;
                        continue;
                    }
                    this.writeToReport("", awardAccount.getAccountNumber(), "", "", "", "", printStream);
                }
            }
        }
        for (String vCat : validationCategory) {
            printStream.printf("%s", "     " + vCat);
            printStream.print("\r\n");
        }
        printStream.print(REPORT_LINE_DIVIDER);
        printStream.print("\r\n");
    }

    protected void writeToReport(String proposalNumber, String accountNumber, String awardBeginningDate, String awardEndingDate, String awardTotalAmount, String cumulativeExpenses, PrintStream printStream) throws IOException {
        printStream.printf("%15s", proposalNumber);
        printStream.printf("%18s", accountNumber);
        printStream.printf("%20s", awardBeginningDate);
        printStream.printf("%19s", awardEndingDate);
        printStream.printf("%15s", awardTotalAmount);
        printStream.printf("%23s", cumulativeExpenses);
        printStream.print("\r\n");
    }

    protected void writeReportHeader(PrintStream printStream) throws IOException {
        printStream.printf("%15s%18s%20s%19s%15s%23s\r\n", "Proposal Number", "Account Number", "Award Start Date", "Award Stop Date", "Award Total", "Cumulative Expenses");
        printStream.printf("%23s", "Validation Category");
        printStream.print("\r\n");
        printStream.print(REPORT_LINE_DIVIDER);
        printStream.print("\r\n");
    }

    protected boolean hasBillableAccounts(ContractsAndGrantsBillingAward award) {
        if (ArConstants.BillingFrequencyValues.isMilestone((Billable)award) || ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)award)) {
            return !this.getContractsGrantsBillingAwardVerificationService().isInvoiceInProgress(award);
        }
        return CollectionUtils.isEmpty((Collection)award.getActiveAwardAccounts()) || !CollectionUtils.isEmpty(this.getValidAwardAccounts(award.getActiveAwardAccounts(), award));
    }

    protected List<ContractsAndGrantsBillingAwardAccount> getValidAwardAccounts(List<ContractsAndGrantsBillingAwardAccount> awardAccounts, ContractsAndGrantsBillingAward award) {
        if (!ArConstants.BillingFrequencyValues.isMilestone((Billable)award) && !ArConstants.BillingFrequencyValues.isPredeterminedBilling((Billable)award)) {
            ArrayList<ContractsAndGrantsBillingAwardAccount> validAwardAccounts = new ArrayList<ContractsAndGrantsBillingAwardAccount>();
            Set<Account> invalidAccounts = this.harvestAccountsFromContractsGrantsInvoices(this.getInProgressInvoicesForAward(award));
            for (ContractsAndGrantsBillingAwardAccount awardAccount : awardAccounts) {
                if (invalidAccounts.contains(awardAccount.getAccount()) || !this.verifyBillingFrequencyService.validateBillingFrequency(award, awardAccount)) continue;
                validAwardAccounts.add(awardAccount);
            }
            return validAwardAccounts;
        }
        return awardAccounts;
    }

    protected Set<Account> harvestAccountsFromContractsGrantsInvoices(Collection<ContractsGrantsInvoiceDocument> contractsGrantsInvoices) {
        HashSet<Account> accounts = new HashSet<Account>();
        for (ContractsGrantsInvoiceDocument invoice : contractsGrantsInvoices) {
            for (InvoiceAccountDetail invoiceAccountDetail : invoice.getAccountDetails()) {
                Account account = this.getAccountService().getByPrimaryId(invoiceAccountDetail.getChartOfAccountsCode(), invoiceAccountDetail.getAccountNumber());
                if (ObjectUtils.isNull((Object)account)) continue;
                accounts.add(account);
            }
        }
        return accounts;
    }

    protected Collection<ContractsGrantsInvoiceDocument> getInProgressInvoicesForAward(ContractsAndGrantsBillingAward award) {
        HashMap<String, Object> fieldValues = new HashMap<String, Object>();
        fieldValues.put("invoiceGeneralDetail.proposalNumber", award.getProposalNumber());
        fieldValues.put("documentHeader.workflowDocumentStatusCode", this.financialSystemDocumentService.getPendingDocumentStatuses());
        return this.businessObjectService.findMatching(ContractsGrantsInvoiceDocument.class, fieldValues);
    }

    @Override
    public Collection<String> retrieveExpenseObjectTypes() {
        ArrayList<String> objectTypeCodes = new ArrayList<String>();
        HashMap<String, String> fieldValues = new HashMap<String, String>();
        fieldValues.put("basicAccountingCategoryCode", "EX");
        Collection objectTypes = this.getBusinessObjectService().findMatching(ObjectType.class, fieldValues);
        for (ObjectType objectType : objectTypes) {
            objectTypeCodes.add(objectType.getCode());
        }
        return objectTypeCodes;
    }

    public AccountService getAccountService() {
        return this.accountService;
    }

    public void setAccountService(AccountService accountService) {
        this.accountService = accountService;
    }

    public void setAccountingPeriodService(AccountingPeriodService accountingPeriodService) {
        this.accountingPeriodService = accountingPeriodService;
    }

    public void setVerifyBillingFrequencyService(VerifyBillingFrequencyService verifyBillingFrequencyService) {
        this.verifyBillingFrequencyService = verifyBillingFrequencyService;
    }

    public BusinessObjectService getBusinessObjectService() {
        return this.businessObjectService;
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }

    public void setWorkflowDocumentService(WorkflowDocumentService workflowDocumentService) {
        this.workflowDocumentService = workflowDocumentService;
    }

    public void setDataDictionaryService(DataDictionaryService dataDictionaryService) {
        this.dataDictionaryService = dataDictionaryService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setAccountsReceivableDocumentHeaderService(AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService) {
        this.accountsReceivableDocumentHeaderService = accountsReceivableDocumentHeaderService;
    }

    public void setContractsGrantsInvoiceDocumentService(ContractsGrantsInvoiceDocumentService contractsGrantsInvoiceDocumentService) {
        this.contractsGrantsInvoiceDocumentService = contractsGrantsInvoiceDocumentService;
    }

    public ContractsGrantsInvoiceDocumentService getContractsGrantsInvoiceDocumentService() {
        return this.contractsGrantsInvoiceDocumentService;
    }

    public DateTimeService getDateTimeService() {
        return this.dateTimeService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public void setKualiModuleService(KualiModuleService kualiModuleService) {
        this.kualiModuleService = kualiModuleService;
    }

    public ConfigurationService getConfigurationService() {
        return this.configurationService;
    }

    public void setConfigurationService(ConfigurationService configurationService) {
        this.configurationService = configurationService;
    }

    public ContractsGrantsBillingUtilityService getContractsGrantsBillingUtilityService() {
        return this.contractsGrantsBillingUtilityService;
    }

    public void setContractsGrantsBillingUtilityService(ContractsGrantsBillingUtilityService contractsGrantsBillingUtilityService) {
        this.contractsGrantsBillingUtilityService = contractsGrantsBillingUtilityService;
    }

    public ContractsAndGrantsModuleBillingService getContractsAndGrantsModuleBillingService() {
        return this.contractsAndGrantsModuleBillingService;
    }

    public void setContractsAndGrantsModuleBillingService(ContractsAndGrantsModuleBillingService contractsAndGrantsModuleBillingService) {
        this.contractsAndGrantsModuleBillingService = contractsAndGrantsModuleBillingService;
    }

    public FinancialSystemDocumentService getFinancialSystemDocumentService() {
        return this.financialSystemDocumentService;
    }

    public void setFinancialSystemDocumentService(FinancialSystemDocumentService financialSystemDocumentService) {
        this.financialSystemDocumentService = financialSystemDocumentService;
    }

    public UniversityDateService getUniversityDateService() {
        return this.universityDateService;
    }

    public void setUniversityDateService(UniversityDateService universityDateService) {
        this.universityDateService = universityDateService;
    }

    public AwardAccountObjectCodeTotalBilledDao getAwardAccountObjectCodeTotalBilledDao() {
        return this.awardAccountObjectCodeTotalBilledDao;
    }

    public void setAwardAccountObjectCodeTotalBilledDao(AwardAccountObjectCodeTotalBilledDao awardAccountObjectCodeTotalBilledDao) {
        this.awardAccountObjectCodeTotalBilledDao = awardAccountObjectCodeTotalBilledDao;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public ParameterService getParameterService() {
        return this.parameterService;
    }

    public void setParameterService(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public ContractsGrantsBillingAwardVerificationService getContractsGrantsBillingAwardVerificationService() {
        return this.contractsGrantsBillingAwardVerificationService;
    }

    public void setContractsGrantsBillingAwardVerificationService(ContractsGrantsBillingAwardVerificationService contractsGrantsBillingAwardVerificationService) {
        this.contractsGrantsBillingAwardVerificationService = contractsGrantsBillingAwardVerificationService;
    }

    public CostCategoryService getCostCategoryService() {
        return this.costCategoryService;
    }

    public void setCostCategoryService(CostCategoryService costCategoryService) {
        this.costCategoryService = costCategoryService;
    }

    public OptionsService getOptionsService() {
        return this.optionsService;
    }

    public void setOptionsService(OptionsService optionsService) {
        this.optionsService = optionsService;
    }

    public void setFinancialSystemUserService(FinancialSystemUserService financialSystemUserService) {
        this.financialSystemUserService = financialSystemUserService;
    }
}

