/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.service.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.kuali.kfs.integration.ar.AccountsReceivableModuleBillingService;
import org.kuali.kfs.kns.web.ui.Field;
import org.kuali.kfs.kns.web.ui.Row;
import org.kuali.kfs.kns.web.ui.Section;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.service.CustomerViewService;

public class CustomerViewServiceImpl
implements CustomerViewService {
    protected AccountsReceivableModuleBillingService accountsReceivableModuleBillingService;

    @Override
    public List getSections(List<Section> sections) {
        if (!this.getAccountsReceivableModuleBillingService().isContractsGrantsBillingEnhancementActive()) {
            Iterator<Section> it = sections.iterator();
            while (it.hasNext()) {
                Section section = it.next();
                if (this.getSectionsToIgnore().contains(section.getSectionId())) {
                    it.remove();
                    continue;
                }
                for (Row row : section.getRows()) {
                    row.setFields(this.getFieldsToDisplay(row));
                }
            }
        }
        return sections;
    }

    protected List<Field> getFieldsToDisplay(Row row) {
        ArrayList<Field> fieldsToDisplay = new ArrayList<Field>();
        for (Field field : row.getFields()) {
            if (field.getCONTAINER().equalsIgnoreCase(field.getFieldType())) {
                List<Row> containerRowsToDisplay = this.getContainerRowsToDisplay(field);
                if (!CollectionUtils.isNotEmpty(containerRowsToDisplay)) continue;
                field.setContainerRows(containerRowsToDisplay);
                fieldsToDisplay.add(field);
                continue;
            }
            if (this.getFieldsToIgnore().contains(field.getPropertyName())) continue;
            fieldsToDisplay.add(field);
        }
        return fieldsToDisplay;
    }

    protected List<Row> getContainerRowsToDisplay(Field field) {
        ArrayList<Row> containerRowsToDisplay = new ArrayList<Row>();
        for (Row containerRow : field.getContainerRows()) {
            ArrayList<Field> updatedContainerRowFields = new ArrayList<Field>();
            for (Field containerRowfield : containerRow.getFields()) {
                if (this.getFieldsToIgnore().contains(ObjectUtils.getNestedAttributePrimitive((String)containerRowfield.getPropertyName()))) continue;
                updatedContainerRowFields.add(containerRowfield);
            }
            if (!CollectionUtils.isNotEmpty(updatedContainerRowFields)) continue;
            containerRow.setFields(updatedContainerRowFields);
            containerRowsToDisplay.add(containerRow);
        }
        return containerRowsToDisplay;
    }

    protected List<String> getSectionsToIgnore() {
        ArrayList<String> sectionsToIgnore = new ArrayList<String>();
        sectionsToIgnore.add("collectionsSection");
        return sectionsToIgnore;
    }

    protected List<String> getFieldsToIgnore() {
        ArrayList<String> fieldsToIgnore = new ArrayList<String>();
        fieldsToIgnore.add("customerInvoiceTemplateCode");
        fieldsToIgnore.add("invoiceTransmissionMethodCode");
        fieldsToIgnore.add("customerCopiesToPrint");
        fieldsToIgnore.add("customerEnvelopesToPrintQuantity");
        return fieldsToIgnore;
    }

    public AccountsReceivableModuleBillingService getAccountsReceivableModuleBillingService() {
        return this.accountsReceivableModuleBillingService;
    }

    public void setAccountsReceivableModuleBillingService(AccountsReceivableModuleBillingService accountsReceivableModuleBillingService) {
        this.accountsReceivableModuleBillingService = accountsReceivableModuleBillingService;
    }
}

