/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.actions;

import org.apache.commons.lang3.StringUtils;
import org.kuali.kfs.datadictionary.BusinessObjectAdminService;
import org.kuali.kfs.krad.bo.BusinessObjectBase;
import org.kuali.kfs.krad.util.UrlFactory;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.ArPropertyConstants;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.CustomerOpenItemReportDetail;
import org.kuali.kfs.module.ar.businessobject.admin.CustomerAdminService;
import org.kuali.kfs.sys.KFSConstants;
import org.kuali.kfs.sys.businessobject.actions.BusinessObjectActionsProvider;
import org.kuali.rice.kim.api.identity.Person;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CustomerActionsProvider extends BusinessObjectActionsProvider {
    @Override
    public List<Map<String, Object>> getActionLinks(BusinessObjectBase businessObject, Person user) {
        List<Map<String, Object>> actions = super.getActionLinks(businessObject, user);

        BusinessObjectAdminService businessObjectAdminService = businessObjectDictionaryService
                .getBusinessObjectAdminService(businessObject.getClass());
        if (businessObjectAdminService instanceof CustomerAdminService &&
                ((CustomerAdminService) businessObjectAdminService).allowsReport(user)) {
            String reportUrl = generateReportUrl((Customer) businessObject);
            actions.add(buildAction("Report", "GET", reportUrl));
        }
        return actions;
    }

    private String generateReportUrl(Customer customer) {
        Map<String, String> params = new HashMap<>();
        params.put(KFSConstants.BUSINESS_OBJECT_CLASS_ATTRIBUTE, CustomerOpenItemReportDetail.class.getName());
        params.put(KFSConstants.RETURN_LOCATION_PARAMETER, StringUtils.EMPTY);
        params.put(KFSConstants.LOOKUPABLE_IMPL_ATTRIBUTE_NAME, ArConstants.CUSTOMER_OPEN_ITEM_REPORT_LOOKUPABLE_IMPL);
        params.put(KFSConstants.DISPATCH_REQUEST_PARAMETER, KFSConstants.SEARCH_METHOD);
        params.put(ArPropertyConstants.CustomerFields.CUSTOMER_NUMBER, customer.getCustomerNumber());
        params.put(KFSConstants.CustomerOpenItemReport.REPORT_NAME,
                KFSConstants.CustomerOpenItemReport.HISTORY_REPORT_NAME);
        params.put(ArPropertyConstants.CustomerFields.CUSTOMER_NAME, customer.getCustomerName());
        params.put(KFSConstants.DOC_FORM_KEY, "88888888");
        return UrlFactory.parameterizeUrl(ArConstants.UrlActions.CUSTOMER_OPEN_ITEM_REPORT_LOOKUP, params);
    }
}
