/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.businessobject.defaultvalue;

import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.businessobject.OrganizationAccountingDefault;
import org.kuali.kfs.sys.businessobject.ChartOrgHolder;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.FinancialSystemUserService;
import org.kuali.kfs.sys.service.UniversityDateService;

import java.util.HashMap;
import java.util.Map;

public class OrganizationAccountingDefaultValueFinderBase {

    private BusinessObjectService businessObjectService;

    /**
     * Constructs a OrganizationAccountingDefaultValueFinderBase.  Sets the OrganizationAccountingDefault BO based on
     * current year, current users chart of account code, and current users organization code
     */
    public OrganizationAccountingDefaultValueFinderBase() {
    }

    public OrganizationAccountingDefault getOrganizationAccountingDefault() {
        // I want to inject these but the beans don't want to resolve
        UniversityDateService universityDateService = SpringContext.getBean(UniversityDateService.class);
        Integer currentUniversityFiscalYear = universityDateService.getCurrentFiscalYear();
        FinancialSystemUserService financialSystemUserService =
                SpringContext.getBean(FinancialSystemUserService.class);
        ChartOrgHolder chartUser = financialSystemUserService.getPrimaryOrganization(
                GlobalVariables.getUserSession().getPerson(), ArConstants.AR_NAMESPACE_CODE);

        Map<String, Object> criteria = new HashMap<>();
        criteria.put("universityFiscalYear", currentUniversityFiscalYear);
        criteria.put("chartOfAccountsCode", chartUser.getChartOfAccountsCode());
        criteria.put("organizationCode", chartUser.getOrganizationCode());
        return businessObjectService.findByPrimaryKey(OrganizationAccountingDefault.class, criteria);
    }

    public void setBusinessObjectService(BusinessObjectService businessObjectService) {
        this.businessObjectService = businessObjectService;
    }
}

