/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.service;

import org.kuali.kfs.module.ar.businessobject.CustomerAddress;

public interface CustomerAddressService {

    /**
     * @param customerNumber
     * @param customerAddressIdentifier
     * @return a customer address by primary key
     */
    CustomerAddress getByPrimaryKey(String customerNumber, Integer customerAddressIdentifier);

    /**
     * @param customerNumber
     * @param customerAddressIdentifier
     * @return {@code true} if customer address exists
     */
    boolean customerAddressExists(String customerNumber, Integer customerAddressIdentifier);

    /**
     * @return the next address identifier
     */
    Integer getNextCustomerAddressIdentifier();

    /**
     * @param customerNumber
     * @return the CustomerAddress specified as the primary address for a Customer.
     */

    CustomerAddress getPrimaryAddress(String customerNumber);

    /**
     * @param customerNumber
     * @param customerAddressIdentifier
     * @return {@code true} if customer address is active
     */
    boolean customerAddressActive(String customerNumber, Integer customerAddressIdentifier);
}
