/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.kfs.module.ar.document.web.struts;

import org.kuali.kfs.kns.web.ui.HeaderField;
import org.kuali.kfs.krad.util.KRADConstants;
import org.kuali.kfs.module.ar.ArConstants;
import org.kuali.kfs.module.ar.document.PaymentApplicationAdjustmentDocument;
import org.kuali.rice.kew.api.WorkflowDocument;

import java.util.List;

/**
 * A Struts {@link org.apache.struts.action.ActionForm} instance associated with the "Payment Application
 * Adjustment" transactional document.
 */
public class PaymentApplicationAdjustmentForm extends PaymentApplicationForm {

    @Override
    protected String getDefaultDocumentTypeName() {
        return ArConstants.PAYMENT_APPLICATION_ADJUSTMENT_DOCUMENT_TYPE_CODE;
    }

    @Override
    protected List<HeaderField> getStandardHeaderFields(final WorkflowDocument workflowDocument) {
        final List<HeaderField> standardHeaderFields = super.getStandardHeaderFields(workflowDocument);

        final HeaderField adjusteeId = getAdjusteeHeaderField();
        standardHeaderFields.add(adjusteeId);

        return standardHeaderFields;
    }

    private HeaderField getAdjusteeHeaderField() {
        final String ddAttributeEntryName = "DataDictionary.AttributeReferenceDummy.attributes.adjusteeId";
        final String displayValue = getPaymentApplicationAdjustmentDocument().getAdjusteeId();
        final String documentHandlerUrl = getDocumentHandlerUrl(displayValue);
        final String nonLookupValue = buildHtmlLink(documentHandlerUrl, displayValue);
        return new HeaderField(
                KRADConstants.DocumentFormHeaderFieldIds.DOCUMENT_ADJUSTEE,
                ddAttributeEntryName,
                displayValue,
                nonLookupValue
        );
    }

    private PaymentApplicationAdjustmentDocument getPaymentApplicationAdjustmentDocument() {
        return (PaymentApplicationAdjustmentDocument) getDocument();
    }

}
