/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.module.ar.batch.CustomerLoadCSVBuilder;
import org.kuali.kfs.module.ar.batch.service.CustomerLoadService;
import org.kuali.kfs.module.ar.batch.vo.CustomerCsvHeaders;
import org.kuali.kfs.module.ar.batch.vo.CustomerDigesterVO;
import org.kuali.kfs.sys.batch.CsvBatchInputFileTypeBase;

public class CustomerLoadCSVInputFileType
extends CsvBatchInputFileTypeBase<CustomerCsvHeaders> {
    private static final Logger LOG = LogManager.getLogger();
    private static final String FILE_NAME_PREFIX = "customer_load";
    private static final String FILE_NAME_DELIM = "_";
    private CustomerLoadService customerLoadService;

    public String getFileName(String principalName, Object parsedFileContents, String fileUserIdentifier) {
        return this.customerLoadService.getFileName(principalName, fileUserIdentifier, FILE_NAME_PREFIX, FILE_NAME_DELIM);
    }

    public String getFileTypeIdentifier() {
        return "customerLoadCSVInputFileType";
    }

    public boolean validate(Object parsedFileContents) {
        List customerVOs = (List)parsedFileContents;
        return this.customerLoadService.validate(customerVOs);
    }

    public String getTitleKey() {
        return "message.ar.customerLoad.batchUpload.csv.title";
    }

    public void setCustomerLoadService(CustomerLoadService customerLoadService) {
        this.customerLoadService = customerLoadService;
    }

    protected Object convertParsedObjectToVO(Object parsedContent) {
        List<CustomerDigesterVO> customerVOs;
        try {
            List parseDataList = (List)parsedContent;
            customerVOs = CustomerLoadCSVBuilder.buildCustomerDigestVO(parseDataList);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e.getMessage(), e);
        }
        return customerVOs;
    }
}

