/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.report;

import java.util.ArrayList;
import java.util.List;

public class LockboxLoadResult {
    private String filename;
    private String lockboxNumber;
    private ResultCode result;
    private List<String[]> messages;

    public LockboxLoadResult() {
        this.messages = new ArrayList<String[]>();
    }

    public LockboxLoadResult(String filename, String lockboxNumber) {
        this.filename = filename;
        this.lockboxNumber = lockboxNumber;
        this.result = ResultCode.INCOMPLETE;
        this.messages = new ArrayList<String[]>();
    }

    public static String getEntryTypeString(EntryType type) {
        String result;
        switch (type) {
            case INFO: {
                result = "INFO";
                break;
            }
            case ERROR: {
                result = "ERROR";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        return result;
    }

    public static String getResultCodeString(ResultCode resultCode) {
        String result;
        switch (resultCode) {
            case SUCCESS: {
                result = "SUCCESS";
                break;
            }
            case FAILURE: {
                result = "FAILURES";
                break;
            }
            case ERROR: {
                result = "ERROR";
                break;
            }
            case INCOMPLETE: {
                result = "INCOMPLETE";
                break;
            }
            default: {
                result = "UNKNOWN";
            }
        }
        return result;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public ResultCode getResult() {
        return this.result;
    }

    public String getResultString() {
        return LockboxLoadResult.getResultCodeString(this.result);
    }

    private void setResult(ResultCode result) {
        this.result = result;
    }

    public void setSuccessResult() {
        this.result = ResultCode.SUCCESS;
    }

    public void setFailureResult() {
        this.result = ResultCode.FAILURE;
    }

    public void setErrorResult() {
        this.result = ResultCode.ERROR;
    }

    public String getLockboxNumber() {
        return this.lockboxNumber;
    }

    public void setLockboxNumber(String lockboxNumber) {
        this.lockboxNumber = lockboxNumber;
    }

    public List<String[]> getMessages() {
        return this.messages;
    }

    private void addMessage(EntryType entryType, String message) {
        this.messages.add(new String[]{LockboxLoadResult.getEntryTypeString(entryType), message});
    }

    public void addErrorMessage(String message) {
        this.addMessage(EntryType.ERROR, message);
    }

    public void addInfoMessage(String message) {
        this.addMessage(EntryType.INFO, message);
    }

    public static enum EntryType {
        INFO,
        ERROR;

    }

    public static enum ResultCode {
        SUCCESS,
        FAILURE,
        ERROR,
        INCOMPLETE;

    }
}

