/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.ar.batch.service.impl;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Paragraph;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.service.BusinessObjectService;
import org.kuali.kfs.krad.service.DocumentService;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.ObjectUtils;
import org.kuali.kfs.module.ar.batch.service.LockboxService;
import org.kuali.kfs.module.ar.businessobject.AccountsReceivableDocumentHeader;
import org.kuali.kfs.module.ar.businessobject.CashControlDetail;
import org.kuali.kfs.module.ar.businessobject.Customer;
import org.kuali.kfs.module.ar.businessobject.Lockbox;
import org.kuali.kfs.module.ar.businessobject.SystemInformation;
import org.kuali.kfs.module.ar.dataaccess.LockboxDao;
import org.kuali.kfs.module.ar.document.CashControlDocument;
import org.kuali.kfs.module.ar.document.CustomerInvoiceDocument;
import org.kuali.kfs.module.ar.document.PaymentApplicationDocument;
import org.kuali.kfs.module.ar.document.service.AccountsReceivableDocumentHeaderService;
import org.kuali.kfs.module.ar.document.service.CashControlDocumentService;
import org.kuali.kfs.module.ar.document.service.CustomerService;
import org.kuali.kfs.module.ar.document.service.PaymentApplicationDocumentService;
import org.kuali.kfs.module.ar.document.service.SystemInformationService;
import org.kuali.rice.core.api.datetime.DateTimeService;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;
import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentType;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.rice.kew.api.document.attribute.DocumentAttributeIndexingQueue;
import org.kuali.rice.kew.api.exception.WorkflowException;
import org.kuali.rice.kim.api.identity.principal.Principal;
import org.kuali.rice.kim.api.services.KimApiServiceLocator;
import org.springframework.transaction.annotation.Transactional;

public class LockboxServiceImpl
implements LockboxService {
    private static final Logger LOG = LogManager.getLogger();
    private DocumentService documentService;
    private SystemInformationService systemInformationService;
    private AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService;
    private CashControlDocumentService cashControlDocumentService;
    private PaymentApplicationDocumentService payAppDocService;
    private DateTimeService dateTimeService;
    private BusinessObjectService boService;
    private CustomerService customerService;
    private DocumentTypeService documentTypeService;
    private LockboxDao lockboxDao;
    private String reportsDirectory;
    Lockbox ctrlLockbox;
    CashControlDocument cashControlDocument;
    boolean anyRecordsFound = false;

    @Override
    public boolean processLockboxes() throws WorkflowException {
        this.ctrlLockbox = new Lockbox();
        this.cashControlDocument = null;
        this.anyRecordsFound = false;
        try (Document pdfdoc = this.getPdfDoc();){
            for (Lockbox lockbox : this.getAllLockboxes()) {
                this.processLockbox(lockbox, pdfdoc);
            }
            if (this.cashControlDocument != null) {
                LOG.info("   routing cash control document.");
                this.cashControlDocument.getDocumentHeader().getWorkflowDocument().route("Routed by Lockbox Batch process.");
                DocumentType documentType = this.documentTypeService.getDocumentTypeByName(this.cashControlDocument.getFinancialDocumentTypeCode());
                DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue((String)documentType.getApplicationId());
                queue.indexDocument(this.cashControlDocument.getDocumentNumber());
            }
            if (!this.anyRecordsFound) {
                this.writeDetailLine(pdfdoc, "NO LOCKBOX RECORDS WERE FOUND");
            }
        }
        catch (DocumentException | IOException ex) {
            throw new RuntimeException("Could not open file for lockbox processing results report", ex);
        }
        return true;
    }

    @Transactional
    protected Collection<Lockbox> getAllLockboxes() {
        return this.lockboxDao.getAllLockboxes();
    }

    @Override
    @Transactional
    public void processLockbox(Lockbox lockbox, Document pdfdoc) {
        PaymentApplicationDocument payAppDoc;
        CustomerInvoiceDocument customerInvoiceDocument;
        Customer customer;
        this.anyRecordsFound = true;
        LOG.info("LOCKBOX: '" + lockbox.getLockboxNumber() + "'");
        SystemInformation sysInfo = this.systemInformationService.getByLockboxNumberForCurrentFiscalYear(lockbox.getLockboxNumber());
        String initiator = sysInfo.getFinancialDocumentInitiatorIdentifier();
        LOG.info("   using SystemInformation: '" + sysInfo.toString() + "'");
        LOG.info("   using Financial Document Initiator ID: '" + initiator + "'");
        Principal principal = KimApiServiceLocator.getIdentityService().getPrincipal(initiator);
        if (principal == null) {
            LOG.warn("   could not find [" + initiator + "] when searching by PrincipalID, so trying to find as a PrincipalName.");
            principal = KimApiServiceLocator.getIdentityService().getPrincipalByPrincipalName(initiator);
            if (principal == null) {
                LOG.error("Financial Document Initiator ID [" + initiator + "] specified in SystemInformation [" + sysInfo.toString() + "] for Lockbox Number " + lockbox.getLockboxNumber() + " is not present in the system as either a PrincipalID or a PrincipalName.");
                throw new RuntimeException("Financial Document Initiator ID [" + initiator + "] specified in SystemInformation [" + sysInfo.toString() + "] for Lockbox Number " + lockbox.getLockboxNumber() + " is not present in the system as either a PrincipalID or a PrincipalName.");
            }
            LOG.info("   found [" + initiator + "] in the system as a PrincipalName.");
        } else {
            LOG.info("   found [" + initiator + "] in the system as a PrincipalID.");
        }
        GlobalVariables.clear();
        GlobalVariables.setUserSession((UserSession)new UserSession(principal.getPrincipalName()));
        if (lockbox.compareTo(this.ctrlLockbox) != 0) {
            LOG.info("New Lockbox batch");
            if (this.cashControlDocument != null) {
                LOG.info("   routing cash control document.");
                try {
                    this.cashControlDocument.getDocumentHeader().getWorkflowDocument().route("Routed by Lockbox Batch process.");
                    DocumentType documentType = this.documentTypeService.getDocumentTypeByName(this.cashControlDocument.getFinancialDocumentTypeCode());
                    DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue((String)documentType.getApplicationId());
                    queue.indexDocument(this.cashControlDocument.getDocumentNumber());
                }
                catch (Exception e) {
                    LOG.error("A Exception was thrown while trying to route the CashControl document.", (Throwable)e);
                    throw new RuntimeException("A Exception was thrown while trying to route the CashControl document.", e);
                }
            }
            LOG.info("Creating new CashControl document for invoice: " + lockbox.getFinancialDocumentReferenceInvoiceNumber() + ".");
            try {
                this.cashControlDocument = (CashControlDocument)this.documentService.getNewDocument("CTRL");
            }
            catch (Exception e) {
                LOG.error("A Exception was thrown while trying to initiate a new CashControl document.", (Throwable)e);
                throw new RuntimeException("A Exception was thrown while trying to initiate a new CashControl document.", e);
            }
            LOG.info("   CashControl documentNumber == '" + this.cashControlDocument.getDocumentNumber() + "'");
            this.writeBatchGroupSectionTitle(pdfdoc, lockbox.getBatchSequenceNumber().toString(), lockbox.getProcessedInvoiceDate(), this.cashControlDocument.getDocumentNumber());
            this.cashControlDocument.setCustomerPaymentMediumCode(lockbox.getCustomerPaymentMediumCode());
            if (ObjectUtils.isNotNull((Object)lockbox.getBankCode())) {
                String bankCode = lockbox.getBankCode();
                this.cashControlDocument.setBankCode(bankCode);
            }
            this.cashControlDocument.getDocumentHeader().setDocumentDescription("Created by Lockbox " + lockbox.getLockboxNumber());
            LOG.info("   creating AR header for customer: [" + lockbox.getCustomerNumber() + "] and ProcessingOrg: " + sysInfo.getProcessingChartOfAccountCode() + "-" + sysInfo.getProcessingOrganizationCode() + ".");
            AccountsReceivableDocumentHeader arDocHeader = new AccountsReceivableDocumentHeader();
            arDocHeader.setProcessingChartOfAccountCode(sysInfo.getProcessingChartOfAccountCode());
            arDocHeader.setProcessingOrganizationCode(sysInfo.getProcessingOrganizationCode());
            arDocHeader.setDocumentNumber(this.cashControlDocument.getDocumentNumber());
            if (ObjectUtils.isNotNull((Object)lockbox.getCustomerNumber()) && ObjectUtils.isNotNull((Object)((Object)(customer = this.customerService.getByPrimaryKey(lockbox.getCustomerNumber()))))) {
                arDocHeader.setCustomerNumber(lockbox.getCustomerNumber());
            }
            this.cashControlDocument.setAccountsReceivableDocumentHeader(arDocHeader);
        }
        this.ctrlLockbox = lockbox;
        this.writeLockboxRecordLine(pdfdoc, lockbox.getLockboxNumber(), lockbox.getCustomerNumber(), lockbox.getFinancialDocumentReferenceInvoiceNumber(), lockbox.getInvoicePaidOrAppliedAmount(), lockbox.getCustomerPaymentMediumCode(), lockbox.getBankCode());
        if (lockbox.getInvoicePaidOrAppliedAmount().isZero()) {
            LOG.warn("   lockbox has a zero dollar amount, so we're skipping it.");
            this.writeSummaryDetailLine(pdfdoc, "ZERO-DOLLAR LOCKBOX - NO FURTHER PROCESSING");
            this.deleteProcessedLockboxEntry(lockbox);
            return;
        }
        if (lockbox.getInvoicePaidOrAppliedAmount().isLessThan((AbstractKualiDecimal)KualiDecimal.ZERO)) {
            LOG.warn("   lockbox has a negative dollar amount, so we're skipping it.");
            this.writeCashControlDetailLine(pdfdoc, lockbox.getInvoicePaidOrAppliedAmount(), "SKIPPED");
            this.writeSummaryDetailLine(pdfdoc, "NEGATIVE-DOLLAR LOCKBOX - NO FURTHER PROCESSING - LOCKBOX ENTRY NOT DELETED");
            return;
        }
        CashControlDetail detail = new CashControlDetail();
        if (ObjectUtils.isNotNull((Object)lockbox.getCustomerNumber()) && ObjectUtils.isNotNull((Object)((Object)(customer = this.customerService.getByPrimaryKey(lockbox.getCustomerNumber()))))) {
            detail.setCustomerNumber(lockbox.getCustomerNumber());
        }
        detail.setFinancialDocumentLineAmount(lockbox.getInvoicePaidOrAppliedAmount());
        detail.setCustomerPaymentDate(lockbox.getProcessedInvoiceDate());
        detail.setCustomerPaymentDescription("Lockbox Remittance  " + lockbox.getFinancialDocumentReferenceInvoiceNumber());
        LOG.info("   creating detail for $" + lockbox.getInvoicePaidOrAppliedAmount() + " with invoiceDate: " + lockbox.getProcessedInvoiceDate());
        try {
            this.cashControlDocumentService.addNewCashControlDetail("Created by Lockbox ", this.cashControlDocument, detail);
        }
        catch (WorkflowException e) {
            LOG.error("A Exception was thrown while trying to create a new CashControl detail.", (Throwable)e);
            throw new RuntimeException("A Exception was thrown while trying to create a new CashControl detail.", e);
        }
        String payAppDocNumber = detail.getReferenceFinancialDocumentNumber();
        LOG.info("   new PayAppDoc was created: " + payAppDocNumber + ".");
        String invoiceNumber = lockbox.getFinancialDocumentReferenceInvoiceNumber();
        LOG.info("   lockbox references invoice number [" + invoiceNumber + "].");
        if (StringUtils.isBlank((CharSequence)invoiceNumber)) {
            LOG.info("   invoice number is blank; cannot load an invoice.");
            detail.setCustomerPaymentDescription("Lockbox: Remittance for INVALID invoice number " + lockbox.getFinancialDocumentReferenceInvoiceNumber());
            try {
                this.documentService.saveDocument((org.kuali.kfs.krad.document.Document)this.cashControlDocument);
            }
            catch (WorkflowException e) {
                LOG.error("A Exception was thrown while trying to save the CashControl document.", (Throwable)e);
                throw new RuntimeException("A Exception was thrown while trying to save the CashControl document.", e);
            }
            this.writeCashControlDetailLine(pdfdoc, detail.getFinancialDocumentLineAmount(), detail.getCustomerPaymentDescription());
            this.writePayAppLine(pdfdoc, detail.getReferenceFinancialDocumentNumber(), "CREATED & SAVED");
            this.writeSummaryDetailLine(pdfdoc, "INVOICE NUMBER IS BLANK");
            this.deleteProcessedLockboxEntry(lockbox);
            return;
        }
        if (!this.documentService.documentExists(invoiceNumber)) {
            LOG.info("   invoice number [" + invoiceNumber + "] does not exist in system, so cannot load the original invoice.");
            detail.setCustomerPaymentDescription("Lockbox: Remittance for INVALID invoice number " + lockbox.getFinancialDocumentReferenceInvoiceNumber());
            try {
                this.documentService.saveDocument((org.kuali.kfs.krad.document.Document)this.cashControlDocument);
            }
            catch (WorkflowException e) {
                LOG.error("A Exception was thrown while trying to save the CashControl document.", (Throwable)e);
                throw new RuntimeException("A Exception was thrown while trying to save the CashControl document.", e);
            }
            this.writeCashControlDetailLine(pdfdoc, detail.getFinancialDocumentLineAmount(), detail.getCustomerPaymentDescription());
            this.writePayAppLine(pdfdoc, detail.getReferenceFinancialDocumentNumber(), "CREATED & SAVED");
            this.writeSummaryDetailLine(pdfdoc, "INVOICE DOESN'T EXIST");
            this.deleteProcessedLockboxEntry(lockbox);
            return;
        }
        LOG.info("   loading invoice number [" + invoiceNumber + "].");
        try {
            customerInvoiceDocument = (CustomerInvoiceDocument)this.documentService.getByDocumentHeaderId(invoiceNumber);
        }
        catch (ClassCastException | WorkflowException e) {
            this.writeCashControlDetailLine(pdfdoc, detail.getFinancialDocumentLineAmount(), detail.getCustomerPaymentDescription());
            this.writePayAppLine(pdfdoc, detail.getReferenceFinancialDocumentNumber(), "CREATED & SAVED");
            this.writeSummaryDetailLine(pdfdoc, "INVALID INVOICE NUMBER " + invoiceNumber);
            this.deleteProcessedLockboxEntry(lockbox);
            return;
        }
        this.writeInvoiceDetailLine(pdfdoc, invoiceNumber, customerInvoiceDocument.isOpenInvoiceIndicator(), customerInvoiceDocument.getCustomer().getCustomerNumber(), customerInvoiceDocument.getOpenAmount());
        if (!customerInvoiceDocument.isOpenInvoiceIndicator()) {
            LOG.info("   invoice is already closed, so saving CashControl doc and moving on.");
            detail.setCustomerPaymentDescription("Lockbox: Remittance for CLOSED invoice number " + lockbox.getFinancialDocumentReferenceInvoiceNumber());
            try {
                this.documentService.saveDocument((org.kuali.kfs.krad.document.Document)this.cashControlDocument);
            }
            catch (WorkflowException e) {
                LOG.error("A Exception was thrown while trying to save the CashControl document.", (Throwable)e);
                throw new RuntimeException("A Exception was thrown while trying to save the CashControl document.", e);
            }
            this.writeCashControlDetailLine(pdfdoc, detail.getFinancialDocumentLineAmount(), detail.getCustomerPaymentDescription());
            this.writePayAppLine(pdfdoc, detail.getReferenceFinancialDocumentNumber(), "CREATED & SAVED");
            this.writeSummaryDetailLine(pdfdoc, "INVOICE ALREADY CLOSED");
            this.deleteProcessedLockboxEntry(lockbox);
            return;
        }
        try {
            payAppDoc = (PaymentApplicationDocument)this.documentService.getByDocumentHeaderId(payAppDocNumber);
        }
        catch (WorkflowException e) {
            LOG.error("A Exception was thrown while trying to load PayApp #" + payAppDocNumber + ".", (Throwable)e);
            throw new RuntimeException("A Exception was thrown while trying to load PayApp #" + payAppDocNumber + ".", e);
        }
        boolean autoApprove = this.canAutoApprove(customerInvoiceDocument, lockbox, payAppDoc);
        String annotation = "CREATED & SAVED";
        if (autoApprove) {
            LOG.info("   lockbox amount matches invoice total document amount [" + customerInvoiceDocument.getTotalDollarAmount() + "].");
            annotation = "CREATED, SAVED, and BLANKET APPROVED";
            LOG.info("   loading the generated PayApp [" + payAppDocNumber + "], so we can route or approve it.");
            LOG.info("   attempting to create paidApplieds on the PayAppDoc for every detail on the invoice.");
            payAppDoc = this.payAppDocService.createInvoicePaidAppliedsForEntireInvoiceDocument(customerInvoiceDocument, payAppDoc);
            LOG.info("   PayAppDoc has TotalApplied of " + payAppDoc.getTotalApplied() + " for a Control Balance of " + payAppDoc.getTotalFromControl() + ".");
            LOG.info("   attempting to blanketApprove the PayApp Doc.");
            try {
                this.documentService.blanketApproveDocument((org.kuali.kfs.krad.document.Document)payAppDoc, "Automatically approved by Lockbox batch job.", null);
            }
            catch (WorkflowException e) {
                LOG.error("A Exception was thrown while trying to blanketApprove PayAppDoc #" + payAppDoc.getDocumentNumber() + ".", (Throwable)e);
                throw new RuntimeException("A Exception was thrown while trying to blanketApprove PayAppDoc #" + payAppDoc.getDocumentNumber() + ".", e);
            }
            this.writeCashControlDetailLine(pdfdoc, detail.getFinancialDocumentLineAmount(), detail.getCustomerPaymentDescription());
            this.writePayAppLine(pdfdoc, detail.getReferenceFinancialDocumentNumber(), annotation);
            this.writeSummaryDetailLine(pdfdoc, "LOCKBOX AMOUNT MATCHES INVOICE OPEN AMOUNT");
        } else {
            LOG.info("   lockbox amount does NOT match invoice total document amount [" + customerInvoiceDocument.getTotalDollarAmount() + "].");
            this.writeCashControlDetailLine(pdfdoc, detail.getFinancialDocumentLineAmount(), detail.getCustomerPaymentDescription());
            this.writePayAppLine(pdfdoc, detail.getReferenceFinancialDocumentNumber(), annotation);
            if (lockbox.getInvoicePaidOrAppliedAmount().isLessThan((AbstractKualiDecimal)customerInvoiceDocument.getOpenAmount())) {
                this.writeSummaryDetailLine(pdfdoc, "LOCKBOX UNDERPAID INVOICE");
            } else {
                this.writeSummaryDetailLine(pdfdoc, "LOCKBOX OVERPAID INVOICE");
            }
        }
        detail.setCustomerPaymentDescription("Lockbox: Remittance for invoice number " + lockbox.getFinancialDocumentReferenceInvoiceNumber());
        LOG.info("   saving cash control document.");
        try {
            this.documentService.saveDocument((org.kuali.kfs.krad.document.Document)this.cashControlDocument);
        }
        catch (WorkflowException e) {
            LOG.error("A Exception was thrown while trying to save the CashControl document.", (Throwable)e);
            throw new RuntimeException("A Exception was thrown while trying to save the CashControl document.", e);
        }
        this.deleteProcessedLockboxEntry(lockbox);
    }

    protected boolean canAutoApprove(CustomerInvoiceDocument invoice, Lockbox lockbox, PaymentApplicationDocument payAppDoc) {
        boolean retVal = invoice.getOpenAmount().equals((Object)lockbox.getInvoicePaidOrAppliedAmount());
        return retVal &= ObjectUtils.isNotNull((Object)payAppDoc.getCashControlDetail().getCustomerNumber());
    }

    protected void routePayAppWithoutBusinessRules(String payAppDocNumber, String annotation) {
        PaymentApplicationDocument payAppDoc;
        LOG.info("   loading the generated PayApp [" + payAppDocNumber + "], so we can route or approve it.");
        try {
            payAppDoc = (PaymentApplicationDocument)this.documentService.getByDocumentHeaderId(payAppDocNumber);
        }
        catch (WorkflowException e) {
            LOG.error("A Exception was thrown while trying to load PayApp #" + payAppDocNumber + ".", (Throwable)e);
            throw new RuntimeException("A Exception was thrown while trying to load PayApp #" + payAppDocNumber + ".", e);
        }
        LOG.info("   attempting to route without business rules the PayApp Doc.");
        payAppDoc.getDocumentHeader().getWorkflowDocument().route(annotation);
        DocumentType documentType = this.documentTypeService.getDocumentTypeByName(payAppDoc.getFinancialDocumentTypeCode());
        DocumentAttributeIndexingQueue queue = KewApiServiceLocator.getDocumentAttributeIndexingQueue((String)documentType.getApplicationId());
        queue.indexDocument(payAppDoc.getDocumentNumber());
    }

    protected void deleteProcessedLockboxEntry(Lockbox lockboxEntry) {
        HashMap<String, Long> pkMap = new HashMap<String, Long>();
        pkMap.put("invoiceSequenceNumber", lockboxEntry.getInvoiceSequenceNumber());
        this.boService.deleteMatching(Lockbox.class, pkMap);
    }

    protected Document getPdfDoc() throws IOException, DocumentException {
        String reportDropFolder = this.reportsDirectory + "/ar/";
        String fileName = "lockbox_batch_" + new SimpleDateFormat("yyyyMMdd_HHmmssSSS", Locale.US).format(this.dateTimeService.getCurrentDate()) + ".pdf";
        File reportFile = new File(reportDropFolder + fileName);
        FileOutputStream fileOutStream = new FileOutputStream(reportFile);
        BufferedOutputStream buffOutStream = new BufferedOutputStream(fileOutStream);
        Document pdfdoc = new Document(PageSize.LETTER, 54.0f, 54.0f, 72.0f, 72.0f);
        PdfWriter.getInstance((Document)pdfdoc, (OutputStream)buffOutStream);
        pdfdoc.open();
        return pdfdoc;
    }

    protected String rightPad(String valToPad, int sizeToPadTo) {
        return this.rightPad(valToPad, sizeToPadTo, " ");
    }

    protected String rightPad(String valToPad, int sizeToPadTo, String padChar) {
        if (StringUtils.isBlank((CharSequence)valToPad)) {
            return StringUtils.repeat((String)padChar, (int)sizeToPadTo);
        }
        if (valToPad.length() >= sizeToPadTo) {
            return valToPad;
        }
        return valToPad + StringUtils.repeat((String)padChar, (int)(sizeToPadTo - valToPad.length()));
    }

    protected void writeBatchGroupSectionTitle(Document pdfDoc, String batchSeqNbr, Date procInvDt, String cashControlDocNumber) {
        Font font = FontFactory.getFont((String)"Courier", (float)10.0f, (int)1);
        String lineText = "CASHCTL " + this.rightPad(cashControlDocNumber, 12) + " BATCH GROUP: " + this.rightPad(batchSeqNbr, 5) + " " + this.rightPad(procInvDt == null ? "NONE" : procInvDt.toString(), 35);
        Paragraph paragraph = new Paragraph();
        paragraph.setAlignment(0);
        Chunk chunk = new Chunk(lineText, font);
        chunk.setBackground(Color.LIGHT_GRAY, 5.0f, 5.0f, 5.0f, 5.0f);
        paragraph.add((Object)chunk);
        paragraph.add((Object)new Chunk("", font));
        try {
            pdfDoc.add((Element)paragraph);
        }
        catch (DocumentException e) {
            LOG.error("iText DocumentException thrown when trying to write content.", (Throwable)e);
            throw new RuntimeException("iText DocumentException thrown when trying to write content.", e);
        }
    }

    protected void writeLockboxRecordLine(Document pdfDoc, String lockboxNumber, String customerNumber, String invoiceNumber, KualiDecimal invoiceTotalAmount, String paymentMediumCode, String bankCode) {
        this.writeDetailLine(pdfDoc, StringUtils.repeat((String)"-", (int)100));
        String detailLineText = "   LOCKBOX: " + this.rightPad(lockboxNumber, 10) + " CUST: " + this.rightPad(customerNumber, 9) + " INV: " + this.rightPad(invoiceNumber, 10) + " " + StringUtils.repeat((String)" ", (int)28) + "AMT: " + this.rightPad(invoiceTotalAmount.toString(), 11) + " ";
        this.writeDetailLine(pdfDoc, detailLineText);
    }

    protected void writeInvoiceDetailLine(Document pdfDoc, String invoiceNumber, boolean open, String customerNumber, KualiDecimal openAmount) {
        StringBuilder sb = new StringBuilder();
        sb.append("   ");
        sb.append("INVOICE: ").append(this.rightPad(invoiceNumber, 10)).append(" ");
        sb.append("CUST: ").append(this.rightPad(customerNumber, 9)).append(" ");
        if (open) {
            sb.append(this.rightPad("OPEN", 16)).append(" ");
        } else {
            sb.append(this.rightPad("CLOSED", 16)).append(" ");
        }
        sb.append(StringUtils.repeat((String)" ", (int)22));
        sb.append("OPEN AMT: ").append(this.rightPad(openAmount.toString(), 11)).append(" ");
        this.writeDetailLine(pdfDoc, sb.toString());
    }

    protected void writeCashControlDetailLine(Document pdfDoc, KualiDecimal amount, String description) {
        String detailLineText = "   CASHCTL DTL: " + this.rightPad(description, 66) + " AMT: " + this.rightPad(amount.toString(), 11) + " ";
        this.writeDetailLine(pdfDoc, detailLineText);
    }

    protected void writeSummaryDetailLine(Document pdfDoc, String summary) {
        this.writeDetailLine(pdfDoc, "   " + summary);
    }

    protected void writePayAppLine(Document pdfDoc, String payAppDocNbr, String description) {
        String detailLineText = "   PAYAPP DOC NBR: " + this.rightPad(payAppDocNbr, 12) + " ACTION: " + description;
        this.writeDetailLine(pdfDoc, detailLineText);
    }

    protected void writeExceptionStackTrace(Document pdfDoc, Exception e) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(outStream, true, StandardCharsets.UTF_8);
        e.printStackTrace(printWriter);
        printWriter.flush();
        this.writeDetailLine(pdfDoc, outStream.toString());
    }

    protected void writeDetailLine(Document pdfDoc, String detailLineText) {
        if (ObjectUtils.isNotNull((Object)detailLineText)) {
            Font font = FontFactory.getFont((String)"Courier", (float)8.0f, (int)0);
            Paragraph paragraph = new Paragraph();
            paragraph.setAlignment(0);
            paragraph.add((Object)new Chunk(detailLineText, font));
            try {
                pdfDoc.add((Element)paragraph);
            }
            catch (DocumentException e) {
                LOG.error("iText DocumentException thrown when trying to write content.", (Throwable)e);
                throw new RuntimeException("iText DocumentException thrown when trying to write content.", e);
            }
        }
    }

    @Override
    @Transactional
    public Long getMaxLockboxSequenceNumber() {
        return this.lockboxDao.getMaxLockboxSequenceNumber();
    }

    public LockboxDao getLockboxDao() {
        return this.lockboxDao;
    }

    public void setLockboxDao(LockboxDao lockboxDao) {
        this.lockboxDao = lockboxDao;
    }

    public SystemInformationService getSystemInformationService() {
        return this.systemInformationService;
    }

    public void setSystemInformationService(SystemInformationService systemInformationService) {
        this.systemInformationService = systemInformationService;
    }

    public AccountsReceivableDocumentHeaderService getAccountsReceivableDocumentHeaderService() {
        return this.accountsReceivableDocumentHeaderService;
    }

    public void setAccountsReceivableDocumentHeaderService(AccountsReceivableDocumentHeaderService accountsReceivableDocumentHeaderService) {
        this.accountsReceivableDocumentHeaderService = accountsReceivableDocumentHeaderService;
    }

    public void setPaymentApplicationDocumentService(PaymentApplicationDocumentService paymentApplicationDocumentService) {
        this.payAppDocService = paymentApplicationDocumentService;
    }

    public DocumentService getDocumentService() {
        return this.documentService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setDateTimeService(DateTimeService dateTimeService) {
        this.dateTimeService = dateTimeService;
    }

    public CashControlDocumentService getCashControlDocumentService() {
        return this.cashControlDocumentService;
    }

    public void setCashControlDocumentService(CashControlDocumentService cashControlDocumentService) {
        this.cashControlDocumentService = cashControlDocumentService;
    }

    public void setReportsDirectory(String reportsDirectory) {
        this.reportsDirectory = reportsDirectory;
    }

    public void setBoService(BusinessObjectService boService) {
        this.boService = boService;
    }

    public CustomerService getCustomerService() {
        return this.customerService;
    }

    public void setCustomerService(CustomerService customerService) {
        this.customerService = customerService;
    }

    public void setDocumentTypeService(DocumentTypeService documentTypeService) {
        this.documentTypeService = documentTypeService;
    }
}

